/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import org.openide.ErrorManager;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TreeViewCellEditor
extends DefaultTreeCellEditor
implements CellEditorListener,
FocusListener {
    static final long serialVersionUID = -2171725285964032312L;
    boolean dndActive = false;
    private boolean cancelled = false;
    private boolean stopped = false;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeViewCellEditor;

    public TreeViewCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
        this.addCellEditorListener(this);
    }

    /*
     * Unable to fully structure code
     */
    public void editingStopped(ChangeEvent e) {
        block8: {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            lastP = this.lastPath;
            if (lastP != null && (n = Visualizer.findNode(lastP.getLastPathComponent())) != null && n.canRename()) {
                block9: {
                    newStr = (String)this.getCellEditorValue();
                    try {
                        if (!n.getName().equals(newStr)) {
                            n.setName(newStr);
                        }
                        break block8;
                    }
                    catch (IllegalArgumentException exc) {
                        needToAnnotate = true;
                        em = ErrorManager.getDefault();
                        ann = em.findAnnotations(exc);
                        if (ann == null || ann.length <= 0) break block9;
                        i = 0;
                        ** while (i < ann.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        glm = ann[i].getLocalizedMessage();
                        if (glm != null && !glm.equals("")) {
                            needToAnnotate = false;
                        }
                        ++i;
                        continue;
                    }
                }
                if (needToAnnotate) {
                    msg = NbBundle.getMessage(TreeViewCellEditor.class$org$openide$explorer$view$TreeViewCellEditor == null ? (TreeViewCellEditor.class$org$openide$explorer$view$TreeViewCellEditor = TreeViewCellEditor.class$("org.openide.explorer.view.TreeViewCellEditor")) : TreeViewCellEditor.class$org$openide$explorer$view$TreeViewCellEditor, "RenameFailed", n.getName(), newStr);
                    em.annotate((Throwable)exc, msg);
                }
                em.notify(256, exc);
            }
        }
    }

    public void editingCanceled(ChangeEvent e) {
        this.cancelled = true;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JTextField) {
            this.cancelled = true;
            this.cancelCellEditing();
        } else {
            super.actionPerformed(evt);
        }
    }

    public void focusLost(FocusEvent evt) {
        if (this.stopped || this.cancelled) {
            return;
        }
        if (!this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    protected TreeCellEditor createTreeCellEditor() {
        JTextField tf = new JTextField(){

            public void addNotify() {
                TreeViewCellEditor.this.stopped = (TreeViewCellEditor.this.cancelled = false);
                super.addNotify();
                this.requestFocus();
            }
        };
        tf.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 0);
        tf.addFocusListener(this);
        Ed ed = new Ed(tf);
        ed.setClickCountToStart(1);
        return ed;
    }

    public boolean isCellEditable(EventObject event) {
        if (event != null && event instanceof MouseEvent && !SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            return false;
        }
        if (this.lastPath != null) {
            Node n = Visualizer.findNode(this.lastPath.getLastPathComponent());
            if (n == null || !n.canRename()) {
                return false;
            }
        } else {
            return false;
        }
        if (this.dndActive) {
            return false;
        }
        return super.isCellEditable(event);
    }

    protected void determineOffset(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            this.renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, true);
            this.editingIcon = this.renderer.getIcon();
            this.offset = this.renderer.getIconTextGap() + this.editingIcon.getIconWidth();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    void setDnDActive(boolean dndActive) {
        this.dndActive = dndActive;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Ed
    extends DefaultCellEditor {
        static final long serialVersionUID = -6373058702842751408L;

        public Ed(JTextField tf) {
            super(tf);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Node ren = Visualizer.findNode(value);
            if (ren != null && ren.canRename()) {
                this.delegate.setValue(ren.getName());
            } else {
                this.delegate.setValue("");
            }
            ((JTextField)this.editorComponent).selectAll();
            return this.editorComponent;
        }
    }
}

