/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.util.EventObject;
import java.util.LinkedList;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

abstract class VisualizerEvent
extends EventObject {
    private int[] array;

    public VisualizerEvent(VisualizerChildren ch, int[] array) {
        super(ch);
        this.array = array;
    }

    public final int[] getArray() {
        return this.array;
    }

    public final VisualizerChildren getChildren() {
        return (VisualizerChildren)this.getSource();
    }

    public final VisualizerNode getVisualizer() {
        return this.getChildren().parent;
    }

    static final class Reordered
    extends VisualizerEvent
    implements Runnable {
        private int[] changedIndices;
        static final long serialVersionUID = -4572356079752325870L;

        public Reordered(VisualizerChildren ch, int[] indx) {
            super(ch, indx);
        }

        public int[] getChangedIndices() {
            if (this.changedIndices == null) {
                int[] permutation = super.getArray();
                int size = permutation.length;
                int changes = 0;
                int i = 0;
                while (i < size) {
                    if (permutation[i] != i) {
                        ++changes;
                    }
                    ++i;
                }
                int[] indices = new int[changes];
                int current = 0;
                int i2 = 0;
                while (i2 < size) {
                    if (permutation[i2] != i2) {
                        indices[current++] = i2;
                    }
                    ++i2;
                }
                this.changedIndices = indices;
            }
            return this.changedIndices;
        }

        public void run() {
            super.getChildren().reordered(this);
        }
    }

    static final class Removed
    extends VisualizerEvent
    implements Runnable {
        public LinkedList removed = new LinkedList();
        static final long serialVersionUID = 5102881916407672392L;

        public Removed(VisualizerChildren ch, int[] indx) {
            super(ch, indx);
        }

        public void run() {
            super.getChildren().removed(this);
        }
    }

    static final class Added
    extends VisualizerEvent
    implements Runnable {
        private Node[] added;
        static final long serialVersionUID = 5906423476285962043L;

        public Added(VisualizerChildren ch, Node[] n, int[] indx) {
            super(ch, indx);
            this.added = n;
        }

        public Node[] getAdded() {
            return this.added;
        }

        public void run() {
            super.getChildren().added(this);
        }
    }
}

