/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.StreamPool;
import org.openide.util.enum.EmptyEnumeration;

final class AbstractFileObject
extends AbstractFolder {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Reference lock;
    private Boolean folder;
    private Date lastModified;

    public AbstractFileObject(AbstractFileSystem fs, AbstractFileObject parent, String name) {
        super(fs, parent, name);
    }

    private AbstractFileSystem getAbstractFileSystem() {
        return (AbstractFileSystem)this.getFileSystem();
    }

    private AbstractFileObject getAbstractChild(String name) {
        return (AbstractFileObject)this.getChild(name);
    }

    protected final String[] list() {
        return this.getAbstractFileSystem().list.children(this.toString());
    }

    protected final AbstractFolder createFile(String name) {
        return this.getAbstractFileSystem().createFileObject(this, name);
    }

    public boolean isFolder() {
        if (this.folder == null) {
            if (this.parent == null || this.getAbstractFileSystem().info.folder(this.toString())) {
                this.folder = Boolean.TRUE;
                return true;
            }
            this.folder = Boolean.FALSE;
            return false;
        }
        return this.folder;
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public Date lastModified() {
        if (this.lastModified == null || !this.getAbstractFileSystem().isLastModifiedCacheEnabled()) {
            this.lastModified = this.getAbstractFileSystem().info.lastModified(this.toString());
        }
        return this.lastModified;
    }

    public boolean isReadOnly() {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        return fs.isReadOnly() || fs.info.readOnly(this.toString());
    }

    public String getMIMEType() {
        String retVal = this.getAbstractFileSystem().info.mimeType(this.toString());
        if (retVal == null) {
            retVal = FileUtil.getMIMEType(this);
        }
        return retVal != null ? retVal : "content/unknown";
    }

    public long getSize() {
        return this.getAbstractFileSystem().info.size(this.toString());
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream is = this.getAbstractFileSystem().info.inputStream(this.toString());
        return StreamPool.createInputStream(this, is);
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        return this.getOutputStream(lock, true);
    }

    synchronized OutputStream getOutputStream(FileLock lock, boolean fireFileChanged) throws IOException {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        if (fs.isReadOnly()) {
            FSException.io("EXC_FSisRO", ((FileSystem)fs).getDisplayName());
        }
        if (this.isReadOnly()) {
            FSException.io("EXC_FisRO", this.name, ((FileSystem)fs).getDisplayName());
        }
        this.testLock(lock);
        OutputStream os = this.getAbstractFileSystem().info.outputStream(this.toString());
        return StreamPool.createOutputStream(this, os, fireFileChanged);
    }

    public synchronized FileLock lock() throws IOException {
        FileLock f;
        if (this.lock != null && (f = (FileLock)this.lock.get()) != null) {
            throw new FileAlreadyLockedException();
        }
        this.getAbstractFileSystem().info.lock(this.toString());
        AfLock l = new AfLock();
        this.lock = new WeakReference<AfLock>(l);
        return l;
    }

    synchronized void unlock() {
        this.getAbstractFileSystem().info.unlock(this.toString());
        this.lastModified = null;
        this.lock = null;
    }

    private void testLock(FileLock l) throws IOException {
        if (this.lock == null) {
            FSException.io("EXC_InvalidLock", l, this.toString(), this.getAbstractFileSystem().getDisplayName(), this.lock);
        }
        if (this.lock.get() != l) {
            FSException.io("EXC_InvalidLock", l, this.toString(), this.getAbstractFileSystem().getDisplayName(), this.lock.get());
        }
    }

    public void setImportant(boolean b) {
        this.getAbstractFileSystem().markImportant(this.toString(), b);
    }

    public Object getAttribute(String attrName) {
        return this.getAttribute(attrName, this.toString());
    }

    final Object getAttribute(String attrName, String path) {
        return this.getAbstractFileSystem().attr.readAttribute(path, attrName);
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.setAttribute(attrName, value, true);
    }

    void setAttribute(String attrName, Object value, boolean fire) throws IOException {
        Object oldValue = null;
        AbstractFileSystem fs = this.getAbstractFileSystem();
        if (fire) {
            oldValue = this.getAttribute(attrName);
        }
        this.getAbstractFileSystem().attr.writeAttribute(this.toString(), attrName, value);
        if (fire && oldValue != value && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, attrName, oldValue, value));
        }
    }

    public Enumeration getAttributes() {
        return this.getAttributes(this.toString());
    }

    final Enumeration getAttributes(String path) {
        return this.getAbstractFileSystem().attr.attributes(path);
    }

    protected final Reference createReference(FileObject fo) {
        return this.getAbstractFileSystem().createReference(fo);
    }

    public FileObject createFolder(String name) throws IOException {
        AbstractFileObject fo;
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                AbstractFileSystem fs = this.getAbstractFileSystem();
                if (fs.isReadOnly()) {
                    FSException.io("EXC_FSisRO", fs.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", name, fs.getDisplayName());
                }
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", name, this.toString(), fs.getDisplayName());
                }
                this.getAbstractFileSystem().change.createFolder(this.toString() + '/' + name);
                this.refresh(name, null);
                fo = this.getAbstractChild(name);
                if (fo == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), name));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(fo), false);
                }
            }
            Object var7_6 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        return fo;
    }

    public FileObject createData(String name, String ext) throws IOException {
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                String n;
                AbstractFileSystem fs = this.getAbstractFileSystem();
                if (fs.isReadOnly()) {
                    FSException.io("EXC_FSisRO", fs.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", name, fs.getDisplayName());
                }
                String string = n = ext == null || "".equals(ext) ? name : name + '.' + ext;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", n, this.toString(), fs.getDisplayName());
                }
                this.getAbstractFileSystem().change.createData(this.toString() + '/' + n);
                this.refresh(n, null);
                AbstractFileObject fo = this.getAbstractChild(n);
                if (fo == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), n));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(fo), true);
                }
                AbstractFileObject abstractFileObject2 = fo;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var3_3
                Object var10_8 = null;
                this.getFileSystem().finishAtomicAction();
                return abstractFileObject2;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotRenameRoot", this.getAbstractFileSystem().getDisplayName());
        }
        if (name.indexOf(47) != -1 || ext != null && ext.indexOf(47) != -1 || name.indexOf(92) != -1 || ext != null && ext.indexOf(92) != -1) {
            FSException.io("EXC_CannotRename", this.toString(), this.getAbstractFileSystem().getDisplayName(), name + "." + ext);
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(lock);
                if (this.isData() && ext != null) {
                    name = name + '.' + ext;
                }
                String newFullName = this.parent.toString() + '/' + name;
                String oldFullName = this.toString();
                if (this.isReadOnly()) {
                    FSException.io("EXC_CannotRename", this.toString(), this.getAbstractFileSystem().getDisplayName(), newFullName);
                }
                if (this.getFileSystem().isReadOnly()) {
                    FSException.io("EXC_FSisRO", this.getAbstractFileSystem().getDisplayName());
                }
                String on = this.getName();
                String oe = this.getExt();
                this.getAbstractFileSystem().change.rename(oldFullName, newFullName);
                String oldName = this.name;
                this.name = name;
                this.parent.refresh(name, oldName);
                this.getAbstractFileSystem().attr.renameAttributes(oldFullName, newFullName);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, on, oe));
                }
            }
            Object var12_11 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public void delete(FileLock lock) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", this.getAbstractFileSystem().getDisplayName());
        }
        try {
            String fullName;
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(lock);
                fullName = this.toString();
                try {
                    this.getAbstractFileSystem().change.delete(fullName);
                }
                catch (IOException ex) {
                    StreamPool p = StreamPool.find(this);
                    if (p != null) {
                        p.annotate(ex);
                    }
                    throw ex;
                }
                String n = this.name;
                this.validFlag = false;
                this.parent.refresh(null, n, true);
            }
            this.getAbstractFileSystem().attr.deleteAttributes(fullName);
            if (this.hasAtLeastOneListeners()) {
                this.fileDeleted0(new FileEvent(this));
            }
            Object var8_8 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        AbstractFileSystem.Transfer from = this.getAbstractFileSystem().transfer;
        if (from == null || !(target instanceof AbstractFileObject)) {
            return super.copy(target, name, ext);
        }
        AbstractFileObject abstractTarget = (AbstractFileObject)target;
        AbstractFileSystem abstractFS = abstractTarget.getAbstractFileSystem();
        AbstractFileSystem.Transfer to = abstractFS.transfer;
        if (to != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFileObject abstractFileObject = abstractTarget;
                synchronized (abstractFileObject) {
                    String n;
                    if (abstractFS.isReadOnly()) {
                        FSException.io("EXC_FSisRO", abstractFS.getDisplayName());
                    }
                    if (target.isReadOnly()) {
                        FSException.io("EXC_FisRO", target.toString(), abstractFS.getDisplayName());
                    }
                    String string = n = "".equals(ext) ? name : name + '.' + ext;
                    if (from.copy(this.toString(), to, target.toString() + '/' + n)) {
                        abstractTarget.refresh(n, null);
                        AbstractFileObject fo = abstractTarget.getAbstractChild(n);
                        if (fo == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractTarget.toString(), n));
                        }
                        if (abstractTarget.hasListeners()) {
                            abstractTarget.fileCreated0(new FileEvent(fo), true);
                        }
                        AbstractFileObject abstractFileObject2 = fo;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 7, 11] lbl27 : MonitorExitStatement: MONITOREXIT : var9_9
                        Object var15_13 = null;
                        this.getFileSystem().finishAtomicAction();
                        return abstractFileObject2;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                this.getFileSystem().finishAtomicAction();
                throw throwable;
            }
            Object var15_14 = null;
            this.getFileSystem().finishAtomicAction();
            {
            }
        }
        return super.copy(target, name, ext);
    }

    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        AbstractFileSystem.Transfer from;
        AbstractFileSystem fs = this.getAbstractFileSystem();
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", fs.getDisplayName());
        }
        if ((from = this.getAbstractFileSystem().transfer) == null || !(target instanceof AbstractFileObject)) {
            return super.move(lock, target, name, ext);
        }
        AbstractFileObject abstractTarget = (AbstractFileObject)target;
        AbstractFileSystem abstractFS = abstractTarget.getAbstractFileSystem();
        AbstractFileSystem.Transfer to = abstractFS.transfer;
        if (to != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFolder abstractFolder = this.parent;
                synchronized (abstractFolder) {
                    this.testLock(lock);
                    if (abstractFS.isReadOnly()) {
                        FSException.io("EXC_FSisRO", abstractFS.getDisplayName());
                    }
                    if (target.isReadOnly()) {
                        FSException.io("EXC_FisRO", target.toString(), abstractFS.getDisplayName());
                    }
                    String n = "".equals(ext) ? name : name + '.' + ext;
                    String fullName = this.toString();
                    if (from.move(fullName, to, target.toString() + '/' + n)) {
                        String oldN = name;
                        this.validFlag = false;
                        this.parent.refresh(null, oldN);
                        abstractTarget.refresh(n, null);
                        AbstractFileObject fo = abstractTarget.getAbstractChild(n);
                        if (fo == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractTarget.toString(), n));
                        }
                        if (this.hasAtLeastOneListeners()) {
                            this.fileDeleted0(new FileEvent(this));
                        }
                        if (abstractTarget.hasListeners()) {
                            abstractTarget.fileCreated0(new FileEvent(fo), true);
                        }
                        AbstractFileObject abstractFileObject = fo;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 8, 13] lbl35 : MonitorExitStatement: MONITOREXIT : var10_10
                        Object var18_16 = null;
                        this.getFileSystem().finishAtomicAction();
                        return abstractFileObject;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                this.getFileSystem().finishAtomicAction();
                throw throwable;
            }
            Object var18_17 = null;
            this.getFileSystem().finishAtomicAction();
            {
            }
        }
        return super.move(lock, target, name, ext);
    }

    public boolean isVirtual() {
        return this.getAbstractFileSystem().checkVirtual(this.toString());
    }

    protected void refresh(String added, String removed, boolean fire, boolean expected) {
        this.refresh(added, removed, fire, expected, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void refresh(String added, String removed, boolean fire, boolean expected, String[] list) {
        FileEvent ev = null;
        boolean refreshParent = false;
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            // MONITORENTER : abstractFileObject
            if (this.isFolder()) {
                super.refresh(added, removed, fire, expected, list);
            } else {
                StreamPool strPool = StreamPool.find(this);
                if (strPool != null && strPool.isOutputStreamOpen()) {
                    // MONITOREXIT : abstractFileObject
                    Object var13_10 = null;
                    this.getFileSystem().finishAtomicAction();
                    return;
                }
                Date l = null;
                if (this.lastModified == null) {
                    this.lastModified = l = this.getAbstractFileSystem().info.lastModified(this.toString());
                    // MONITOREXIT : abstractFileObject
                    Object var13_11 = null;
                    this.getFileSystem().finishAtomicAction();
                    return;
                }
                l = this.getAbstractFileSystem().info.lastModified(this.toString());
                if (Math.abs(this.lastModified.getTime() - l.getTime()) != 0L) {
                    this.lastModified = l;
                    if (fire && this.hasAtLeastOneListeners()) {
                        ev = new FileEvent((FileObject)this, (FileObject)this, expected);
                    }
                    if (l.getTime() == 0L) {
                        this.validFlag = false;
                        if (ev != null) {
                            this.fileDeleted0(ev);
                        }
                        refreshParent = true;
                    } else if (ev != null) {
                        this.fileChanged0(ev);
                    }
                }
            }
            // MONITOREXIT : abstractFileObject
            if (refreshParent && this.parent.getFileObject(this.getName(), this.getExt()) != null) {
                this.parent.refreshFolder(null, this.getNameExt(), fire, expected, null);
            }
            Object var13_12 = null;
            this.getFileSystem().finishAtomicAction();
            return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    protected void outputStreamClosed(boolean fireFileChanged) {
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            this.lastModified = null;
        }
        super.outputStreamClosed(fireFileChanged);
    }

    static final class Replace
    implements Serializable {
        static final long serialVersionUID = -8543432135435542113L;
        private String fsName;
        private String fileName;

        public Replace(String fsName, String fileName) {
            this.fsName = fsName;
            this.fileName = fileName;
        }

        public Object readResolve() {
            Repository rep = ExternalUtil.getRepository();
            FileSystem fs = rep.findFileSystem(this.fsName);
            FileObject fo = null;
            if (fs != null) {
                fo = fs.findResource(this.fileName);
            }
            if (fo == null) {
                fo = rep.findResource(this.fileName);
            }
            if (fo == null) {
                return new Invalid(this.fsName, this.fileName);
            }
            return fo;
        }
    }

    static final class Invalid
    extends FileObject {
        static final long serialVersionUID = -4558997829579415276L;
        private String name;
        private String fullName;
        private String fileSystemName;
        private static final Invalid ROOT = new Invalid("");

        public Invalid(String name) {
            this.fullName = name;
            int i = name.lastIndexOf(47) + 1;
            this.name = i == 0 || i == name.length() ? name : name.substring(i);
        }

        public Invalid(String fs, String name) {
            this(name);
            this.fileSystemName = fs;
        }

        public String getName() {
            int i = this.name.lastIndexOf(46);
            return i <= 0 ? this.name : this.name.substring(0, i);
        }

        public String getExt() {
            int i = this.name.lastIndexOf(46) + 1;
            return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new FileStateInvalidException(null, this.name + "[" + this.fileSystemName + "]");
        }

        public boolean isRoot() {
            return this == ROOT;
        }

        public boolean isFolder() {
            return this == ROOT;
        }

        public Date lastModified() {
            return new Date();
        }

        public boolean isData() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isValid() {
            return false;
        }

        public String getMIMEType() {
            return "content/unknown";
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        public synchronized OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        public synchronized FileLock lock() throws IOException {
            throw new IOException();
        }

        public void setImportant(boolean b) {
        }

        public Object getAttribute(String attrName) {
            return null;
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new IOException();
        }

        public Enumeration getAttributes() {
            return EmptyEnumeration.EMPTY;
        }

        public synchronized FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        public synchronized FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        public FileObject getParent() {
            return this == ROOT ? null : ROOT;
        }

        public synchronized FileObject[] getChildren() {
            return new FileObject[0];
        }

        public synchronized FileObject getFileObject(String name, String ext) {
            return null;
        }

        public void refresh() {
        }

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }
    }

    private class AfLock
    extends FileLock {
        AfLock() {
        }

        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                AbstractFileObject.this.unlock();
            }
        }
    }
}

