/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;

public abstract class FileObject
implements Serializable {
    static final long serialVersionUID = 85305031923497718L;
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;

    public abstract String getName();

    public abstract String getExt();

    public abstract void rename(FileLock var1, String var2, String var3) throws IOException;

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        if (this.isFolder()) {
            throw new IOException(NbBundle.getBundle(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = FileObject.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject).getString("EXC_FolderCopy"));
        }
        FileObject dest = FileUtil.copyFileImpl(this, target, name, ext);
        return dest;
    }

    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        if (this.getParent().equals(target)) {
            this.rename(lock, name, ext);
            return this;
        }
        FileObject dest = this.copy(target, name, ext);
        this.delete(lock);
        return dest;
    }

    public String toString() {
        return this.getPackageNameExt('/', '.');
    }

    public String getPackageNameExt(char separatorChar, char extSepChar) {
        String pn = this.getPackageName(separatorChar);
        String ext = this.getExt();
        if (!ext.equals("")) {
            return pn + extSepChar + ext;
        }
        return pn;
    }

    public String getPackageName(char separatorChar) {
        StringBuffer sb = new StringBuffer();
        this.constructName(sb, separatorChar);
        return sb.toString();
    }

    public String getNameExt() {
        String n = this.getName();
        String e = this.getExt();
        return e == null || e.length() == 0 ? n : n + '.' + e;
    }

    private void constructName(StringBuffer sb, char sepChar) {
        FileObject parent = this.getParent();
        if (parent != null && !parent.isRoot()) {
            parent.constructName(sb, sepChar);
            sb.append(sepChar);
        }
        sb.append(this.getName());
    }

    public abstract FileSystem getFileSystem() throws FileStateInvalidException;

    public abstract FileObject getParent();

    public abstract boolean isFolder();

    public abstract Date lastModified();

    public abstract boolean isRoot();

    public abstract boolean isData();

    public abstract boolean isValid();

    public boolean existsExt(String ext) {
        FileObject parent = this.getParent();
        return parent != null && parent.getFileObject(this.getName(), ext) != null;
    }

    public abstract void delete(FileLock var1) throws IOException;

    public final void delete() throws IOException {
        FileLock lock = this.lock();
        try {
            this.delete(lock);
            Object var3_2 = null;
            lock.releaseLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.releaseLock();
            throw throwable;
        }
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IOException;

    public abstract Enumeration getAttributes();

    public final boolean hasExt(String ext) {
        if (this.isHasExtOverride()) {
            return this.hasExtOverride(ext);
        }
        return this.getExt().equals(ext);
    }

    boolean isHasExtOverride() {
        return false;
    }

    boolean hasExtOverride(String ext) {
        return false;
    }

    public abstract void addFileChangeListener(FileChangeListener var1);

    public abstract void removeFileChangeListener(FileChangeListener var1);

    protected void fireFileDataCreatedEvent(Enumeration en, FileEvent fe) {
        this.dispatchEvent(0, en, fe);
    }

    protected void fireFileFolderCreatedEvent(Enumeration en, FileEvent fe) {
        this.dispatchEvent(1, en, fe);
    }

    protected void fireFileChangedEvent(Enumeration en, FileEvent fe) {
        this.dispatchEvent(2, en, fe);
    }

    protected void fireFileDeletedEvent(Enumeration en, FileEvent fe) {
        this.dispatchEvent(3, en, fe);
    }

    protected void fireFileAttributeChangedEvent(Enumeration en, FileAttributeEvent fe) {
        this.dispatchEvent(5, en, fe);
    }

    protected void fireFileRenamedEvent(Enumeration en, FileRenameEvent fe) {
        this.dispatchEvent(4, en, fe);
    }

    private final void dispatchEvent(int op, Enumeration en, FileEvent fe) {
        try {
            FileSystem fs = this.getFileSystem();
            fs.dispatchEvent(new ED(op, en, fe));
        }
        catch (FileStateInvalidException ex) {
            // empty catch block
        }
    }

    public String getMIMEType() {
        String type = FileUtil.getMIMEType(this);
        return type == null ? "content/unknown" : type;
    }

    public abstract long getSize();

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public abstract OutputStream getOutputStream(FileLock var1) throws IOException;

    public abstract FileLock lock() throws IOException;

    public abstract void setImportant(boolean var1);

    public abstract FileObject[] getChildren();

    public Enumeration getChildren(final boolean rec) {
        QueueEnumeration en = new QueueEnumeration(){

            public void process(Object o) {
                FileObject fo = (FileObject)o;
                if (rec && fo.isFolder()) {
                    this.put(fo.getChildren());
                }
            }
        };
        en.put(this.getChildren());
        return en;
    }

    public Enumeration getFolders(boolean rec) {
        return new FilterEnumeration(this.getChildren(rec)){

            protected boolean accept(Object o) {
                return ((FileObject)o).isFolder();
            }
        };
    }

    public Enumeration getData(boolean rec) {
        return new FilterEnumeration(this.getChildren(rec)){

            protected boolean accept(Object o) {
                return ((FileObject)o).isData();
            }
        };
    }

    public abstract FileObject getFileObject(String var1, String var2);

    public final FileObject getFileObject(String name) {
        return this.getFileObject(name, null);
    }

    public abstract FileObject createFolder(String var1) throws IOException;

    public abstract FileObject createData(String var1, String var2) throws IOException;

    public FileObject createData(String name) throws IOException {
        return this.createData(name, "");
    }

    public abstract boolean isReadOnly();

    public void refresh(boolean expected) {
    }

    public void refresh() {
        this.refresh(false);
    }

    public final URL getURL() throws FileStateInvalidException {
        return FileURL.encodeFileObject(this);
    }

    public boolean isVirtual() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ED
    extends FileSystem.EventDispatcher {
        private int op;
        private Enumeration en;
        private FileEvent fe;

        public ED(int op, Enumeration en, FileEvent fe) {
            this.op = op;
            this.en = en;
            this.fe = fe;
        }

        private boolean isPriorityListener(FileChangeListener fcl) {
            return fcl instanceof MultiFileObject.MfoWeakListener;
        }

        protected void dispatch(boolean onlyPriority) {
            boolean transmit;
            QueueEnumeration newEnum = new QueueEnumeration();
            while (this.en.hasMoreElements()) {
                FileChangeListener fcl = (FileChangeListener)this.en.nextElement();
                if (onlyPriority && !this.isPriorityListener(fcl)) {
                    newEnum.put(fcl);
                    continue;
                }
                FileObject fo = this.fe.getFile();
                if (fo != null && (this.op == 0 || this.op == 1)) {
                    this.op = fo.isFolder() ? 1 : 0;
                }
                FCLSupport.dispatchEvent(fcl, this.fe, this.op);
            }
            if (onlyPriority) {
                this.en = newEnum;
            }
            boolean bl = transmit = !this.fe.getFile().equals(this.fe.getSource());
            if (this.op == 1 || this.op == 0) {
                boolean bl2 = transmit = !transmit;
            }
            if (!this.en.hasMoreElements() && transmit && !onlyPriority) {
                FileSystem fs = null;
                Repository rep = null;
                try {
                    fs = this.fe.getFile().getFileSystem();
                    rep = fs.getRepository();
                }
                catch (FileStateInvalidException fsix) {
                    return;
                }
                fs.getFCLSupport().dispatchEvent(this.fe, this.op);
                if (rep != null) {
                    rep.getFCLSupport().dispatchEvent(this.fe, this.op);
                }
            }
        }

        protected void setAtomicActionLink(EventControl.AtomicActionLink propID) {
            this.fe.setAtomicActionLink(propID);
        }
    }
}

