/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.Utilities;

public final class FileUtil {
    static final Set transientAttributes = new HashSet();
    private static Dictionary map;

    private FileUtil() {
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = is.read(BUFFER)) != -1) {
            os.write(BUFFER, 0, len);
        }
        return;
    }

    static FileObject copyFileImpl(FileObject source, FileObject destFolder, String newName, String newExt) throws IOException {
        OutputStream bufOut;
        FileLock lock;
        FileObject dest;
        block7: {
            dest = destFolder.createData(newName, newExt);
            lock = null;
            InputStream bufIn = null;
            bufOut = null;
            try {
                lock = dest.lock();
                bufIn = source.getInputStream();
                bufOut = dest instanceof AbstractFileObject ? ((AbstractFileObject)dest).getOutputStream(lock, false) : dest.getOutputStream(lock);
                FileUtil.copy(bufIn, bufOut);
                FileUtil.copyAttributes(source, dest);
                Object var9_8 = null;
                if (bufIn == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bufIn != null) {
                    bufIn.close();
                }
                if (bufOut != null) {
                    bufOut.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
                throw throwable;
            }
            bufIn.close();
        }
        if (bufOut != null) {
            bufOut.close();
        }
        if (lock != null) {
            lock.releaseLock();
        }
        return dest;
    }

    public static FileObject copyFile(FileObject source, FileObject destFolder, String newName, String newExt) throws IOException {
        return source.copy(destFolder, newName, newExt);
    }

    public static FileObject copyFile(FileObject source, FileObject destFolder, String newName) throws IOException {
        return FileUtil.copyFile(source, destFolder, newName, source.getExt());
    }

    public static FileObject moveFile(FileObject source, FileObject destFolder, String newName) throws IOException {
        FileLock lock = null;
        try {
            lock = source.lock();
            FileObject fileObject = source.move(lock, destFolder, newName, source.getExt());
            Object var6_5 = null;
            if (lock != null) {
                lock.releaseLock();
            }
            return fileObject;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (lock == null) break block3;
                lock.releaseLock();
            }
            throw throwable;
        }
    }

    public static FileObject createFolder(FileObject folder, String name) throws IOException {
        String separators = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer st = new StringTokenizer(name, separators);
        while (st.hasMoreElements()) {
            FileObject f;
            block4: {
                name = st.nextToken();
                if (name.length() <= 0) continue;
                f = folder.getFileObject(name);
                if (f == null) {
                    try {
                        f = folder.createFolder(name);
                    }
                    catch (SyncFailedException ex) {
                        folder.refresh();
                        f = folder.getFileObject(name);
                        if (f != null) break block4;
                        throw ex;
                    }
                }
            }
            folder = f;
        }
        return folder;
    }

    public static FileObject createData(FileObject folder, String name) throws IOException {
        FileObject data;
        block8: {
            String ext;
            String fname;
            String dataname;
            int index = name.lastIndexOf(47);
            if (index >= name.length()) {
                throw new IOException("Wrong file name.");
            }
            if (index != -1) {
                String foldername = name.substring(0, index);
                dataname = name.substring(index + 1);
                folder = FileUtil.createFolder(folder, foldername);
            } else {
                dataname = name;
            }
            index = dataname.lastIndexOf(46);
            if (index != -1) {
                fname = dataname.substring(0, index);
                ext = dataname.substring(index + 1);
            } else {
                fname = dataname;
                ext = "";
            }
            data = folder.getFileObject(fname, ext);
            if (data == null) {
                try {
                    data = folder.createData(fname, ext);
                }
                catch (SyncFailedException ex) {
                    folder.refresh();
                    data = folder.getFileObject(fname, ext);
                    if (data != null) break block8;
                    throw ex;
                }
            }
        }
        return data;
    }

    public static File toFile(FileObject fo) {
        return (File)fo.getAttribute("java.io.File");
    }

    /*
     * Unable to fully structure code
     */
    public static FileObject[] fromFile(File file) {
        en = Repository.getDefault().getFileSystems();
        list = new ArrayList<FileObject>();
        fileName = null;
        try {
            file = file.getCanonicalFile();
            fileName = file.getCanonicalPath();
            if (true) ** GOTO lbl24
        }
        catch (IOException iex) {
            return new FileObject[0];
        }
        do {
            fs = (FileSystem)en.nextElement();
            try {
                root = FileUtil.toFile(fs.getRoot());
                if (root == null || fileName.indexOf(rootName = root.getCanonicalPath()) != 0) continue;
                res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                fo = fs.findResource(res);
                v0 = file2Fo = fo != null ? FileUtil.toFile(fo) : null;
                if (fo == null || file2Fo == null || !file.equals(file2Fo.getCanonicalFile())) continue;
                list.add(fo);
            }
            catch (IOException iexc) {
                // empty catch block
            }
lbl24:
            // 5 sources

        } while (en.hasMoreElements());
        results = new FileObject[list.size()];
        list.toArray(results);
        return results;
    }

    public static void copyAttributes(FileObject source, FileObject dest) throws IOException {
        Enumeration attrKeys = source.getAttributes();
        while (attrKeys.hasMoreElements()) {
            Object value;
            String key = (String)attrKeys.nextElement();
            if (transientAttributes.contains(key) || FileUtil.isTransient(source, key) || (value = source.getAttribute(key)) == null) continue;
            dest.setAttribute(key, value);
        }
    }

    static boolean isTransient(FileObject fo, String attrName) {
        return XMLMapAttr.ModifiedAttribute.isTransient(fo, attrName);
    }

    public static void extractJar(final FileObject fo, final InputStream is) throws IOException {
        FileSystem fs = fo.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileUtil.extractJarImpl(fo, is);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void extractJarImpl(FileObject fo, InputStream is) throws IOException {
        JarEntry je;
        HashMap<String, DefaultAttributes.Table> attributes = new HashMap<String, DefaultAttributes.Table>(7);
        JarInputStream jis = new JarInputStream(is);
        while ((je = jis.getNextJarEntry()) != null) {
            Object var12_11;
            void var3_4;
            String name = var3_4.getName();
            if (name.toLowerCase().startsWith("meta-inf/")) continue;
            if (var3_4.isDirectory()) {
                FileUtil.createFolder(fo, name);
                continue;
            }
            if (DefaultAttributes.acceptName(name)) {
                DefaultAttributes.Table table = DefaultAttributes.loadTable(jis, name);
                attributes.put(name, table);
                continue;
            }
            FileObject fd = FileUtil.createData(fo, name);
            FileLock lock = fd.lock();
            try {
                Object var10_10;
                OutputStream os = fd.getOutputStream(lock);
                try {
                    FileUtil.copy(jis, os);
                    var10_10 = null;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                var12_11 = null;
                lock.releaseLock();
            }
            catch (Throwable throwable) {
                var12_11 = null;
                lock.releaseLock();
                throw throwable;
            }
        }
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String fileName = (String)entry.getKey();
            int last = fileName.lastIndexOf(47);
            String dirName = last != -1 ? fileName.substring(0, last + 1) : "";
            String prefix = fo.isRoot() ? dirName : fo.getPackageName('/') + '/' + dirName;
            DefaultAttributes.Table t = (DefaultAttributes.Table)entry.getValue();
            Iterator files = t.keySet().iterator();
            while (files.hasNext()) {
                String orig = (String)files.next();
                String fn = prefix + orig;
                FileObject obj = fo.getFileSystem().findResource(fn);
                if (obj == null) continue;
                Enumeration attrEnum = t.attrs(orig);
                while (attrEnum.hasMoreElements()) {
                    String attrName = (String)attrEnum.nextElement();
                    Object value = t.getAttr(orig, attrName);
                    if (value == null) continue;
                    obj.setAttribute(attrName, value);
                }
            }
        }
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static String findFreeFileName(FileObject folder, String name, String ext) {
        if (FileUtil.checkFreeName(folder, name, ext)) {
            return name;
        }
        int i = 1;
        String destName;
        while (!FileUtil.checkFreeName(folder, destName = name + "_" + i, ext)) {
            ++i;
        }
        return destName;
    }

    public static String findFreeFolderName(FileObject folder, String name) {
        if (FileUtil.checkFreeName(folder, name, null)) {
            return name;
        }
        int i = 1;
        String destName;
        while (!FileUtil.checkFreeName(folder, destName = name + "_" + i, null)) {
            ++i;
        }
        return destName;
    }

    private static boolean checkFreeName(FileObject fo, String name, String ext) {
        if (Utilities.isWindows()) {
            Enumeration en = fo.getChildren(false);
            while (en.hasMoreElements()) {
                fo = (FileObject)en.nextElement();
                String n = fo.getName();
                String e = fo.getExt();
                if (!n.equalsIgnoreCase(name)) continue;
                if (!(ext != null && ext.trim().length() != 0 || e != null && e.trim().length() != 0)) {
                    return false;
                }
                if (ext == null || e == null || !ext.equalsIgnoreCase(e)) continue;
                return false;
            }
            return true;
        }
        if (ext == null) {
            return fo.getFileObject(name) == null;
        }
        return fo.getFileObject(name, ext) == null;
    }

    public static FileObject findBrother(FileObject fo, String ext) {
        if (fo == null) {
            return null;
        }
        FileObject parent = fo.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getFileObject(fo.getName(), ext);
    }

    public static String getMIMEType(String ext) {
        String s = (String)map.get(ext);
        if (s != null) {
            return s;
        }
        return (String)map.get(ext.toLowerCase());
    }

    public static String getMIMEType(FileObject fo) {
        String retVal = MIMESupport.findMIMEType(fo);
        if (retVal == null) {
            retVal = FileUtil.getMIMEType(fo.getExt());
        }
        return retVal;
    }

    public static void setMIMEType(String ext, String mimeType) {
        Dictionary dictionary = map;
        synchronized (dictionary) {
            String old = (String)map.get(ext);
            if (old == null) {
                map.put(ext, mimeType);
            } else if (!old.equals(mimeType)) {
                throw new IllegalArgumentException("Cannot overwrite existing MIME type mapping for extension `" + ext + "' with " + mimeType + " (was " + old + ")");
            }
        }
    }

    static {
        transientAttributes.add("templateWizardURL");
        transientAttributes.add("templateWizardIterator");
        transientAttributes.add("templateWizardDescResource");
        transientAttributes.add("SystemFileSystem.localizingBundle");
        transientAttributes.add("SystemFileSystem.icon");
        transientAttributes.add("SystemFileSystem.icon32");
        map = new Hashtable();
        FileUtil.setMIMEType("", "content/unknown");
        FileUtil.setMIMEType("uu", "application/octet-stream");
        FileUtil.setMIMEType("exe", "application/octet-stream");
        FileUtil.setMIMEType("ps", "application/postscript");
        FileUtil.setMIMEType("zip", "application/zip");
        FileUtil.setMIMEType("class", "application/octet-stream");
        FileUtil.setMIMEType("jar", "application/x-jar");
        FileUtil.setMIMEType("sh", "application/x-shar");
        FileUtil.setMIMEType("tar", "application/x-tar");
        FileUtil.setMIMEType("snd", "audio/basic");
        FileUtil.setMIMEType("au", "audio/basic");
        FileUtil.setMIMEType("wav", "audio/x-wav");
        FileUtil.setMIMEType("gif", "image/gif");
        FileUtil.setMIMEType("jpg", "image/jpeg");
        FileUtil.setMIMEType("jpeg", "image/jpeg");
        FileUtil.setMIMEType("htm", "text/html");
        FileUtil.setMIMEType("html", "text/html");
        FileUtil.setMIMEType("xml", "text/xml");
        FileUtil.setMIMEType("xsl", "text/xml");
        FileUtil.setMIMEType("xsd", "text/xml");
        FileUtil.setMIMEType("dtd", "text/x-dtd");
        FileUtil.setMIMEType("css", "text/css");
        FileUtil.setMIMEType("text", "text/plain");
        FileUtil.setMIMEType("pl", "text/plain");
        FileUtil.setMIMEType("txt", "text/plain");
        FileUtil.setMIMEType("properties", "text/plain");
        FileUtil.setMIMEType("java", "text/x-java");
        FileUtil.setMIMEType("ra", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("ram", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("rm", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("rpm", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("mov", "video/quicktime");
        FileUtil.setMIMEType("jsp", "text/plain");
    }
}

