/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.StreamPool;
import org.openide.util.RequestProcessor;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;

public class JarFileSystem
extends AbstractFileSystem {
    static final long serialVersionUID = -98124752801761145L;
    private static final String JAR_FS = "JAR_FS ";
    private transient JarFile jar;
    private transient Manifest manifest;
    private File root = new File(".");
    private static RequestProcessor req = new RequestProcessor("JarFs - modification watcher");
    private transient RequestProcessor.Task watcherTask = null;
    private transient long lastModification = 0L;
    private transient Object closeSync = new Object();
    private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.JarFileSystem.REFRESH_TIME", 15000);
    private transient ReferenceQueue refQueue = new ReferenceQueue();
    private transient long aliveCount = 0L;
    private transient EntryCache rootOfCache = null;
    private transient long cacheLastAccess = 0L;

    public JarFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    public JarFileSystem(FileSystemCapability cap) {
        this();
        this.setCapability(cap);
    }

    protected Reference createReference(FileObject fo) {
        ++this.aliveCount;
        if (REFRESH_TIME > 0 && this.watcherTask == null) {
            this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
        }
        return new WeakReference<FileObject>(fo, this.refQueue);
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    JarFile j = this.reOpenJarFile();
                    this.manifest = j == null ? null : j.getManifest();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.manifest == null) {
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    public void setJarFile(File aRoot) throws IOException, PropertyVetoException {
        FileObject newRoot = null;
        String oldDisplayName = this.getDisplayName();
        if (this.getRefreshTime() > 0) {
            this.setRefreshTime(0);
        }
        if (aRoot == null) {
            FSException.io("EXC_NotValidFile", aRoot);
        }
        if (!aRoot.exists()) {
            FSException.io("EXC_FileNotExists", aRoot.toString());
        }
        if (!aRoot.canRead()) {
            FSException.io("EXC_CanntRead", aRoot.toString());
        }
        if (!aRoot.isFile()) {
            FSException.io("EXC_NotValidFile", aRoot.toString());
        }
        if (aRoot.equals(this.root)) {
            return;
        }
        String s = aRoot.getCanonicalPath();
        s = s.intern();
        JarFile tempJar = null;
        try {
            tempJar = new JarFile(s);
        }
        catch (ZipException e) {
            FSException.io("EXC_NotValidJarFile", s);
        }
        Object object = this.closeSync;
        synchronized (object) {
            this.setSystemName(s);
            this.closeCurrentRoot();
            this.jar = tempJar;
            this.root = new File(s);
            this.rootOfCache = null;
            this.aliveCount = 0L;
            newRoot = this.refreshRoot();
            this.manifest = null;
            this.lastModification = 0L;
        }
        this.firePropertyChange("root", null, newRoot);
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
    }

    public File getJarFile() {
        return this.root;
    }

    public String getDisplayName() {
        if (this.root != null && this.root.isFile() && this.root.exists() && this.root.canRead()) {
            return this.root.getName();
        }
        return FileSystem.getString("JAR_NotValidJarFileSystem");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void removeNotify() {
        this.closeCurrentRoot();
    }

    public void addNotify() {
        super.addNotify();
    }

    public void prepareEnvironment(FileSystem.Environment env) {
        if (this.root != null) {
            env.addClassPath(this.root.toString());
        }
    }

    protected String[] children(String name) {
        EntryCache tmpRootCache = this.getCacheOfRoot();
        if (tmpRootCache == null && (tmpRootCache = this.parse(false)) == null) {
            return new String[0];
        }
        EntryCache entryCache = this.getCacheOfEntry(tmpRootCache, name);
        if (entryCache == null) {
            return new String[0];
        }
        return entryCache.getChildrenNames();
    }

    protected void createFolder(String name) throws IOException {
        throw new IOException();
    }

    protected void createData(String name) throws IOException {
        throw new IOException();
    }

    protected void rename(String oldName, String newName) throws IOException {
        throw new IOException();
    }

    protected void delete(String name) throws IOException {
        throw new IOException();
    }

    protected Date lastModified(String name) {
        return new Date(this.getEntry(name).getTime());
    }

    protected boolean folder(String name) {
        EntryCache tmpCache;
        if ("".equals(name)) {
            return true;
        }
        EntryCache tmpRootCache = this.getCacheOfRoot();
        if (tmpRootCache == null) {
            tmpRootCache = this.parse(false);
        }
        if ((tmpCache = this.getCacheOfEntry(tmpRootCache, name)) == null) {
            return false;
        }
        return tmpCache.isFolder();
    }

    protected boolean readOnly(String name) {
        return true;
    }

    protected String mimeType(String name) {
        return null;
    }

    protected long size(String name) {
        long retVal = this.getEntry(name).getSize();
        return retVal == -1L ? 0L : retVal;
    }

    protected InputStream inputStream(String name) throws FileNotFoundException {
        InputStream is = null;
        AbstractFolder fo = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                JarEntry je;
                JarFile j = this.reOpenJarFile();
                if (j != null && (je = j.getJarEntry(name)) != null && (is = this.getInputStream4336753(j, je)) != null) {
                    Reference eref = this.findReference(name);
                    if (eref != null) {
                        fo = (AbstractFolder)eref.get();
                    }
                    if (fo != null) {
                        is = StreamPool.createInputStream(fo, is);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        if (is == null) {
            throw new FileNotFoundException(name);
        }
        return is;
    }

    private InputStream getInputStream4336753(JarFile j, JarEntry je) throws IOException {
        InputStream in = null;
        while (in == null) {
            try {
                in = j.getInputStream(je);
                break;
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
        }
        return in;
    }

    protected OutputStream outputStream(String name) throws IOException {
        throw new IOException();
    }

    protected void lock(String name) throws IOException {
        FSException.io("EXC_CannotLock", name, this.getDisplayName(), name);
    }

    protected void unlock(String name) {
    }

    protected void markUnimportant(String name) {
    }

    protected Object readAttribute(String name, String attrName) {
        Attributes attr = this.getManifest().getAttributes(name);
        try {
            return attr == null ? null : attr.getValue(attrName);
        }
        catch (IllegalArgumentException iax) {
            return null;
        }
    }

    protected void writeAttribute(String name, String attrName, Object value) throws IOException {
        throw new IOException();
    }

    protected Enumeration attributes(String name) {
        Attributes attr = this.getManifest().getAttributes(name);
        if (attr != null) {
            return new AlterEnumeration(Collections.enumeration(attr.keySet())){

                public Object alter(Object obj) {
                    return obj.toString();
                }
            };
        }
        return EmptyEnumeration.EMPTY;
    }

    protected void renameAttributes(String oldName, String newName) {
    }

    protected void deleteAttributes(String name) {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeCurrentRoot();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.closeSync = new Object();
        this.rootOfCache = null;
        this.cacheLastAccess = 0L;
        this.refQueue = new ReferenceQueue();
        this.aliveCount = 0L;
        try {
            this.setJarFile(this.root);
        }
        catch (PropertyVetoException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void closeCurrentRoot() {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.jar != null) {
                try {
                    block8: {
                        try {
                            StreamPool pool = StreamPool.find(this);
                            if (pool != null && (pool.isInputStreamOpen() || pool.isOutputStreamOpen())) break block8;
                            this.jar.close();
                        }
                        catch (Exception exc) {
                            ExternalUtil.exception(exc);
                            Object var4_5 = null;
                            this.jar = null;
                        }
                    }
                    Object var4_4 = null;
                    this.jar = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.jar = null;
                    throw throwable;
                }
            }
        }
    }

    private EntryCache getCacheOfRoot() {
        this.cacheLastAccess = System.currentTimeMillis();
        return this.rootOfCache;
    }

    private void setCacheOfRoot(EntryCache newCache) {
        this.cacheLastAccess = System.currentTimeMillis();
        this.rootOfCache = newCache;
    }

    private EntryCache getCacheOfEntry(EntryCache cache, String name) {
        EntryCache tmpCache = cache;
        if (tmpCache == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(name, "/");
        while (tok.hasMoreElements() && tmpCache != null) {
            tmpCache = tmpCache.getChild((String)tok.nextElement());
        }
        return tmpCache;
    }

    private void refreshExistingFileObjects(EntryCache cache) {
        EntryCache tmpRootCache = cache;
        Enumeration en = this.existingFileObjects(this.getRoot());
        while (en.hasMoreElements()) {
            EntryCache tmpCache;
            AbstractFolder fo = (AbstractFolder)en.nextElement();
            if (fo.isFolder() && !fo.isInitialized() || (tmpCache = this.getCacheOfEntry(tmpRootCache, fo.getPackageNameExt('/', '.'))) == null) continue;
            fo.refresh(null, null, true, true, tmpCache.getChildrenNames());
        }
    }

    private boolean isInUse() {
        Reference ref;
        while ((ref = this.refQueue.poll()) != null) {
            --this.aliveCount;
        }
        return this.aliveCount != 0L;
    }

    private EntryCache parse(boolean refresh) {
        EntryCache entryCache = new EntryCache("", true);
        JarFile j = null;
        this.beginAtomicAction();
        try {
            Object object = this.closeSync;
            synchronized (object) {
                long start = System.currentTimeMillis();
                this.lastModification = 0L;
                this.closeCurrentRoot();
                int i = 0;
                while (i <= 2) {
                    try {
                        j = this.reOpenJarFile();
                        break;
                    }
                    catch (IOException ex) {
                        if (i >= 2) {
                            EntryCache entryCache2 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 19, 4, 5, 9] lbl19 : MonitorExitStatement: MONITOREXIT : var7_4
                            Object var13_14 = null;
                            if (refresh) {
                                this.refreshExistingFileObjects(entryCache);
                            }
                            if (REFRESH_TIME > 0 && this.watcherTask == null) {
                                this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
                            }
                            this.finishAtomicAction();
                            return entryCache2;
                        }
                        ++i;
                    }
                }
                try {
                    Enumeration<JarEntry> en = j.entries();
                    while (en.hasMoreElements()) {
                        JarEntry je = en.nextElement();
                        String name = je.getName();
                        this.addFile(name, entryCache);
                    }
                }
                catch (Throwable t) {
                    EntryCache entryCache3 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 6] lbl40 : MonitorExitStatement: MONITOREXIT : var7_4
                    Object var13_15 = null;
                    if (refresh) {
                        this.refreshExistingFileObjects(entryCache);
                    }
                    if (REFRESH_TIME > 0 && this.watcherTask == null) {
                        this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
                    }
                    this.finishAtomicAction();
                    return entryCache3;
                }
                this.lastModification = this.root.lastModified();
                this.setCacheOfRoot(entryCache);
            }
            EntryCache entryCache4 = entryCache;
            Object var13_16 = null;
            if (refresh) {
                this.refreshExistingFileObjects(entryCache);
            }
            if (REFRESH_TIME > 0 && this.watcherTask == null) {
                this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
            }
            this.finishAtomicAction();
            return entryCache4;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (refresh) {
                this.refreshExistingFileObjects(entryCache);
            }
            if (REFRESH_TIME > 0 && this.watcherTask == null) {
                this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
            }
            this.finishAtomicAction();
            throw throwable;
        }
    }

    private void addFile(String name, EntryCache cache) {
        EntryCache tmpRootCache = cache;
        boolean isFold = false;
        String realName = name;
        if ((name = name.replace('\\', '/')).endsWith("/")) {
            name = name.substring(0, name.length() - 1);
            isFold = true;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.length() == 0) {
            return;
        }
        int endIdx = 0;
        int beginIdx = 0;
        while (beginIdx <= name.length()) {
            endIdx = name.indexOf(47, beginIdx);
            if (endIdx < 0) {
                endIdx = name.length();
            }
            String fragment = name.substring(beginIdx, endIdx);
            if (isFold || endIdx != name.length()) {
                tmpRootCache = tmpRootCache.addChild(fragment, new EntryCache(fragment, true));
            } else {
                tmpRootCache.addChild(fragment, new EntryCache(fragment, false));
            }
            beginIdx = ++endIdx;
        }
    }

    private Runnable watcherTask() {
        return new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                try {
                                    if (JarFileSystem.this.root == null) {
                                        Object var2_1 = null;
                                        break block7;
                                    }
                                    if (!JarFileSystem.this.isInUse()) {
                                        if (JarFileSystem.this.watcherTask != null) {
                                            JarFileSystem.this.watcherTask.cancel();
                                            JarFileSystem.this.watcherTask = null;
                                            JarFileSystem.this.rootOfCache = null;
                                            JarFileSystem.this.closeCurrentRoot();
                                        }
                                        break block8;
                                    }
                                    if (JarFileSystem.this.root.lastModified() != JarFileSystem.this.lastModification) {
                                        JarFileSystem.this.parse(true);
                                        break block9;
                                    }
                                    if (JarFileSystem.this.rootOfCache != null && System.currentTimeMillis() - JarFileSystem.this.cacheLastAccess > (long)REFRESH_TIME) {
                                        JarFileSystem.this.rootOfCache = null;
                                    }
                                    break block10;
                                }
                                catch (Throwable throwable) {
                                    Object var2_5 = null;
                                    if (JarFileSystem.this.watcherTask == null) throw throwable;
                                    JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                                    throw throwable;
                                }
                            }
                            if (JarFileSystem.this.watcherTask == null) return;
                            JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                            return;
                        }
                        Object var2_2 = null;
                        if (JarFileSystem.this.watcherTask == null) return;
                        JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                        return;
                    }
                    Object var2_3 = null;
                    if (JarFileSystem.this.watcherTask == null) return;
                    JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                    return;
                }
                Object var2_4 = null;
                if (JarFileSystem.this.watcherTask == null) return;
                JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
            }
        };
    }

    private final JarEntry getEntry(String file) {
        JarFile j = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                j = this.reOpenJarFile();
                JarEntry je = j.getJarEntry(file);
                if (je != null) {
                    JarEntry jarEntry = je;
                    return jarEntry;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new JarEntry(file);
    }

    private JarFile reOpenJarFile() throws IOException {
        JarFile j = this.jar;
        if (j != null) {
            return j;
        }
        Object object = this.closeSync;
        synchronized (object) {
            if (this.jar == null && this.root != null) {
                this.jar = new JarFile(this.root);
            }
            JarFile jarFile = this.jar;
            return jarFile;
        }
    }

    private static class EntryCache {
        String name;
        Map children;
        EntryCache parent;
        boolean folder;

        public EntryCache(String name, boolean folder) {
            this.name = name;
            this.parent = null;
            this.folder = folder;
        }

        EntryCache addChild(String name, EntryCache child) {
            EntryCache retVal;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((retVal = this.children.put(name, child)) != null) {
                child = retVal;
                this.children.put(name, child);
            }
            child.parent = this;
            return child;
        }

        EntryCache[] getChildren() {
            if (this.children == null) {
                return new EntryCache[0];
            }
            EntryCache[] retval = new EntryCache[this.children.size()];
            this.children.values().toArray(retval);
            return retval;
        }

        String[] getChildrenNames() {
            if (this.children == null) {
                return new String[0];
            }
            String[] retval = new String[this.children.size()];
            this.children.keySet().toArray(retval);
            return retval;
        }

        String getName() {
            return this.name;
        }

        boolean isFolder() {
            return this.folder;
        }

        EntryCache getChild(String name) {
            if (this.children == null) {
                return null;
            }
            return (EntryCache)this.children.get(name);
        }

        EntryCache getParent() {
            return this.parent;
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        static final long serialVersionUID = -67233308132567232L;
        private JarFileSystem fs;

        public Impl(JarFileSystem fs) {
            this.fs = fs;
        }

        public String[] children(String name) {
            return this.fs.children(name);
        }

        public void createFolder(String name) throws IOException {
            this.fs.createFolder(name);
        }

        public void createData(String name) throws IOException {
            this.fs.createData(name);
        }

        public void rename(String oldName, String newName) throws IOException {
            this.fs.rename(oldName, newName);
        }

        public void delete(String name) throws IOException {
            this.fs.delete(name);
        }

        public Date lastModified(String name) {
            return this.fs.lastModified(name);
        }

        public boolean folder(String name) {
            return this.fs.folder(name);
        }

        public boolean readOnly(String name) {
            return this.fs.readOnly(name);
        }

        public String mimeType(String name) {
            return this.fs.mimeType(name);
        }

        public long size(String name) {
            return this.fs.size(name);
        }

        public InputStream inputStream(String name) throws FileNotFoundException {
            return this.fs.inputStream(name);
        }

        public OutputStream outputStream(String name) throws IOException {
            return this.fs.outputStream(name);
        }

        public void lock(String name) throws IOException {
            this.fs.lock(name);
        }

        public void unlock(String name) {
            this.fs.unlock(name);
        }

        public void markUnimportant(String name) {
            this.fs.markUnimportant(name);
        }

        public Object readAttribute(String name, String attrName) {
            return this.fs.readAttribute(name, attrName);
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            this.fs.writeAttribute(name, attrName, value);
        }

        public Enumeration attributes(String name) {
            return this.fs.attributes(name);
        }

        public void renameAttributes(String oldName, String newName) {
            this.fs.renameAttributes(oldName, newName);
        }

        public void deleteAttributes(String name) {
            this.fs.deleteAttributes(name);
        }
    }
}

