/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListener;

final class MIMESupport {
    private static Map cache;
    private static LinkedList recentlist;
    private static int cachesize;
    private static MIMESupport defaultInst;
    private static final int MAX_CACHE_SIZE = 5;

    static String findMIMEType(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (!CachedFileObject.isAnyResolver()) {
            return null;
        }
        CachedFileObject cfo = MIMESupport.getDefault().getCachedFileObject(fo);
        Object object = cfo.syncObject;
        synchronized (object) {
            String string = cfo.getMIMEType();
            return string;
        }
    }

    private static synchronized MIMESupport getDefault() {
        if (defaultInst == null) {
            defaultInst = new MIMESupport();
        }
        return defaultInst;
    }

    private MIMESupport() {
        cachesize = 5;
        cache = new HashMap(cachesize);
        recentlist = new LinkedList();
    }

    private CachedFileObject getCachedFileObject(FileObject fo) {
        CachedFileObject retVal = null;
        Map map = cache;
        synchronized (map) {
            retVal = (CachedFileObject)cache.get(fo);
            if (retVal == null) {
                if (recentlist.size() > cachesize) {
                    cache.remove(recentlist.getLast());
                    recentlist.removeLast();
                }
                retVal = new CachedFileObject(fo);
                cache.put(fo, retVal);
                recentlist.addFirst(fo);
            } else {
                boolean isModified;
                boolean bl = isModified = fo.lastModified().getTime() != retVal.lastModified().getTime();
                if (isModified) {
                    retVal = new CachedFileObject(fo);
                    cache.put(fo, retVal);
                }
                recentlist.remove(fo);
                recentlist.addFirst(fo);
            }
        }
        return retVal;
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private byte[] buffer = new byte[256];
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;

        CachedInputStream(InputStream is) {
            this.inputStream = is;
        }

        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        public int read() throws IOException {
            if (this.eof) {
                return -1;
            }
            if (this.pos < this.len) {
                int c;
                c = (c = this.buffer[this.pos++]) < 0 ? c + 256 : c;
                return c;
            }
            int c = this.inputStream.read();
            if (c < 0) {
                this.eof = true;
                return -1;
            }
            if (this.len >= this.buffer.length) {
                byte[] buf = new byte[this.buffer.length * 2 + 1];
                System.arraycopy(this.buffer, 0, buf, 0, this.buffer.length);
                this.buffer = buf;
            }
            this.buffer[this.len++] = c > 127 ? (byte)(c - 256) : (byte)c;
            this.pos = this.len;
            return c;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String retVal = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            retVal = retVal + new String(this.buffer);
            return retVal;
        }
    }

    private static class CachedFileObject
    extends FileObject
    implements FileChangeListener {
        String mimeType;
        Date lastModified;
        CachedInputStream fixIt;
        private Object syncObject = new Object();
        static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$MIMEResolver == null ? (class$org$openide$filesystems$MIMEResolver = CachedFileObject.class$("org.openide.filesystems.MIMEResolver")) : class$org$openide$filesystems$MIMEResolver));
        static MIMEResolver[] resolvers;
        FileObject fileObj;
        static /* synthetic */ Class class$org$openide$filesystems$MIMEResolver;

        CachedFileObject(FileObject fo) {
            this.fileObj = fo;
            this.lastModified = this.fileObj.lastModified();
            this.fileObj.addFileChangeListener(WeakListener.fileChange(this, this.fileObj));
        }

        public static boolean isAnyResolver() {
            return resolvers.length > 0;
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
        }

        public String getMIMEType() {
            if (this.mimeType == null) {
                this.mimeType = this.resolveMIME();
            }
            return this.mimeType;
        }

        private String resolveMIME() {
            String retVal = null;
            MIMEResolver[] local = resolvers;
            try {
                int i = 0;
                while (i < local.length) {
                    retVal = local[i].findMIMEType(this);
                    if (retVal != null) {
                        String string = retVal;
                        Object var6_5 = null;
                        if (this.fixIt != null) {
                            this.fixIt.internalClose();
                        }
                        this.fixIt = null;
                        return string;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
                throw throwable;
            }
            Object var6_6 = null;
            if (this.fixIt != null) {
                this.fixIt.internalClose();
            }
            this.fixIt = null;
            return FileUtil.getMIMEType(this.getExt());
        }

        public Date lastModified() {
            if (this.lastModified != null) {
                return this.lastModified;
            }
            this.lastModified = this.fileObj.lastModified();
            return this.lastModified;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                InputStream is = this.fileObj.getInputStream();
                if (!(is instanceof BufferedInputStream)) {
                    is = new BufferedInputStream(is);
                }
                this.fixIt = new CachedInputStream(is);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        public void fileChanged(FileEvent fe) {
            this.freeCaches();
        }

        public void fileDeleted(FileEvent fe) {
            this.freeCaches();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.freeCaches();
        }

        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        public String getPackageNameExt(char separatorChar, char extSepChar) {
            return this.fileObj.getPackageNameExt(separatorChar, extSepChar);
        }

        public FileObject copy(FileObject target, String name, String ext) throws IOException {
            return this.fileObj.copy(target, name, ext);
        }

        protected void fireFileDeletedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileDeletedEvent(en, fe);
        }

        protected void fireFileFolderCreatedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileFolderCreatedEvent(en, fe);
        }

        public void setImportant(boolean b) {
            this.fileObj.setImportant(b);
        }

        public boolean isData() {
            return this.fileObj.isData();
        }

        public Object getAttribute(String attrName) {
            return this.fileObj.getAttribute(attrName);
        }

        public Enumeration getFolders(boolean rec) {
            return this.fileObj.getFolders(rec);
        }

        public void delete(FileLock lock) throws IOException {
            this.fileObj.delete(lock);
        }

        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        public Enumeration getData(boolean rec) {
            return this.fileObj.getData(rec);
        }

        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        public boolean isValid() {
            return this.fileObj.isValid();
        }

        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        public String getExt() {
            return this.fileObj.getExt();
        }

        public String getName() {
            return this.fileObj.getName();
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
            this.fileObj.removeFileChangeListener(fcl);
        }

        protected void fireFileRenamedEvent(Enumeration en, FileRenameEvent fe) {
            this.fileObj.fireFileRenamedEvent(en, fe);
        }

        public void refresh(boolean expected) {
            this.fileObj.refresh(expected);
        }

        protected void fireFileAttributeChangedEvent(Enumeration en, FileAttributeEvent fe) {
            this.fileObj.fireFileAttributeChangedEvent(en, fe);
        }

        public long getSize() {
            return this.fileObj.getSize();
        }

        public Enumeration getAttributes() {
            return this.fileObj.getAttributes();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            this.fileObj.rename(lock, name, ext);
        }

        protected void fireFileChangedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileChangedEvent(en, fe);
        }

        public FileObject getFileObject(String name, String ext) {
            return this.fileObj.getFileObject(name, ext);
        }

        public void refresh() {
            this.fileObj.refresh();
        }

        public FileObject createData(String name, String ext) throws IOException {
            return this.fileObj.createData(name, ext);
        }

        public void addFileChangeListener(FileChangeListener fcl) {
            this.fileObj.addFileChangeListener(fcl);
        }

        protected void fireFileDataCreatedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileDataCreatedEvent(en, fe);
        }

        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        public FileObject createFolder(String name) throws IOException {
            return this.fileObj.createFolder(name);
        }

        public Enumeration getChildren(boolean rec) {
            return this.fileObj.getChildren(rec);
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            this.fileObj.setAttribute(attrName, value);
        }

        public String getPackageName(char separatorChar) {
            return this.fileObj.getPackageName(separatorChar);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            return this.fileObj.getOutputStream(lock);
        }

        public boolean existsExt(String ext) {
            return this.fileObj.existsExt(ext);
        }

        public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
            return this.fileObj.move(lock, target, name, ext);
        }

        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CachedFileObject) {
                return ((CachedFileObject)obj).fileObj.equals(this.fileObj);
            }
            return super.equals(obj);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static {
            result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent evt) {
                    CachedFileObject.resolvers = CachedFileObject.result.allInstances().toArray(new MIMEResolver[0]);
                }
            });
            resolvers = result.allInstances().toArray(new MIMEResolver[0]);
        }
    }
}

