/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.WeakListener;

final class MultiFileObject
extends AbstractFolder
implements FileChangeListener {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Set delegates;
    private FileObject leader;
    private Reference lock;
    private FileChangeListener weakL = new MfoWeakListener(this);
    private FileObject lastAttrCacheFile;
    private String lastAttrCacheName = "";
    private static final FileSystem.AtomicAction markAtomicAction = new FileSystem.AtomicAction(){

        public void run() {
        }
    };

    public MultiFileObject(MultiFileSystem fs, MultiFileObject parent, String name) {
        super(fs, parent, name);
        this.update();
        if (this.leader == null) {
            this.leader = new AbstractFileObject.Invalid(name);
        }
    }

    public MultiFileObject(MultiFileSystem fs) {
        this(fs, null, "");
    }

    public FileSystem getLeaderFileSystem() throws FileStateInvalidException {
        return this.leader.getFileSystem();
    }

    private void freeLastAttrCache() {
        this.lastAttrCacheFile = null;
        this.lastAttrCacheName = "";
    }

    private void update() {
        MultiFileSystem mfs = this.getMultiFileSystem();
        FileSystem[] arr = mfs.getDelegates();
        Set now = this.delegates == null ? Collections.EMPTY_SET : this.delegates;
        HashSet<FileObject> del = new HashSet<FileObject>(arr.length * 2);
        FileObject led = null;
        String name = this.toString();
        int i = 0;
        while (i < arr.length) {
            FileObject fo;
            if (arr[i] != null && (fo = mfs.findResourceOn(arr[i], name)) != null) {
                del.add(fo);
                if (!now.remove(fo)) {
                    fo.addFileChangeListener(this.weakL);
                }
                if (led == null && fo.isValid()) {
                    led = fo;
                }
            }
            ++i;
        }
        Iterator it = now.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            fo.removeFileChangeListener(this.weakL);
        }
        if (led != null) {
            if (led != this.leader && this.leader != null) {
                if (this.isData() && this.isValid()) {
                    this.fileChanged0(new FileEvent(this));
                }
                this.getMultiFileSystem().notifyMigration(this);
            }
            this.leader = led;
        }
        this.delegates = del;
    }

    void updateAll() {
        MultiFileSystem mfs = this.getMultiFileSystem();
        try {
            mfs.beginAtomicAction();
            Enumeration en = this.existingSubFiles(true);
            while (en.hasMoreElements()) {
                MultiFileObject mfo = (MultiFileObject)en.nextElement();
                if (mfo.isFolder() && !mfo.isInitialized()) continue;
                mfo.freeLastAttrCache();
                mfo.superRefresh(true);
            }
            Object var5_4 = null;
            mfs.finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mfs.finishAtomicAction();
            throw throwable;
        }
    }

    void updateAllAfterSetDelegates(FileSystem[] oldFileSystems) {
        try {
            this.getMultiFileSystem().beginAtomicAction();
            FileSystem[] fileSystems = this.getMultiFileSystem().getDelegates();
            Enumeration en = this.existingSubFiles(true);
            while (en.hasMoreElements()) {
                MultiFileObject mfo = (MultiFileObject)en.nextElement();
                if (mfo.isFolder() && !mfo.isInitialized()) continue;
                if (mfo.hasListeners()) {
                    String path = mfo.toString();
                    FileObject oldLeader = this.findLeader(oldFileSystems, path);
                    FileObject newLeader = this.findLeader(fileSystems, path);
                    if (oldLeader != null && newLeader != null && oldLeader != newLeader) {
                        mfo.fileAttributeChanged0(new FileAttributeEvent(mfo, null, null, null));
                    }
                }
                mfo.freeLastAttrCache();
                mfo.refresh(true);
            }
            Object var9_8 = null;
            this.getMultiFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.getMultiFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    private void refreshAfterEvent(FileEvent fe) {
        FileObject fSource = (FileObject)fe.getSource();
        FileObject fFile = fe.getFile();
        this.superRefresh(false);
        MultiFileObject mFile = (MultiFileObject)this.getFileObject(fFile.getName(), fFile.getExt());
        if (mFile != null) {
            mFile.superRefresh(false);
        }
    }

    private void superRefresh(boolean expected) {
        super.refresh(expected);
    }

    private FileObject findLeader(FileSystem[] fs, String path) {
        MultiFileSystem mfs = this.getMultiFileSystem();
        int i = 0;
        while (i < fs.length) {
            FileObject fo = mfs.findResourceOn(fs[i], path);
            if (fo != null) {
                return fo;
            }
            ++i;
        }
        return null;
    }

    private MultiFileSystem getMultiFileSystem() {
        return (MultiFileSystem)this.getFileSystem();
    }

    private MultiFileObject getMultiChild(String name) {
        return (MultiFileObject)this.getChild(name);
    }

    private FileObject writable() throws IOException {
        MultiFileSystem fs = this.getMultiFileSystem();
        FileSystem single = fs.createWritableOn(this.toString());
        if (single != this.leader.getFileSystem()) {
            if (this.leader.isFolder()) {
                this.leader = FileUtil.createFolder(this.root(single), this.toString());
            } else {
                FileObject folder = FileUtil.createFolder(this.root(single), this.getParent().toString());
                this.leader = this.leader.copy(folder, this.leader.getName(), this.leader.getExt());
            }
            MfLock l = this.lock == null ? null : this.lock.get();
            if (l != null) {
                l.addLock(this.leader);
            }
        }
        return this.leader;
    }

    private Enumeration delegates() {
        return this.getMultiFileSystem().delegates(this.toString());
    }

    private static void updateFoldersLock(FileObject fo) throws IOException {
        while (fo != null) {
            MultiFileObject mfo = (MultiFileObject)fo;
            MfLock l = mfo.lock == null ? null : mfo.lock.get();
            if (l != null) {
                mfo.writable();
            }
            fo = fo.getParent();
        }
    }

    protected final String[] list() {
        Properties exclude = new Properties();
        LinkedList<String> addList = new LinkedList<String>();
        HashSet<String> addSet = new HashSet<String>(101);
        Enumeration it = this.delegates();
        while (it.hasMoreElements()) {
            FileObject folder = (FileObject)it.nextElement();
            if (folder == null || !folder.isFolder()) continue;
            FileObject[] arr = folder.getChildren();
            Properties local = null;
            int i = 0;
            while (i < arr.length) {
                block9: {
                    String name;
                    block8: {
                        name = arr[i].getNameExt();
                        if (!name.endsWith("_hidden")) break block8;
                        String basename = name.substring(0, name.length() - "_hidden".length());
                        if (local == null) {
                            local = new Properties(exclude);
                        }
                        local.setProperty(basename, basename);
                        if (!this.getMultiFileSystem().getPropagateMasks()) break block9;
                    }
                    if (!addSet.contains(name) && exclude.getProperty(name) == null) {
                        addSet.add(name);
                        addList.add(name);
                    }
                }
                ++i;
            }
            if (local == null) continue;
            exclude = local;
        }
        if (this.getMultiFileSystem().getPropagateMasks()) {
            addList.removeAll(((Hashtable)exclude).keySet());
        }
        String[] res = addList.toArray(new String[addList.size()]);
        return res;
    }

    protected void refresh(String add, String remove, boolean fire, boolean expected) {
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                this.update();
                super.refresh(add, remove, fire, expected);
            }
            this.validFlag &= this.leader.isValid();
            Object var8_7 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    protected final AbstractFolder createFile(String name) {
        return new MultiFileObject(this.getMultiFileSystem(), this, name);
    }

    public boolean isFolder() {
        return this.parent == null || this.leader.isFolder();
    }

    public Date lastModified() {
        return this.leader.lastModified();
    }

    public boolean isData() {
        return this.leader.isData();
    }

    public boolean isReadOnly() {
        MultiFileSystem fs = this.getMultiFileSystem();
        if (fs.isReadOnly()) {
            return true;
        }
        if (this.leader.isReadOnly()) {
            try {
                FileSystem simple = fs.createWritableOn(this.toString());
                return simple == this.leader.getFileSystem();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    public String getMIMEType() {
        return this.leader.getMIMEType();
    }

    public long getSize() {
        return this.leader.getSize();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return this.leader.getInputStream();
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        try {
            FileLock lWritable;
            FileObject fo;
            this.getFileSystem().beginAtomicAction(markAtomicAction);
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                MfLock l = this.testLock(lock);
                fo = this.writable();
                lWritable = l.findLock(fo);
            }
            OutputStream outputStream = fo.getOutputStream(lWritable);
            Object var8_8 = null;
            this.getFileSystem().finishAtomicAction();
            return outputStream;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public synchronized FileLock lock() throws IOException {
        FileLock f;
        if (this.lock != null && (f = (FileLock)this.lock.get()) != null) {
            throw new FileAlreadyLockedException(this.toString());
        }
        Set set = this.getMultiFileSystem().createLocksOn(this.toString());
        MfLock l = new MfLock(this.leader, this.delegates(), set);
        this.lock = new WeakReference<MfLock>(l);
        return l;
    }

    private MfLock testLock(FileLock l) throws IOException {
        if (this.lock == null) {
            FSException.io("EXC_InvalidLock", l, this.toString(), this.getMultiFileSystem().getDisplayName(), this.lock);
        }
        if (this.lock.get() != l) {
            FSException.io("EXC_InvalidLock", l, this.toString(), this.getMultiFileSystem().getDisplayName(), this.lock.get());
        }
        return (MfLock)l;
    }

    public void setImportant(boolean b) {
        Enumeration en = this.delegates();
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            fo.setImportant(b);
        }
        if (!b) {
            this.getMultiFileSystem().markUnimportant(this);
        }
    }

    private static final Object voidify(Object o) {
        if (o == null) {
            return new VoidValue(0);
        }
        if (o instanceof VoidValue) {
            VoidValue vv = (VoidValue)o;
            return new VoidValue(vv.level + 1);
        }
        return o;
    }

    private static final Object devoidify(Object o) {
        if (o instanceof VoidValue) {
            VoidValue vv = (VoidValue)o;
            if (vv.level == 0) {
                return null;
            }
            return new VoidValue(vv.level - 1);
        }
        return o;
    }

    public Object getAttribute(String attrName) {
        return this.getAttribute(attrName, this.toString());
    }

    private final Object getAttribute(String attrName, String path) {
        FileSystem leaderfs;
        String prefixattr = path.length() == 0 ? null : path.replace('/', '\\') + '\\' + attrName;
        FileObject localFo = this.lastAttrCacheFile;
        String cachedAttrName = this.lastAttrCacheName;
        if (localFo != null && localFo != this && cachedAttrName.equals(attrName)) {
            Object oPerf;
            if (localFo.isRoot() && prefixattr != null) {
                try {
                    FileSystem foFs = localFo.getFileSystem();
                    if (!(foFs instanceof XMLFileSystem) && (oPerf = this.getAttribute(localFo = foFs.getRoot(), prefixattr, "")) != null) {
                        return MultiFileObject.devoidify(oPerf);
                    }
                }
                catch (FileStateInvalidException fiex) {
                    // empty catch block
                }
            }
            if ((oPerf = this.getAttribute(localFo, attrName, localFo.toString())) != null) {
                return MultiFileObject.devoidify(oPerf);
            }
        }
        FileSystem[] systems = this.getMultiFileSystem().getDelegates();
        try {
            leaderfs = this.getLeaderFileSystem();
        }
        catch (FileStateInvalidException fsie) {
            leaderfs = null;
        }
        int i = 0;
        while (i < systems.length) {
            if (systems[i] != null) {
                Object o;
                FileObject fo = this.getMultiFileSystem().findResourceOn(systems[i], path);
                if (fo != null && (o = this.getAttribute(fo, attrName, fo.toString())) != null) {
                    return MultiFileObject.devoidify(o);
                }
                if (prefixattr != null && !(systems[i] instanceof XMLFileSystem) && (o = this.getAttribute(fo = systems[i].getRoot(), prefixattr, "")) != null) {
                    return MultiFileObject.devoidify(o);
                }
            }
            ++i;
        }
        return null;
    }

    private Object getAttribute(FileObject fo, String attrName, String path) {
        Object o = fo instanceof MultiFileObject ? ((MultiFileObject)fo).getAttribute(attrName, path) : (fo instanceof AbstractFileObject ? ((AbstractFileObject)fo).getAttribute(attrName, path) : fo.getAttribute(attrName));
        if (o != null) {
            this.lastAttrCacheFile = fo;
            this.lastAttrCacheName = attrName;
        }
        return o;
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.setAttribute(attrName, value, true);
    }

    void setAttribute(String attrName, Object value, boolean fire) throws IOException {
        String path = this.toString();
        FileSystem fs = this.getMultiFileSystem().createWritableOn(path);
        FileObject fo = this.getMultiFileSystem().findResourceOn(fs, path);
        Object oldValue = null;
        String attrToSet = attrName;
        if (fire) {
            oldValue = this.getAttribute(attrName);
        }
        if (fo == null) {
            fo = fs.getRoot();
            attrToSet = path.replace('/', '\\') + '\\' + attrName;
        }
        this.lastAttrCacheFile = fo;
        this.lastAttrCacheName = attrToSet;
        if (fo instanceof AbstractFolder) {
            ((AbstractFolder)fo).setAttribute(attrToSet, MultiFileObject.voidify(value), false);
        } else {
            fire = fire && fo.isRoot();
            fo.setAttribute(attrToSet, MultiFileObject.voidify(value));
        }
        if (fire && oldValue != value && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, attrName, oldValue, value));
        }
    }

    public Enumeration getAttributes() {
        return this.getAttributes(this.toString());
    }

    private final Enumeration getAttributes(String path) {
        HashSet<String> s = new HashSet<String>();
        FileSystem[] systems = this.getMultiFileSystem().getDelegates();
        String prefix = path.length() == 0 ? null : path.replace('/', '\\') + '\\';
        int i = 0;
        while (i < systems.length) {
            if (systems[i] != null) {
                String attr;
                Enumeration e;
                FileObject fo = this.getMultiFileSystem().findResourceOn(systems[i], path);
                if (fo != null) {
                    e = fo instanceof MultiFileObject ? ((MultiFileObject)fo).getAttributes(path) : (fo instanceof AbstractFileObject ? ((AbstractFileObject)fo).getAttributes(path) : fo.getAttributes());
                    while (e.hasMoreElements()) {
                        attr = (String)e.nextElement();
                        s.add(attr);
                    }
                }
                if (prefix != null) {
                    fo = systems[i].getRoot();
                    e = fo instanceof MultiFileObject ? ((MultiFileObject)fo).getAttributes("") : (fo instanceof AbstractFileObject ? ((AbstractFileObject)fo).getAttributes("") : fo.getAttributes());
                    while (e.hasMoreElements()) {
                        attr = (String)e.nextElement();
                        if (!attr.startsWith(prefix)) continue;
                        s.add(attr.substring(prefix.length()));
                    }
                }
            }
            ++i;
        }
        return Collections.enumeration(s);
    }

    public FileObject createFolder(String name) throws IOException {
        MultiFileObject fo;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                MultiFileSystem fs = this.getMultiFileSystem();
                if (fs.isReadOnly()) {
                    FSException.io("EXC_FSisRO", fs.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", name, fs.getDisplayName());
                }
                String fullName = this.toString() + '/' + name;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", name, this.toString(), fs.getDisplayName());
                }
                if (this.getFileObject(name) != null) {
                    FSException.io("EXC_FolderAlreadyExist", name, fs.getDisplayName());
                }
                FileSystem simple = fs.createWritableOn(fullName);
                FileUtil.createFolder(this.root(simple), fullName);
                this.getMultiFileSystem().unmaskFileOnAll(simple, fullName);
                this.refresh(name, null, true, false);
                fo = this.getMultiChild(name);
                if (fo == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), name));
                }
                FileObject[] chlds = fo.getChildren();
                int i = 0;
                while (i < chlds.length) {
                    this.getMultiFileSystem().maskFile(simple, chlds[i].toString());
                    ++i;
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(fo), false);
                }
            }
            Object var11_10 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        return fo;
    }

    public FileObject createData(String name, String ext) throws IOException {
        MultiFileObject fo;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                String n;
                MultiFileSystem fs = this.getMultiFileSystem();
                if (fs.isReadOnly()) {
                    FSException.io("EXC_FSisRO", fs.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", name, fs.getDisplayName());
                }
                String string = n = "".equals(ext) ? name : name + '.' + ext;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", n, this.toString(), fs.getDisplayName());
                }
                if (this.getFileObject(name, ext) != null) {
                    FSException.io("EXC_DataAlreadyExist", n, fs.getDisplayName());
                }
                String fullName = this.toString() + '/' + n;
                FileSystem simple = fs.createWritableOn(fullName);
                FileUtil.createData(this.root(simple), fullName);
                this.getMultiFileSystem().unmaskFileOnAll(simple, fullName);
                this.refresh(n, null, true, false);
                fo = this.getMultiChild(n);
                if (fo == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), n));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(fo), true);
                }
            }
            Object var11_10 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        return fo;
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        MultiFileSystem fs = this.getMultiFileSystem();
        if (this.parent == null) {
            FSException.io("EXC_CannotRenameRoot", fs.getDisplayName());
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                MfLock l = this.testLock(lock);
                String newFullName = this.parent.toString() + '/' + name;
                if (this.isData()) {
                    newFullName = newFullName + '.' + ext;
                }
                String oldFullName = this.toString();
                if (this.isReadOnly()) {
                    FSException.io("EXC_CannotRename", this.toString(), this.getMultiFileSystem().getDisplayName(), newFullName);
                }
                if (this.getFileSystem().isReadOnly()) {
                    FSException.io("EXC_FSisRO", this.getMultiFileSystem().getDisplayName());
                }
                String on = this.getName();
                String oe = this.getExt();
                FileSystem single = fs.createWritableOnForRename(oldFullName, newFullName);
                if (single == this.leader.getFileSystem()) {
                    this.leader.rename(l.findLock(this.leader), name, ext);
                    this.getMultiFileSystem().unmaskFileOnAll(single, newFullName);
                    MultiFileObject.copyContent(this, this.leader);
                } else {
                    FileObject previousLeader = this.leader;
                    if (this.isData()) {
                        FileObject folder = FileUtil.createFolder(this.root(single), this.getParent().toString());
                        this.leader = this.leader.copy(folder, name, ext);
                        MultiFileObject.copyAttrs(this, this.leader);
                    } else {
                        FileObject fo = FileUtil.createFolder(this.root(single), newFullName);
                        MultiFileObject.copyContent(this, fo);
                        this.leader = fo;
                        this.name = name;
                        this.update();
                    }
                    l.changeLocks(previousLeader, this.leader);
                }
                if (this.getMultiFileSystem().delegates(oldFullName).hasMoreElements()) {
                    this.getMultiFileSystem().maskFile(single, oldFullName);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                if (this.isData()) {
                    name = name + '.' + ext;
                }
                String oldName = this.name;
                this.name = name;
                this.parent.refresh(name, oldName);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, on, oe));
                }
            }
            Object var16_16 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public void delete(FileLock lock) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", this.getMultiFileSystem().getDisplayName());
        }
        MultiFileSystem fs = this.getMultiFileSystem();
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                String fullName = this.toString();
                FileSystem single = fs.createWritableOn(fullName);
                if (this.needsMask(lock, true)) {
                    this.getMultiFileSystem().maskFile(single, fullName);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                String n = this.name;
                this.validFlag = false;
                this.parent.refresh(null, n, true, false);
                if (this.hasAtLeastOneListeners()) {
                    this.fileDeleted0(new FileEvent(this));
                }
            }
            Object var9_8 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        return this.leader.copy(target, name, ext);
    }

    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        MultiFileSystem fs = this.getMultiFileSystem();
        try {
            fs.beginAtomicAction();
            if (this.parent == null) {
                FSException.io("EXC_CannotDeleteRoot", fs.getDisplayName());
            }
            MfLock lck = this.testLock(lock);
            FileLock l = lck.findLock(this.leader);
            FileSystem simple = fs.createWritableOn(this.toString());
            if (fs.isReadOnly()) {
                FSException.io("EXC_FSisRO", fs.getDisplayName());
            }
            if (l == null && this.leader.getFileSystem() != simple) {
                this.leader = this.writable();
                l = lck.findLock(this.leader);
            }
            if (this.needsMask(lock, false)) {
                this.getMultiFileSystem().maskFile(simple, this.toString());
                MultiFileObject.updateFoldersLock(this.getParent());
            }
            FileObject fileObject = this.leader.move(l, target, name, ext);
            Object var11_10 = null;
            fs.finishAtomicAction();
            return fileObject;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            fs.finishAtomicAction();
            throw throwable;
        }
    }

    public final void refresh(boolean expected) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        Enumeration en = this.delegates();
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            fo.refresh(expected);
        }
        super.refresh(expected);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.updateAll();
    }

    public void fileDataCreated(FileEvent fe) {
        this.refreshAfterEvent(fe);
    }

    public void fileChanged(FileEvent fe) {
        FileObject changedFile = this;
        if (fe.getSource() == this.leader && this.hasAtLeastOneListeners() && !fe.firedFrom(markAtomicAction)) {
            if (!fe.getFile().equals(fe.getSource())) {
                changedFile = this.getFileObject(fe.getFile().getName(), fe.getFile().getExt());
            }
            if (changedFile != null) {
                this.fileChanged1(new FileEvent((FileObject)this, changedFile, fe.getTime()));
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        if (fe.getFile().isFolder()) {
            this.updateAll();
        } else {
            this.refreshAfterEvent(fe);
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.updateAll();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        if (!this.hasAtLeastOneListeners() || this.leader == null) {
            return;
        }
        if (fe.getFile() != this.leader && fe.getName() != null && this.leader.getAttribute(fe.getName()) != null) {
            return;
        }
        if (fe.getFile() != this.leader && fe.getNewValue() != null && fe.getName() != null && !fe.getNewValue().equals(this.getAttribute(fe.getName()))) {
            return;
        }
        this.fileAttributeChanged0(new FileAttributeEvent(this, fe.getName(), fe.getOldValue(), fe.getNewValue()));
    }

    private static void copyContent(FileObject source, FileObject target) throws IOException {
        FileObject[] srcArr = source.getChildren();
        MultiFileObject.copyAttrs(source, target);
        int i = 0;
        while (i < srcArr.length) {
            FileObject child = srcArr[i];
            if (!MultiFileSystem.isMaskFile(child) && target.getFileObject(child.getName(), child.getExt()) == null) {
                if (child.isData()) {
                    FileObject fo = FileUtil.copyFile(child, target, child.getName(), child.getExt());
                    if (fo != null) {
                        MultiFileObject.copyAttrs(child, fo);
                    }
                } else {
                    FileObject targetChild = target.createFolder(child.getName());
                    MultiFileObject.copyContent(child, targetChild);
                }
            }
            ++i;
        }
    }

    private static void copyAttrs(FileObject source, FileObject target) {
        Enumeration en = source.getAttributes();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object value = source.getAttribute(key);
            try {
                target.setAttribute(key, value);
            }
            catch (IOException ie) {
                // empty catch block
            }
        }
    }

    private boolean needsMask(FileLock lock, boolean deleteDelegates) throws IOException {
        MfLock lck = this.testLock(lock);
        Enumeration enumeration = this.getMultiFileSystem().delegates(this.toString());
        boolean needsMask = false;
        while (enumeration.hasMoreElements()) {
            FileObject fo = (FileObject)enumeration.nextElement();
            FileLock lockForFo = lck.findLock(fo);
            if (lockForFo == null) {
                needsMask = true;
                continue;
            }
            if (!deleteDelegates) continue;
            fo.delete(lockForFo);
        }
        return needsMask;
    }

    private FileObject root(FileSystem fs) {
        return this.getMultiFileSystem().findResourceOn(fs, "");
    }

    final FileObject getLeader() {
        return this.leader;
    }

    static class MfoWeakListener
    extends WeakListener.FileChange {
        public MfoWeakListener(FileChangeListener l) {
            super(l);
        }
    }

    private class MfLock
    extends FileLock {
        private Map map = new HashMap(11);

        public MfLock(FileObject leader, Enumeration delegates, Set systems) throws IOException {
            while (delegates.hasMoreElements()) {
                FileObject fo = (FileObject)delegates.nextElement();
                if (!systems.contains(fo.getFileSystem())) continue;
                FileLock l = fo.lock();
                this.map.put(fo, l);
            }
        }

        public FileLock findLock(FileObject fo) {
            return (FileLock)this.map.get(fo);
        }

        public void addLock(FileObject fo) throws IOException {
            this.map.put(fo, fo.lock());
        }

        public void changeLocks(FileObject old, FileObject n) throws IOException {
            FileLock l = (FileLock)this.map.remove(old);
            if (l != null) {
                l.releaseLock();
            }
            this.addLock(n);
        }

        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                Iterator it = this.map.values().iterator();
                while (it.hasNext()) {
                    FileLock l = (FileLock)it.next();
                    l.releaseLock();
                }
                this.map.clear();
                MultiFileObject.this.lock = null;
            }
        }
    }

    private static final class VoidValue
    implements Externalizable {
        int level;
        private static final long serialVersionUID = -2743645909916238684L;

        VoidValue(int level) {
            this.level = level;
        }

        public String toString() {
            return "org.openide.filesystems.MultiFileObject.VoidValue#" + this.level;
        }

        public VoidValue() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.level);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.level = in.readInt();
        }
    }
}

