/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;

public abstract class URLMapper {
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int NETWORK = 2;
    private static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$URLMapper == null ? (class$org$openide$filesystems$URLMapper = URLMapper.class$("org.openide.filesystems.URLMapper")) : class$org$openide$filesystems$URLMapper));
    static /* synthetic */ Class class$org$openide$filesystems$URLMapper;

    public static URL findURL(FileObject fo, int type) {
        URL retVal = URLMapper.getURLBasicImpl(fo, type);
        if (retVal != null) {
            return retVal;
        }
        Iterator instances = result.allInstances().iterator();
        while (instances.hasNext()) {
            URLMapper mapper = (URLMapper)instances.next();
            retVal = mapper.getURL(fo, type);
            if (retVal == null) continue;
            return retVal;
        }
        if (type == 0) {
            try {
                retVal = fo.getURL();
            }
            catch (FileStateInvalidException iex) {
                return null;
            }
        }
        return retVal;
    }

    public abstract URL getURL(FileObject var1, int var2);

    public static FileObject[] findFileObjects(URL url) {
        HashSet<FileObject> retSet = new HashSet<FileObject>();
        FileObject[] retVal = URLMapper.geFileObjectBasicImpl(url);
        if (retVal != null) {
            retSet.addAll(Arrays.asList(retVal));
        }
        Iterator instances = result.allInstances().iterator();
        while (instances.hasNext()) {
            URLMapper mapper = (URLMapper)instances.next();
            retVal = mapper.getFileObjects(url);
            if (retVal == null) continue;
            retSet.addAll(Arrays.asList(retVal));
        }
        retVal = new FileObject[retSet.size()];
        retSet.toArray(retVal);
        return retVal;
    }

    public abstract FileObject[] getFileObjects(URL var1);

    private static URL getURLBasicImpl(FileObject fo, int type) {
        if (fo == null) {
            return null;
        }
        if (type == 2) {
            return null;
        }
        URL retURL = null;
        FileSystem fs = null;
        try {
            fs = fo.getFileSystem();
        }
        catch (FileStateInvalidException fsex) {
            return null;
        }
        if (fs instanceof LocalFileSystem) {
            if (type != 1) {
                return null;
            }
            LocalFileSystem lfs = (LocalFileSystem)fs;
            File f = lfs.getRootDirectory();
            if (f == null) {
                return null;
            }
            try {
                retURL = new URL(f.toURL(), fo.toString());
            }
            catch (MalformedURLException mfx) {
                return null;
            }
        } else if (fs instanceof JarFileSystem) {
            if (type != 1) {
                return null;
            }
            if (fo.isFolder()) {
                return null;
            }
            JarFileSystem jfs = (JarFileSystem)fs;
            File f = jfs.getJarFile();
            if (f == null) {
                return null;
            }
            try {
                retURL = new URL("jar:" + f.toURL().toString() + "!/" + fo.toString());
            }
            catch (MalformedURLException mfx) {
                return null;
            }
        } else {
            if (fs instanceof MultiFileSystem) {
                FileObject leader = ((MultiFileObject)fo).getLeader();
                return URLMapper.getURLBasicImpl(leader, type);
            }
            if (fs instanceof XMLFileSystem) {
                URL retVal = null;
                try {
                    retVal = ((XMLFileSystem)fs).getURL(fo.toString());
                    if (retVal == null) {
                        return null;
                    }
                    if (type == 0) {
                        return retVal;
                    }
                    boolean isInternal = retVal.getProtocol().startsWith("nbres");
                    if (type == 1 && !isInternal) {
                        return retVal;
                    }
                    return null;
                }
                catch (FileNotFoundException fnx) {
                    return null;
                }
            }
        }
        return retURL;
    }

    private static FileObject[] geFileObjectBasicImpl(URL url) {
        String prot = url.getProtocol();
        if (prot.equals("nbfs")) {
            FileObject[] fileObjectArray;
            FileObject retVal = FileURL.decodeURL(url);
            if (retVal == null) {
                fileObjectArray = null;
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = retVal;
            }
            return fileObjectArray;
        }
        if (prot.equals("jar")) {
            try {
                URLConnection ucon = url.openConnection();
                if (ucon != null && ucon instanceof JarURLConnection) {
                    URL jarURL = ((JarURLConnection)ucon).getJarFileURL();
                    String systemName = new File(jarURL.getFile()).getCanonicalPath();
                    FileSystem fs = Repository.getDefault().findFileSystem(systemName);
                    if (fs != null && fs instanceof JarFileSystem) {
                        FileObject[] fileObjectArray;
                        FileObject retVal = fs.findResource(((JarURLConnection)ucon).getEntryName());
                        if (retVal == null) {
                            fileObjectArray = null;
                        } else {
                            FileObject[] fileObjectArray3 = new FileObject[1];
                            fileObjectArray = fileObjectArray3;
                            fileObjectArray3[0] = retVal;
                        }
                        return fileObjectArray;
                    }
                }
            }
            catch (IOException iox) {
                return null;
            }
            return null;
        }
        if (prot.equals("file")) {
            try {
                File f = new File(url.getFile()).getCanonicalFile();
                FileObject[] foRes = FileUtil.fromFile(f);
                if (foRes != null && foRes.length > 0) {
                    return foRes;
                }
            }
            catch (IOException iox) {
                return null;
            }
            return null;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

