/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.NbBundle;
import org.openide.util.enum.EmptyEnumeration;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLFileSystem
extends AbstractFileSystem {
    static final long serialVersionUID = 28974107313702326L;
    private URL[] urlsToXml = new URL[0];
    private transient FileObjRef rootRef;
    private static final Map DTD_MAP = new HashMap();
    static /* synthetic */ Class class$org$openide$filesystems$XMLFileSystem;

    public XMLFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    public XMLFileSystem(String uri) throws SAXException {
        this();
        try {
            this.setXmlUrl(new URL(uri));
        }
        catch (Exception e) {
            throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(e.getMessage()), e);
        }
    }

    public XMLFileSystem(URL url) throws SAXException {
        this();
        try {
            this.setXmlUrl(url);
        }
        catch (Exception e) {
            throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(e.getMessage()), e);
        }
    }

    public XMLFileSystem(FileSystemCapability cap) {
        this();
        this.setCapability(cap);
    }

    public URL getXmlUrl() {
        return this.urlsToXml.length > 0 ? this.urlsToXml[0] : null;
    }

    public synchronized void setXmlUrl(URL url) throws IOException, PropertyVetoException {
        this.setXmlUrl(url, false);
    }

    public synchronized void setXmlUrl(URL url, boolean validate) throws IOException, PropertyVetoException {
        this.setXmlUrls(new URL[]{url}, validate);
    }

    public URL[] getXmlUrls() {
        return this.urlsToXml;
    }

    public synchronized void setXmlUrls(URL[] urls) throws IOException, PropertyVetoException {
        this.setXmlUrls(urls, false);
    }

    private synchronized void setXmlUrls(URL[] urls, boolean validate) throws IOException, PropertyVetoException {
        String oldDisplayName = this.getDisplayName();
        if (urls.length == 0) {
            this.urlsToXml = new URL[0];
            ResourceElem rootElem = new ResourceElem(true, urls, null);
            this.refreshChildrenInAtomicAction((AbstractFolder)this.getRoot(), rootElem);
            rootElem = null;
            return;
        }
        ResourceElem rootElem = new ResourceElem(true, urls, null);
        Handler handler = new Handler(DTD_MAP, rootElem, validate);
        URL[] origUrls = this.urlsToXml;
        this.urlsToXml = new URL[urls.length];
        try {
            this.setSystemName("XML_" + urls[0].toString());
        }
        catch (PropertyVetoException pvx) {
            this.urlsToXml = origUrls;
            rootElem = null;
            throw pvx;
        }
        URL act = null;
        try {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(validate);
                factory.setNamespaceAware(false);
                Parser xp = factory.newSAXParser().getParser();
                xp.setEntityResolver(handler);
                xp.setDocumentHandler(handler);
                xp.setErrorHandler(handler);
                int index = 0;
                while (index < urls.length) {
                    this.urlsToXml[index] = act = urls[index];
                    handler.urlContext = act;
                    xp.parse(act.toString());
                    ++index;
                }
                this.refreshChildrenInAtomicAction((AbstractFolder)this.getRoot(), rootElem);
            }
            catch (IOException iox) {
                this.urlsToXml = origUrls;
                throw iox;
            }
            catch (Exception e) {
                IOException x = new IOException(e.getMessage() + " : " + act);
                ExternalUtil.copyAnnotation(x, e);
                throw x;
            }
            Object var12_16 = null;
            rootElem = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            rootElem = null;
            throw throwable;
        }
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
    }

    boolean isLastModifiedCacheEnabled() {
        return false;
    }

    private boolean isFolder(String name) {
        Reference ref = this.findReference(name);
        if (ref != null && ref instanceof FileObjRef) {
            return ((FileObjRef)ref).isFolder();
        }
        return false;
    }

    private InputStream getInputStream(String name) throws FileNotFoundException {
        Reference ref = this.findReference(name);
        if (ref != null && ref instanceof FileObjRef) {
            return ((FileObjRef)ref).getInputStream(name);
        }
        throw new FileNotFoundException(NbBundle.getMessage(class$org$openide$filesystems$XMLFileSystem == null ? (class$org$openide$filesystems$XMLFileSystem = XMLFileSystem.class$("org.openide.filesystems.XMLFileSystem")) : class$org$openide$filesystems$XMLFileSystem, "EXC_CanntRead", name));
    }

    URL getURL(String name) throws FileNotFoundException {
        Reference ref = this.findReference(name);
        if (ref != null && ref instanceof FileObjRef) {
            return ((FileObjRef)ref).createAbsoluteUrl(name);
        }
        throw new FileNotFoundException(NbBundle.getMessage(class$org$openide$filesystems$XMLFileSystem == null ? (class$org$openide$filesystems$XMLFileSystem = XMLFileSystem.class$("org.openide.filesystems.XMLFileSystem")) : class$org$openide$filesystems$XMLFileSystem, "EXC_CanntRead", name));
    }

    private long getSize(String name) {
        Reference ref = this.findReference(name);
        if (ref != null && ref instanceof FileObjRef) {
            return ((FileObjRef)ref).getSize(name);
        }
        return 0L;
    }

    private Date lastModified(String name) {
        Reference ref = this.findReference(name);
        if (ref != null && ref instanceof FileObjRef) {
            return ((FileObjRef)ref).lastModified(name);
        }
        return new Date(0L);
    }

    public String getDisplayName() {
        if (this.urlsToXml.length == 0 || this.urlsToXml[0] == null || this.urlsToXml[0].toString().length() == 0) {
            return NbBundle.getMessage(class$org$openide$filesystems$XMLFileSystem == null ? (class$org$openide$filesystems$XMLFileSystem = XMLFileSystem.class$("org.openide.filesystems.XMLFileSystem")) : class$org$openide$filesystems$XMLFileSystem, "XML_NotValidXMLFileSystem");
        }
        return "XML:" + this.urlsToXml[0].toString().trim();
    }

    public boolean isReadOnly() {
        return true;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = ois.readFields();
        URL[] urls = (URL[])fields.get("urlsToXml", null);
        if (urls == null) {
            urls = new URL[]{(URL)fields.get("uriId", null)};
        }
        try {
            if (this.urlsToXml.length != 1) {
                this.setXmlUrls(this.urlsToXml);
            } else {
                this.setXmlUrl(this.urlsToXml[0]);
            }
        }
        catch (PropertyVetoException ex) {
            IOException x = new IOException(ex.getMessage());
            ExternalUtil.copyAnnotation(x, ex);
            throw x;
        }
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    protected Reference createReference(FileObject fo) {
        return new FileObjRef(fo);
    }

    private void refreshChildrenInAtomicAction(AbstractFolder fo, ResourceElem resElem) {
        try {
            this.beginAtomicAction();
            this.refreshChildren(fo, resElem);
            Object var4_3 = null;
            this.finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finishAtomicAction();
            throw throwable;
        }
    }

    private void refreshChildren(AbstractFolder fo, ResourceElem resElem) {
        if (fo.isRoot()) {
            this.rootRef = new FileObjRef(fo);
            this.initializeReference(this.rootRef, resElem);
        }
        List nameList = resElem.getChildren();
        String[] names = new String[nameList.size()];
        ResourceElem[] children = new ResourceElem[names.length];
        nameList.toArray(names);
        int i = 0;
        while (i < names.length) {
            children[i] = resElem.getChild(names[i]);
            ++i;
        }
        fo.refresh(null, null, true, true, names);
        int i2 = 0;
        while (i2 < children.length) {
            AbstractFolder fo2 = (AbstractFolder)fo.getFileObject(names[i2]);
            FileObjRef currentRef = (FileObjRef)this.findReference(fo2.toString());
            this.initializeReference(currentRef, children[i2]);
            if (fo2.isFolder()) {
                this.refreshChildren(fo2, children[i2]);
            }
            ++i2;
        }
    }

    private void initializeReference(FileObjRef currentRef, ResourceElem resElem) {
        if (!currentRef.isInitialized()) {
            currentRef.initialize(resElem);
        } else {
            currentRef.attacheAttrs(resElem.getAttr(false));
            currentRef.setUrlContext(resElem.getUrlContext());
            if (resElem.getContent() != null) {
                currentRef.content = resElem.getContent();
            } else if (resElem.getURI() != null) {
                currentRef.content = resElem.getURI();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DTD_MAP.put("-//NetBeans//DTD Filesystem 1.0//EN", "org/openide/filesystems/filesystem.dtd");
        DTD_MAP.put("-//NetBeans//DTD Filesystem 1.1//EN", "org/openide/filesystems/filesystem1_1.dtd");
    }

    static class Handler
    extends HandlerBase {
        private static final int FILESYSTEM_CODE = "filesystem".hashCode();
        private static final int FOLDER_CODE = "folder".hashCode();
        private static final int FILE_CODE = "file".hashCode();
        private static final int ATTR_CODE = "attr".hashCode();
        private ResourceElem rootElem;
        private boolean validate = false;
        Stack resElemStack = new Stack();
        Stack elementStack = new Stack();
        URL urlContext;
        private Map dtdMap;
        private ResourceElem topRE;
        private StringBuffer pcdata = new StringBuffer();
        static /* synthetic */ Class class$org$openide$filesystems$XMLFileSystem;

        Handler(Map dtdMap, ResourceElem rootElem, boolean validate) {
            this.dtdMap = dtdMap;
            this.rootElem = rootElem;
            this.validate = validate;
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void startElement(String name, AttributeList amap) throws SAXException {
            int controlCode = name.hashCode();
            this.elementStack.push(name);
            String foName = amap.getValue("name");
            if (controlCode == FOLDER_CODE) {
                if (foName == null) {
                    throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$XMLFileSystem == null ? (class$org$openide$filesystems$XMLFileSystem = Handler.class$("org.openide.filesystems.XMLFileSystem")) : class$org$openide$filesystems$XMLFileSystem, "XML_MisssingAttr"));
                }
                ResourceElem newRes = new ResourceElem(true, this.urlContext, null);
                this.topRE = this.topRE.addChild(foName, newRes);
                this.resElemStack.push(this.topRE);
                return;
            }
            if (controlCode == FILE_CODE) {
                if (foName == null) {
                    throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$XMLFileSystem == null ? (class$org$openide$filesystems$XMLFileSystem = Handler.class$("org.openide.filesystems.XMLFileSystem")) : class$org$openide$filesystems$XMLFileSystem, "XML_MisssingAttr"));
                }
                foName = foName.intern();
                String uri = null;
                if (amap.getLength() > 1) {
                    uri = amap.getValue("url");
                }
                ResourceElem newRes = new ResourceElem(false, this.urlContext, uri);
                this.topRE = this.topRE.addChild(foName, newRes);
                this.resElemStack.push(this.topRE);
                this.pcdata.setLength(0);
                return;
            }
            if (controlCode == ATTR_CODE) {
                if (foName == null) {
                    throw new SAXException(NbBundle.getMessage(class$org$openide$filesystems$XMLFileSystem == null ? (class$org$openide$filesystems$XMLFileSystem = Handler.class$("org.openide.filesystems.XMLFileSystem")) : class$org$openide$filesystems$XMLFileSystem, "XML_MisssingAttr"));
                }
                int len = amap.getLength();
                int i = 0;
                while (i < len) {
                    String key = amap.getName(i);
                    String value = amap.getValue(i);
                    if (XMLMapAttr.Attr.isValid(key) != -1) {
                        XMLMapAttr.Attr attr = new XMLMapAttr.Attr(key, value);
                        XMLMapAttr attrMap = this.topRE.getAttr(true);
                        Object retVal = attrMap.put(foName, attr);
                        if (retVal != null) {
                            attrMap.put(foName, retVal);
                        }
                    }
                    ++i;
                }
                return;
            }
        }

        public void endElement(String name) throws SAXException {
            if (this.elementStack.peek().hashCode() == FILE_CODE && !this.topRE.isFolder()) {
                String string = this.pcdata.toString().trim();
                if (string.length() > 0) {
                    this.topRE.setContent(string.getBytes());
                }
                this.pcdata.setLength(0);
            }
            int controlCode = name.hashCode();
            this.elementStack.pop();
            if (controlCode == FOLDER_CODE || controlCode == FILE_CODE) {
                this.resElemStack.pop();
                this.topRE = (ResourceElem)this.resElemStack.peek();
                return;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.elementStack.peek().hashCode() != FILE_CODE) {
                return;
            }
            if (this.topRE.isFolder()) {
                return;
            }
            this.pcdata.append(new String(ch, start, length));
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            String publicURL = (String)this.dtdMap.get(pid);
            if (publicURL != null) {
                if (this.validate) {
                    publicURL = this.getClass().getClassLoader().getResource(publicURL).toString();
                    return new InputSource(publicURL);
                }
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return new InputSource(sid);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.resElemStack = new Stack();
            this.resElemStack.push(this.rootElem);
            this.topRE = this.rootElem;
            this.elementStack = new Stack();
            this.elementStack.push("<root>");
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            this.resElemStack.pop();
            this.elementStack.pop();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class FileObjRef
    extends WeakReference {
        private FileObject fo;
        private Object content;
        private XMLMapAttr foAttrs;
        byte isFolder = (byte)-1;
        Object urlContext = null;

        public FileObjRef(FileObject fo) {
            super(fo);
            this.fo = fo;
        }

        public boolean isInitialized() {
            return this.isFolder != -1;
        }

        public void initialize(ResourceElem res) {
            this.content = res.getContent();
            XMLMapAttr tmp = res.getAttr(false);
            if (tmp != null && !tmp.isEmpty()) {
                this.foAttrs = tmp;
            }
            byte by = this.isFolder = res.isFolder() ? (byte)1 : 0;
            if (this.content == null) {
                this.content = res.getURI();
            }
            this.setUrlContext(res.getUrlContext());
        }

        public boolean isFolder() {
            return this.isFolder == 1;
        }

        public void attacheAttrs(XMLMapAttr attrs) {
            if (attrs == null || attrs.isEmpty()) {
                return;
            }
            if (this.foAttrs == null) {
                this.foAttrs = new XMLMapAttr();
            }
            Iterator it = attrs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry attrEntry = (Map.Entry)it.next();
                Object retVal = this.foAttrs.put(attrEntry.getKey(), attrEntry.getValue());
            }
        }

        public void setUrlContext(URL[] ctx) {
            if (ctx.length > 0) {
                this.urlContext = ctx.length > 1 ? ctx : ctx[0];
            }
        }

        public Enumeration attributes() {
            if (this.foAttrs == null) {
                return EmptyEnumeration.EMPTY;
            }
            HashSet s = new HashSet(this.foAttrs.keySet());
            return Collections.enumeration(s);
        }

        private URL[] getLayers() {
            if (this.urlContext == null) {
                return null;
            }
            if (this.urlContext instanceof URL[]) {
                return (URL[])this.urlContext;
            }
            return new URL[]{(URL)this.urlContext};
        }

        public Object readAttribute(String attrName) {
            if (attrName.equals("layers")) {
                return this.getLayers();
            }
            if (this.foAttrs == null) {
                return null;
            }
            Object[] objs = new Object[]{this.fo, attrName};
            return this.foAttrs.get(attrName, objs);
        }

        public InputStream getInputStream(String name) throws FileNotFoundException {
            InputStream is = null;
            if (this.content == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (this.content instanceof String) {
                String uri = (String)this.content;
                URL absURL = this.createAbsoluteUrl(name);
                try {
                    is = absURL.openStream();
                }
                catch (IOException iox) {
                    FileNotFoundException x = new FileNotFoundException(name);
                    ExternalUtil.copyAnnotation(x, iox);
                    throw x;
                }
            }
            if (this.content instanceof byte[]) {
                is = new ByteArrayInputStream((byte[])this.content);
            }
            if (is == null) {
                throw new FileNotFoundException(name);
            }
            return is;
        }

        private URL createAbsoluteUrl(String name) throws FileNotFoundException {
            if (!(this.content instanceof String)) {
                return null;
            }
            String uri = (String)this.content;
            try {
                URL[] uc = this.getLayers();
                URL retVal = uc == null || uc.length == 0 ? new URL(uri) : new URL(uc[0], uri);
                return retVal;
            }
            catch (IOException ex) {
                FileNotFoundException x = new FileNotFoundException(name);
                ExternalUtil.copyAnnotation(x, ex);
                throw x;
            }
        }

        public long getSize(String name) {
            if (this.content == null) {
                return 0L;
            }
            if (this.content instanceof byte[]) {
                return ((byte[])this.content).length;
            }
            if (this.content instanceof String) {
                try {
                    String uri = (String)this.content;
                    URL absURL = this.createAbsoluteUrl(name);
                    return absURL.openConnection().getContentLength();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return 0L;
        }

        public Date lastModified(String name) {
            URL url;
            if (this.content == null || !(this.content instanceof String)) {
                return new Date(0L);
            }
            try {
                url = this.createAbsoluteUrl(name);
            }
            catch (IOException iex) {
                return new Date(0L);
            }
            File localFile = this.getLocalFile(url);
            if (localFile != null) {
                return new Date(localFile.lastModified());
            }
            return this.timeFromDateHeaderField(url);
        }

        private File getLocalFile(URL url0) {
            return FileObjRef.getFileFromResourceString(FileObjRef.getLocalResource(url0));
        }

        private static String getLocalResource(URL url) {
            if (url == null) {
                return null;
            }
            if (url.getProtocol().equals("jar")) {
                URL testURL = null;
                try {
                    testURL = new URL(url.getFile());
                    if (testURL.getProtocol().equals("file")) {
                        return testURL.getFile();
                    }
                }
                catch (MalformedURLException mfx) {
                    return null;
                }
            }
            if (url.getProtocol().equals("file")) {
                return url.getFile();
            }
            return null;
        }

        private static File getFileFromResourceString(String localResource) {
            if (localResource == null) {
                return null;
            }
            int idx = localResource.indexOf(33);
            String fileName = idx != -1 ? localResource.substring(0, idx) : localResource;
            File f = new File(fileName);
            if (f.exists()) {
                return f;
            }
            return null;
        }

        private Date timeFromDateHeaderField(URL url) {
            try {
                URLConnection urlConn = url.openConnection();
                return new Date(urlConn.getDate());
            }
            catch (IOException ie) {
                return new Date(0L);
            }
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        static final long serialVersionUID = -67233358102597232L;
        private long urlDate = 0L;
        private XMLFileSystem fs;

        public Impl(XMLFileSystem fs) {
            this.fs = fs;
        }

        public String[] children(String name) {
            FileObject fo2name = this.fs.findResource(name);
            if (fo2name == null) {
                return new String[0];
            }
            FileObject fileObject = fo2name;
            synchronized (fileObject) {
                String[] stringArray = ((AbstractFolder)fo2name).getChildrenArray();
                return stringArray;
            }
        }

        public void createFolder(String name) throws IOException {
            throw new IOException();
        }

        public void createData(String name) throws IOException {
            throw new IOException();
        }

        public void rename(String oldName, String newName) throws IOException {
            throw new IOException();
        }

        public void delete(String name) throws IOException {
            throw new IOException();
        }

        public Date lastModified(String name) {
            return this.fs.lastModified(name);
        }

        public boolean folder(String name) {
            return this.fs.isFolder(name);
        }

        public boolean readOnly(String name) {
            return true;
        }

        public String mimeType(String name) {
            return null;
        }

        public long size(String name) {
            if (this.fs.isFolder(name)) {
                return 0L;
            }
            return this.fs.getSize(name);
        }

        public InputStream inputStream(String name) throws FileNotFoundException {
            InputStream is = this.fs.getInputStream(name);
            if (is == null) {
                throw new FileNotFoundException(name);
            }
            return is;
        }

        public OutputStream outputStream(String name) throws IOException {
            throw new IOException();
        }

        public void lock(String name) throws IOException {
            FSException.io("EXC_CannotLock", name, this.fs.getDisplayName(), name);
        }

        public void unlock(String name) {
        }

        public void markUnimportant(String name) {
        }

        public Object readAttribute(String name, String attrName) {
            FileObjRef ref = (FileObjRef)this.fs.findReference(name);
            if (ref == null && name.length() == 0 && this.fs.rootRef != null) {
                ref = this.fs.rootRef;
            }
            if (ref == null) {
                return null;
            }
            return ref.readAttribute(attrName);
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            throw new IOException();
        }

        public Enumeration attributes(String name) {
            FileObjRef ref = (FileObjRef)this.fs.findReference(name);
            if (ref == null && name.length() == 0 && this.fs.rootRef != null) {
                ref = this.fs.rootRef;
            }
            if (ref == null) {
                return EmptyEnumeration.EMPTY;
            }
            return ref.attributes();
        }

        public void renameAttributes(String oldName, String newName) {
        }

        public void deleteAttributes(String name) {
        }
    }

    private static class ResourceElem {
        private List children;
        private List names;
        private byte[] content;
        private List urlContext = new ArrayList();
        private XMLMapAttr foAttrs;
        private boolean isFolder;
        private String uri;

        public ResourceElem(boolean isFolder, URL[] urlContext, String uri) {
            this.isFolder = isFolder;
            this.uri = uri;
            this.urlContext.addAll(Arrays.asList(urlContext));
            if (isFolder) {
                this.children = new ArrayList();
                this.names = new ArrayList();
            }
        }

        public ResourceElem(boolean isFolder, URL urlContext, String uri) {
            this.isFolder = isFolder;
            this.uri = uri;
            this.urlContext.add(urlContext);
            if (isFolder) {
                this.children = new ArrayList();
                this.names = new ArrayList();
            }
        }

        ResourceElem addChild(String name, ResourceElem child) {
            if (!this.isFolder) {
                throw new IllegalArgumentException("not a folder");
            }
            ResourceElem retVal = child;
            int idx = this.names.indexOf(name);
            if (idx == -1) {
                this.names.add(name);
                this.children.add(child);
            } else {
                retVal = (ResourceElem)this.children.get(idx);
            }
            return retVal;
        }

        List getChildren() {
            return this.names;
        }

        ResourceElem getChild(String name) {
            return (ResourceElem)this.children.get(this.names.indexOf(name));
        }

        XMLMapAttr getAttr(boolean create) {
            if (create && this.foAttrs == null) {
                this.foAttrs = new XMLMapAttr();
            }
            return this.foAttrs;
        }

        byte[] getContent() {
            return this.content;
        }

        URL[] getUrlContext() {
            URL[] retVal = new URL[this.urlContext.size()];
            this.urlContext.toArray(retVal);
            return retVal;
        }

        String getURI() {
            return this.uri;
        }

        void setContent(byte[] content) {
            if (this.content == null) {
                byte[] alloc = new byte[content.length];
                System.arraycopy(content, 0, alloc, 0, content.length);
                this.content = alloc;
            }
        }

        boolean isFolder() {
            return this.isFolder;
        }
    }
}

