/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.TreeSelectionEvent;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ClassNamePanel
extends JPanel
implements DocumentListener,
WizardDescriptor.FinishPanel {
    private ChangeListener listener;
    private String extension;
    DataFolder targetFolder;
    private JPanel namePanel;
    private JTextField className;
    private JLabel jLabel1;
    static /* synthetic */ Class class$org$openide$loaders$ClassNamePanel;

    public ClassNamePanel() {
        this.initComponents();
        this.setName(ClassNamePanel.getString("LAB_NewClassPanelName"));
        this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.className.getDocument().addDocumentListener(this);
        this.className.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$loaders$ClassNamePanel == null ? (class$org$openide$loaders$ClassNamePanel = ClassNamePanel.class$("org.openide.loaders.ClassNamePanel")) : class$org$openide$loaders$ClassNamePanel);
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_TemplateClassName_Mnemonic").charAt(0));
        this.setClassName("");
        this.putClientProperty("WizardPanel_contentData", new String[]{this.getName()});
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
        this.className.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TemplateClassName"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ClassNamePanel"));
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.className = new JTextField();
        this.setLayout(new BorderLayout(0, 8));
        this.setPreferredSize(new Dimension(560, 520));
        this.namePanel.setLayout(new GridBagLayout());
        this.namePanel.setPreferredSize(new Dimension(0, 0));
        this.jLabel1.setLabelFor(this.className);
        this.jLabel1.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplateClassName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.namePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.className.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ClassNamePanel.this.classNameFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.namePanel.add((Component)this.className, gridBagConstraints);
        this.add((Component)this.namePanel, "Center");
    }

    private void packageNameFocusGained(FocusEvent evt) {
    }

    private void packageModelChanged(ListDataEvent evt) {
    }

    private void classNameFocusGained(FocusEvent evt) {
        if (Utilities.getOperatingSystem() == 8 | Utilities.getOperatingSystem() == 256) {
            return;
        }
        this.className.selectAll();
    }

    private void templatesTreeValueChanged(TreeSelectionEvent evt) {
    }

    public void changedUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.className.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ClassNamePanel.this.className.getText().equals("")) {
                        ClassNamePanel.this.setClassName("");
                    }
                    ClassNamePanel.this.fireStateChanged();
                }
            });
        }
    }

    public void removeUpdate(DocumentEvent p1) {
        this.changedUpdate(p1);
    }

    public void insertUpdate(DocumentEvent p1) {
        this.changedUpdate(p1);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$openide$loaders$ClassNamePanel == null ? (class$org$openide$loaders$ClassNamePanel = ClassNamePanel.class$("org.openide.loaders.ClassNamePanel")) : class$org$openide$loaders$ClassNamePanel);
    }

    public boolean isValid() {
        Object obj = this.targetFolder.getPrimaryFile().getAttribute("isRemoteAndSlow");
        boolean makeFileExistsChecks = true;
        if (obj instanceof Boolean) {
            boolean bl = makeFileExistsChecks = (Boolean)obj == false;
        }
        if (makeFileExistsChecks) {
            FileObject f = this.targetFolder.getPrimaryFile().getFileObject(this.className.getText(), this.extension);
            return f == null;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    private void setClassName(String name) {
        String n = name;
        if (name == null || name.length() == 0) {
            n = ClassNamePanel.defaultClassName();
        }
        this.className.getDocument().removeDocumentListener(this);
        this.className.setText(n);
        this.className.getDocument().addDocumentListener(this);
        if (name == null || name.length() == 0) {
            this.className.selectAll();
        }
    }

    public String getClassName() {
        return this.className.getText();
    }

    static String defaultClassName() {
        return ClassNamePanel.getString("FMT_DefaultClassName");
    }

    private static String getString(String key) {
        return NbBundle.getBundle(class$org$openide$loaders$ClassNamePanel == null ? (class$org$openide$loaders$ClassNamePanel = ClassNamePanel.class$("org.openide.loaders.ClassNamePanel")) : class$org$openide$loaders$ClassNamePanel).getString(key);
    }

    public Component getComponent() {
        return this;
    }

    public void readSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        DataObject template = wizard.getTemplate();
        if (template != null) {
            this.extension = template.getPrimaryFile().getExt();
        }
        try {
            this.targetFolder = wizard.getTargetFolder();
        }
        catch (IOException x) {
            ErrorManager.getDefault().notify(x);
        }
    }

    public void storeSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        String name = this.className.getText();
        if (name.equals(ClassNamePanel.defaultClassName())) {
            name = null;
        }
        wizard.setTargetName(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

