/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashSet;
import org.openide.ServiceType;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerType;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public class CompilerSupport
implements CompilerCookie {
    private static final String EA_COMPILER_MANAGER = "NetBeansAttrDataObjectCompilerManager";
    public static final String PROP_COMPILER_TYPE = "compiler";
    private MultiDataObject.Entry entry;
    private Class cookie;
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    static /* synthetic */ Class class$org$openide$compiler$CompilerType;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    protected CompilerSupport(MultiDataObject.Entry entry, Class cookie) {
        this.entry = entry;
        this.cookie = cookie;
    }

    public boolean isDepthSupported(Compiler.Depth depth) {
        return Compiler.DEPTH_ONE == depth;
    }

    public void addToJob(CompilerJob job, Compiler.Depth depth) {
        CompilerType comp = CompilerSupport.getCompilerType(this.entry);
        if (comp == null) {
            comp = this.defaultCompilerType();
        }
        if (comp == null) {
            throw new IllegalStateException(this.getClass().getName() + ".defaultCompilerType returned null");
        }
        comp.prepareJob(job, this.cookie, this.entry.getDataObject());
    }

    protected CompilerType defaultCompilerType() {
        return CompilerType.getDefault();
    }

    public static void setCompilerType(MultiDataObject.Entry entry, CompilerType man) throws IOException {
        entry.getFile().setAttribute(EA_COMPILER_MANAGER, man == null ? null : new ServiceType.Handle(man));
    }

    public static CompilerType getCompilerType(MultiDataObject.Entry entry) {
        Object man = entry.getFile().getAttribute(EA_COMPILER_MANAGER);
        if (man == null || !(man instanceof ServiceType.Handle)) {
            return null;
        }
        ServiceType type = ((ServiceType.Handle)man).getServiceType();
        if (type instanceof CompilerType) {
            return (CompilerType)type;
        }
        Lookup l = Environment.find(entry.getDataObject());
        return (CompilerType)l.lookup(class$org$openide$compiler$CompilerType == null ? (class$org$openide$compiler$CompilerType = CompilerSupport.class$("org.openide.compiler.CompilerType")) : class$org$openide$compiler$CompilerType);
    }

    public void addProperties(Sheet.Set set) {
        set.put(this.createCompilerProperty());
    }

    public static void prepareJob(CompilerJob job, Enumeration en, Class type, Compiler.Depth depth) {
        CompilerSupport.prepareJobFor(job, en, type, depth, null);
    }

    static void prepareJobFor(CompilerJob job, Enumeration en, Class type, Compiler.Depth depth, Object forObj) {
        HashSet<Object> processsedObjects = new HashSet<Object>(37);
        if (forObj != null) {
            processsedObjects.add(forObj);
        }
        FilterEnumeration cookies = new FilterEnumeration(CompilerSupport.enumerateForDepth(type, en, depth, processsedObjects));
        while (cookies.hasMoreElements()) {
            CompilerCookie cc = (CompilerCookie)cookies.nextElement();
            cc.addToJob(job, depth);
        }
    }

    private static Enumeration enumerateForDepth(Class cookie, Enumeration nodesOrDataObjects, Compiler.Depth depth, HashSet processedObjects) {
        QueueEnumeration queue = new QueueEnumeration();
        queue.put(CompilerSupport.processArray(nodesOrDataObjects, cookie, queue, depth, processedObjects));
        return new SequenceEnumeration(queue);
    }

    private static Enumeration processArray(Enumeration en, final Class cookie, final QueueEnumeration queue, final Compiler.Depth depth, final HashSet processsedObjects) {
        return new AlterEnumeration(en){

            public Object alter(Object o) {
                return CompilerSupport.processObject(o, cookie, queue, depth, processsedObjects);
            }
        };
    }

    private static CompilerCookie processObject(Object obj, Class cookie, QueueEnumeration queue, Compiler.Depth depth, HashSet processsedObjects) {
        DataObject.Container cont;
        DataFolder.Cmp fc;
        if (processsedObjects.contains(obj)) {
            return null;
        }
        CompilerCookie c = (CompilerCookie)CompilerSupport.resolveCookie(obj, cookie);
        if (c != obj) {
            processsedObjects.add(obj);
        }
        if (c instanceof DataFolder.Cmp && (fc = (DataFolder.Cmp)c).wasCreatedFor(obj)) {
            c = null;
        }
        if (c != null) {
            if (processsedObjects.contains(c)) {
                return null;
            }
            processsedObjects.add(c);
            return c;
        }
        if (!depth.isLastDepth() && (cont = (DataObject.Container)CompilerSupport.resolveCookie(obj, class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = CompilerSupport.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container)) != null) {
            Object[] arr = cont.getChildren();
            ArrayEnumeration en = new ArrayEnumeration(arr);
            queue.put(CompilerSupport.processArray(en, cookie, queue, depth.nextDepth(), processsedObjects));
        }
        return null;
    }

    private static Object resolveCookie(Object obj, Class cookie) {
        Object res = null;
        if (obj instanceof DataObject) {
            res = ((DataObject)obj).getCookie(cookie);
        } else if (obj instanceof Node) {
            res = ((Node)obj).getCookie(cookie);
        } else if (cookie.isInstance(obj)) {
            res = obj;
        }
        return res;
    }

    private PropertySupport createCompilerProperty() {
        return new PropertySupport.ReadWrite(PROP_COMPILER_TYPE, class$org$openide$compiler$CompilerType == null ? (class$org$openide$compiler$CompilerType = CompilerSupport.class$("org.openide.compiler.CompilerType")) : class$org$openide$compiler$CompilerType, DataObject.getString("PROP_compilerType"), DataObject.getString("HINT_compilerType")){

            public Object getValue() {
                CompilerType ct = CompilerSupport.getCompilerType(CompilerSupport.this.entry);
                if (ct == null) {
                    return CompilerSupport.this.defaultCompilerType();
                }
                return ct;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    CompilerSupport.setCompilerType(CompilerSupport.this.entry, (CompilerType)val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)CompilerSupport.this.entry.getFile().getAttribute(CompilerSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Clean
    extends CompilerSupport
    implements CompilerCookie.Clean {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;

        public Clean(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = Clean.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Build
    extends CompilerSupport
    implements CompilerCookie.Build {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;

        public Build(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = Build.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Compile
    extends CompilerSupport
    implements CompilerCookie.Compile {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

        public Compile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = Compile.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

