/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openide.cookies.ConnectionCookie;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;

public class ConnectionSupport
implements ConnectionCookie {
    private static final String EA_LISTENERS = "EA-OpenIDE-Connection";
    private MultiDataObject.Entry entry;
    private ConnectionCookie.Type[] types;
    private Set typesSet;
    private LinkedList listeners;
    static /* synthetic */ Class class$org$openide$cookies$ConnectionCookie$Listener;

    public ConnectionSupport(MultiDataObject.Entry entry, ConnectionCookie.Type[] types) {
        this.entry = entry;
        this.types = types;
    }

    public synchronized void register(ConnectionCookie.Type type, Node listener) throws IOException {
        this.testSupported(type);
        boolean persistent = type.isPersistent();
        LinkedList<Pair> list = persistent ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (list == null) {
            list = new LinkedList<Pair>();
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Node n;
            Pair pair = (Pair)it.next();
            if (!type.equals(pair.getType())) continue;
            try {
                n = pair.getNode();
            }
            catch (IOException e) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    e.printStackTrace();
                }
                it.remove();
                continue;
            }
            if (!n.equals(listener)) continue;
            it.remove();
        }
        list.add(persistent ? new Pair(type, listener.getHandle()) : new Pair(type, listener));
        if (persistent) {
            this.entry.getFile().setAttribute(EA_LISTENERS, list);
        }
    }

    public synchronized void unregister(ConnectionCookie.Type type, Node listener) throws IOException {
        this.testSupported(type);
        boolean persistent = type.isPersistent();
        LinkedList list = persistent ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Node n;
            Pair pair = (Pair)it.next();
            if (!type.equals(pair.getType())) continue;
            try {
                n = pair.getNode();
            }
            catch (IOException e) {
                it.remove();
                continue;
            }
            if (!n.equals(listener)) continue;
            it.remove();
        }
        if (persistent) {
            this.entry.getFile().setAttribute(EA_LISTENERS, list);
        }
    }

    public Set getTypes() {
        if (this.typesSet == null) {
            this.typesSet = Collections.unmodifiableSet(new HashSet<ConnectionCookie.Type>(Arrays.asList(this.types)));
        }
        return this.typesSet;
    }

    public List getRegisteredTypes() {
        LinkedList<ConnectionCookie.Type> typesList = new LinkedList<ConnectionCookie.Type>();
        LinkedList list = this.listeners;
        int i = 0;
        while (i <= 1) {
            if (i == 1) {
                list = (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS);
            }
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    typesList.add(((Pair)it.next()).getType());
                }
            }
            ++i;
        }
        return typesList;
    }

    public synchronized void fireEvent(ConnectionCookie.Event ev) {
        ConnectionCookie.Type type = ev.getType();
        boolean persistent = type.isPersistent();
        LinkedList list = persistent ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (list == null) {
            return;
        }
        int size = list.size();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            if (!pair.getType().overlaps(ev.getType())) continue;
            try {
                ConnectionCookie.Listener l = (ConnectionCookie.Listener)pair.getNode().getCookie(class$org$openide$cookies$ConnectionCookie$Listener == null ? ConnectionSupport.class$("org.openide.cookies.ConnectionCookie$Listener") : class$org$openide$cookies$ConnectionCookie$Listener);
                if (l == null) continue;
                try {
                    l.notify(ev);
                }
                catch (IllegalArgumentException e) {
                    it.remove();
                }
                catch (ClassCastException e) {
                    it.remove();
                }
            }
            catch (IOException e) {
                it.remove();
            }
        }
        if (persistent && list.size() != size) {
            try {
                this.entry.getFile().setAttribute(EA_LISTENERS, list);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public synchronized Set listenersFor(ConnectionCookie.Type type) {
        LinkedList list = type.isPersistent() ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (list == null) {
            return Collections.EMPTY_SET;
        }
        Iterator it = list.iterator();
        HashSet<Node> set = new HashSet<Node>(7);
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            if (!type.overlaps(pair.getType())) continue;
            try {
                set.add(pair.getNode());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return set;
    }

    private void testSupported(ConnectionCookie.Type t) throws InvalidObjectException {
        int i = 0;
        while (i < this.types.length) {
            if (t.overlaps(this.types[i])) {
                return;
            }
            ++i;
        }
        throw new InvalidObjectException(t.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Pair
    implements Serializable {
        private ConnectionCookie.Type type;
        private Object value;
        static final long serialVersionUID = 387180886175136728L;

        public Pair(ConnectionCookie.Type t, Node n) {
            this.type = t;
            this.value = n;
        }

        public Pair(ConnectionCookie.Type t, Node.Handle h) throws IOException {
            if (h == null) {
                throw new IOException();
            }
            this.type = t;
            this.value = h;
        }

        public ConnectionCookie.Type getType() {
            return this.type;
        }

        public Node getNode() throws IOException {
            return this.value instanceof Node ? (Node)this.value : ((Node.Handle)this.value).getNode();
        }
    }
}

