/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.SafeException;

public abstract class DataLoader
extends SharedClassObject {
    private static final long serialVersionUID = 1986614061378346169L;
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ACTIONS = "actions";
    private static final String PROP_DEF_ACTIONS = "defaultActions";
    private static final Object PROP_REPRESENTATION_CLASS = new Object();
    private static final Object PROP_REPRESENTATION_CLASS_NAME = new Object();
    private static final int LOADER_VERSION = 1;
    static /* synthetic */ Class class$org$openide$loaders$DataLoader;

    protected DataLoader(Class representationClass) {
        this.putProperty(PROP_REPRESENTATION_CLASS, representationClass);
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, representationClass.getName());
    }

    protected DataLoader(String representationClassName) {
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, representationClassName);
    }

    public final Class getRepresentationClass() {
        Class<?> cls = (Class<?>)this.getProperty(PROP_REPRESENTATION_CLASS);
        if (cls != null) {
            return cls;
        }
        String clsName = (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
        try {
            cls = Class.forName(clsName, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe.toString());
        }
        this.putProperty(PROP_REPRESENTATION_CLASS, cls);
        return cls;
    }

    private String getRepresentationClassName() {
        return (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
    }

    public final SystemAction[] getActions() {
        SystemAction[] actions = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (actions == null && (actions = (SystemAction[])this.getProperty(PROP_DEF_ACTIONS)) == null) {
            actions = this.defaultActions();
            this.putProperty(PROP_DEF_ACTIONS, actions, false);
        }
        return actions;
    }

    protected SystemAction[] defaultActions() {
        SystemAction[] actions = NodeOp.getDefaultActions();
        return actions;
    }

    public final void setActions(SystemAction[] actions) {
        this.putProperty(PROP_ACTIONS, actions, true);
    }

    public final String getDisplayName() {
        String dn = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (dn != null) {
            return dn;
        }
        dn = this.defaultDisplayName();
        if (dn != null) {
            return dn;
        }
        return this.getRepresentationClassName();
    }

    protected final void setDisplayName(String displayName) {
        this.putProperty(PROP_DISPLAY_NAME, displayName, true);
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(class$org$openide$loaders$DataLoader == null ? (class$org$openide$loaders$DataLoader = DataLoader.class$("org.openide.loaders.DataLoader")) : class$org$openide$loaders$DataLoader).getString("LBL_loader_display_name");
    }

    public final DataObject findDataObject(FileObject fo, RecognizedFiles recognized) throws IOException {
        try {
            return this.handleFindDataObject(fo, recognized);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (RuntimeException e) {
            IOException ioe = new IOException(e.toString());
            ErrorManager.getDefault().annotate((Throwable)ioe, e);
            throw ioe;
        }
    }

    protected abstract DataObject handleFindDataObject(FileObject var1, RecognizedFiles var2) throws IOException;

    public final void markFile(FileObject fo) throws IOException {
        DataLoaderPool.setPreferredLoader(fo, this);
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(new Integer(1));
        SystemAction[] arr = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (arr == null) {
            oo.writeObject(null);
        } else {
            LinkedList<String> names = new LinkedList<String>();
            int i = 0;
            while (i < arr.length) {
                if (arr[i] == null) {
                    names.add(null);
                } else {
                    names.add(arr[i].getClass().getName());
                }
                ++i;
            }
            oo.writeObject(names.toArray());
        }
        String dn = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (dn == null) {
            dn = "";
        }
        oo.writeUTF(dn);
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        String displayName;
        ClassNotFoundException main = null;
        int version = 0;
        Object first = oi.readObject();
        if (first instanceof Integer) {
            version = (Integer)first;
            first = oi.readObject();
        }
        if (first != null && !(first instanceof SystemAction[])) {
            Object[] arr = (Object[])first;
            boolean isdefault = true;
            SystemAction[] defactions = this.getActions();
            if (version > 0 || version == 0 && arr.length != defactions.length) {
                isdefault = false;
            }
            LinkedList<SystemAction> ll = new LinkedList<SystemAction>();
            int i = 0;
            while (i < arr.length) {
                if (arr[i] == null) {
                    ll.add(null);
                    if (version == 0 && isdefault && defactions[i] != null) {
                        isdefault = false;
                    }
                } else {
                    try {
                        Class<?> c = Class.forName(Utilities.translate((String)arr[i]), false, TopManager.getDefault().systemClassLoader());
                        SystemAction ac = SystemAction.get(c);
                        ll.add(ac);
                        if (version == 0 && isdefault && !defactions[i].equals(ac)) {
                            isdefault = false;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        ErrorManager.getDefault().annotate(ex, 1, null, null, null, null);
                        if (main == null) {
                            main = ex;
                        }
                        ErrorManager.getDefault().annotate((Throwable)main, ex);
                    }
                }
                ++i;
            }
            if (main == null && !isdefault) {
                this.setActions(ll.toArray(new SystemAction[0]));
            }
        }
        if ((displayName = oi.readUTF()).equals("") || version == 0 && displayName.equals(this.defaultDisplayName())) {
            displayName = null;
        }
        this.setDisplayName(displayName);
        if (main != null) {
            SafeException se = new SafeException(main);
            String message = NbBundle.getMessage(class$org$openide$loaders$DataLoader == null ? (class$org$openide$loaders$DataLoader = DataLoader.class$("org.openide.loaders.DataLoader")) : class$org$openide$loaders$DataLoader, "EXC_missing_actions_in_loader", this.getDisplayName());
            ErrorManager.getDefault().annotate((Throwable)se, message);
            throw se;
        }
    }

    protected boolean clearSharedData() {
        return false;
    }

    public static DataLoader getLoader(Class loaderClass) {
        return (DataLoader)SharedClassObject.findObject(loaderClass, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface RecognizedFiles {
        public void markRecognized(FileObject var1);
    }
}

