/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.BrokenDataShadow;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.loaders.ShadowChangeAdapter;
import org.openide.loaders.UniFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

public abstract class DataLoaderPool
implements Serializable {
    static final long serialVersionUID = -360141823874889956L;
    private static MultiFileLoader[] systemLoaders;
    private static MultiFileLoader[] defaultLoaders;
    private transient DataLoader[] loaderArray;
    private transient EventListenerList listeners;
    private transient DataLoader preferredLoader;
    private static final DataLoader.RecognizedFiles emptyDataLoaderRecognized;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$openide$loaders$OperationListener;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$FolderLoader;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$Loader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$InstanceLoader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$DefaultLoader;

    protected DataLoaderPool() {
    }

    protected DataLoaderPool(DataLoader loader) {
        this.preferredLoader = loader;
    }

    protected abstract Enumeration loaders();

    public final synchronized void addChangeListener(ChangeListener chl) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DataLoaderPool.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, chl);
    }

    public final synchronized void removeChangeListener(ChangeListener chl) {
        if (this.listeners != null) {
            this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DataLoaderPool.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, chl);
        }
    }

    protected final void fireChangeEvent(final ChangeEvent che) {
        Object[] list;
        this.loaderArray = null;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getListenerList();
        }
        int i = list.length - 2;
        while (i >= 0) {
            if (list[i] == (class$javax$swing$event$ChangeListener == null ? DataLoaderPool.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                final ChangeListener l = (ChangeListener)list[i + 1];
                RequestProcessor.postRequest(new Runnable(){

                    public void run() {
                        l.stateChanged(che);
                    }
                });
            }
            i -= 2;
        }
    }

    public final synchronized void addOperationListener(OperationListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = DataLoaderPool.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener, l);
    }

    public final synchronized void removeOperationListener(OperationListener l) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = DataLoaderPool.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener, l);
        }
    }

    final void fireOperationEvent(OperationEvent ev, int type) {
        Object[] list;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getListenerList();
        }
        int i = list.length - 2;
        while (i >= 0) {
            if (list[i] == (class$org$openide$loaders$OperationListener == null ? DataLoaderPool.class$("org.openide.loaders.OperationListener") : class$org$openide$loaders$OperationListener)) {
                OperationListener l = (OperationListener)list[i + 1];
                switch (type) {
                    case 1: {
                        l.operationCopy((OperationEvent.Copy)ev);
                        break;
                    }
                    case 2: {
                        l.operationMove((OperationEvent.Move)ev);
                        break;
                    }
                    case 3: {
                        l.operationDelete(ev);
                        break;
                    }
                    case 4: {
                        l.operationRename((OperationEvent.Rename)ev);
                        break;
                    }
                    case 5: {
                        l.operationCreateShadow((OperationEvent.Copy)ev);
                        break;
                    }
                    case 6: {
                        l.operationCreateFromTemplate((OperationEvent.Copy)ev);
                        break;
                    }
                    case 7: {
                        l.operationPostCreate(ev);
                    }
                }
            }
            i -= 2;
        }
    }

    public final Enumeration allLoaders() {
        if (this.preferredLoader == null) {
            return new SequenceEnumeration(new ArrayEnumeration(new Enumeration[]{new ArrayEnumeration(DataLoaderPool.getSystemLoaders()), this.loaders(), new ArrayEnumeration(DataLoaderPool.getDefaultLoaders())}));
        }
        return new SequenceEnumeration(new ArrayEnumeration(new Enumeration[]{new SingletonEnumeration(this.preferredLoader), new ArrayEnumeration(DataLoaderPool.getSystemLoaders()), this.loaders(), new ArrayEnumeration(DataLoaderPool.getDefaultLoaders())}));
    }

    public DataLoader[] toArray() {
        DataLoader[] localArray = this.loaderArray;
        if (localArray != null) {
            return localArray;
        }
        ArrayList loaders = new ArrayList();
        Enumeration en = this.loaders();
        while (en.hasMoreElements()) {
            loaders.add(en.nextElement());
        }
        localArray = new DataLoader[loaders.size()];
        localArray = loaders.toArray(localArray);
        this.loaderArray = localArray;
        return localArray;
    }

    public final DataLoader firstProducerOf(Class clazz) {
        Enumeration en = this.allLoaders();
        while (en.hasMoreElements()) {
            DataLoader dl = (DataLoader)en.nextElement();
            if (!dl.getRepresentationClass().isAssignableFrom(clazz)) continue;
            return dl;
        }
        return null;
    }

    public final Enumeration producersOf(final Class clazz) {
        return new FilterEnumeration(this.allLoaders()){

            public boolean accept(Object o) {
                DataLoader dl = (DataLoader)o;
                return clazz.isAssignableFrom(dl.getRepresentationClass());
            }
        };
    }

    public DataObject findDataObject(FileObject fo) throws IOException {
        return this.findDataObject(fo, emptyDataLoaderRecognized);
    }

    public DataObject findDataObject(FileObject fo, DataLoader.RecognizedFiles r) throws IOException {
        DataObject obj;
        DataLoader pref = DataLoaderPool.getPreferredLoader(fo);
        if (pref != null && (obj = pref.findDataObject(fo, r)) != null) {
            DataObjectPool.getPOOL().notifyCreation(obj);
            return obj;
        }
        Enumeration en = this.allLoaders();
        while (en.hasMoreElements()) {
            DataLoader l = (DataLoader)en.nextElement();
            DataObject obj2 = l.findDataObject(fo, r);
            if (obj2 == null) continue;
            DataObjectPool.getPOOL().notifyCreation(obj2);
            return obj2;
        }
        return null;
    }

    public static void setPreferredLoader(FileObject fo, DataLoader loader) throws IOException {
        DataLoader prev = DataLoaderPool.getPreferredLoader(fo);
        if (prev == loader) {
            return;
        }
        if (loader == null) {
            fo.setAttribute("NetBeansAttrAssignedLoader", null);
        } else {
            Class<?> c = loader.getClass();
            Iterator modules = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = DataLoaderPool.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances().iterator();
            String modulename = null;
            while (modules.hasNext()) {
                ModuleInfo module = (ModuleInfo)modules.next();
                if (!module.owns(c)) continue;
                modulename = module.getCodeNameBase();
                break;
            }
            fo.setAttribute("NetBeansAttrAssignedLoader", c.getName());
            fo.setAttribute("NetBeansAttrAssignedLoaderModule", modulename);
        }
        DataObject d = DataObjectPool.getPOOL().find(fo);
        if (d != null && d.getLoader() != loader) {
            try {
                d.setValid(false);
            }
            catch (PropertyVetoException e) {
                ErrorManager.getDefault().notify(1, e);
            }
        }
    }

    public static DataLoader getPreferredLoader(FileObject fo) {
        String assignedLoaderName = (String)fo.getAttribute("NetBeansAttrAssignedLoader");
        if (assignedLoaderName != null) {
            String modulename = (String)fo.getAttribute("NetBeansAttrAssignedLoaderModule");
            if (modulename != null) {
                Iterator modules = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = DataLoaderPool.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances().iterator();
                boolean ok = false;
                while (modules.hasNext()) {
                    ModuleInfo module = (ModuleInfo)modules.next();
                    if (!module.getCodeNameBase().equals(modulename)) continue;
                    if (module.isEnabled()) {
                        ok = true;
                        break;
                    }
                    return null;
                }
                if (!ok) {
                    return null;
                }
            }
            try {
                Class<?> loaderClass = Class.forName(assignedLoaderName, true, TopManager.getDefault().systemClassLoader());
                return DataLoader.getLoader(loaderClass);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
        }
        return null;
    }

    private static MultiFileLoader[] getSystemLoaders() {
        if (systemLoaders == null) {
            systemLoaders = new MultiFileLoader[]{new ShadowLoader(), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem == null ? (class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$InstanceLoaderSystem")) : class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem)};
        }
        return systemLoaders;
    }

    private static MultiFileLoader[] getDefaultLoaders() {
        if (defaultLoaders == null) {
            defaultLoaders = new MultiFileLoader[]{(MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$FolderLoader == null ? (class$org$openide$loaders$DataLoaderPool$FolderLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$FolderLoader")) : class$org$openide$loaders$DataLoaderPool$FolderLoader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$XMLDataObject$Loader == null ? (class$org$openide$loaders$XMLDataObject$Loader = DataLoaderPool.class$("org.openide.loaders.XMLDataObject$Loader")) : class$org$openide$loaders$XMLDataObject$Loader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$InstanceLoader == null ? (class$org$openide$loaders$DataLoaderPool$InstanceLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$InstanceLoader")) : class$org$openide$loaders$DataLoaderPool$InstanceLoader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$DefaultLoader == null ? (class$org$openide$loaders$DataLoaderPool$DefaultLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$DefaultLoader")) : class$org$openide$loaders$DataLoaderPool$DefaultLoader)};
        }
        return defaultLoaders;
    }

    static MultiFileLoader getDefaultFileLoader() {
        return DataLoaderPool.getDefaultLoaders()[3];
    }

    static MultiFileLoader getFolderLoader() {
        return DataLoaderPool.getDefaultLoaders()[0];
    }

    static MultiFileLoader getShadowLoader() {
        return DataLoaderPool.getSystemLoaders()[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        emptyDataLoaderRecognized = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fo) {
            }
        };
    }

    private static class ShadowLoader
    extends UniFileLoader {
        static final long serialVersionUID = -11013405787959120L;
        private static ShadowChangeAdapter changeAdapter = new ShadowChangeAdapter();
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public ShadowLoader() {
            super("org.openide.loaders.DataShadow");
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = ShadowLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_shadow_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            if (fo.hasExt("shadow")) {
                return fo;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry(obj, primaryFile);
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            try {
                DataObject d = DataShadow.deserialize(primaryFile);
                if (d != null) {
                    return new DataShadow(primaryFile, d, this);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new BrokenDataShadow(primaryFile, this);
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class DefaultLoader
    extends MultiFileLoader {
        static final long serialVersionUID = -6761887227412396555L;
        static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$RenameAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public DefaultLoader() {
            super("org.openide.loaders.DefaultDataObject");
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = DefaultLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction), null, SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = DefaultLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DefaultLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = DefaultLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = DefaultLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), SystemAction.get(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = DefaultLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DefaultLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = DefaultLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DefaultLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_default_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            if (fo.isFolder()) {
                return null;
            }
            return fo;
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            return new DefaultDataObject(primaryFile, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry(obj, primaryFile);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
            throw new UnsupportedOperationException();
        }

        void checkFiles(MultiDataObject obj) {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class InstanceLoader
    extends UniFileLoader {
        static final long serialVersionUID = -3462727693843631328L;
        static /* synthetic */ Class class$org$openide$actions$CustomizeBeanAction;
        static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$RenameAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public InstanceLoader() {
            super("org.openide.loaders.InstanceDataObject");
        }

        protected void initialize() {
            super.initialize();
            this.setExtensions(null);
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = InstanceLoader.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction), SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = InstanceLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction), null, SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = InstanceLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = InstanceLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = InstanceLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = InstanceLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), SystemAction.get(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = InstanceLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = InstanceLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = InstanceLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = InstanceLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_instance_loader_display_name");
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            InstanceDataObject obj = new InstanceDataObject(primaryFile, this);
            return obj;
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
            oo.writeObject(this);
            super.writeExternal(oo);
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            Object o = oi.readObject();
            if (o instanceof SystemAction[]) {
                this.setActions((SystemAction[])o);
                this.setExtensions(this.getExtensions());
            } else if (o instanceof ExtensionList) {
                ExtensionList list = (ExtensionList)o;
                this.setExtensions(list);
            } else {
                super.readExternal(oi);
                this.setExtensions(this.getExtensions());
            }
        }

        public void setExtensions(ExtensionList ext) {
            super.setExtensions(this.initExtensions(ext));
        }

        private ExtensionList initExtensions(ExtensionList ext) {
            String[] rqext = this.getRequiredExt();
            if (ext == null) {
                ext = new ExtensionList();
            }
            int i = 0;
            while (i < rqext.length) {
                ext.addExtension(rqext[i]);
                ++i;
            }
            return ext;
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "ser", "settings"};
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class InstanceLoaderSystem
    extends InstanceLoader {
        private static final long serialVersionUID = -935749906623354837L;

        protected FileObject findPrimaryFile(FileObject fo) {
            FileSystem fs = null;
            try {
                fs = fo.getFileSystem();
            }
            catch (FileStateInvalidException e) {
                return null;
            }
            if (fs != Repository.getDefault().getDefaultFileSystem()) {
                return null;
            }
            return super.findPrimaryFile(fo);
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "settings"};
        }
    }

    static class FolderLoader
    extends UniFileLoader {
        static final long serialVersionUID = -8325525104047820255L;
        static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
        static /* synthetic */ Class class$org$openide$actions$FindAction;
        static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
        static /* synthetic */ Class class$org$openide$actions$CompileAction;
        static /* synthetic */ Class class$org$openide$actions$CompileAllAction;
        static /* synthetic */ Class class$org$openide$actions$BuildAction;
        static /* synthetic */ Class class$org$openide$actions$BuildAllAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$RenameAction;
        static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;

        public FolderLoader() {
            super("org.openide.loaders.DataFolder");
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = FolderLoader.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction), SystemAction.get(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = FolderLoader.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction), SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = FolderLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction), null, SystemAction.get(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = FolderLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction), SystemAction.get(class$org$openide$actions$CompileAllAction == null ? (class$org$openide$actions$CompileAllAction = FolderLoader.class$("org.openide.actions.CompileAllAction")) : class$org$openide$actions$CompileAllAction), null, SystemAction.get(class$org$openide$actions$BuildAction == null ? (class$org$openide$actions$BuildAction = FolderLoader.class$("org.openide.actions.BuildAction")) : class$org$openide$actions$BuildAction), SystemAction.get(class$org$openide$actions$BuildAllAction == null ? (class$org$openide$actions$BuildAllAction = FolderLoader.class$("org.openide.actions.BuildAllAction")) : class$org$openide$actions$BuildAllAction), null, SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = FolderLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = FolderLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = FolderLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), null, SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = FolderLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), SystemAction.get(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = FolderLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction), null, SystemAction.get(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = FolderLoader.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction), null, SystemAction.get(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = FolderLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction), SystemAction.get(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = FolderLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = FolderLoader.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool, "LBL_folder_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            if (fo.isFolder()) {
                return fo;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry.Folder(obj, primaryFile);
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            return new DataFolder(primaryFile);
        }

        MultiDataObject createMultiObject(FileObject primaryFile, DataFolder original) throws DataObjectExistsException, IOException {
            class NodeSharingDataFolder
            extends DataFolder {
                private final /* synthetic */ DataFolder val$original;
                private final /* synthetic */ FolderLoader this$0;

                public NodeSharingDataFolder(FolderLoader this$0, DataFolder val$original, FileObject fo) throws DataObjectExistsException, IllegalArgumentException {
                    super(fo);
                    this.this$0 = this$0;
                    this.val$original = val$original;
                }

                protected Node createNodeDelegate() {
                    return new FilterNode(this.val$original.getNodeDelegate());
                }

                Node getClonedNodeDelegate(DataFilter filter) {
                    return new FilterNode(this.val$original.getClonedNodeDelegate(filter));
                }
            }
            return new NodeSharingDataFolder(this, original, primaryFile);
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

