/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class DataObject
implements Node.Cookie,
Serializable {
    private static final long serialVersionUID = 3328227388376142699L;
    public static final String PROP_TEMPLATE = "template";
    public static final String PROP_NAME = "name";
    public static final String PROP_HELP = "helpCtx";
    public static final String PROP_MODIFIED = "modified";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PRIMARY_FILE = "primaryFile";
    public static final String PROP_FILES = "files";
    static final String EA_ASSIGNED_LOADER = "NetBeansAttrAssignedLoader";
    static final String EA_ASSIGNED_LOADER_MODULE = "NetBeansAttrAssignedLoaderModule";
    private static ModifiedRegistry modified = new ModifiedRegistry();
    private static Set syncModified = Collections.synchronizedSet(modified);
    private static final Object listenersMethodLock = new Object();
    private boolean modif = false;
    private transient Node nodeDelegate;
    DataObjectPool.Item item;
    private DataLoader loader;
    private EventListenerList listeners;
    private Object nodeCreationLock = new Object();
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;

    public DataObject(FileObject pf, DataLoader loader) throws DataObjectExistsException {
        this(pf, DataObjectPool.getPOOL().register(pf, loader), loader);
    }

    private DataObject(FileObject pf, DataObjectPool.Item item, DataLoader loader) {
        this.item = item;
        this.loader = loader;
        item.setDataObject(this);
    }

    protected void dispose() {
        DataObjectPool.Item item = this.item;
        if (item != null) {
            item.deregister(true);
            item.setDataObject(null);
            this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void setValid(boolean valid) throws PropertyVetoException {
        if (!valid && this.isValid()) {
            this.fireVetoableChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
            this.dispose();
            this.setModified(false);
        }
    }

    public final boolean isValid() {
        return this.item.isValid();
    }

    public final DataLoader getLoader() {
        return this.loader;
    }

    protected final void markFiles() throws IOException {
        Iterator en = this.files().iterator();
        while (en.hasNext()) {
            FileObject fo = (FileObject)en.next();
            this.loader.markFile(fo);
        }
    }

    public Set files() {
        return Collections.singleton(this.getPrimaryFile());
    }

    public final Node getNodeDelegate() {
        if (!this.isValid()) {
            IllegalStateException e = new IllegalStateException("The data object " + this.getPrimaryFile() + " is invalid; you may not call getNodeDelegate on it any more; see #17020 and please fix your code");
            ErrorManager.getDefault().notify(1, e);
        }
        if (this.nodeDelegate == null) {
            Children.MUTEX.readAccess(new Runnable(){

                public void run() {
                    Object object = DataObject.this.nodeCreationLock;
                    synchronized (object) {
                        if (DataObject.this.nodeDelegate == null) {
                            DataObject.this.nodeDelegate = DataObject.this.createNodeDelegate();
                        }
                    }
                }
            });
            if (this.nodeDelegate == null) {
                throw new IllegalStateException("DataObject " + this + " has null node delegate");
            }
        }
        return this.nodeDelegate;
    }

    Node getClonedNodeDelegate(DataFilter filter) {
        return this.getNodeDelegate().cloneNode();
    }

    Node getNodeDelegateOrNull() {
        return this.nodeDelegate;
    }

    protected Node createNodeDelegate() {
        return new DataNode(this, Children.LEAF);
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryFile().lock();
    }

    static boolean setTemplate(FileObject fo, boolean newTempl) throws IOException {
        boolean oldTempl = false;
        Object o = fo.getAttribute(PROP_TEMPLATE);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            oldTempl = true;
        }
        if (oldTempl == newTempl) {
            return false;
        }
        fo.setAttribute(PROP_TEMPLATE, newTempl ? new Boolean(true) : null);
        return true;
    }

    public final void setTemplate(boolean newTempl) throws IOException {
        if (!DataObject.setTemplate(this.getPrimaryFile(), newTempl)) {
            return;
        }
        this.firePropertyChange(PROP_TEMPLATE, new Boolean(!newTempl), new Boolean(newTempl));
    }

    public final boolean isTemplate() {
        Object o = this.getPrimaryFile().getAttribute(PROP_TEMPLATE);
        boolean ret = false;
        if (o instanceof Boolean) {
            ret = (Boolean)o;
        }
        return ret;
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean modif) {
        if (this.modif != modif) {
            this.modif = modif;
            if (modif) {
                syncModified.add(this);
            } else {
                syncModified.remove(this);
            }
            this.firePropertyChange(PROP_MODIFIED, new Boolean(!modif), new Boolean(modif));
        }
    }

    public abstract HelpCtx getHelpCtx();

    public final FileObject getPrimaryFile() {
        return this.item.primaryFile;
    }

    public static DataObject find(FileObject fo) throws DataObjectNotFoundException {
        if (fo == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (!fo.isValid()) {
                throw new FileStateInvalidException(fo.toString());
            }
            DataObject obj = DataObjectPool.getPOOL().find(fo);
            if (obj != null) {
                return obj;
            }
            obj = TopManager.getDefault().getLoaderPool().findDataObject(fo);
            if (obj != null) {
                return obj;
            }
            throw new DataObjectNotFoundException(fo);
        }
        catch (DataObjectExistsException ex) {
            return ex.getDataObject();
        }
        catch (IOException ex) {
            DataObjectNotFoundException donfe = new DataObjectNotFoundException(fo);
            ErrorManager.getDefault().annotate((Throwable)donfe, ex);
            throw donfe;
        }
    }

    public static Registry getRegistry() {
        return Registry.INSTANCE;
    }

    public String getName() {
        return this.getPrimaryFile().getName();
    }

    public String toString() {
        return super.toString() + '[' + this.getPrimaryFile() + ']';
    }

    public final DataFolder getFolder() {
        FileObject fo = this.getPrimaryFile().getParent();
        return fo == null ? null : DataFolder.findFolder(fo);
    }

    public final DataObject copy(final DataFolder f) throws IOException {
        final DataObject[] result = new DataObject[1];
        FileSystem fs = f.getPrimaryFile().getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                result[0] = DataObject.this.handleCopy(f);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(result[0], this), 1);
        return result[0];
    }

    protected abstract DataObject handleCopy(DataFolder var1) throws IOException;

    public final void delete() throws IOException {
        Object object = this.synchObject();
        synchronized (object) {
            FileSystem fs = this.getPrimaryFile().getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    DataObject.this.handleDelete();
                    DataObject.this.item.deregister(false);
                    DataObject.this.item.setDataObject(null);
                }
            });
        }
        this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        DataObject.fireOperationEvent(new OperationEvent(this), 3);
    }

    protected abstract void handleDelete() throws IOException;

    public final void rename(final String name) throws IOException {
        String oldName;
        if (name != null && name.trim().length() == 0) {
            IllegalArgumentException iae = new IllegalArgumentException(this.getName());
            String msg = NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "MSG_NotValidName", this.getName());
            ErrorManager.getDefault().annotate((Throwable)iae, msg);
            throw iae;
        }
        final FileObject[] files = new FileObject[2];
        Object object = this.synchObject();
        synchronized (object) {
            oldName = this.getName();
            if (oldName.equals(name)) {
                return;
            }
            files[0] = this.getPrimaryFile();
            FileSystem fs = files[0].getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    files[1] = DataObject.this.handleRename(name);
                    if (files[0] != files[1]) {
                        DataObject.this.item.changePrimaryFile(files[1]);
                    }
                }
            });
        }
        if (files[0] != files[1]) {
            this.firePropertyChange(PROP_PRIMARY_FILE, files[0], this.getPrimaryFile());
        }
        DataObject.fireOperationEvent(new OperationEvent.Rename(this, oldName), 4);
        this.firePropertyChange(PROP_NAME, oldName, this.getName());
    }

    protected abstract FileObject handleRename(String var1) throws IOException;

    public final void move(final DataFolder df) throws IOException {
        FileObject old;
        Object object = this.synchObject();
        synchronized (object) {
            if (this.getFolder() == null) {
                return;
            }
            if (df.equals(this.getFolder())) {
                return;
            }
            old = this.getPrimaryFile();
            FileSystem fs = old.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject mf = DataObject.this.handleMove(df);
                    DataObject.this.item.changePrimaryFile(mf);
                }
            });
        }
        this.firePropertyChange(PROP_PRIMARY_FILE, old, this.getPrimaryFile());
        DataObject.fireOperationEvent(new OperationEvent.Move(this, old), 2);
    }

    protected abstract FileObject handleMove(DataFolder var1) throws IOException;

    protected DataShadow handleCreateShadow(DataFolder f) throws IOException {
        return DataShadow.create(f, this);
    }

    public final DataShadow createShadow(final DataFolder f) throws IOException {
        final DataShadow[] result = new DataShadow[1];
        FileSystem fs = f.getPrimaryFile().getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                result[0] = DataObject.this.handleCreateShadow(f);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(result[0], this), 5);
        return result[0];
    }

    public final DataObject createFromTemplate(DataFolder f) throws IOException {
        return this.createFromTemplate(f, null);
    }

    public final DataObject createFromTemplate(final DataFolder f, final String name) throws IOException {
        final DataObject[] result = new DataObject[1];
        FileSystem fs = f.getPrimaryFile().getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                result[0] = DataObject.this.handleCreateFromTemplate(f, name);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(result[0], this), 6);
        return result[0];
    }

    protected abstract DataObject handleCreateFromTemplate(DataFolder var1, String var2) throws IOException;

    private static void fireOperationEvent(OperationEvent ev, int type) {
        TopManager.getDefault().getLoaderPool().fireOperationEvent(ev, type);
    }

    Object synchObject() {
        return this.nodeCreationLock;
    }

    private EventListenerList listeners() {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
        }
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners().add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DataObject.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners().remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DataObject.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
    }

    protected final void firePropertyChange(String name, Object oldValue, Object newValue) {
        Object[] listeners = this.listeners().getListenerList();
        PropertyChangeEvent fooEvent = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$beans$PropertyChangeListener == null ? DataObject.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                if (fooEvent == null) {
                    fooEvent = new PropertyChangeEvent(this, name, oldValue, newValue);
                }
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(fooEvent);
            }
            i -= 2;
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.listeners().add(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = DataObject.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.listeners().remove(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = DataObject.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, l);
    }

    protected final void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        Object[] listeners = this.listeners().getListenerList();
        PropertyChangeEvent fooEvent = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$beans$VetoableChangeListener == null ? DataObject.class$("java.beans.VetoableChangeListener") : class$java$beans$VetoableChangeListener)) {
                if (fooEvent == null) {
                    fooEvent = new PropertyChangeEvent(this, name, oldValue, newValue);
                }
                ((VetoableChangeListener)listeners[i + 1]).vetoableChange(fooEvent);
            }
            i -= 2;
        }
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isInstance(this)) {
            return this;
        }
        return null;
    }

    protected Node.Cookie getCookie(DataShadow shadow, Class clazz) {
        return this.getCookie(clazz);
    }

    public Object writeReplace() {
        return new Replace(this);
    }

    static String getString(String name) {
        return NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, name);
    }

    void recognizedByFolder() {
    }

    void notifyFileRenamed(FileRenameEvent fe) {
        if (fe.getFile().equals(this.getPrimaryFile())) {
            this.firePropertyChange(PROP_NAME, fe.getName(), this.getName());
        }
    }

    void notifyFileDeleted(FileEvent fe) {
    }

    void notifyFileDataCreated(FileEvent fe) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ModifiedRegistry
    extends HashSet {
        private HashSet listeners;
        static final long serialVersionUID = -2861723614638919680L;

        private ModifiedRegistry() {
        }

        public final synchronized void addChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                this.listeners = new HashSet(5);
            }
            this.listeners.add(chl);
        }

        public final synchronized void removeChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(chl);
        }

        public boolean add(Object o) {
            boolean result = super.add(o);
            if (result) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return result;
        }

        public boolean remove(Object o) {
            boolean result = super.remove(o);
            if (result) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return result;
        }

        protected final void fireChangeEvent(ChangeEvent che) {
            HashSet cloned;
            if (this.listeners == null) {
                return;
            }
            ModifiedRegistry modifiedRegistry = this;
            synchronized (modifiedRegistry) {
                cloned = (HashSet)this.listeners.clone();
            }
            Iterator iter = cloned.iterator();
            while (iter.hasNext()) {
                ((ChangeListener)iter.next()).stateChanged(che);
            }
        }
    }

    public static final class Registry {
        private static Registry INSTANCE = new Registry();

        private Registry() {
        }

        public void addChangeListener(ChangeListener chl) {
            modified.addChangeListener(chl);
        }

        public void removeChangeListener(ChangeListener chl) {
            modified.removeChangeListener(chl);
        }

        public Set getModifiedSet() {
            return Collections.unmodifiableSet(syncModified);
        }

        public DataObject[] getModified() {
            return ((AbstractCollection)modified).toArray(new DataObject[0]);
        }
    }

    public static interface Container
    extends Node.Cookie {
        public static final String PROP_CHILDREN = "children";

        public DataObject[] getChildren();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static final class Replace
    implements Serializable {
        private FileObject fo;
        private transient DataObject obj;
        private static final long serialVersionUID = -627843044348243058L;

        public Replace(DataObject obj) {
            this.obj = obj;
            this.fo = obj.getPrimaryFile();
        }

        public Object readResolve() {
            return this.obj;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.obj = DataObject.find(this.fo);
        }
    }
}

