/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FolderList;
import org.openide.loaders.OperationEvent;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

final class DataObjectPool
implements ChangeListener,
RepositoryListener,
PropertyChangeListener,
Runnable {
    private static final Validator VALIDATOR = new Validator();
    private HashMap map = new HashMap();
    private WeakSet knownFileSystems = new WeakSet();
    private static DataObjectPool POOL;
    private static Object lockPOOL;
    private HashSet toNotify = new HashSet();
    private ThreadLocal last = new ThreadLocal();
    private long toNotifyModified;
    private static final int SAFE_NOTIFY_DELAY = 500;
    private static final Integer ONE;
    private RequestProcessor.Task task;
    private final Map registrationCounts = new WeakHashMap();

    static DataObjectPool getPOOL() {
        Object object = lockPOOL;
        synchronized (object) {
            if (POOL != null) {
                DataObjectPool dataObjectPool = POOL;
                return dataObjectPool;
            }
            POOL = new DataObjectPool();
        }
        TopManager.getDefault().getLoaderPool().addChangeListener(POOL);
        TopManager.getDefault().getRepository().addRepositoryListener(POOL);
        return POOL;
    }

    private DataObjectPool() {
        this.task = RequestProcessor.createRequest(this);
        this.task.setPriority(1);
    }

    public DataObject find(FileObject fo) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            Item doh = (Item)this.map.get(fo);
            if (doh == null) {
                DataObject dataObject = null;
                return dataObject;
            }
            if (this.toNotify.contains(doh) && this.last.get() != doh) {
                DataObject dataObject = null;
                return dataObject;
            }
            DataObject dataObject = doh.getDataObjectOrNull();
            return dataObject;
        }
    }

    void countRegistration(FileObject fo) {
        Integer i = (Integer)this.registrationCounts.get(fo);
        Integer i2 = i == null ? ONE : new Integer(i + 1);
        this.registrationCounts.put(fo, i2);
    }

    int registrationCount(FileObject fo) {
        Integer i = (Integer)this.registrationCounts.get(fo);
        if (i == null) {
            return 0;
        }
        return i;
    }

    private void refreshAllFolders() {
        HashSet files;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            files = new HashSet(this.map.keySet());
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            DataObject obj;
            FileObject fo = (FileObject)it.next();
            if (!fo.isFolder() || !((obj = this.find(fo)) instanceof DataFolder)) continue;
            DataFolder df = (DataFolder)obj;
            FileObject file = df.getPrimaryFile();
            DataObjectPool dataObjectPool2 = this;
            synchronized (dataObjectPool2) {
                if (this.toNotify.isEmpty() || !this.toNotify.contains((Item)this.map.get(file))) {
                    FolderList.changedDataSystem(file);
                }
            }
        }
    }

    public Set revalidate(Set s) {
        return VALIDATOR.revalidate(s);
    }

    public Set revalidate() {
        Set files;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            files = DataObjectPool.createSetOfAllFiles(this.map.values());
        }
        return this.revalidate(files);
    }

    public void notifyCreation(DataObject obj) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            if (this.toNotify.isEmpty()) {
                return;
            }
            if (!this.toNotify.remove(obj.item)) {
                return;
            }
            if (this.toNotify.isEmpty()) {
                this.task.cancel();
            }
            this.notifyAll();
        }
        DataLoaderPool pool = TopManager.getDefault().getLoaderPool();
        pool.fireOperationEvent(new OperationEvent(obj), 7);
    }

    public void waitNotified(DataObject obj) {
        try {
            DataObjectPool dataObjectPool = this;
            synchronized (dataObjectPool) {
                if (this.toNotify.isEmpty()) {
                    return;
                }
                if (obj.item == this.last.get()) {
                    return;
                }
                if (!this.toNotify.contains(obj.item)) {
                    return;
                }
                this.wait(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        Item[] arr;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            if (this.toNotify.isEmpty()) {
                return;
            }
            if (System.currentTimeMillis() < this.toNotifyModified + 500L) {
                this.task.schedule(500);
                return;
            }
            arr = ((AbstractCollection)this.toNotify).toArray(new Item[this.toNotify.size()]);
        }
        int i = 0;
        while (i < arr.length) {
            DataObject obj = arr[i].getDataObjectOrNull();
            if (obj != null) {
                this.notifyCreation(obj);
            } else {
                DataObjectPool dataObjectPool2 = this;
                synchronized (dataObjectPool2) {
                    this.toNotify.remove(arr[i]);
                }
            }
            ++i;
        }
    }

    private void notifyAdd(Item item) {
        if (this.toNotify.isEmpty()) {
            this.task.schedule(500);
        }
        this.toNotify.add(item);
        this.last.set(item);
        this.toNotifyModified = System.currentTimeMillis();
    }

    public Item register(FileObject fo, DataLoader loader) throws DataObjectExistsException {
        DataObject obj;
        Item doh;
        try {
            FileSystem fs = fo.getFileSystem();
            WeakSet weakSet = this.knownFileSystems;
            synchronized (weakSet) {
                if (!this.knownFileSystems.contains(fs)) {
                    fs.addFileChangeListener(new FSListener());
                    this.knownFileSystems.add(fs);
                }
            }
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            doh = (Item)this.map.get(fo);
            if (doh == null) {
                doh = new Item(fo);
                this.map.put(fo, doh);
                this.countRegistration(fo);
                this.notifyAdd(doh);
                VALIDATOR.notifyRegistered(fo);
                Item item = doh;
                return item;
            }
            obj = doh.getDataObjectOrNull();
            if (obj == null) {
                doh = new Item(fo);
                this.map.put(fo, doh);
                this.countRegistration(fo);
                this.notifyAdd(doh);
                Item item = doh;
                return item;
            }
            if (!VALIDATOR.reregister(obj, loader)) {
                throw new DataObjectExistsException(obj);
            }
        }
        try {
            obj.setValid(false);
            DataObjectPool dataObjectPool2 = this;
            synchronized (dataObjectPool2) {
                Item doh2 = (Item)this.map.get(fo);
                if (doh2 == null) {
                    doh = new Item(fo);
                    this.map.put(fo, doh);
                    this.countRegistration(fo);
                    this.notifyAdd(doh);
                    Item item = doh;
                    return item;
                }
            }
        }
        catch (PropertyVetoException ex) {
            VALIDATOR.refusingObjects.add(obj);
        }
        throw new DataObjectExistsException(obj);
    }

    private synchronized void deregister(Item item, boolean refresh) {
        DataFolder df;
        Item item2;
        FileObject fo = item.primaryFile;
        Item previous = (Item)this.map.remove(fo);
        if (previous != null && previous != item) {
            this.map.put(fo, previous);
            this.countRegistration(fo);
            if (this.toNotify.remove(item)) {
                if (this.toNotify.isEmpty()) {
                    this.task.cancel();
                }
                this.notifyAll();
            }
            return;
        }
        if (refresh && (fo = fo.getParent()) != null && (item2 = (Item)this.map.get(fo)) != null && (df = (DataFolder)item2.getDataObjectOrNull()) != null) {
            VALIDATOR.refreshFolderOf(df);
        }
    }

    private synchronized void changePrimaryFile(Item item, FileObject newFile) {
        this.map.remove(item.primaryFile);
        item.primaryFile = newFile;
        this.map.put(newFile, item);
        this.countRegistration(newFile);
    }

    public void stateChanged(ChangeEvent ev) {
        Set<Object> set;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            set = new HashSet(this.map.values());
        }
        set = DataObjectPool.createSetOfAllFiles(set);
        this.revalidate(set);
    }

    private static Set createSetOfAllFiles(Collection c) {
        HashSet set = new HashSet(c.size() * 7);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            DataObject obj = item.getDataObjectOrNull();
            if (obj == null) continue;
            set.addAll(obj.files());
        }
        return set;
    }

    private void removeInvalidObjects() {
        Set<Object> files;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            files = new HashSet(this.map.values());
        }
        files = DataObjectPool.createSetOfAllFiles(files);
        VALIDATOR.removeInvalidObject(files);
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        ev.getFileSystem().addPropertyChangeListener(DataObjectPool.getPOOL());
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        ev.getFileSystem().removePropertyChangeListener(DataObjectPool.getPOOL());
        this.removeInvalidObjects();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("systemName".equals(ev.getPropertyName())) {
            this.removeInvalidObjects();
        }
        if ("root".equals(ev.getPropertyName())) {
            this.removeInvalidObjects();
        }
    }

    Iterator getActiveDataObjects() {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            ArrayList alist = new ArrayList(this.map.values());
            Iterator iterator = ((AbstractList)alist).iterator();
            return iterator;
        }
    }

    static {
        lockPOOL = new Object();
        ONE = new Integer(1);
    }

    private static final class Validator
    implements DataLoader.RecognizedFiles {
        private Set files;
        private Thread current;
        private int waiters;
        private HashSet recognizedFiles;
        private HashSet refusingObjects;
        private HashSet createdFiles;

        Validator() {
        }

        private synchronized Set enter(Set set) {
            ++this.waiters;
            while (this.current != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.current = Thread.currentThread();
            --this.waiters;
            if (this.files == null) {
                this.files = set;
            } else {
                this.files.addAll(set);
            }
            return this.files;
        }

        private synchronized void exit() {
            this.current = null;
            if (this.waiters == 0) {
                this.files = null;
            }
            this.notify();
        }

        private synchronized boolean goOn() {
            return this.waiters == 0;
        }

        public void refreshFolderOf(DataFolder df) {
            if (this.createdFiles == null) {
                FolderList.changedDataSystem(df.getPrimaryFile());
            }
        }

        public void markRecognized(FileObject fo) {
            this.recognizedFiles.add(fo);
        }

        public void notifyRegistered(FileObject fo) {
            if (this.createdFiles != null) {
                this.createdFiles.add(fo);
            }
        }

        public boolean reregister(DataObject obj, DataLoader loader) {
            if (this.recognizedFiles == null) {
                return false;
            }
            if (obj.getLoader() == loader) {
                return false;
            }
            if (this.createdFiles.contains(obj.getPrimaryFile())) {
                return false;
            }
            return !this.refusingObjects.contains(obj);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set revalidate(Set s) {
            HashSet hashSet;
            LinkedList<DataObject> createObjects = new LinkedList<DataObject>();
            try {
                s = this.enter(s);
                this.recognizedFiles = new HashSet();
                this.refusingObjects = new HashSet();
                this.createdFiles = new HashSet();
                HashSet<FileSystem> allFS = new HashSet<FileSystem>(Arrays.asList(TopManager.getDefault().getRepository().toArray()));
                DataLoaderPool pool = TopManager.getDefault().getLoaderPool();
                Iterator it = s.iterator();
                while (it.hasNext() && this.goOn()) {
                    boolean invalidate;
                    FileObject fo = (FileObject)it.next();
                    if (this.recognizedFiles.contains(fo)) continue;
                    try {
                        FileSystem fs = fo.getFileSystem();
                        invalidate = !allFS.contains(fs);
                    }
                    catch (FileStateInvalidException ex) {
                        invalidate = true;
                    }
                    try {
                        DataObject orig = DataObjectPool.getPOOL().find(fo);
                        if (orig == null) continue;
                        if (!invalidate) {
                            DataObject obj = pool.findDataObject(fo, this);
                            createObjects.add(obj);
                            boolean bl = invalidate = obj != orig;
                        }
                        if (!invalidate) continue;
                        it.remove();
                        try {
                            orig.setValid(false);
                        }
                        catch (PropertyVetoException ex) {
                            this.refusingObjects.add(orig);
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                hashSet = this.refusingObjects;
                Object var11_13 = null;
                this.recognizedFiles = null;
                this.refusingObjects = null;
                this.createdFiles = null;
                this.exit();
                if (s.size() <= 1) return hashSet;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.recognizedFiles = null;
                this.refusingObjects = null;
                this.createdFiles = null;
                this.exit();
                if (s.size() <= 1) throw throwable;
                DataObjectPool.getPOOL().refreshAllFolders();
                throw throwable;
            }
            DataObjectPool.getPOOL().refreshAllFolders();
            return hashSet;
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void removeInvalidObject(Set files) {
            try {
                files = this.enter(files);
                HashSet<FileSystem> allFS = new HashSet<FileSystem>();
                FileSystem[] fss = TopManager.getDefault().getRepository().toArray();
                int i = 0;
                while (i < fss.length) {
                    allFS.add(fss[i]);
                    ++i;
                }
                Iterator it = files.iterator();
                boolean bl = true;
                do {
                    if (!bl || (bl = false) || !true) {
                        boolean invalidate;
                        FileObject fo = (FileObject)it.next();
                        boolean bl2 = invalidate = !fo.isValid();
                        if (!invalidate) {
                            try {
                                FileSystem fs = fo.getFileSystem();
                                invalidate = !allFS.contains(fs);
                            }
                            catch (FileStateInvalidException ex) {
                                invalidate = true;
                            }
                        }
                        DataObject orig = null;
                        DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
                        synchronized (dataObjectPool) {
                            Item itm = (Item)DataObjectPool.getPOOL().map.get(fo);
                            if (itm == null) {
                            } else {
                                orig = itm.getDataObjectOrNull();
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 9, 12, 14] lbl32 : MonitorExitStatement: MONITOREXIT : var9_10
                                if (invalidate && orig != null) {
                                    it.remove();
                                    try {
                                        orig.setValid(false);
                                    }
                                    catch (PropertyVetoException ex) {
                                        ErrorManager.getDefault().notify(1, ex);
                                    }
                                }
                            }
                        }
                    }
                    if (!it.hasNext()) break;
                } while (this.goOn());
                Object var13_13 = null;
                this.exit();
                return;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.exit();
                throw throwable;
            }
        }
    }

    static final class ReferenceHandler
    implements Runnable {
        ReferenceHandler() {
        }

        static void start() {
            RequestProcessor.postRequest(new ReferenceHandler(), 5000);
        }

        private void restart() {
            RequestProcessor.postRequest(this, 5000);
        }

        public void run() {
            ItemReference.checkQueue();
            this.restart();
        }
    }

    static final class ItemReference
    extends WeakReference {
        private static ReferenceQueue refqueue;
        private Item item;

        private static synchronized ReferenceQueue getRefqueue() {
            if (refqueue == null) {
                refqueue = new ReferenceQueue();
                ReferenceHandler.start();
            }
            return refqueue;
        }

        static void checkQueue() {
            if (refqueue == null) {
                return;
            }
            ItemReference ref = (ItemReference)refqueue.poll();
            while (ref != null) {
                ref.deregister();
                ref = (ItemReference)refqueue.poll();
            }
        }

        ItemReference(DataObject dobject, Item item) {
            super(dobject, ItemReference.getRefqueue());
            this.item = item;
            ItemReference.checkQueue();
        }

        private void deregister() {
            this.item.deregister(false);
            this.item = null;
        }
    }

    static final class Item {
        private static final Reference REFERENCE_NOT_SET = new WeakReference<Object>(null);
        private Reference obj = REFERENCE_NOT_SET;
        FileObject primaryFile;

        public Item(FileObject fo) {
            this.primaryFile = fo;
        }

        public void setDataObject(DataObject obj) {
            this.obj = new ItemReference(obj, this);
            if (obj != null && !obj.getPrimaryFile().isValid()) {
                this.deregister(false);
            }
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                DataObjectPool.getPOOL().notifyAll();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        DataObject getDataObjectOrNull() {
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            // MONITORENTER : dataObjectPool
            while (this.obj == REFERENCE_NOT_SET) {
                try {
                    DataObjectPool.getPOOL().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : dataObjectPool
            if (this.obj == null) {
                return null;
            }
            DataObject dataObject = (DataObject)this.obj.get();
            return dataObject;
        }

        public DataObject getDataObject() {
            DataObject obj = this.getDataObjectOrNull();
            if (obj == null) {
                throw new IllegalStateException();
            }
            return obj;
        }

        public void deregister(boolean refresh) {
            DataObjectPool.getPOOL().deregister(this, refresh);
        }

        public void changePrimaryFile(FileObject newFile) {
            DataObjectPool.getPOOL().changePrimaryFile(this, newFile);
        }

        public boolean isValid() {
            if (DataObjectPool.getPOOL().map.get(this.primaryFile) == this) {
                return this.primaryFile.isValid();
            }
            return false;
        }

        public String toString() {
            DataObject obj = (DataObject)this.obj.get();
            if (obj == null) {
                return "nothing[" + this.primaryFile + "]";
            }
            return obj.toString();
        }
    }

    private final class FSListener
    extends FileChangeAdapter {
        private FSListener() {
        }

        private Iterator getTargets(FileEvent fe) {
            FileObject fo = fe.getFile();
            LinkedList<Item> toNotify = new LinkedList<Item>();
            DataObjectPool dataObjectPool = DataObjectPool.this;
            synchronized (dataObjectPool) {
                Item itm = (Item)DataObjectPool.this.map.get(fo);
                if (itm != null) {
                    toNotify.add(itm);
                } else {
                    FileObject parent = fo.getParent();
                    if (parent != null) {
                        FileObject[] siblings = parent.getChildren();
                        int i = 0;
                        while (i < siblings.length) {
                            itm = (Item)DataObjectPool.this.map.get(siblings[i]);
                            if (itm != null) {
                                toNotify.add(itm);
                            }
                            ++i;
                        }
                    }
                }
            }
            return toNotify.iterator();
        }

        public void fileRenamed(FileRenameEvent fe) {
            Iterator it = this.getTargets(fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (dobj == null) continue;
                dobj.notifyFileRenamed(fe);
            }
        }

        public void fileDeleted(FileEvent fe) {
            Iterator it = this.getTargets(fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (dobj == null) continue;
                dobj.notifyFileDeleted(fe);
            }
        }

        public void fileDataCreated(FileEvent fe) {
            Iterator it = this.getTargets(fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (dobj == null) continue;
                dobj.notifyFileDataCreated(fe);
            }
        }
    }
}

