/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.LoaderTransfer;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

abstract class DataTransferSupport {
    DataTransferSupport() {
    }

    protected abstract PasteTypeExt[] definePasteTypes(int var1);

    protected abstract int[] defineOperations();

    protected void handleCreatePasteTypes(Transferable t, List s) {
    }

    public final void createPasteTypes(Transferable t, List s) {
        int[] ops = this.defineOperations();
        int i = 0;
        while (i < ops.length) {
            DataObject[] objs = LoaderTransfer.getDataObjects(t, ops[i]);
            if (objs != null && objs.length != 0) {
                PasteTypeExt[] pts = this.definePasteTypes(ops[i]);
                int j = 0;
                while (j < pts.length) {
                    pts[j].setDataObjects(objs);
                    if (pts[j].canPaste()) {
                        s.add(pts[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.handleCreatePasteTypes(t, s);
    }

    static class InstantiatePaste
    extends PasteType {
        private InstanceCookie cookie;
        private DataFolder target;
        static /* synthetic */ Class class$org$openide$loaders$DataTransferSupport$InstantiatePaste;

        public InstantiatePaste(DataFolder target, InstanceCookie cookie) {
            this.cookie = cookie;
            this.target = target;
        }

        public String getName() {
            return DataObject.getString("PT_instance");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$loaders$DataTransferSupport$InstantiatePaste == null ? (class$org$openide$loaders$DataTransferSupport$InstantiatePaste = InstantiatePaste.class$("org.openide.loaders.DataTransferSupport$InstantiatePaste")) : class$org$openide$loaders$DataTransferSupport$InstantiatePaste);
        }

        public final Transferable paste() throws IOException {
            try {
                Class clazz = this.cookie.instanceClass();
                NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(DataObject.getString("InstanceClass_Text"), DataObject.getString("InstanceClass_Title"));
                nd.setInputText(Utilities.getShortClassName(clazz));
                if (NotifyDescriptor.OK_OPTION == TopManager.getDefault().notify(nd)) {
                    String name = nd.getInputText();
                    if (name.equals("")) {
                        name = null;
                    }
                    InstanceDataObject.create(this.getTargetFolder(), name, clazz);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex.getMessage());
            }
            return null;
        }

        protected DataFolder getTargetFolder() throws IOException {
            return this.target;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class SerializePaste
    extends PasteType {
        private InstanceCookie cookie;
        private DataFolder target;
        static /* synthetic */ Class class$org$openide$loaders$DataTransferSupport$SerializePaste;

        public SerializePaste(DataFolder target, InstanceCookie cookie) {
            this.cookie = cookie;
            this.target = target;
        }

        public String getName() {
            return DataObject.getString("PT_serialize");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$loaders$DataTransferSupport$SerializePaste == null ? (class$org$openide$loaders$DataTransferSupport$SerializePaste = SerializePaste.class$("org.openide.loaders.DataTransferSupport$SerializePaste")) : class$org$openide$loaders$DataTransferSupport$SerializePaste);
        }

        public final Transferable paste() throws IOException {
            DataFolder trg = this.getTargetFolder();
            String name = this.cookie.instanceName();
            int i = name.lastIndexOf(46) + 1;
            if (i != 0 && i != name.length()) {
                name = name.substring(i);
            }
            name = FileUtil.findFreeFileName(trg.getPrimaryFile(), name, "ser");
            NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(DataObject.getString("SerializeBean_Text"), DataObject.getString("SerializeBean_Title"));
            nd.setInputText(name);
            if (NotifyDescriptor.OK_OPTION == TopManager.getDefault().notify(nd)) {
                trg.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, trg, nd){
                    private final /* synthetic */ DataFolder val$trg;
                    private final /* synthetic */ NotifyDescriptor.InputLine val$nd;
                    private final /* synthetic */ SerializePaste this$0;
                    {
                        this.this$0 = this$0;
                        this.val$trg = val$trg;
                        this.val$nd = val$nd;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() throws IOException {
                        FileLock lock;
                        block6: {
                            FileObject fo = this.val$trg.getPrimaryFile().createData(this.val$nd.getInputText(), "ser");
                            lock = fo.lock();
                            ObjectOutputStream oos = null;
                            try {
                                try {
                                    oos = new ObjectOutputStream(new BufferedOutputStream(fo.getOutputStream(lock)));
                                    oos.writeObject(SerializePaste.access$000(this.this$0).instanceCreate());
                                }
                                catch (ClassNotFoundException e) {
                                    throw new IOException(e.getMessage());
                                }
                                Object var6_4 = null;
                                if (oos == null) break block6;
                            }
                            catch (Throwable throwable) {
                                Object var6_5 = null;
                                if (oos != null) {
                                    oos.close();
                                }
                                lock.releaseLock();
                                throw throwable;
                            }
                            oos.close();
                        }
                        lock.releaseLock();
                    }
                });
            }
            return null;
        }

        protected DataFolder getTargetFolder() throws IOException {
            return this.target;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ InstanceCookie access$000(SerializePaste x0) {
            return x0.cookie;
        }
    }

    static abstract class PasteTypeExt
    extends PasteType {
        private DataObject[] objs;

        protected abstract boolean handleCanPaste(DataObject var1);

        protected abstract void handlePaste(DataObject var1) throws IOException;

        protected boolean cleanClipboard() {
            return false;
        }

        public final boolean canPaste() {
            int i = 0;
            while (i < this.objs.length) {
                if (!this.handleCanPaste(this.objs[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public final Transferable paste() throws IOException {
            int i = 0;
            while (i < this.objs.length) {
                this.handlePaste(this.objs[i]);
                ++i;
            }
            return this.cleanClipboard() ? ExTransferable.EMPTY : null;
        }

        public final void setDataObjects(DataObject[] objs) {
            this.objs = objs;
        }
    }
}

