/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.ArgumentsCookie;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.DebuggerCookie;
import org.openide.cookies.ExecCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerType;
import org.openide.execution.Executor;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExecSupport
implements ExecCookie,
ArgumentsCookie,
DebuggerCookie {
    private static final String EA_EXECUTOR = "NetBeansAttrExecutor";
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    private static final String EA_DEBUGGER_TYPE = "NetBeansAttrDebuggerType";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    public static final String PROP_DEBUGGER_TYPE = "debuggerType";
    static ResourceBundle bundle;
    protected MultiDataObject.Entry entry;
    private boolean isReadOnly = false;
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    static /* synthetic */ Class class$org$openide$execution$Executor;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$ExecSupport;

    public ExecSupport(MultiDataObject.Entry entry) {
        this.entry = entry;
        this.isReadOnly = entry.getFile().isReadOnly();
    }

    public void start() {
        Executor exec = ExecSupport.getExecutor(this.entry);
        if (exec == null) {
            exec = this.defaultExecutor();
        }
        try {
            exec.execute(this.entry.getDataObject());
        }
        catch (IOException ex) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ExecSupport.this.startFailed(ex)) {
                        ExecSupport.this.start();
                    }
                }
            });
        }
    }

    public void debug(final boolean stopOnMain) throws DebuggerException {
        DebuggerType t = ExecSupport.getDebuggerType(this.entry);
        if (t == null) {
            t = this.defaultDebuggerType();
        }
        try {
            t.startDebugger(this.entry.getDataObject(), stopOnMain);
            return;
        }
        catch (DebuggerException ex) {
            try {
                Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                    public Object run() throws DebuggerException {
                        if (ExecSupport.this.debugFailed(ex)) {
                            ExecSupport.this.debug(stopOnMain);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mx) {
                throw (DebuggerException)mx.getException();
            }
            return;
        }
    }

    protected boolean startFailed(IOException ex) {
        Executor e = (Executor)ExecSupport.choose(ExecSupport.getExecutor(this.entry), class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, ex);
        if (e == null) {
            return false;
        }
        try {
            ExecSupport.setExecutor(this.entry, e);
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    protected boolean debugFailed(DebuggerException ex) {
        DebuggerType e = (DebuggerType)ExecSupport.choose(ExecSupport.getDebuggerType(this.entry), class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType, ex);
        if (e == null) {
            return false;
        }
        try {
            ExecSupport.setDebuggerType(this.entry, e);
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    protected boolean checkCompiled() {
        MultiDataObject obj = this.entry.getDataObject();
        CompilerCookie c = (CompilerCookie)((DataObject)obj).getCookie(class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = ExecSupport.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie);
        if (c != null) {
            CompilerJob job = new CompilerJob(Compiler.DEPTH_ZERO);
            job.setDisplayName(obj.getName());
            c.addToJob(job, Compiler.DEPTH_ZERO);
            if (!job.isUpToDate()) {
                CompilerTask t = job.start();
                return t.isSuccessful();
            }
        }
        return true;
    }

    protected DebuggerType defaultDebuggerType() {
        return DebuggerType.getDefault();
    }

    protected Executor defaultExecutor() {
        return Executor.getDefault();
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor exec) throws IOException {
        entry.getFile().setAttribute(EA_EXECUTOR, exec == null ? null : new ServiceType.Handle(exec));
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        ServiceType exec;
        Object handle = entry.getFile().getAttribute(EA_EXECUTOR);
        if (handle != null && handle instanceof ServiceType.Handle && (exec = ((ServiceType.Handle)handle).getServiceType()) instanceof Executor) {
            return (Executor)exec;
        }
        Lookup l = Environment.find(entry.getDataObject());
        Executor et = (Executor)l.lookup(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor);
        if (et != null) {
            return et;
        }
        return null;
    }

    public void setArguments(String[] args) throws IOException {
        this.entry.getFile().setAttribute(EA_ARGUMENTS, args);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] args) throws IOException {
        entry.getFile().setAttribute(EA_ARGUMENTS, args);
    }

    public String[] getArguments() {
        return ExecSupport.getArguments(this.entry);
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        Object o = entry.getFile().getAttribute(EA_ARGUMENTS);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        return new String[0];
    }

    public static void setDebuggerType(MultiDataObject.Entry entry, DebuggerType type) throws IOException {
        entry.getFile().setAttribute(EA_DEBUGGER_TYPE, type == null ? null : new ServiceType.Handle(type));
    }

    public static DebuggerType getDebuggerType(MultiDataObject.Entry entry) {
        ServiceType dbg;
        Object handle = entry.getFile().getAttribute(EA_DEBUGGER_TYPE);
        if (handle != null && handle instanceof ServiceType.Handle && (dbg = ((ServiceType.Handle)handle).getServiceType()) instanceof DebuggerType) {
            return (DebuggerType)dbg;
        }
        Lookup l = Environment.find(entry.getDataObject());
        DebuggerType dt = (DebuggerType)l.lookup(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType);
        if (dt != null) {
            return dt;
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put(this.createParamsProperty());
        set.put(this.createExecutorProperty());
        set.put(this.createDebuggerProperty());
    }

    private PropertySupport createParamsProperty() {
        return new PropertySupport.ReadWrite(PROP_FILE_PARAMS, class$java$lang$String == null ? (class$java$lang$String = ExecSupport.class$("java.lang.String")) : class$java$lang$String, ExecSupport.getString("PROP_fileParams"), ExecSupport.getString("HINT_fileParams")){

            public Object getValue() {
                String[] args = ExecSupport.this.getArguments();
                return Utilities.escapeParameters(args);
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String) {
                    try {
                        ExecSupport.this.setArguments(Utilities.parseParameters((String)val));
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecSupport.this.setArguments(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)ExecSupport.this.entry.getFile().getAttribute(ExecSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    private PropertySupport createExecutorProperty() {
        return new PropertySupport.ReadWrite(PROP_EXECUTION, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, ExecSupport.getString("PROP_execution"), ExecSupport.getString("HINT_execution")){

            public Object getValue() {
                Executor e = ExecSupport.getExecutor(ExecSupport.this.entry);
                if (e == null) {
                    return ExecSupport.this.defaultExecutor();
                }
                return e;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExecSupport.setExecutor(ExecSupport.this.entry, (Executor)val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)ExecSupport.this.entry.getFile().getAttribute(ExecSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    private PropertySupport createDebuggerProperty() {
        return new PropertySupport.ReadWrite(PROP_DEBUGGER_TYPE, class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType, ExecSupport.getString("PROP_debuggerType"), ExecSupport.getString("HINT_debuggerType")){

            public Object getValue() {
                DebuggerType dt = ExecSupport.getDebuggerType(ExecSupport.this.entry);
                if (dt == null) {
                    return ExecSupport.this.defaultDebuggerType();
                }
                return dt;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExecSupport.setDebuggerType(ExecSupport.this.entry, (DebuggerType)val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)ExecSupport.this.entry.getFile().getAttribute(ExecSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport);
        }
        return bundle.getString(s);
    }

    private static ServiceType choose(ServiceType current, Class clazz, Exception ex) {
        ErrorManager em = ErrorManager.getDefault();
        em.notify(1, ex);
        PropertyEditor ed = PropertyEditorManager.findEditor(clazz);
        if (ed == null) {
            return null;
        }
        ed.setValue(current);
        Component c = ed.getCustomEditor();
        if (c == null) {
            return null;
        }
        String configure = NbBundle.getBundle(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport).getString("CTL_ServiceConfigure");
        NotifyDescriptor.Exception exc = new NotifyDescriptor.Exception(ex);
        exc.setTitle(NbBundle.getBundle(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport).getString("CTL_Service_Configuration_Title"));
        ErrorManager.Annotation[] annots = em.findAnnotations(ex);
        if (annots != null && annots.length > 0) {
            exc.setMessage(annots[0].getLocalizedMessage());
        } else {
            exc.setMessage(ex.getLocalizedMessage());
        }
        exc.setOptions(new Object[]{configure, NotifyDescriptor.CANCEL_OPTION});
        Object res = TopManager.getDefault().notify(exc);
        if (!configure.equals(res)) {
            return null;
        }
        DialogDescriptor d = new DialogDescriptor(c, ExecSupport.getString("MSG_ConfigureService"));
        d.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        Dialog dialog = TopManager.getDefault().createDialog(d);
        dialog.show();
        if (d.getValue() == NotifyDescriptor.OK_OPTION) {
            return (ServiceType)ed.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

