/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderChildren;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListener;

final class FolderChildren
extends Children.Keys
implements PropertyChangeListener {
    private DataFolder folder;
    private DataFilter filter;
    private Task initTask;
    private Task refreshTask;
    private PropertyChangeListener listener;
    private ErrorManager err;
    private static final int TIME_DELAY = 256;
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_refresher");

    public FolderChildren(DataFolder f) {
        this(f, DataFilter.ALL);
    }

    public FolderChildren(DataFolder f, DataFilter filter) {
        this.folder = f;
        this.filter = filter;
        this.listener = WeakListener.propertyChange(this, this.folder);
        this.err = ErrorManager.getDefault().getInstance("org.openide.loaders.FolderChildren." + f.getPrimaryFile().getPackageName('.'));
        if (!this.err.isLoggable(1)) {
            this.err = null;
        }
    }

    DataFilter getFilter() {
        return this.filter;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("children".equals(ev.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_CHILDREN");
            }
            this.refreshChildren();
            return;
        }
        if ("sortMode".equals(ev.getPropertyName()) || "order".equals(ev.getPropertyName())) {
            if (this.err != null) {
                this.err.log("Got PROP_SORT_MODE or PROP_ORDER");
            }
            this.refreshChildren();
            return;
        }
    }

    void refreshChildren() {
        this.initialize(true, false);
    }

    static Object createKey(DataObject obj) {
        return new Pair(obj.getPrimaryFile());
    }

    private static FileObject getFile(Object key) {
        return ((Pair)key).primaryFile;
    }

    protected Node[] createNodes(Object key) {
        if (this.err != null) {
            this.err.log("createNodes: " + key);
        }
        FileObject fo = FolderChildren.getFile(key);
        try {
            DataObject obj = DataObject.find(fo);
            if (this.filter == null || this.filter.acceptDataObject(obj)) {
                return new Node[]{obj.getClonedNodeDelegate(this.filter)};
            }
            return new Node[0];
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, e);
            return new Node[0];
        }
    }

    public Node findChild(String name) {
        Node[] forget = this.getNodes();
        class Jst
        implements Runnable {
            public boolean checkReadOrWrite;
            public boolean inReadAccess;
            public boolean inWriteAccess;
            private final /* synthetic */ FolderChildren this$0;

            Jst(FolderChildren this$0) {
                this.this$0 = this$0;
                this.inReadAccess = true;
                this.inWriteAccess = true;
            }

            public void run() {
                if (this.checkReadOrWrite) {
                    this.inReadAccess = false;
                } else {
                    this.inWriteAccess = false;
                }
            }
        }
        Jst t = new Jst(this);
        Children.MUTEX.postWriteRequest(t);
        t.checkReadOrWrite = true;
        Children.MUTEX.postReadRequest(t);
        if (!t.inReadAccess && !t.inWriteAccess) {
            this.initialize(name == null, false).waitFinished();
            this.refreshTask.waitFinished();
        }
        Node node = super.findChild(name);
        return node;
    }

    protected void addNotify() {
        this.initialize(true, true);
        this.folder.addPropertyChangeListener(this.listener);
    }

    protected void removeNotify() {
        this.folder.removePropertyChangeListener(this.listener);
        this.setKeys(Collections.EMPTY_SET);
    }

    private Task initialize(boolean force, boolean waitFirst) {
        Task t = this.initTask;
        if (t != null && t.isFinished()) {
            FolderList l = FolderList.find(this.folder.getPrimaryFile(), true);
            l.waitProcessingFinished();
            t = this.initTask;
        }
        if (t != null && !force) {
            return t;
        }
        Addition add = new Addition(waitFirst);
        this.initTask = t = this.folder.computeChildrenList(add);
        t.addTaskListener(add);
        if (waitFirst) {
            add.waitFirst();
        }
        this.refreshTask = add.refTask;
        return t;
    }

    public String toString() {
        return this.folder.getPrimaryFile().toString();
    }

    static /* synthetic */ RequestProcessor access$100() {
        return refRP;
    }

    private static final class Pair {
        public FileObject primaryFile;
        public int seq;

        public Pair(FileObject primaryFile) {
            this.primaryFile = primaryFile;
            this.seq = DataObjectPool.getPOOL().registrationCount(primaryFile);
        }

        public int hashCode() {
            return this.primaryFile.hashCode() ^ this.seq;
        }

        public boolean equals(Object o) {
            if (o instanceof Pair) {
                Pair p = (Pair)o;
                return this.primaryFile.equals(p.primaryFile) && this.seq == p.seq;
            }
            return false;
        }

        public String toString() {
            return "FolderChildren.Pair[" + this.primaryFile + "," + this.seq + "]";
        }
    }

    private class Addition
    implements TaskListener,
    FolderListListener,
    Runnable {
        static final long serialVersionUID = -4194617547214845940L;
        private long time = System.currentTimeMillis() + 256L;
        private int delay = 256;
        private boolean processingUpdate;
        private List refKeys;
        private List dataObjects = new ArrayList();
        private RequestProcessor.Task refTask = FolderChildren.access$100().create(this);

        public Addition(boolean processingUpdate) {
            this.processingUpdate = processingUpdate;
        }

        public void process(DataObject obj, List arr) {
            if (!FolderChildren.this.filter.acceptDataObject(obj)) {
                return;
            }
            boolean first = arr.isEmpty();
            arr.add(obj);
            this.dataObjects.add(obj);
            if (!this.processingUpdate) {
                return;
            }
            if (first) {
                Addition addition = this;
                synchronized (addition) {
                    this.notify();
                    this.refreshKeys(arr);
                }
                return;
            }
            if (System.currentTimeMillis() > this.time) {
                if (!arr.isEmpty()) {
                    Addition addition = this;
                    synchronized (addition) {
                        this.refreshKeys(arr);
                    }
                    this.delay *= 2;
                }
                this.time = System.currentTimeMillis() + (long)this.delay;
            }
        }

        public void finished(List arr) {
            Addition addition = this;
            synchronized (addition) {
                this.notify();
                this.refreshKeys(arr);
            }
        }

        public synchronized void waitFirst() {
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                throw new InternalError();
            }
        }

        public void taskFinished(Task task) {
            FolderChildren.this.initTask = Task.EMPTY;
        }

        private void refreshKeys(List ch) {
            if (FolderChildren.this.err != null) {
                FolderChildren.this.err.log("refreshKeys: " + ch);
            }
            ListIterator it = ch.listIterator();
            LinkedList<Object> l = new LinkedList<Object>();
            while (it.hasNext()) {
                DataObject obj = (DataObject)it.next();
                l.add(FolderChildren.createKey(obj));
            }
            this.refKeys = l;
            this.refTask.schedule(0);
        }

        public void run() {
            List toSet;
            Addition addition = this;
            synchronized (addition) {
                toSet = this.refKeys;
                this.refKeys = null;
            }
            if (toSet != null) {
                if (FolderChildren.this.err != null) {
                    FolderChildren.this.err.log("setKeys: " + toSet);
                }
                FolderChildren.super.setKeys(toSet);
            }
        }
    }
}

