/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

final class FolderList
implements FileChangeListener,
DataObject.Container {
    static final long serialVersionUID = -592616022226761148L;
    private static final int LATER_PRIORITY = 5;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder recognizer");
    private static final WeakHashMap map = new WeakHashMap(101);
    protected FileObject folder;
    private transient long time;
    private transient RequestProcessor.Task refreshTask;
    private transient HashMap primaryFiles = null;
    private transient List order;
    private transient ErrorManager err;
    private transient PropertyChangeSupport pcs;
    static /* synthetic */ Class class$org$openide$loaders$FolderList;

    private FolderList(FileObject folder, boolean attach) {
        this.folder = folder;
        if (attach) {
            folder.addFileChangeListener(WeakListener.fileChange(this, folder));
        }
    }

    public static FolderList find(FileObject folder, boolean create) {
        boolean created = false;
        FolderList list = null;
        Class clazz = class$org$openide$loaders$FolderList == null ? (class$org$openide$loaders$FolderList = FolderList.class$("org.openide.loaders.FolderList")) : class$org$openide$loaders$FolderList;
        synchronized (clazz) {
            Reference ref = (Reference)map.get(folder);
            FolderList folderList = list = ref == null ? null : (FolderList)ref.get();
            if (list == null && create) {
                list = new FolderList(folder, true);
                map.put(folder, new SoftReference<FolderList>(list));
                created = true;
            }
        }
        if (list != null && list.err == null) {
            list.err = ErrorManager.getDefault().getInstance("org.openide.loaders.FolderList." + folder.getPackageName('.'));
        }
        return list;
    }

    public static boolean isFolderRecognizerThread() {
        return PROCESSOR.isRequestProcessorThread();
    }

    public static void changedFolderOrder(FileObject folder) {
        FolderList list = FolderList.find(folder, false);
        if (list != null) {
            list.changeComparator();
        }
    }

    public static void changedDataSystem(FileObject folder) {
        FolderList list = FolderList.find(folder, false);
        if (list != null) {
            list.refresh();
        }
    }

    public DataObject[] getChildren() {
        List res = this.getChildrenList();
        DataObject[] arr = new DataObject[res.size()];
        res.toArray(arr);
        return arr;
    }

    public List getChildrenList() {
        ListTask lt = this.getChildrenList(null);
        lt.task.waitFinished();
        return lt.result;
    }

    public void waitProcessingFinished() {
        RequestProcessor.Task t = this.refreshTask;
        if (t != null) {
            ((Task)t).waitFinished();
        }
    }

    public RequestProcessor.Task computeChildrenList(FolderListListener filter) {
        return this.getChildrenList((FolderListListener)filter).task;
    }

    private ListTask getChildrenList(FolderListListener filter) {
        ListTask lt = new ListTask(filter);
        int priority = Thread.currentThread().getPriority();
        lt.task = PROCESSOR.post(lt, 0, priority);
        return lt;
    }

    private void changeComparator() {
        this.err.log("changeComparator");
        PROCESSOR.post(new Runnable(){

            public void run() {
                if (FolderList.this.primaryFiles != null) {
                    FolderList.this.err.log("changeComparator: get old");
                    List v = FolderList.this.getObjects(null);
                    if (v.size() != 0) {
                        FolderList.this.order = null;
                        FolderList.this.err.log("changeComparator: get new");
                        List r = FolderList.this.getObjects(null);
                        FolderList.this.err.log("changeComparator: fire change");
                        FolderList.this.fireChildrenChange(r, v);
                    }
                }
            }
        }, 0, 1);
    }

    public void refresh() {
        this.refresh(Long.MAX_VALUE);
    }

    private RequestProcessor.Task doRefreshIfNotDone() {
        if (this.refreshTask == null) {
            FolderList folderList = this;
            synchronized (folderList) {
                if (this.refreshTask == null) {
                    this.refresh();
                }
            }
        }
        return this.refreshTask;
    }

    private void refresh(final long now) {
        this.err.log("refresh @" + now);
        this.refreshTask = PROCESSOR.post(new Runnable(){

            public void run() {
                FolderList.this.err.log("refresh: now=" + now + " time=" + FolderList.this.time);
                if (now > FolderList.this.time - 10L) {
                    FolderList.this.time = System.currentTimeMillis();
                    if (FolderList.this.primaryFiles != null) {
                        FolderList.this.createBoth(null, true);
                    }
                }
            }
        }, 0, 5);
    }

    public void fileChanged(FileEvent fe) {
        this.err.log("fileChanged: " + fe);
        FileObject fo = fe.getFile();
        if (fo.isData() && fo.isValid() && this.primaryFiles != null) {
            try {
                DataObject obj = DataObject.find(fo);
                if (!this.primaryFiles.containsKey(obj.getPrimaryFile())) {
                    this.refresh(fe.getTime());
                }
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        this.err.log("fileDeleted: " + fe);
        if (this.primaryFiles == null || this.primaryFiles.containsKey(fe.getFile())) {
            this.refresh(fe.getTime());
        }
    }

    public void fileDataCreated(FileEvent fe) {
        this.err.log("fileDataCreated: " + fe);
        this.refresh(fe.getTime());
    }

    public void fileFolderCreated(FileEvent fe) {
        this.err.log("fileFolderCreated: " + fe);
        this.refresh(fe.getTime());
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.err.log("fileRenamed: " + fe);
        this.refresh(fe.getTime());
        this.changeComparator();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.err.log("fileAttributeChanged: " + fe);
        if (fe.getFile() == this.folder) {
            if (fe.getName() == null) {
                this.changeComparator();
                return;
            }
            if ("OpenIDE-Folder-Order".equals(fe.getName()) || "OpenIDE-Folder-SortMode".equals(fe.getName()) || -1 != fe.getName().indexOf("/")) {
                this.changeComparator();
            }
        }
    }

    private FolderOrder getComparator() {
        return FolderOrder.findFor(this.folder);
    }

    private List getObjects(FolderListListener f) {
        List res;
        this.err.log("getObjects");
        if (this.primaryFiles == null) {
            res = this.createBoth(f, false);
        } else if (this.order != null) {
            res = this.createObjects(this.order, this.primaryFiles, f);
        } else {
            res = this.createObjects(this.primaryFiles.keySet(), this.primaryFiles, f);
            res = this.carefullySort(res, this.getComparator());
            this.order = FolderList.createOrder(res);
        }
        return res;
    }

    private List carefullySort(List l, FolderOrder c) {
        this.err.log("carefullySort");
        Collections.sort(l, c);
        Comparator p = c.getPartialComparator();
        if (p == null) {
            return l;
        }
        this.err.log("carefullySort: partial orders");
        try {
            return Utilities.partialSort(l, p, true);
        }
        catch (Utilities.UnorderableException ue) {
            this.err.annotate(ue, 16, "Folder cannot be sorted: " + this.folder, null, null, null);
            this.err.notify(16, ue);
            return l;
        }
    }

    private static List createOrder(List list) {
        int size = list.size();
        ArrayList<FileObject> res = new ArrayList<FileObject>(size);
        int i = 0;
        while (i < size) {
            res.add(((DataObject)list.get(i)).getPrimaryFile());
            ++i;
        }
        return res;
    }

    private List createObjects(Collection order, Map map, FolderListListener f) {
        this.err.log("createObjects");
        int size = order.size();
        Iterator it = order.iterator();
        ArrayList<DataObject> res = new ArrayList<DataObject>(size);
        int i = 0;
        while (i < size) {
            FileObject fo = (FileObject)it.next();
            if (fo.isValid()) {
                SoftReference<DataObject> ref = (SoftReference<DataObject>)map.get(fo);
                DataObject obj = (DataObject)((Reference)ref).get();
                if (obj == null) {
                    try {
                        obj = DataObject.find(fo);
                        ref = new SoftReference<DataObject>(obj);
                    }
                    catch (DataObjectNotFoundException ex) {
                        ErrorManager.getDefault().notify(1, ex);
                    }
                }
                if (obj != null) {
                    if (f == null) {
                        res.add(obj);
                    } else {
                        f.process(obj, res);
                    }
                }
            }
            ++i;
        }
        if (f != null) {
            f.finished(res);
        }
        return res;
    }

    private List createBoth(FolderListListener filter, boolean notify) {
        this.err.log("createBoth");
        HashMap<FileObject, WeakReference<DataObject>> file = new HashMap<FileObject, WeakReference<DataObject>>();
        List<DataObject> all = new ArrayList();
        List<DataObject> res = new ArrayList();
        HashMap remove = this.primaryFiles == null ? new HashMap() : (HashMap)this.primaryFiles.clone();
        ArrayList<DataObject> add = new ArrayList<DataObject>();
        DataLoaderPool pool = TopManager.getDefault().getLoaderPool();
        final HashSet marked = new HashSet();
        DataLoader.RecognizedFiles recog = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fo) {
                if (fo != null) {
                    marked.add(fo);
                }
            }
        };
        Enumeration en = this.folder.getChildren(false);
        while (en.hasMoreElements()) {
            DataObject obj;
            FileObject fo = (FileObject)en.nextElement();
            if (marked.contains(fo)) continue;
            try {
                obj = pool.findDataObject(fo, recog);
            }
            catch (DataObjectExistsException ex) {
                obj = ex.getDataObject();
            }
            catch (IOException ex) {
                obj = null;
                ErrorManager.getDefault().notify(ex);
            }
            if (obj == null) continue;
            obj.recognizedByFolder();
            FileObject primary = obj.getPrimaryFile();
            boolean doNotRemovePrimaryFile = false;
            if (!file.containsKey(primary)) {
                boolean goIn;
                boolean bl = goIn = this.primaryFiles == null;
                if (!goIn) {
                    Reference r = (Reference)this.primaryFiles.get(primary);
                    boolean bl2 = goIn = r == null;
                    if (!goIn) {
                        DataObject obj2 = (DataObject)r.get();
                        boolean bl3 = goIn = obj2 == null || obj2 != obj;
                        if (goIn) {
                            doNotRemovePrimaryFile = true;
                        }
                    }
                }
                if (goIn) {
                    add.add(obj);
                }
                all.add(obj);
                if (filter == null) {
                    res.add(obj);
                } else {
                    filter.process(obj, res);
                }
            }
            if (!doNotRemovePrimaryFile) {
                remove.remove(primary);
            }
            file.put(primary, new WeakReference<DataObject>(obj));
        }
        this.primaryFiles = file;
        all = this.carefullySort(all, this.getComparator());
        this.order = FolderList.createOrder(all);
        res = all.size() == res.size() ? all : this.carefullySort(res, this.getComparator());
        if (notify) {
            this.fireChildrenChange(add, remove.keySet());
        }
        if (filter != null) {
            filter.finished(res);
        }
        return res;
    }

    private void fireChildrenChange(Collection add, Collection removed) {
        if (!(this.pcs == null || add.isEmpty() && removed.isEmpty())) {
            this.pcs.firePropertyChange("children", null, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs == null) {
            FolderList folderList = this;
            synchronized (folderList) {
                if (this.pcs == null) {
                    this.pcs = new PropertyChangeSupport(this);
                }
            }
        }
        this.pcs.addPropertyChangeListener(l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ListTask
    implements Runnable {
        private FolderListListener filter;
        public List result;
        public RequestProcessor.Task task;

        public ListTask(FolderListListener filter) {
            this.filter = filter;
        }

        public void run() {
            FolderList.this.err.log("ListTask.run 1");
            if (FolderList.this.refreshTask != null) {
                FolderList.this.refreshTask.waitFinished();
            }
            FolderList.this.err.log("ListTask.run 2");
            this.result = FolderList.this.getObjects(this.filter);
            FolderList.this.err.log("ListTask.run 3");
        }
    }
}

