/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.FolderList;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ProxyLookup;

public class FolderLookup
extends FolderInstance {
    private static final Object LOCK = new Object();
    private ProxyLkp lookup;
    private String rootName;
    private final boolean isRoot;
    static /* synthetic */ Class class$org$openide$loaders$FolderLookup$ProxyLkp;
    static /* synthetic */ Class class$org$openide$util$Lookup;

    public FolderLookup(DataObject.Container df) {
        this(df, "FL[");
    }

    public FolderLookup(DataObject.Container df, String prefix) {
        this(df, prefix, true);
    }

    private FolderLookup(DataObject.Container df, String prefix, boolean isRoot) {
        super(df);
        this.rootName = prefix;
        this.isRoot = isRoot;
    }

    public final Class instanceClass() {
        return class$org$openide$loaders$FolderLookup$ProxyLkp == null ? (class$org$openide$loaders$FolderLookup$ProxyLkp = FolderLookup.class$("org.openide.loaders.FolderLookup$ProxyLkp")) : class$org$openide$loaders$FolderLookup$ProxyLkp;
    }

    public final Lookup getLookup() {
        boolean inited = false;
        Object object = LOCK;
        synchronized (object) {
            if (this.lookup == null) {
                this.lookup = new ProxyLkp(this);
                inited = true;
            }
        }
        if (inited) {
            this.checkRecreate();
        }
        return this.lookup;
    }

    protected final Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        FolderLookupData flData = new FolderLookupData();
        if (this.isRoot) {
            flData.lookups.add(null);
        }
        int i = 0;
        while (i < cookies.length) {
            try {
                Object obj = cookies[i].instanceCreate();
                if (obj instanceof FolderLookupData) {
                    flData.items.addAll(((FolderLookupData)obj).items);
                    flData.lookups.addAll(((FolderLookupData)obj).lookups);
                } else if (obj instanceof Lookup) {
                    flData.lookups.add(obj);
                } else {
                    flData.items.add(obj);
                }
            }
            catch (IOException ex) {
                FolderLookup.exception(ex);
            }
            catch (ClassNotFoundException ex) {
                FolderLookup.exception(ex);
            }
            ++i;
        }
        if (!this.isRoot) {
            return flData;
        }
        this.getLookup();
        this.lookup.update(flData.items, flData.lookups);
        return this.lookup;
    }

    protected Object instanceForCookie(DataObject dobj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        boolean isLookup = cookie instanceof InstanceCookie.Of ? ((InstanceCookie.Of)cookie).instanceOf(class$org$openide$util$Lookup == null ? (class$org$openide$util$Lookup = FolderLookup.class$("org.openide.util.Lookup")) : class$org$openide$util$Lookup) : (class$org$openide$util$Lookup == null ? (class$org$openide$util$Lookup = FolderLookup.class$("org.openide.util.Lookup")) : class$org$openide$util$Lookup).isAssignableFrom(cookie.instanceClass());
        if (isLookup) {
            return cookie.instanceCreate();
        }
        return new ICItem(dobj, this.rootName, cookie);
    }

    protected InstanceCookie acceptFolder(DataFolder df) {
        return new FolderLookup(df, FolderLookup.objectName(this.rootName, df), false);
    }

    protected InstanceCookie acceptContainer(DataObject.Container df) {
        return new FolderLookup(df, this.rootName == null ? "<container>" : this.rootName + "<container>", false);
    }

    protected final Task postCreationTask(Runnable run) {
        run.run();
        return null;
    }

    private static String objectName(String name, DataObject obj) {
        if (name == null) {
            return obj.getName();
        }
        return name + '/' + obj.getName();
    }

    private static void exception(Exception e) {
        ErrorManager.getDefault().notify(1, e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FolderLookupData {
        private Collection items = new ArrayList(30);
        private List lookups = new ArrayList(5);
    }

    private static final class ICItem
    extends AbstractLookup.Pair {
        private InstanceCookie ic;
        private DataObject obj;
        private WeakReference ref;
        private String rootName;
        static /* synthetic */ Class class$java$lang$Object;

        public ICItem(DataObject obj, String rootName, InstanceCookie ic) {
            this.ic = ic;
            this.obj = obj;
            this.rootName = rootName;
        }

        protected boolean instanceOf(Class clazz) {
            if (this.ic instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.ic;
                return of.instanceOf(clazz);
            }
            try {
                return clazz.isAssignableFrom(this.ic.instanceClass());
            }
            catch (ClassNotFoundException ex) {
                FolderLookup.exception(ex);
            }
            catch (IOException ex) {
                FolderLookup.exception(ex);
            }
            return false;
        }

        public Object getInstance() {
            try {
                Object obj = this.ic.instanceCreate();
                this.ref = new WeakReference<Object>(obj);
                return obj;
            }
            catch (ClassNotFoundException ex) {
                FolderLookup.exception(ex);
            }
            catch (IOException ex) {
                FolderLookup.exception(ex);
            }
            return null;
        }

        public int hashCode() {
            return System.identityHashCode(this.ic);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ICItem) {
                ICItem i = (ICItem)obj;
                return this.ic == i.ic;
            }
            return false;
        }

        public String getId() {
            return FolderLookup.objectName(this.rootName, this.obj);
        }

        public String getDisplayName() {
            return this.obj.getNodeDelegate().getDisplayName();
        }

        protected boolean creatorOf(Object obj) {
            WeakReference w = this.ref;
            return w != null && w.get() == obj;
        }

        public Class getType() {
            try {
                return this.ic.instanceClass();
            }
            catch (IOException ex) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = ICItem.class$("java.lang.Object")) : class$java$lang$Object;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class ProxyLkp
    extends ProxyLookup {
        private FolderLookup fl;
        private AbstractLookup.Content content;

        public ProxyLkp(FolderLookup folder) {
            this(folder, new AbstractLookup.Content());
        }

        private ProxyLkp(FolderLookup folder, AbstractLookup.Content content) {
            super(new Lookup[]{new AbstractLookup(content)});
            this.fl = folder;
            this.content = content;
        }

        public void update(Collection items, List lookups) {
            Lookup pairs = this.getLookups()[0];
            this.content.setPairs(items);
            if (this.fl.err().isLoggable(1)) {
                this.fl.err().log("Changed pairs: " + items);
            }
            lookups.set(0, pairs);
            Lookup[] arr = lookups.toArray(new Lookup[lookups.size()]);
            this.setLookups(arr);
            if (this.fl.err().isLoggable(1)) {
                this.fl.err().log("Changed lookups: " + lookups);
            }
        }

        protected void beforeLookup(Lookup.Template template) {
            if (!FolderList.isFolderRecognizerThread()) {
                this.fl.instanceFinished();
            }
        }
    }
}

