/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderOrder;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.RemoveDuplicatesEnumeration;

final class FolderOrder
implements Comparator {
    private static final char SEP = '/';
    private static final WeakHashMap map = new WeakHashMap(101);
    private static final Map knownOrders = Collections.synchronizedMap(new WeakHashMap(50));
    private Map order;
    private FileObject folder;
    private boolean ignorePartials;
    private DataFolder.SortMode sortMode;
    private Object previous;

    private FolderOrder(FileObject folder) {
        this.folder = folder;
    }

    public void setSortMode(DataFolder.SortMode mode) throws IOException {
        this.sortMode = mode;
        mode.write(this.folder);
    }

    public DataFolder.SortMode getSortMode() {
        if (this.sortMode == null) {
            this.sortMode = DataFolder.SortMode.read(this.folder);
        }
        return this.sortMode;
    }

    public synchronized void setOrder(DataObject[] arr) throws IOException {
        if (arr != null) {
            this.order = new HashMap(arr.length * 3 / 4);
            RemoveDuplicatesEnumeration en = new RemoveDuplicatesEnumeration(new ArrayEnumeration(arr));
            int i = 0;
            while (en.hasMoreElements()) {
                DataObject obj = (DataObject)en.nextElement();
                FileObject fo = obj.getPrimaryFile();
                if (!this.folder.equals(fo.getParent())) continue;
                this.order.put(fo.getNameExt(), new Integer(i++));
            }
            this.ignorePartials = true;
        } else {
            this.order = null;
        }
        this.write();
    }

    public synchronized Comparator getPartialComparator() {
        Set partials = this.readPartials();
        if (partials.isEmpty()) {
            return null;
        }
        class OrderPartialComparator
        implements Comparator {
            private StringBuffer buffer;
            private final /* synthetic */ Set val$partials;
            private final /* synthetic */ FolderOrder this$0;

            OrderPartialComparator(FolderOrder this$0, Set val$partials) {
                this.this$0 = this$0;
                this.val$partials = val$partials;
            }

            public int compare(Object o1, Object o2) {
                DataObject d1 = (DataObject)o1;
                DataObject d2 = (DataObject)o2;
                FileObject f1 = d1.getPrimaryFile();
                FileObject f2 = d2.getPrimaryFile();
                String s1 = f1.getNameExt();
                String s2 = f2.getNameExt();
                if (FolderOrder.access$000(this.this$0) && FolderOrder.access$100(this.this$0).get(s1) != null && FolderOrder.access$100(this.this$0).get(s2) != null) {
                    return 0;
                }
                if (this.buffer == null) {
                    this.buffer = new StringBuffer(40);
                } else {
                    this.buffer.setLength(0);
                }
                this.buffer.append(s1).append('/').append(s2);
                if (this.val$partials.contains(this.buffer.toString())) {
                    return -1;
                }
                this.buffer.setLength(0);
                this.buffer.append(s2).append('/').append(s1);
                if (this.val$partials.contains(this.buffer.toString())) {
                    return 1;
                }
                return 0;
            }
        }
        return new OrderPartialComparator(this, partials);
    }

    private Set readPartials() {
        Enumeration e = this.folder.getAttributes();
        HashSet<String> s = new HashSet<String>();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            if (name.indexOf(47) == -1 || !((value = this.folder.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            s.add(name);
        }
        return s;
    }

    public int compare(Object o1, Object o2) {
        Integer i2;
        DataObject obj1 = (DataObject)o1;
        DataObject obj2 = (DataObject)o2;
        Integer i1 = this.order == null ? null : (Integer)this.order.get(obj1.getPrimaryFile().getNameExt());
        Integer n = i2 = this.order == null ? null : (Integer)this.order.get(obj2.getPrimaryFile().getNameExt());
        if (i1 == null) {
            if (i2 != null) {
                return 1;
            }
            return this.getSortMode().compare(obj1, obj2);
        }
        if (i2 == null) {
            return -1;
        }
        if (i1.intValue() == i2.intValue()) {
            return 0;
        }
        if (i1 < i2) {
            return -1;
        }
        return 1;
    }

    public void write() throws IOException {
        if (this.order == null) {
            this.folder.setAttribute("OpenIDE-Folder-Order", null);
        } else {
            Iterator it = this.order.entrySet().iterator();
            String[] filenames = new String[this.order.size()];
            while (it.hasNext()) {
                Map.Entry en = it.next();
                String fo = (String)en.getKey();
                int indx = (Integer)en.getValue();
                filenames[indx] = fo;
            }
            StringBuffer buf = new StringBuffer(255);
            int i = 0;
            while (i < filenames.length) {
                if (i > 0) {
                    buf.append('/');
                }
                buf.append(filenames[i]);
                ++i;
            }
            this.folder.setAttribute("OpenIDE-Folder-Order", buf.toString());
            if (this.ignorePartials) {
                Set p = this.readPartials();
                if (!p.isEmpty()) {
                    HashSet<String> f = new HashSet<String>();
                    it = this.order.keySet().iterator();
                    while (it.hasNext()) {
                        String fo = (String)((Object)it.next());
                        f.add(fo);
                    }
                    it = p.iterator();
                    while (it.hasNext()) {
                        int idx;
                        String s = (String)((Object)it.next());
                        if (!f.contains(s.substring(0, idx = s.indexOf(47))) || !f.contains(s.substring(idx + 1))) continue;
                        this.folder.setAttribute(s, null);
                    }
                }
                this.ignorePartials = false;
            }
        }
    }

    private void read() {
        Object o = this.folder.getAttribute("OpenIDE-Folder-Order");
        if (this.previous == null && o == null || this.previous != null && this.previous.equals(o)) {
            return;
        }
        if (o instanceof Object[] && this.previous instanceof Object[] && FolderOrder.compare((Object[])o, (Object[])this.previous)) {
            return;
        }
        this.doRead(o);
        this.previous = o;
        if (this.previous != null) {
            knownOrders.put(this.folder, this.previous);
        }
        FolderList.changedFolderOrder(this.folder);
    }

    private static boolean compare(Object[] a, Object[] b) {
        Object[] arr;
        if (a == b) {
            return true;
        }
        int len = Math.min(a.length, b.length);
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                if (a[i] == null) {
                    return false;
                }
                if (!a[i].equals(b[i])) {
                    if (a[i] instanceof Object[] && b[i] instanceof Object[]) {
                        if (!FolderOrder.compare((Object[])a[i], (Object[])b[i])) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
            }
            ++i;
        }
        Object[] objectArray = arr = a.length > b.length ? a : b;
        return !FolderOrder.checkNonNull(arr, len);
    }

    private static boolean checkNonNull(Object[] a, int from) {
        int i = from;
        while (i < a.length) {
            if (a[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void doRead(Object o) {
        if (o == null) {
            this.order = null;
            return;
        }
        if (o instanceof String[][]) {
            String[][] namesExts = (String[][])o;
            if (namesExts.length != 2) {
                this.order = null;
                return;
            }
            String[] names = namesExts[0];
            String[] exts = namesExts[1];
            if (names == null || exts == null || names.length != exts.length) {
                this.order = null;
                return;
            }
            HashMap<String, Integer> set = new HashMap<String, Integer>(names.length);
            int i = 0;
            while (i < names.length) {
                set.put(names[i], new Integer(i));
                ++i;
            }
            this.order = set;
            return;
        }
        if (o instanceof String) {
            String sepnames = (String)o;
            HashMap<String, Integer> set = new HashMap<String, Integer>();
            StringTokenizer tok = new StringTokenizer(sepnames, "/");
            int i = 0;
            while (tok.hasMoreTokens()) {
                String file = tok.nextToken();
                set.put(file, new Integer(i));
                ++i;
            }
            this.order = set;
            return;
        }
        this.order = null;
    }

    public static FolderOrder findFor(FileObject folder) {
        FolderOrder order = null;
        WeakHashMap weakHashMap = map;
        synchronized (weakHashMap) {
            Reference ref = (Reference)map.get(folder);
            FolderOrder folderOrder = order = ref == null ? null : (FolderOrder)ref.get();
            if (order == null) {
                order = new FolderOrder(folder);
                order.previous = knownOrders.get(folder);
                order.doRead(order.previous);
                map.put(folder, new SoftReference<FolderOrder>(order));
            }
        }
        FolderOrder folderOrder = order;
        synchronized (folderOrder) {
            order.read();
            FolderOrder folderOrder2 = order;
            return folderOrder2;
        }
    }

    static /* synthetic */ boolean access$000(FolderOrder x0) {
        return x0.ignorePartials;
    }

    static /* synthetic */ Map access$100(FolderOrder x0) {
        return x0.order;
    }
}

