/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceNode;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;

public class InstanceDataObject
extends MultiDataObject
implements InstanceCookie.Of {
    static final long serialVersionUID = -6134784731744777123L;
    private static final String EA_INSTANCE_CLASS = "instanceClass";
    private static final String EA_INSTANCE_CREATE = "instanceCreate";
    private static final String EA_INSTANCE_OF = "instanceOf";
    static final String EA_NAME = "name";
    private static final int SAVE_DELAY = 2000;
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    public static final String INSTANCE = "instance";
    static final String SER_EXT = "ser";
    static final String XML_EXT = "settings";
    private static final String ICON_NAME = "icon";
    private static final String DISPLAY_NAME = "name";
    private Ser ser;
    private boolean savingCanceled = false;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Instance processor");
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.InstanceDataObject");
    private final Object IDO_LOCK = new Object();
    private UpdatableNode un;
    private Lookup.Result cookieResult = null;
    private Lookup.Result nodeResult = null;
    private Lookup cookiesLkp = null;
    private LookupListener cookiesLsnr = null;
    private static final Set warnedAboutBrackets = new WeakSet(100);
    private static final int MAX_FILENAME_LENGTH = 50;
    private FileLock fileLock;
    private static final String EA_PROVIDER_PATH = "settings.providerPath";
    private static final List createdIDOs = Collections.synchronizedList(new ArrayList(1));
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$nodes$Node$Handle;
    static /* synthetic */ Class class$org$openide$nodes$Node$Cookie;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$java$lang$Object;

    public InstanceDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        if (pf.hasExt(SER_EXT)) {
            this.ser = new Ser(this);
            this.getCookieSet().add(this.ser);
        } else if (!pf.hasExt(XML_EXT)) {
            this.ser = new Ser(this);
        }
    }

    private Object getLock() {
        return this.IDO_LOCK;
    }

    private static FileObject findFO(DataFolder folder, String name, String className) {
        FileObject fo = folder.getPrimaryFile();
        String classNameEnc = className.replace('.', '-');
        Enumeration en = fo.getChildren(false);
        while (en.hasMoreElements()) {
            FileObject newFile = (FileObject)en.nextElement();
            if (!newFile.hasExt(INSTANCE) || (name == null ? !classNameEnc.equals(InstanceDataObject.getName(newFile)) : !name.equals(InstanceDataObject.getName(newFile))) || !className.equals(Ser.getClassName(newFile))) continue;
            return newFile;
        }
        return null;
    }

    private static String getName(FileObject fo) {
        String superName = (String)fo.getAttribute("name");
        if (superName != null) {
            return superName;
        }
        superName = fo.getName();
        int bracket = superName.indexOf(91);
        if (bracket == -1) {
            return InstanceDataObject.unescape(superName);
        }
        InstanceDataObject.warnAboutBrackets(fo);
        return InstanceDataObject.unescape(superName.substring(0, bracket));
    }

    public static InstanceDataObject find(DataFolder folder, String name, String className) {
        FileObject newFile = InstanceDataObject.findFO(folder, name, className);
        if (newFile != null) {
            try {
                return (InstanceDataObject)DataObject.find(newFile);
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static InstanceDataObject find(DataFolder folder, String name, Class clazz) {
        return InstanceDataObject.find(folder, name, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder folder, final String name, final String className) throws IOException {
        final FileObject fo = folder.getPrimaryFile();
        if (name != null && name.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        FileObject newFile = InstanceDataObject.findFO(folder, name, className);
        if (newFile == null) {
            final FileObject[] fos = new FileObject[1];
            fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    String fileName = name == null ? FileUtil.findFreeFileName(fo, className.replace('.', '-'), InstanceDataObject.INSTANCE) : InstanceDataObject.escape(name);
                    fos[0] = fo.createData(fileName, InstanceDataObject.INSTANCE);
                    fos[0].setAttribute(InstanceDataObject.EA_INSTANCE_CLASS, className);
                }
            });
            newFile = fos[0];
        }
        return (InstanceDataObject)DataObject.find(newFile);
    }

    public static InstanceDataObject create(DataFolder folder, String name, Class clazz) throws IOException {
        return InstanceDataObject.create(folder, name, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder folder, String name, Object instance, ModuleInfo info) throws IOException {
        return InstanceDataObject.create(folder, name, instance, info, false);
    }

    public static InstanceDataObject create(DataFolder folder, String name, Object instance, ModuleInfo info, boolean create) throws IOException {
        if (name != null && name.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        return Creator.createInstanceDataObject(folder, name, instance, info, create);
    }

    private static InstanceDataObject storeSettings(DataFolder df, String name, Object obj, ModuleInfo mi) throws IOException {
        InstanceDataObject ido;
        FileObject fo = df.getPrimaryFile();
        String fullname = fo.getPackageName('/') + '/' + name + '.' + XML_EXT;
        try {
            System.setProperty("InstanceDataObject.current.file", fo.toString() + "/" + name + "." + XML_EXT);
            ByteArrayOutputStream buf = InstanceDataObject.storeThroughConvertor(obj);
            System.setProperty("InstanceDataObject.current.file", "");
            FileObject newFile = fo.getFileObject(name, XML_EXT);
            if (newFile == null) {
                createdIDOs.add(fullname);
                newFile = fo.createData(name, XML_EXT);
                FileLock flock = null;
                try {
                    flock = newFile.lock();
                    OutputStream os = newFile.getOutputStream(flock);
                    os.write(buf.toByteArray());
                    os.close();
                    Object var12_10 = null;
                    if (flock != null) {
                        flock.releaseLock();
                    }
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (flock != null) {
                        flock.releaseLock();
                    }
                    throw throwable;
                }
            }
            ido = (InstanceDataObject)DataObject.find(newFile);
            ido.attachToConvertor(obj);
            Object var14_14 = null;
            createdIDOs.remove(fullname);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            createdIDOs.remove(fullname);
            throw throwable;
        }
        return ido;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean remove(DataFolder folder, String name, String className) {
        FileLock lock = null;
        try {
            try {
                FileObject fileToRemove = InstanceDataObject.findFO(folder, name, className);
                if (fileToRemove == null) {
                    boolean bl = false;
                    Object var7_8 = null;
                    if (lock == null) return bl;
                    lock.releaseLock();
                    return bl;
                }
                lock = fileToRemove.lock();
                fileToRemove.delete(lock);
            }
            catch (IOException exc) {
                boolean bl = false;
                Object var7_10 = null;
                if (lock == null) return bl;
                lock.releaseLock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        Object var7_9 = null;
        if (lock == null) return true;
        lock.releaseLock();
        return true;
    }

    public static boolean remove(DataFolder folder, String name, Class clazz) {
        return InstanceDataObject.remove(folder, name, clazz.getName());
    }

    public HelpCtx getHelpCtx() {
        HelpCtx test = InstanceSupport.findHelp(this);
        if (test != null) {
            return test;
        }
        return new HelpCtx(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = InstanceDataObject.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject);
    }

    static void inform(Throwable t) {
        err.notify(1, t);
    }

    protected Node createNodeDelegate() {
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            this.un = new UpdatableNode(this.createNodeDelegateImpl());
            return this.un;
        }
        return this.createNodeDelegateImpl();
    }

    private Node createNodeDelegateImpl() {
        Node n;
        try {
            if (this.getPrimaryFile().getFileSystem() != Repository.getDefault().getDefaultFileSystem()) {
                return new DataNode(this, Children.LEAF);
            }
        }
        catch (FileStateInvalidException ex) {
            InstanceDataObject.inform(ex);
            return new DataNode(this, Children.LEAF);
        }
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            if (null == this.getCookieFromEP(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)) {
                return new CookieAdjustingFilter(new UnrecognizedSettingNode());
            }
            n = (Node)this.getCookieFromEP(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = InstanceDataObject.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            if (n != null) {
                return new CookieAdjustingFilter(n);
            }
        }
        try {
            if (this.instanceOf(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = InstanceDataObject.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                n = (Node)this.instanceCreate();
                return new CookieAdjustingFilter(n);
            }
            if (this.instanceOf(class$org$openide$nodes$Node$Handle == null ? (class$org$openide$nodes$Node$Handle = InstanceDataObject.class$("org.openide.nodes.Node$Handle")) : class$org$openide$nodes$Node$Handle)) {
                Node.Handle h = (Node.Handle)this.instanceCreate();
                return new CookieAdjustingFilter(h.getNode());
            }
        }
        catch (IOException ex) {
            InstanceDataObject.inform(ex);
        }
        catch (ClassNotFoundException ex) {
            InstanceDataObject.inform(ex);
        }
        return new InstanceNode(this);
    }

    private Object getCookieFromEP(Class clazz) {
        this.updateLookup();
        return this.cookiesLkp.lookup(clazz);
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie supe = null;
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            String filename = this.getPrimaryFile().getPackageNameExt('/', '.');
            if (createdIDOs.contains(filename)) {
                return null;
            }
            supe = (Node.Cookie)this.getCookieFromEP(clazz);
            if ((class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie).isAssignableFrom(clazz)) {
                return supe;
            }
        }
        if (supe == null) {
            supe = super.getCookie(clazz);
        }
        return supe;
    }

    private Lookup findLookup() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.cookiesLkp != null) {
                Lookup lookup = this.cookiesLkp;
                return lookup;
            }
        }
        Lookup envLkp = Environment.findForOne(this);
        Object object2 = this.getLock();
        synchronized (object2) {
            if (this.cookiesLkp == null) {
                this.cookiesLkp = envLkp == null ? Lookup.EMPTY : envLkp;
            }
            Lookup lookup = this.cookiesLkp;
            return lookup;
        }
    }

    private void updateLookup() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.cookieResult != null) {
                return;
            }
        }
        this.findLookup();
        boolean initialize = false;
        Object object2 = this.getLock();
        synchronized (object2) {
            if (this.cookieResult != null) {
                return;
            }
            this.cookieResult = this.cookiesLkp.lookup(new Lookup.Template(class$org$openide$nodes$Node$Cookie == null ? (class$org$openide$nodes$Node$Cookie = InstanceDataObject.class$("org.openide.nodes.Node$Cookie")) : class$org$openide$nodes$Node$Cookie));
            this.cookiesLsnr = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    InstanceDataObject.this.firePropertyChange("cookie", null, null);
                }
            };
            this.cookieResult.addLookupListener(this.cookiesLsnr);
            this.nodeResult = this.cookiesLkp.lookup(new Lookup.Template(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie));
            this.nodeResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    if (InstanceDataObject.this.un != null) {
                        InstanceDataObject.this.un.update();
                    }
                }
            });
            initialize = true;
        }
        if (initialize) {
            this.cookieResult.allItems();
            this.nodeResult.allItems();
        }
    }

    private InstanceCookie.Of delegateIC() {
        InstanceCookie.Of ic = null;
        ic = this.getPrimaryFile().hasExt(XML_EXT) ? (InstanceCookie.Of)this.getCookieFromEP(class$org$openide$cookies$InstanceCookie$Of == null ? (class$org$openide$cookies$InstanceCookie$Of = InstanceDataObject.class$("org.openide.cookies.InstanceCookie$Of")) : class$org$openide$cookies$InstanceCookie$Of) : this.ser;
        return ic;
    }

    public String instanceName() {
        InstanceCookie.Of delegateIC = this.delegateIC();
        if (delegateIC == null) {
            return this.getName();
        }
        return delegateIC.instanceName();
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        InstanceCookie.Of delegateIC = this.delegateIC();
        if (delegateIC == null) {
            return this.getClass();
        }
        return delegateIC.instanceClass();
    }

    public boolean instanceOf(Class type) {
        InstanceCookie.Of delegateIC = this.delegateIC();
        if (delegateIC == null) {
            return type.isAssignableFrom(this.getClass());
        }
        return delegateIC.instanceOf(type);
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        InstanceCookie.Of delegateIC = this.delegateIC();
        if (delegateIC == null) {
            return this;
        }
        return delegateIC.instanceCreate();
    }

    public String getName() {
        String superName = (String)this.getPrimaryFile().getAttribute("name");
        if (superName != null) {
            return superName;
        }
        superName = super.getName();
        int bracket = superName.indexOf(91);
        if (bracket == -1) {
            return InstanceDataObject.unescape(superName);
        }
        InstanceDataObject.warnAboutBrackets(this.getPrimaryFile());
        return InstanceDataObject.unescape(superName.substring(0, bracket));
    }

    private static void warnAboutBrackets(FileObject fo) {
        if (warnedAboutBrackets.add(fo)) {
            err.log(16, "Use of [] in " + fo + " is deprecated.");
            err.log(16, "(Please use the string-valued file attribute instanceClass instead.)");
        }
    }

    protected FileObject handleRename(String name) throws IOException {
        FileObject fo = this.getPrimaryFile();
        fo.setAttribute("name", name);
        return fo;
    }

    static String escape(String text) {
        boolean spacenasty = text.startsWith(" ") || text.endsWith(" ") || text.indexOf("  ") != -1;
        int len = text.length();
        StringBuffer escaped = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == ' ' && spacenasty || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                escaped.append('#');
                String hex = Integer.toString(c, 16).toUpperCase();
                if (hex.length() < 4) {
                    escaped.append('0');
                }
                if (hex.length() < 3) {
                    escaped.append('0');
                }
                if (hex.length() < 2) {
                    escaped.append('0');
                }
                escaped.append(hex);
            } else {
                escaped.append(c);
            }
            ++i;
        }
        return escaped.toString();
    }

    static String unescape(String text) {
        int len = text.length();
        StringBuffer unesc = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '#') {
                if (i + 4 >= len) {
                    err.log(16, "trailing garbage in instance name: " + text);
                    break;
                }
                try {
                    char[] hex = new char[4];
                    text.getChars(i + 1, i + 5, hex, 0);
                    unesc.append((char)Integer.parseInt(new String(hex), 16));
                }
                catch (NumberFormatException nfe) {
                    err.notify(1, nfe);
                }
                i += 4;
            } else {
                unesc.append(c);
            }
            ++i;
        }
        return unesc.toString();
    }

    static String escapeAndCut(String name) {
        int maxLen = 50;
        String ename = InstanceDataObject.escape(name);
        if (ename.length() <= maxLen) {
            return ename;
        }
        String hash = Integer.toHexString(ename.hashCode());
        maxLen = maxLen > hash.length() ? (maxLen - hash.length()) / 2 : 1;
        String start = ename.substring(0, maxLen);
        String end = ename.substring(ename.length() - maxLen);
        return start + hash + end;
    }

    final void scheduleSave() {
        if (this.isSavingCanceled() || !this.getPrimaryFile().hasExt(SER_EXT)) {
            return;
        }
        this.doFileLock();
        this.ser.getSaveTask().schedule(2000);
    }

    private FileLock doFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fileLock != null) {
                FileLock fileLock = this.fileLock;
                return fileLock;
            }
            try {
                this.fileLock = this.getPrimaryFile().lock();
            }
            catch (IOException ex) {
                err.annotate((Throwable)ex, this.getPrimaryFile().toString());
                InstanceDataObject.inform(ex);
            }
            FileLock fileLock = this.fileLock;
            return fileLock;
        }
    }

    private void relaseFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fileLock == null) {
                return;
            }
            this.fileLock.releaseLock();
            this.fileLock = null;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        try {
            if (this.getPrimaryFile().hasExt(XML_EXT)) {
                InstanceCookie ic = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object obj = ic.instanceCreate();
                InstanceDataObject d = this.createSettingsFile(df, name, obj);
                this.attachToConvertor(null);
                return d;
            }
            if (!this.getPrimaryFile().hasExt(INSTANCE) && (class$java$io$Serializable == null ? (class$java$io$Serializable = InstanceDataObject.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.instanceClass())) {
                InstanceCookie ic = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                Object obj = ic.instanceCreate();
                return DataObject.find(this.createSerFile(df, name, obj));
            }
        }
        catch (ClassNotFoundException ex) {
            InstanceDataObject.inform(ex);
        }
        return super.handleCreateFromTemplate(df, name);
    }

    protected DataObject handleCopy(DataFolder df) throws IOException {
        try {
            InstanceCookie ic;
            if (this.getPrimaryFile().hasExt(XML_EXT)) {
                InstanceCookie ic2 = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                if (ic2 != null) {
                    Object obj = ic2.instanceCreate();
                    InstanceDataObject ido = this.createSettingsFile(df, this.getNodeDelegate().getDisplayName(), obj);
                    ido.attachToConvertor(null);
                    return ido;
                }
            } else if (!this.getPrimaryFile().hasExt(INSTANCE) && (class$java$io$Serializable == null ? (class$java$io$Serializable = InstanceDataObject.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.instanceClass()) && (ic = (InstanceCookie)this.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)) != null) {
                Object obj = ic.instanceCreate();
                return DataObject.find(this.createSerFile(df, this.getNodeDelegate().getDisplayName(), obj));
            }
        }
        catch (ClassNotFoundException ex) {
            InstanceDataObject.inform(ex);
        }
        return super.handleCopy(df);
    }

    private boolean isSavingCanceled() {
        return this.savingCanceled;
    }

    protected void dispose() {
        if (this.getPrimaryFile().hasExt(SER_EXT)) {
            RequestProcessor.Task task;
            this.savingCanceled = true;
            if (this.ser != null && ((task = this.ser.getSaveTask()).getDelay() > 0 || this.ser.isSaving() && !task.isFinished())) {
                task.waitFinished();
            }
            this.relaseFileLock();
        } else if (this.getPrimaryFile().hasExt(XML_EXT)) {
            SaveCookie s = (SaveCookie)this.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = InstanceDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            try {
                if (s != null) {
                    s.save();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    protected void handleDelete() throws IOException {
        this.savingCanceled = true;
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            this.handleDeleteSettings();
            return;
        }
        if (this.ser != null) {
            RequestProcessor.Task task = this.ser.getSaveTask();
            task.cancel();
            if (this.ser.isSaving() && !task.isFinished()) {
                task.waitFinished();
            }
        }
        this.relaseFileLock();
        super.handleDelete();
    }

    private void handleDeleteSettings() throws IOException {
        SaveCookie s = (SaveCookie)this.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = InstanceDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        try {
            if (s != null) {
                s.save();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.handleDelete();
    }

    private InstanceDataObject createSettingsFile(DataFolder df, String name, Object obj) throws IOException {
        String filename;
        FileObject fo = df.getPrimaryFile();
        boolean isServiceType = false;
        if (obj instanceof ServiceType) {
            isServiceType = true;
            ServiceType sr = (ServiceType)obj;
            String stName = name = name == null ? sr.getName() : name;
            int i = 1;
            while (TopManager.getDefault().getServices().find(stName) != null) {
                stName = new StringBuffer(name.length() + 2).append(name).append('_').append(i).toString();
                ++i;
            }
            if (!stName.equals(sr.getName())) {
                sr = sr.createClone();
                obj = sr;
                sr.setName(stName);
            }
            filename = InstanceDataObject.escapeAndCut(stName);
        } else {
            filename = name == null ? this.getPrimaryFile().getName() : InstanceDataObject.escapeAndCut(name);
        }
        filename = FileUtil.findFreeFileName(df.getPrimaryFile(), filename, this.getPrimaryFile().getExt());
        InstanceDataObject newFile = InstanceDataObject.storeSettings(df, filename, obj, null);
        if (name != null && !isServiceType) {
            newFile.getPrimaryFile().setAttribute("name", name);
        }
        return newFile;
    }

    private FileObject createSerFile(DataFolder df, String name, Object obj) throws IOException {
        FileObject newFile;
        FileLock lock;
        block7: {
            lock = null;
            OutputStream ostream = null;
            newFile = null;
            try {
                FileObject fo = df.getPrimaryFile();
                if (name == null) {
                    name = FileUtil.findFreeFileName(df.getPrimaryFile(), this.getPrimaryFile().getName(), this.getPrimaryFile().getExt());
                }
                if ((newFile = fo.getFileObject(name, SER_EXT)) == null) {
                    newFile = fo.createData(name, SER_EXT);
                }
                lock = newFile.lock();
                ostream = newFile.getOutputStream(lock);
                ObjectOutputStream p = new ObjectOutputStream(ostream);
                p.writeObject(obj);
                p.flush();
                Object var10_9 = null;
                if (ostream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (ostream != null) {
                    ostream.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
                throw throwable;
            }
            ostream.close();
        }
        if (lock != null) {
            lock.releaseLock();
        }
        return newFile;
    }

    final void setCustomClassLoader(ClassLoader cl) {
        if (this.ser instanceof Ser) {
            this.ser.setCustomClassLoader(cl);
        }
    }

    private static ByteArrayOutputStream storeThroughConvertor(Object inst) throws IOException {
        FileObject fo = InstanceDataObject.resolveConvertor(inst);
        Object convertor = fo.getAttribute("settings.convertor");
        if (convertor == null) {
            throw new IOException("missing attribute settings.convertor");
        }
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)b, "UTF-8");
        InstanceDataObject.convertorWriteMethod(convertor, w, inst);
        ((Writer)w).close();
        return b;
    }

    private static void convertorWriteMethod(Object convertor, Writer w, Object inst) throws IOException {
        Throwable e;
        block5: {
            e = null;
            try {
                Method method = convertor.getClass().getMethod("write", class$java$io$Writer == null ? (class$java$io$Writer = InstanceDataObject.class$("java.io.Writer")) : class$java$io$Writer, class$java$lang$Object == null ? (class$java$lang$Object = InstanceDataObject.class$("java.lang.Object")) : class$java$lang$Object);
                ((AccessibleObject)method).setAccessible(true);
                method.invoke(convertor, w, inst);
            }
            catch (NoSuchMethodException ex) {
                e = ex;
            }
            catch (IllegalAccessException ex) {
                e = ex;
            }
            catch (InvocationTargetException ex) {
                e = ex.getTargetException();
                if (!(e instanceof IOException)) break block5;
                throw (IOException)e;
            }
        }
        if (e != null) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Problem with Convertor.write method."), e);
        }
    }

    private static FileObject resolveConvertor(Object obj) throws IOException {
        String prefix = "xml/memory/";
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        FileObject memContext = sfs.findResource(prefix);
        if (memContext == null) {
            throw new FileNotFoundException("SFS/xml/memory/");
        }
        String[] classes = new String[]{obj.getClass().getName(), (class$java$lang$Object == null ? (class$java$lang$Object = InstanceDataObject.class$("java.lang.Object")) : class$java$lang$Object).getName()};
        int i = 0;
        while (i < classes.length) {
            String convertorPath = new StringBuffer(200).append(prefix).append(classes[i].replace('.', '/')).toString();
            FileObject fo = sfs.findResource(convertorPath);
            if (fo != null) {
                String providerPath = (String)fo.getAttribute(EA_PROVIDER_PATH);
                if (providerPath == null) break;
                return sfs.findResource(providerPath);
            }
            ++i;
        }
        throw new FileNotFoundException("None convertor was found under SFS/xml/memory/ for " + obj);
    }

    private void attachToConvertor(Object obj) throws IOException {
        this.findLookup();
        Object ic = this.cookiesLkp.lookup(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = InstanceDataObject.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
        if (ic == null) {
            throw new IllegalStateException("Trying to store object " + obj + " which most probably belongs to already disabled module!");
        }
        InstanceDataObject.convertorSetInstanceMethod(ic, obj);
    }

    private static void convertorSetInstanceMethod(Object convertor, Object inst) throws IOException {
        ReflectiveOperationException e;
        block5: {
            e = null;
            try {
                Method method = convertor.getClass().getMethod("setInstance", class$java$lang$Object == null ? (class$java$lang$Object = InstanceDataObject.class$("java.lang.Object")) : class$java$lang$Object);
                ((AccessibleObject)method).setAccessible(true);
                method.invoke(convertor, inst);
            }
            catch (NoSuchMethodException ex) {
                e = ex;
            }
            catch (IllegalAccessException ex) {
                e = ex;
            }
            catch (InvocationTargetException ex) {
                e = ex;
                if (!(ex.getTargetException() instanceof IOException)) break block5;
                throw (IOException)ex.getTargetException();
            }
        }
        if (e != null) {
            ErrorManager.getDefault().annotate((Throwable)e, "Problem with InstanceCookie.setInstance method: " + convertor.getClass());
            InstanceDataObject.inform(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Creator
    implements FileSystem.AtomicAction {
        private ModuleInfo mi = null;
        private DataFolder folder = null;
        private Object instance = null;
        private String name = null;
        private InstanceDataObject result = null;
        private boolean create;
        private static final Creator me = new Creator();

        private Creator() {
        }

        public void run() throws IOException {
            FileObject fo = this.folder.getPrimaryFile();
            String filename = this.name;
            if (filename == null) {
                filename = this.instance.getClass().getName().replace('.', '-');
                filename = FileUtil.findFreeFileName(fo, filename, InstanceDataObject.XML_EXT);
            } else {
                String escapedFileName = InstanceDataObject.escape(filename);
                filename = fo.getFileObject(escapedFileName, InstanceDataObject.XML_EXT) == null ? InstanceDataObject.escapeAndCut(filename) : escapedFileName;
                if (this.create) {
                    filename = FileUtil.findFreeFileName(fo, filename, InstanceDataObject.XML_EXT);
                }
            }
            this.result = InstanceDataObject.storeSettings(this.folder, filename, this.instance, this.mi);
        }

        public static InstanceDataObject createInstanceDataObject(DataFolder folder, String name, Object instance, ModuleInfo mi, boolean create) throws IOException {
            Creator creator = me;
            synchronized (creator) {
                Creator.me.mi = mi;
                Creator.me.folder = folder;
                Creator.me.instance = instance;
                Creator.me.name = name;
                Creator.me.create = create;
                folder.getPrimaryFile().getFileSystem().runAtomicAction(me);
                Creator.me.mi = null;
                Creator.me.folder = null;
                Creator.me.instance = null;
                Creator.me.name = null;
                InstanceDataObject result = Creator.me.result;
                Creator.me.result = null;
                InstanceDataObject instanceDataObject = result;
                return instanceDataObject;
            }
        }

        public static boolean isFiredFromMe(FileEvent fe) {
            return fe.firedFrom(me);
        }
    }

    private static final class Ser
    extends InstanceSupport.Origin
    implements Runnable {
        private Reference bean = new SoftReference<Object>(null);
        private long saveTime;
        private ClassLoader customClassLoader = null;
        private InstanceDataObject dobj;
        private RequestProcessor.Task task;
        private boolean saving = false;
        static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;

        public Ser(InstanceDataObject dobj) {
            super(dobj.getPrimaryEntry());
            this.dobj = dobj;
        }

        public String instanceName() {
            Object o;
            FileObject fo = this.entry().getFile();
            if (fo.lastModified().getTime() <= this.saveTime && (o = this.bean.get()) != null) {
                return o.getClass().getName();
            }
            if (!fo.hasExt(InstanceDataObject.INSTANCE)) {
                return super.instanceName();
            }
            return Ser.getClassName(fo);
        }

        private static String getClassName(FileObject fo) {
            int last;
            Object attr = fo.getAttribute(InstanceDataObject.EA_INSTANCE_CLASS);
            if (attr instanceof String) {
                return Utilities.translate((String)attr);
            }
            if (attr != null) {
                err.log(16, "instanceClass was a " + attr.getClass().getName());
            }
            if ((attr = fo.getAttribute(InstanceDataObject.EA_INSTANCE_CREATE)) != null) {
                return attr.getClass().getName();
            }
            String name = fo.getName();
            int first = name.indexOf(91) + 1;
            if (first != 0) {
                InstanceDataObject.warnAboutBrackets(fo);
            }
            if ((last = name.indexOf(93)) < 0) {
                last = name.length();
            }
            if (first < last) {
                name = name.substring(first, last);
            }
            name = name.replace('-', '.');
            name = Utilities.translate(name);
            return name;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            Class type = super.instanceClass(this.customClassLoader);
            Ser.updateListOfClasses(type, this.entry().getFile());
            return type;
        }

        public boolean instanceOf(Class type) {
            Object o;
            FileObject fo = this.entry().getFile();
            if (fo.lastModified().getTime() <= this.saveTime && (o = this.bean.get()) != null) {
                return type.isInstance(o);
            }
            Boolean res = Ser.inListOfClasses(type, this.entry().getFile());
            if (res == null) {
                return super.instanceOf(type);
            }
            return res;
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            FileObject fo = this.entry().getFile();
            Object o = fo.lastModified().getTime() <= this.saveTime ? (Object)this.bean.get() : null;
            if (o != null) {
                return o;
            }
            this.saveTime = fo.lastModified().getTime();
            if (this.saveTime < System.currentTimeMillis()) {
                this.saveTime = System.currentTimeMillis();
            }
            if (fo.hasExt(InstanceDataObject.INSTANCE)) {
                o = fo.getAttribute(InstanceDataObject.EA_INSTANCE_CREATE);
            }
            if (o == null) {
                o = super.instanceCreate();
            }
            this.bean = new SoftReference<Object>(o);
            return o;
        }

        public void run() {
            try {
                this.saving = true;
                this.runImpl();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.dobj.relaseFileLock();
                this.saving = false;
                throw throwable;
            }
            this.dobj.relaseFileLock();
            this.saving = false;
        }

        private void runImpl() {
            Object bean = this.bean.get();
            if (bean == null) {
                return;
            }
            try {
                FileLock lock = this.dobj.doFileLock();
                if (lock == null) {
                    return;
                }
                ObjectOutputStream oos = new ObjectOutputStream(this.entry().getFile().getOutputStream(lock));
                try {
                    oos.writeObject(bean);
                    this.saveTime = this.entry().getFile().lastModified().getTime();
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    oos.close();
                    throw throwable;
                }
                oos.close();
                {
                }
            }
            catch (IOException ex) {
                err.annotate((Throwable)ex, NbBundle.getMessage(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = Ser.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject, "EXC_CannotSaveBean", this.instanceName(), this.entry().getFile().getPackageNameExt('/', '.')));
                err.notify(ex);
            }
        }

        private static Boolean inListOfClasses(Class type, FileObject fo) {
            Object obj = fo.getAttribute(InstanceDataObject.EA_INSTANCE_OF);
            if (obj instanceof String) {
                String typeName = type.getName();
                StringTokenizer tok = new StringTokenizer((String)obj, ",;:");
                while (tok.hasMoreTokens()) {
                    String t = tok.nextToken().trim();
                    if (!typeName.equals(t)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (obj != null) {
                err.log(16, "instanceOf was a " + obj.getClass().getName());
            }
            return null;
        }

        private static void updateListOfClasses(Class type, FileObject fo) {
            boolean update;
            StringBuffer sb = null;
            Object obj = fo.getAttribute(InstanceDataObject.EA_INSTANCE_OF);
            if (obj instanceof String) {
                update = false;
                sb = new StringBuffer(1024);
                HashSet<String> added = new HashSet<String>(101);
                added.add("java.lang.Object");
                Ser.collectType(type, sb, added);
                StringTokenizer tok = new StringTokenizer((String)obj, ",;:");
                while (tok.hasMoreTokens()) {
                    if (added.contains(tok.nextToken().trim())) continue;
                    update = true;
                    break;
                }
            } else {
                update = false;
            }
            if (update) {
                try {
                    fo.setAttribute(InstanceDataObject.EA_INSTANCE_OF, sb.toString());
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }

        private static boolean collectType(Class type, StringBuffer sb, HashSet added) {
            if (type == null) {
                return false;
            }
            String typeName = type.getName();
            if (added.contains(typeName)) {
                return false;
            }
            added.add(typeName);
            if (Ser.collectType(type.getSuperclass(), sb, added)) {
                sb.append(',');
            }
            Class<?>[] impls = type.getInterfaces();
            int i = 0;
            while (i < impls.length) {
                if (Ser.collectType(impls[i], sb, added)) {
                    sb.append(',');
                }
                ++i;
            }
            sb.append(typeName);
            return true;
        }

        final void setCustomClassLoader(ClassLoader cl) {
            this.customClassLoader = cl;
        }

        public RequestProcessor.Task getSaveTask() {
            if (this.task == null) {
                this.task = PROCESSOR.create(this);
            }
            return this.task;
        }

        public boolean isSaving() {
            return this.saving;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class CookieAdjustingFilter
    extends FilterNode {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;

        public CookieAdjustingFilter(Node n) {
            super(n);
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz == (class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = CookieAdjustingFilter.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject) || clazz == (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = CookieAdjustingFilter.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject)) {
                return InstanceDataObject.this;
            }
            return super.getCookie(clazz);
        }

        public Node.Handle getHandle() {
            return this.getOriginal().getHandle();
        }

        public boolean equals(Object o) {
            return this == o || this.getOriginal().equals(o) || o != null && o.equals(this.getOriginal());
        }

        public int hashCode() {
            return this.getOriginal().hashCode();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class UnrecognizedSettingNode
    extends AbstractNode {
        static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;

        public UnrecognizedSettingNode() {
            super(Children.LEAF);
            this.setName(NbBundle.getMessage(class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = UnrecognizedSettingNode.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject, "LBL_BrokenSettings"));
            this.setIconBase("org/openide/resources/instanceBroken");
            this.setShortDescription(InstanceDataObject.this.getPrimaryFile().toString());
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = UnrecognizedSettingNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)};
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class UpdatableNode
    extends FilterNode {
        public UpdatableNode(Node n) {
            super(n);
        }

        public void update() {
            this.changeOriginal(InstanceDataObject.this.createNodeDelegateImpl(), true);
        }
    }
}

