/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.EventObject;
import org.openide.TopManager;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.BrokenDataShadow;
import org.openide.loaders.DataShadow;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;

class ShadowChangeAdapter
implements RepositoryListener,
OperationListener {
    ShadowChangeAdapter() {
        TopManager.getDefault().getRepository().addRepositoryListener(this);
        TopManager.getDefault().getLoaderPool().addOperationListener(this);
    }

    static void checkBrokenDataShadows(EventObject ev) {
        BrokenDataShadow.checkValidity(ev);
    }

    static void checkDataShadows(EventObject ev) {
        DataShadow.checkValidity(ev);
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        ShadowChangeAdapter.checkBrokenDataShadows(ev);
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        ShadowChangeAdapter.checkDataShadows(ev);
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
    }

    public void operationPostCreate(OperationEvent ev) {
        ShadowChangeAdapter.checkBrokenDataShadows(ev);
    }

    public void operationCopy(OperationEvent.Copy ev) {
    }

    public void operationMove(OperationEvent.Move ev) {
        ShadowChangeAdapter.checkDataShadows(ev);
        ShadowChangeAdapter.checkBrokenDataShadows(ev);
    }

    public void operationDelete(OperationEvent ev) {
        ShadowChangeAdapter.checkDataShadows(ev);
    }

    public void operationRename(OperationEvent.Rename ev) {
        ShadowChangeAdapter.checkDataShadows(ev);
        ShadowChangeAdapter.checkBrokenDataShadows(ev);
    }

    public void operationCreateShadow(OperationEvent.Copy ev) {
    }

    public void operationCreateFromTemplate(OperationEvent.Copy ev) {
        ShadowChangeAdapter.checkBrokenDataShadows(ev);
    }
}

