/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.ClassNamePanel;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard1;
import org.openide.loaders.TemplateWizard2;
import org.openide.loaders.TemplateWizardIterImpl;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class TemplateWizard
extends WizardDescriptor {
    private static final String EA_DESCRIPTION = "templateWizardURL";
    private static final String EA_ITERATOR = "templateWizardIterator";
    private static final String EA_DESC_RESOURCE = "templateWizardDescResource";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    static Dimension PREF_DIM = new Dimension(560, 350);
    private WizardDescriptor.Panel templateChooser;
    private WizardDescriptor.Panel targetChooser;
    private boolean showTargetChooser = true;
    private Iterator targetIterator;
    private TemplateWizardIterImpl iterator;
    private DataObject template;
    private DataFolder templatesFolder;
    private String className = null;
    private String packageName = NbBundle.getMessage(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard, "LAB_TemplatePackageName");
    private Reference system = new WeakReference<Object>(null);
    private boolean titleFormatSet = false;
    private PropertyChangeListener pcl;
    private Component lastComp;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard$Iterator;

    public TemplateWizard() {
        this(new TemplateWizardIterImpl());
    }

    private TemplateWizard(TemplateWizardIterImpl it) {
        super(it);
        this.iterator = it;
        this.iterator.initialize(this);
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getMessage(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard, "CTL_TemplateTitle"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    protected TemplateWizard(Iterator it) {
        this();
        this.iterator.setIterator(it, false);
    }

    protected void initialize() {
        if (this.iterator != null) {
            this.iterator.initialize(this);
        }
        super.initialize();
    }

    final String getClassName() {
        return this.className;
    }

    final void setClassName(String name) {
        this.className = name;
    }

    final String getPackageName() {
        return this.packageName;
    }

    final FileSystem getSystem() {
        FileSystem fs = (FileSystem)this.system.get();
        if (fs == null || !fs.isValid()) {
            Enumeration en = Repository.getDefault().fileSystems();
            while (en.hasMoreElements()) {
                fs = (FileSystem)en.nextElement();
                if (fs.isHidden()) continue;
                this.system = new WeakReference<FileSystem>(fs);
                return fs;
            }
            fs = Repository.getDefault().getDefaultFileSystem();
            this.system = new WeakReference<FileSystem>(fs);
        }
        return fs;
    }

    final void setNameSystem(String packageName, FileSystem system) {
        this.packageName = packageName;
        this.system = new WeakReference<FileSystem>(system);
    }

    final void setTemplateImpl(DataObject obj, boolean notify) {
        DataObject old = this.template;
        if (this.template != obj) {
            this.template = obj;
        }
        this.setTitle(NbBundle.getMessage(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard, "CTL_TemplateTitle2", obj.getNodeDelegate().getDisplayName()));
        if (old != this.template) {
            Iterator it;
            if (obj == null || (it = TemplateWizard.getIterator(obj)) == null) {
                it = this.defaultIterator();
            }
            this.iterator.setIterator(it, notify);
        }
    }

    public DataObject getTemplate() {
        return this.template;
    }

    public void setTemplate(DataObject obj) {
        if (obj != null) {
            this.setTemplateImpl(obj, true);
        }
    }

    public void setTemplatesFolder(DataFolder folder) {
        this.templatesFolder = folder;
    }

    public DataFolder getTemplatesFolder() {
        DataFolder df = this.templatesFolder;
        return df == null ? TopManager.getDefault().getPlaces().folders().templates() : df;
    }

    public DataFolder getTargetFolder() throws IOException {
        if (this.packageName.length() > 0) {
            return DataFolder.findFolder(TemplateWizard.convertPackageName(this.getSystem().getRoot(), this.packageName, 0));
        }
        return DataFolder.findFolder(this.getSystem().getRoot());
    }

    private static FileObject convertPackageName(FileObject fo, String name, int start) throws IOException {
        if (start >= name.length()) {
            return null;
        }
        int index = name.indexOf(46, start);
        if (index == -1) {
            index = name.length();
        }
        while (index != -1) {
            FileObject r = fo.getFileObject(name.substring(start, index));
            if (r != null) {
                if (index == name.length()) {
                    return r;
                }
                return TemplateWizard.convertPackageName(r, name, index + 1);
            }
            if (index != name.length()) {
                if ((index = name.indexOf(46, index + 1)) != -1) continue;
                index = name.length();
                continue;
            }
            index = -1;
        }
        return DataFolder.create(DataFolder.findFolder(fo), name.substring(start).replace('.', '/')).getPrimaryFile();
    }

    public void setTargetFolder(DataFolder f) {
        try {
            FileSystem system = f.getPrimaryFile().getFileSystem();
            String newName = f.getPrimaryFile().getPackageNameExt('.', '.');
            this.setNameSystem(newName, system);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public String getTargetName() {
        return this.className;
    }

    public void setTargetName(String name) {
        this.className = name;
    }

    public WizardDescriptor.Panel templateChooser() {
        if (this.templateChooser == null) {
            TemplateWizard templateWizard = this;
            synchronized (templateWizard) {
                if (this.templateChooser == null) {
                    this.templateChooser = this.createTemplateChooser();
                }
            }
        }
        return this.templateChooser;
    }

    public WizardDescriptor.Panel targetChooser() {
        if (this.targetChooser == null) {
            TemplateWizard templateWizard = this;
            synchronized (templateWizard) {
                if (this.targetChooser == null) {
                    this.targetChooser = this.createTargetChooser();
                }
            }
        }
        return this.targetChooser;
    }

    final synchronized Iterator defaultIterator() {
        if (this.targetIterator == null) {
            this.targetIterator = this.createDefaultIterator();
        }
        return this.targetIterator;
    }

    protected WizardDescriptor.Panel createTemplateChooser() {
        return new TemplateWizard1();
    }

    protected WizardDescriptor.Panel createTargetChooser() {
        return this.showTargetChooser ? new TemplateWizard2() : new ClassNamePanel();
    }

    protected Iterator createDefaultIterator() {
        return new DefaultIterator();
    }

    public Set instantiate() throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(null, null);
    }

    public Set instantiate(DataObject template) throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(template, null);
    }

    public Set instantiate(DataObject template, DataFolder targetFolder) throws IOException {
        this.showTargetChooser = false;
        return this.instantiateImpl(template, targetFolder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set instantiateImpl(DataObject template, DataFolder targetFolder) throws IOException {
        Set set;
        block13: {
            this.showTargetChooser |= targetFolder == null;
            this.targetChooser = null;
            IllegalStateException thrownMessage = null;
            try {
                Set set2;
                while (true) {
                    if (targetFolder != null) {
                        this.setTargetFolder(targetFolder);
                    }
                    if (template != null) {
                        this.template = null;
                        this.setTemplate(template);
                        if (this.iterator != null) {
                            this.iterator.initialize(this);
                        }
                    } else if (this.iterator != null) {
                        this.iterator.initialize(this);
                        this.iterator.first();
                    }
                    try {
                        Object option;
                        this.updateState();
                        final Dialog d = TopManager.getDefault().createDialog(this);
                        if (thrownMessage != null) {
                            final IllegalStateException t = thrownMessage;
                            thrownMessage = null;
                            d.addComponentListener(new ComponentAdapter(){

                                public void componentShown(ComponentEvent e) {
                                    if (t.getMessage() != null) {
                                        ErrorManager.getDefault().notify(256, t);
                                    } else {
                                        ErrorManager.getDefault().notify(t);
                                    }
                                    d.removeComponentListener(this);
                                }
                            });
                        }
                        d.show();
                        d.dispose();
                        if (this.lastComp != null) {
                            this.lastComp.removePropertyChangeListener(this.propL());
                            this.lastComp = null;
                        }
                        if ((option = this.getValue()) == WizardDescriptor.FINISH_OPTION || option == NotifyDescriptor.YES_OPTION || option == NotifyDescriptor.OK_OPTION) {
                            set2 = this.handleInstantiate();
                            Object var8_9 = null;
                            if (this.iterator == null) return set2;
                            break;
                        }
                        set = null;
                        break block13;
                    }
                    catch (IllegalStateException ise) {
                        thrownMessage = ise;
                        continue;
                    }
                    break;
                }
                this.iterator.uninitialize();
                return set2;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (this.iterator == null) throw throwable;
                this.iterator.uninitialize();
                throw throwable;
            }
        }
        Object var8_10 = null;
        if (this.iterator == null) return set;
        this.iterator.uninitialize();
        return set;
    }

    public void setTitleFormat(MessageFormat format) {
        this.titleFormatSet = true;
        super.setTitleFormat(format);
    }

    public MessageFormat getTitleFormat() {
        if (!this.titleFormatSet) {
            this.setTitleFormat(new MessageFormat(NbBundle.getMessage(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard, "CTL_TemplateTitle")));
        }
        return super.getTitleFormat();
    }

    protected Set handleInstantiate() throws IOException {
        return this.iterator.getIterator().instantiate(this);
    }

    public static void setDescription(DataObject obj, URL url) throws IOException {
        obj.getPrimaryFile().setAttribute(EA_DESCRIPTION, url);
    }

    public static URL getDescription(DataObject obj) {
        URL desc = (URL)obj.getPrimaryFile().getAttribute(EA_DESCRIPTION);
        if (desc != null) {
            return desc;
        }
        String rsrc = (String)obj.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
        if (rsrc != null) {
            try {
                URL better = new URL("nbresloc:/" + rsrc);
                try {
                    TemplateWizard.setDescription(obj, better);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return better;
            }
            catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
            }
        }
        return null;
    }

    public static void setDescriptionAsResource(DataObject obj, String rsrc) throws IOException {
        if (rsrc != null && rsrc.startsWith("/")) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.err.println("Warning: auto-stripping leading slash from resource path in TemplateWizard.setDescriptionAsResource");
            }
            rsrc = rsrc.substring(1);
        }
        obj.getPrimaryFile().setAttribute(EA_DESC_RESOURCE, rsrc);
    }

    public static String getDescriptionAsResource(DataObject obj) {
        return (String)obj.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
    }

    public static void setIterator(DataObject obj, Iterator iter) throws IOException {
        obj.getPrimaryFile().setAttribute(EA_ITERATOR, iter);
    }

    public static Iterator getIterator(DataObject obj) {
        Iterator it = (Iterator)obj.getPrimaryFile().getAttribute(EA_ITERATOR);
        if (it != null) {
            return it;
        }
        return (Iterator)obj.getCookie(class$org$openide$loaders$TemplateWizard$Iterator == null ? (class$org$openide$loaders$TemplateWizard$Iterator = TemplateWizard.class$("org.openide.loaders.TemplateWizard$Iterator")) : class$org$openide$loaders$TemplateWizard$Iterator);
    }

    protected void updateState() {
        super.updateState();
        if (this.lastComp != null) {
            this.lastComp.removePropertyChangeListener(this.propL());
        }
        this.lastComp = this.iterator.current().getComponent();
        this.lastComp.addPropertyChangeListener(this.propL());
        this.putProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(this.getContentSelectedIndex()));
        if (this.getContentData() != null) {
            this.putProperty(PROP_CONTENT_DATA, this.getContentData());
        }
    }

    private String[] getContentData() {
        Object property;
        Component first = this.templateChooser().getComponent();
        if (this.iterator.current() == this.templateChooser()) {
            return (String[])((JComponent)first).getClientProperty(PROP_CONTENT_DATA);
        }
        String[] cd = null;
        Component c = this.iterator.current().getComponent();
        if (c instanceof JComponent && (property = ((JComponent)c).getClientProperty(PROP_CONTENT_DATA)) instanceof String[]) {
            String[] cont = (String[])property;
            cd = new String[cont.length + 1];
            cd[0] = ((String[])((JComponent)first).getClientProperty(PROP_CONTENT_DATA))[0];
            System.arraycopy(cont, 0, cd, 1, cont.length);
        }
        return cd;
    }

    private int getContentSelectedIndex() {
        Object property;
        if (this.iterator.current() == this.templateChooser()) {
            return 0;
        }
        int index = 1;
        Component c = this.iterator.current().getComponent();
        if (c instanceof JComponent && (property = ((JComponent)c).getClientProperty(PROP_CONTENT_SELECTED_INDEX)) instanceof Integer) {
            index += ((Integer)property).intValue();
        }
        return index;
    }

    private PropertyChangeListener propL() {
        if (this.pcl == null) {
            this.pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    if (TemplateWizard.PROP_CONTENT_SELECTED_INDEX.equals(ev.getPropertyName())) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_SELECTED_INDEX, new Integer(TemplateWizard.this.getContentSelectedIndex()));
                    } else if (TemplateWizard.PROP_CONTENT_DATA.equals(ev.getPropertyName()) && TemplateWizard.this.getContentData() != null) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_DATA, TemplateWizard.this.getContentData());
                    }
                }
            };
        }
        return this.pcl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class DefaultIterator
    implements Iterator {
        private DefaultIterator() {
        }

        public String name() {
            return "";
        }

        public Set instantiate(TemplateWizard wiz) throws IOException {
            String n = wiz.getTargetName();
            DataFolder folder = wiz.getTargetFolder();
            DataObject template = wiz.getTemplate();
            DataObject obj = n == null ? template.createFromTemplate(folder) : template.createFromTemplate(folder, n);
            Node node = obj.getNodeDelegate();
            SystemAction sa = node.getDefaultAction();
            if (sa != null) {
                TopManager.getDefault().getActionManager().invokeAction(sa, new ActionEvent(node, 1001, ""));
            }
            return Collections.singleton(obj);
        }

        public void initialize(TemplateWizard wiz) {
        }

        public void uninitialize(TemplateWizard wiz) {
        }

        public WizardDescriptor.Panel current() {
            return TemplateWizard.this.targetChooser();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public void nextPanel() {
            throw new NoSuchElementException();
        }

        public void previousPanel() {
            throw new NoSuchElementException();
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    public static interface Iterator
    extends WizardDescriptor.Iterator,
    Serializable,
    Node.Cookie {
        public Set instantiate(TemplateWizard var1) throws IOException;

        public void initialize(TemplateWizard var1);

        public void uninitialize(TemplateWizard var1);
    }
}

