/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class TemplateWizard1
extends JPanel
implements DataFilter,
WizardDescriptor.Panel,
ExplorerManager.Provider,
PropertyChangeListener {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private ChangeListener listener;
    private DataObject template;
    private DataFolder templatesRoot;
    private ExplorerManager manager;
    private JPanel browserPanel;
    private HtmlBrowser browser;
    private JLabel noBrowser;
    private JLabel templatesLabel;
    private JLabel browserLabel;
    private TemplatesTreeView treeView;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard1;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public TemplateWizard1() {
        this.initComponents();
        this.treeView = new TemplatesTreeView();
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints1);
        this.setName(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1).getString("LAB_TemplateChooserPanelName"));
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1);
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        this.putClientProperty(PROP_CONTENT_DATA, new String[]{this.getName(), "..."});
        this.putClientProperty("LAB_SelectTemplateBorder", bundle.getString("LAB_SelectTemplateBorder"));
        this.putClientProperty("LAB_SelectTemplateBorder_Mnemonic", bundle.getString("LAB_SelectTemplateBorder_Mnemonic"));
        this.putClientProperty("LAB_TemplateDescriptionBorder", bundle.getString("LAB_TemplateDescriptionBorder"));
        this.putClientProperty("LAB_TemplateDescriptionBorder_Mnemonic", bundle.getString("LAB_TemplateDescriptionBorder_Mnemonic"));
        this.putClientProperty("ACSD_TemplatesTree", bundle.getString("ACSD_TemplatesTree"));
        this.putClientProperty("ACSD_TemplateWizard1", bundle.getString("ACSD_TemplateWizard1"));
        this.updateRootNode(null);
        this.noBrowser.setText(bundle.getString("MSG_NoDescription"));
        this.templatesLabel.setLabelFor(this.treeView);
        this.browserLabel.setLabelFor(this.browser);
        CardLayout card = (CardLayout)this.browserPanel.getLayout();
        card.show(this.browserPanel, "noBrowser");
    }

    public void addNotify() {
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1);
        this.templatesLabel.setText((String)this.getClientProperty("LAB_SelectTemplateBorder"));
        this.templatesLabel.setDisplayedMnemonic(((String)this.getClientProperty("LAB_SelectTemplateBorder_Mnemonic")).charAt(0));
        this.browserLabel.setText((String)this.getClientProperty("LAB_TemplateDescriptionBorder"));
        this.browserLabel.setDisplayedMnemonic(((String)this.getClientProperty("LAB_TemplateDescriptionBorder_Mnemonic")).charAt(0));
        this.treeView.getAccessibleContext().setAccessibleDescription((String)this.getClientProperty("ACSD_TemplatesTree"));
        this.browser.getAccessibleContext().setAccessibleName(this.browserLabel.getText());
        this.getAccessibleContext().setAccessibleDescription((String)this.getClientProperty("ACSD_TemplateWizard1"));
        super.addNotify();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener(this);
        }
        return this.manager;
    }

    public boolean requestDefaultFocus() {
        return this.treeView.requestDefaultFocus();
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    private void updateRootNode(DataFolder root) {
        if (root == null) {
            root = TopManager.getDefault().getPlaces().folders().templates();
        }
        if (root.equals(this.templatesRoot)) {
            return;
        }
        this.templatesRoot = root;
        Children ch = root.createNodeChildren(this);
        this.getExplorerManager().setRootContext(new FilterNode(root.getNodeDelegate(), ch));
    }

    private void updateDescription(DataObject obj) {
        URL url = null;
        if (obj != null) {
            url = TemplateWizard.getDescription(obj);
        }
        CardLayout card = (CardLayout)this.browserPanel.getLayout();
        if (url != null && this.getExplorerManager().getSelectedNodes().length != 0) {
            this.browser.setURL(url);
            card.show(this.browserPanel, "browser");
        } else {
            card.show(this.browserPanel, "noBrowser");
        }
    }

    private void initComponents() {
        this.browserPanel = new JPanel();
        this.browser = new HtmlBrowser();
        this.noBrowser = new JLabel();
        this.templatesLabel = new JLabel();
        this.browserLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(0, 0));
        this.browserPanel.setLayout(new CardLayout());
        this.browser.setStatusLineVisible(false);
        this.browser.setName("browser");
        this.browser.setToolbarVisible(false);
        this.browserPanel.add((Component)this.browser, "browser");
        this.noBrowser.setHorizontalAlignment(0);
        this.browserPanel.add((Component)this.noBrowser, "noBrowser");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weighty = 0.5;
        this.add((Component)this.browserPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.templatesLabel, gridBagConstraints1);
        this.browserLabel.setLabelFor(this.browser);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.browserLabel, gridBagConstraints1);
    }

    private void nameFocusGained(FocusEvent evt) {
    }

    private void templatesTreeValueChanged(TreeSelectionEvent evt) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "selectedNodes" && this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
            this.updateDescription(this.template);
        }
    }

    private void packagesListValueChanged(ListSelectionEvent evt) {
    }

    public boolean acceptDataObject(DataObject obj) {
        if (obj instanceof DataFolder) {
            Object o = obj.getPrimaryFile().getAttribute("simple");
            return o == null || Boolean.TRUE.equals(o);
        }
        return obj.isTemplate();
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        if (this.getExplorerManager().getRootContext() != Node.EMPTY) {
            return new HelpCtx((class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1).getName() + "." + this.getExplorerManager().getRootContext().getName());
        }
        return new HelpCtx(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1);
    }

    public void readSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        wizard.setTitle(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard1.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).getString("CTL_TemplateTitle"));
        this.updateRootNode(wizard.getTemplatesFolder());
        this.template = wizard.getTemplate();
        if (this.template != null && !this.template.isValid()) {
            this.template = null;
        }
        DataFolder stop = wizard.getTemplatesFolder();
        final LinkedList<String> ll = new LinkedList<String>();
        for (DataObject obj = this.template; obj != null && obj != stop; obj = obj.getFolder()) {
            String key = obj.getNodeDelegate().getName();
            ll.addFirst(key);
        }
        RequestProcessor.postRequest(new Runnable(){
            private Node selection;

            public void run() {
                if (this.selection == null) {
                    Node node = TemplateWizard1.this.getExplorerManager().getRootContext();
                    ListIterator it = ll.listIterator();
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        if ((node = node.getChildren().findChild(name)) != null) continue;
                        node = TemplateWizard1.this.getExplorerManager().getRootContext();
                        break;
                    }
                    this.selection = node;
                    SwingUtilities.invokeLater(this);
                } else {
                    try {
                        TemplateWizard1.this.getExplorerManager().setSelectedNodes(new Node[]{this.selection});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }, 300, 1);
    }

    public void storeSettings(Object settings) {
        if (this.template != null) {
            Component c;
            TemplateWizard wizard = (TemplateWizard)settings;
            if (wizard.getTemplate() != this.template && (c = wizard.targetChooser().getComponent()) instanceof JComponent) {
                ((JComponent)c).putClientProperty(PROP_CONTENT_DATA, new String[]{c.getName()});
                ((JComponent)c).putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
            }
            wizard.setTemplateImpl(this.template, false);
        }
    }

    public boolean isValid() {
        boolean enable = false;
        Node[] n = this.getExplorerManager().getSelectedNodes();
        if (n.length == 1) {
            this.template = (DataObject)n[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateWizard1.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            enable = this.template != null && this.template.isTemplate();
        }
        return enable;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class TemplatesTreeView
    extends BeanTreeView {
        TemplatesTreeView() {
            this.tree.setEditable(false);
            this.tree.getSelectionModel().setSelectionMode(1);
        }

        protected NodeTreeModel createModel() {
            return new TemplatesModel();
        }
    }

    private static final class TemplatesModel
    extends NodeTreeModel {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        private TemplatesModel() {
        }

        public int getChildCount(Object o) {
            Node n = Visualizer.findNode(o);
            DataObject obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplatesModel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return obj == null || obj.isTemplate() ? 0 : super.getChildCount(o);
        }

        public boolean isLeaf(Object o) {
            Node n = Visualizer.findNode(o);
            DataObject obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplatesModel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return obj == null || obj.isTemplate();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

