/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.Caret;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.loaders.TemplateWizard2;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

final class TemplateWizard2
extends JPanel
implements DocumentListener,
WizardDescriptor.FinishPanel,
DataFilter,
PropertyChangeListener,
VetoableChangeListener {
    private static MessageFormat defaultPackageName;
    private ChangeListener listener;
    private Reference system = new WeakReference<Object>(null);
    private boolean systemSelected;
    private Node rootNode;
    private String extension;
    private JPanel namePanel;
    private JLabel jLabel1;
    private JTextField className;
    private ExplorerPanel packagesPanel;
    private JPanel packageNamePanel;
    private JLabel jLabel2;
    private JTextField packageName;
    private JLabel jLabel3;
    private JTextField directoryName;
    private BeanTreeView beanTreeView;
    private JLabel descriptionLabel;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard2;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public TemplateWizard2() {
        this.initComponents();
        this.setName(DataObject.getString("LAB_TargetLocationPanelName"));
        this.rootNode = this.createPackagesNode();
        this.packagesPanel.getExplorerManager().setRootContext(this.rootNode);
        this.packagesPanel.getExplorerManager().addPropertyChangeListener(this);
        this.packagesPanel.getExplorerManager().addVetoableChangeListener(this);
        this.packageName.getDocument().addDocumentListener(this);
        this.packageName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.className.getDocument().addDocumentListener(this);
        this.className.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2);
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_TemplateClassName_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(bundle.getString("CTL_TemplatePackageName_Mnemonic").charAt(0));
        this.jLabel3.setDisplayedMnemonic(bundle.getString("CTL_TemplateDirectoryName_Mnemonic").charAt(0));
        this.descriptionLabel.setText(bundle.getString("LAB_TargetLocationDescription"));
        this.descriptionLabel.setDisplayedMnemonic(bundle.getString("LAB_TargetLocationDescription_Mnemonic").charAt(0));
        this.className.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TemplateClassName"));
        this.packageName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TemplatePackageName"));
        this.directoryName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TemplateDirectoryName"));
        this.beanTreeView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TargetLocationDescription"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TemplateWizard2"));
        this.putClientProperty("WizardPanel_contentData", new String[]{this.getName()});
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    public void requestFocus() {
        this.className.requestFocus();
        this.className.selectAll();
    }

    private Node createPackagesNode() {
        Node orig = TopManager.getDefault().getPlaces().nodes().repository(this);
        return new FilterNode(orig, new ExCh(orig));
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.className = new JTextField();
        this.packagesPanel = new ExplorerPanel();
        this.packageNamePanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.packageName = new JTextField();
        this.jLabel3 = new JLabel();
        this.directoryName = new JTextField();
        this.beanTreeView = new BeanTreeView();
        this.descriptionLabel = new JLabel();
        this.setLayout(new BorderLayout(0, 11));
        this.setPreferredSize(new Dimension(0, 0));
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.jLabel1.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplateClassName"));
        this.jLabel1.setLabelFor(this.className);
        this.namePanel.add((Component)this.jLabel1, "West");
        this.className.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TemplateWizard2.this.classNameFocusGained(evt);
            }
        });
        this.namePanel.add((Component)this.className, "Center");
        this.add((Component)this.namePanel, "North");
        this.packagesPanel.setLayout(new BorderLayout(0, 5));
        this.packageNamePanel.setLayout(new GridBagLayout());
        this.jLabel2.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplatePackageName"));
        this.jLabel2.setLabelFor(this.packageName);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(6, 0, 5, 0);
        gridBagConstraints1.anchor = 17;
        this.packageNamePanel.add((Component)this.jLabel2, gridBagConstraints1);
        this.packageName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TemplateWizard2.this.packageNameFocusGained(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(6, 8, 5, 0);
        gridBagConstraints1.weightx = 1.0;
        this.packageNamePanel.add((Component)this.packageName, gridBagConstraints1);
        this.jLabel3.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplateDirectoryName"));
        this.jLabel3.setLabelFor(this.directoryName);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.packageNamePanel.add((Component)this.jLabel3, gridBagConstraints1);
        this.directoryName.setEditable(false);
        this.directoryName.setText("jTextField1");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 8, 0, 0);
        this.packageNamePanel.add((Component)this.directoryName, gridBagConstraints1);
        this.packagesPanel.add((Component)this.packageNamePanel, "South");
        this.beanTreeView.setPopupAllowed(false);
        this.packagesPanel.add((Component)this.beanTreeView, "Center");
        this.descriptionLabel.setLabelFor(this.beanTreeView);
        this.packagesPanel.add((Component)this.descriptionLabel, "North");
        this.add((Component)this.packagesPanel, "Center");
    }

    private void packageNameFocusGained(FocusEvent evt) {
        this.packageName.selectAll();
    }

    private void packageModelChanged(ListDataEvent evt) {
    }

    private void classNameFocusGained(FocusEvent evt) {
        if (Utilities.getOperatingSystem() == 8 | Utilities.getOperatingSystem() == 256) {
            return;
        }
        this.className.selectAll();
    }

    private void templatesTreeValueChanged(TreeSelectionEvent evt) {
    }

    public boolean acceptDataObject(DataObject obj) {
        Node.Cookie o = obj.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (o == null) {
            return false;
        }
        try {
            FileSystem fs = obj.getPrimaryFile().getFileSystem();
            if (!fs.isHidden() || this.system.get() == fs) {
                return !fs.isReadOnly();
            }
            return false;
        }
        catch (FileStateInvalidException ex) {
            return false;
        }
    }

    public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
        Node[] arr;
        if ("selectedNodes".equals(ev.getPropertyName()) && (arr = (Node[])ev.getNewValue()).length > 1) {
            throw new PropertyVetoException("Only single selection allowed", ev);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("selectedNodes".equals(ev.getPropertyName())) {
            DataFolder df;
            Node[] arr = this.packagesPanel.getExplorerManager().getSelectedNodes();
            if (arr.length == 1 && (df = (DataFolder)arr[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
                try {
                    FileObject fo = df.getPrimaryFile();
                    FileSystem fs = fo.getFileSystem();
                    this.system = new WeakReference<FileSystem>(fs);
                    this.systemSelected = true;
                    String name = fo.getPackageNameExt('.', '.');
                    this.packageName.getDocument().removeDocumentListener(this);
                    this.packageName.setText(name);
                    this.updateDirectory();
                    this.packageName.getDocument().addDocumentListener(this);
                    this.fireStateChanged();
                    return;
                }
                catch (FileStateInvalidException fsie) {
                    this.system = new WeakReference<Object>(null);
                    this.systemSelected = false;
                }
            }
            this.systemSelected = false;
            this.setTargetFolder((DataFolder)null);
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void changedUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String text = TemplateWizard2.this.packageName.getText();
                    if (text != null) {
                        TemplateWizard2.this.setTargetFolder(text);
                        TemplateWizard2.this.updateDirectory();
                    }
                }
            });
            return;
        }
        if (p1.getDocument() == this.className.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TemplateWizard2.this.className.getText().equals("")) {
                        TemplateWizard2.this.setClassName("");
                    }
                    TemplateWizard2.this.fireStateChanged();
                }
            });
        }
    }

    public void removeUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TemplateWizard2.this.packageName.getText().length() == 0) {
                        FileSystem fs = (FileSystem)TemplateWizard2.this.system.get();
                        if (fs != null) {
                            DataFolder df = DataFolder.findFolder(fs.getRoot());
                            TemplateWizard2.this.setTargetFolder(df);
                            TemplateWizard2.this.packageName.selectAll();
                        }
                        TemplateWizard2.this.updateDirectory();
                    } else {
                        TemplateWizard2.this.updateDirectory();
                        TemplateWizard2.this.fireStateChanged();
                    }
                }
            });
        }
        if (p1.getDocument() == this.className.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TemplateWizard2.this.className.getText().equals("")) {
                        TemplateWizard2.this.setClassName("");
                    }
                    TemplateWizard2.this.fireStateChanged();
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent p1) {
        this.changedUpdate(p1);
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2);
    }

    public void readSettings(Object settings) {
        FileObject fo;
        TemplateWizard wizard = (TemplateWizard)settings;
        DataObject template = wizard.getTemplate();
        if (template != null) {
            this.extension = template.getPrimaryFile().getExt();
        }
        this.setClassName(wizard.getClassName());
        String name = wizard.getPackageName();
        FileSystem fs = wizard.getSystem();
        this.system = new WeakReference<FileSystem>(fs);
        this.requestFocus();
        if (fs != null && name != null && (fo = fs.find(name, null, null)) != null) {
            this.systemSelected = this.setTargetFolder(DataFolder.findFolder(fo));
            return;
        }
        this.systemSelected = this.setTargetFolder(name);
    }

    public void storeSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        FileSystem fs = (FileSystem)this.system.get();
        String name = this.packageName.getText();
        if (name.equals(TemplateWizard2.defaultPackageName(fs))) {
            name = "";
        }
        wizard.setNameSystem(name, fs);
        name = this.className.getText();
        if (name.equals(TemplateWizard2.defaultClassName())) {
            name = null;
        }
        wizard.setTargetName(name);
    }

    public boolean isValid() {
        Node[] arr;
        String text = this.packageName.getText();
        if (text.length() == 0 && (arr = this.packagesPanel.getExplorerManager().getSelectedNodes()).length == 1 && arr[0] == this.rootNode) {
            return false;
        }
        FileSystem fs = (FileSystem)this.system.get();
        if (fs != null) {
            FileObject f = fs.find(text, this.className.getText(), this.extension);
            if (f != null) {
                return false;
            }
            if (text.equals(TemplateWizard2.defaultPackageName(fs)) && (f = fs.find("", this.className.getText(), this.extension)) != null) {
                return false;
            }
            if (fs.isReadOnly()) {
                return false;
            }
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    private static String computeSuggestion(Node node, String pref, Node[] first) {
        Node[] arr = node.getChildren().getNodes();
        String match = null;
        int i = 0;
        while (i < arr.length) {
            String name = arr[i].getName();
            if (name.startsWith(pref)) {
                if (match == null) {
                    match = name;
                    if (first != null) {
                        first[0] = arr[i];
                    }
                } else {
                    int indx = pref.length();
                    int end = Math.min(name.length(), match.length());
                    while (indx < end && match.charAt(indx) == name.charAt(indx)) {
                        ++indx;
                    }
                    match = match.substring(0, indx);
                }
            }
            ++i;
        }
        if (match == null || match.length() == pref.length()) {
            return null;
        }
        return match.substring(pref.length());
    }

    private boolean setTargetFolder(DataFolder f) {
        boolean exact;
        Node n;
        String name;
        if (f != null) {
            FileObject fo = f.getPrimaryFile();
            name = fo.getPackageNameExt('.', '.');
            StringTokenizer st = new StringTokenizer(name, ".");
            try {
                FileSystem fs = fo.getFileSystem();
                if (fo.isRoot()) {
                    name = TemplateWizard2.defaultPackageName(fs);
                }
                this.system = new WeakReference<FileSystem>(fs);
                SequenceEnumeration en = new SequenceEnumeration(new SingletonEnumeration(fs.getSystemName()), st);
                n = NodeOp.findPath(this.rootNode, en);
                exact = true;
            }
            catch (FileStateInvalidException ex) {
                n = this.rootNode;
                name = "";
                exact = false;
            }
            catch (NodeNotFoundException ex) {
                n = ex.getClosestNode();
                DataFolder df = (DataFolder)n.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                name = df != null ? df.getPrimaryFile().getPackageNameExt('.', '.') : "";
                exact = false;
            }
        } else {
            n = this.rootNode;
            name = null;
            exact = true;
        }
        ExplorerManager em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener(this);
        this.packageName.getDocument().removeDocumentListener(this);
        try {
            em.setSelectedNodes(new Node[]{n});
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        this.packageName.setText(name);
        this.updateDirectory();
        this.packageName.getDocument().addDocumentListener(this);
        em.addPropertyChangeListener(this);
        this.fireStateChanged();
        return exact;
    }

    private boolean setTargetFolder(String f) {
        Node[] nodeArray;
        Node n = null;
        NodeNotFoundException closest = null;
        HashSet<Node> selected = new HashSet<Node>(Arrays.asList(this.packagesPanel.getExplorerManager().getSelectedNodes()));
        FileSystem fsystem = (FileSystem)this.system.get();
        Node fsNode = null;
        if (this.systemSelected && fsystem != null) {
            fsNode = NodeOp.findChild(this.rootNode, fsystem.getSystemName());
        }
        if (fsNode != null) {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = fsNode;
        } else {
            nodeArray = this.rootNode.getChildren().getNodes();
        }
        Node[] arr = nodeArray;
        int i = 0;
        while (i < arr.length) {
            Node root = arr[i];
            StringTokenizer st = new StringTokenizer(f, ".");
            try {
                n = NodeOp.findPath(root, st);
                break;
            }
            catch (NodeNotFoundException ex) {
                if (!st.hasMoreElements()) {
                    String sugg = TemplateWizard2.computeSuggestion(ex.getClosestNode(), ex.getMissingChildName(), null);
                    if (closest == null || selected.contains(root) && sugg != null) {
                        closest = ex;
                    }
                }
                ++i;
            }
        }
        if (n != null) {
            closest = null;
        } else {
            if (closest == null) {
                return false;
            }
            n = closest.getClosestNode();
        }
        ExplorerManager em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener(this);
        if (closest != null) {
            Node[] first = new Node[1];
            String sugg = TemplateWizard2.computeSuggestion(closest.getClosestNode(), closest.getMissingChildName(), first);
            if (sugg != null) {
                this.packageName.getDocument().removeDocumentListener(this);
                this.packageName.setText(f + sugg);
                this.updateDirectory();
                Caret c = this.packageName.getCaret();
                c.setDot(f.length() + sugg.length());
                c.moveDot(f.length());
                this.packageName.getDocument().addDocumentListener(this);
            }
            if (first[0] != null) {
                n = first[0];
            }
        }
        try {
            em.setSelectedNodes(new Node[]{n});
            this.beanTreeView.expandNode(n);
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        DataFolder df = (DataFolder)n.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (df != null) {
            try {
                FileSystem fs = df.getPrimaryFile().getFileSystem();
                this.system = new WeakReference<FileSystem>(fs);
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        em.addPropertyChangeListener(this);
        this.fireStateChanged();
        return closest == null;
    }

    private void setClassName(String name) {
        String n = name;
        if (name == null || name.length() == 0) {
            n = TemplateWizard2.defaultClassName();
        }
        this.className.getDocument().removeDocumentListener(this);
        this.className.setText(n);
        this.className.getDocument().addDocumentListener(this);
        if (name == null || name.length() == 0) {
            this.className.selectAll();
        }
    }

    private static String defaultPackageName(FileSystem fs) {
        if (defaultPackageName == null) {
            defaultPackageName = new MessageFormat(DataObject.getString("FMT_TemplateDefaultPackageName"));
        }
        String n = fs == null ? "" : fs.getDisplayName();
        return defaultPackageName.format(new Object[]{n});
    }

    private static String defaultClassName() {
        return DataObject.getString("FMT_TemplateDefaultClassName");
    }

    private void updateDirectory() {
        String name;
        StringBuffer sb = new StringBuffer();
        FileSystem fs = (FileSystem)this.system.get();
        if (fs != null) {
            sb.append(fs.getDisplayName());
        }
        if ((name = this.packageName.getText()).equals(TemplateWizard2.defaultPackageName(fs))) {
            name = "";
        }
        if (name.length() > 0) {
            sb.append(File.separatorChar);
            sb.append(name.replace('.', File.separatorChar));
        }
        this.directoryName.setText(sb.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ExCh
    extends FilterNode.Children {
        public ExCh(Node or) {
            super(or);
        }

        protected void addNotify() {
            this.updateKeys();
        }

        protected void filterChildrenRemoved(NodeMemberEvent ev) {
            this.updateKeys();
        }

        protected void filterChildrenReordered(NodeReorderEvent ev) {
            this.updateKeys();
        }

        protected Node[] createNodes(Object key) {
            if (key == this) {
                FileSystem fs = (FileSystem)TemplateWizard2.this.system.get();
                if (fs != null && fs.isHidden()) {
                    try {
                        DataFolder df = DataFolder.findFolder(fs.getRoot());
                        Children ch = df.createNodeChildren(TemplateWizard2.this);
                        class NoSynchBeanNode
                        extends BeanNode {
                            private final /* synthetic */ ExCh this$1;

                            public NoSynchBeanNode(ExCh this$1, Object bean, Children kids) throws IntrospectionException {
                                super(bean, kids);
                                this.this$1 = this$1;
                                this.setSynchronizeName(false);
                            }
                        }
                        NoSynchBeanNode bn = new NoSynchBeanNode(this, fs, ch);
                        ((Node)bn).setName(fs.getSystemName());
                        bn.setDisplayName(fs.getDisplayName());
                        return new Node[]{bn};
                    }
                    catch (IntrospectionException ex) {
                        ErrorManager.getDefault().notify(ex);
                    }
                }
                return new Node[0];
            }
            return super.createNodes(key);
        }

        protected void filterChildrenAdded(NodeMemberEvent ev) {
            this.updateKeys();
        }

        private void updateKeys() {
            Node[] arr = this.original.getChildren().getNodes();
            ArrayList<Object> al = new ArrayList<Object>(arr.length + 1);
            al.add(this);
            int i = 0;
            while (i < arr.length) {
                al.add(arr[i].cloneNode());
                ++i;
            }
            this.setKeys(al);
        }
    }
}

