/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.modules.IllegalModuleException;
import org.openide.modules.ManifestSection;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public final class ModuleDescription {
    private static final boolean VERBOSE;
    public static final Attributes.Name TAG_MAGIC;
    public static final Attributes.Name TAG_NAME;
    public static final Attributes.Name TAG_SHORT_DESCRIPTION;
    public static final Attributes.Name TAG_LONG_DESCRIPTION;
    public static final Attributes.Name TAG_CATEGORY;
    private static final Comparator codeNameComparator;
    public static final Attributes.Name TAG_SPEC_VERSION;
    public static final Attributes.Name TAG_IMPL_VERSION;
    public static final Attributes.Name TAG_MODULE_DEPENDENCIES;
    public static final Attributes.Name TAG_PACKAGE_DEPENDENCIES;
    public static final Attributes.Name TAG_JAVA_DEPENDENCIES;
    public static final Attributes.Name TAG_IDE_DEPENDENCIES;
    public static final Attributes.Name TAG_MAIN;
    public static final Attributes.Name TAG_LAYER;
    public static final Attributes.Name TAG_DESCRIPTION;
    public static final Attributes.Name TAG_SECTION_CLASS;
    public static final String SECTION_ACTION = "Action";
    public static final String SECTION_OPTION = "Option";
    public static final String SECTION_LOADER = "Loader";
    public static final Attributes.Name TAG_INSTALL_BEFORE;
    public static final Attributes.Name TAG_INSTALL_AFTER;
    public static final String SECTION_FILESYSTEM = "Filesystem";
    public static final Attributes.Name TAG_FILESYSTEM_NAME;
    public static final Attributes.Name TAG_FILESYSTEM_HELP;
    public static final String SECTION_SERVICE = "Service";
    public static final Attributes.Name TAG_SERVICE_DEFAULT;
    public static final String SECTION_DEBUGGER = "Debugger";
    public static final String SECTION_NODE = "Node";
    public static final Attributes.Name TAG_NODE_TYPE;
    public static final String SECTION_CLIPBOARD_CONVERTOR = "ClipboardConvertor";
    ClassLoader cl;
    private String moduleName;
    private String codeName;
    private String shortDescription;
    private String longDescription;
    private String displayCategory;
    private String mainClass;
    private boolean mainClassSer;
    private ModuleInstall main;
    private String layerResource;
    private URL layer;
    private String specVersion;
    private String implVersion;
    private Set dependenciesSet;
    private String description;
    private ManifestSection[] sections;
    private static ResourceBundle bundle;
    final Set badClasses = new HashSet();
    private static final ModuleInstall MODULE_NONE;
    static /* synthetic */ Class class$org$openide$modules$ModuleDescription;

    public ModuleDescription(String name, Manifest man) throws IllegalModuleException {
        this(name, man, TopManager.getDefault().currentClassLoader());
    }

    public ModuleDescription(String name, Manifest man, ClassLoader cl) throws IllegalModuleException {
        this.setClassLoader(cl);
        this.createDescription(name, man);
        if (VERBOSE) {
            System.err.println("Making module description for " + this);
            Enumeration en = this.dependencies();
            while (en.hasMoreElements()) {
                System.err.println("\t=>" + (Dependency)en.nextElement());
            }
        }
    }

    public ModuleDescription(File jar) throws IllegalModuleException, IOException {
        this(jar.getPath(), new Manifest(new FileInputStream(jar)), new URLClassLoader(new URL[]{jar.getCanonicalFile().toURL()}, TopManager.getDefault().currentClassLoader()));
    }

    public ModuleDescription(String text) throws IllegalModuleException, IOException {
        this("/no/path/to/testManifest.mf", new Manifest(new ByteArrayInputStream(text.getBytes())));
    }

    public String getName() {
        return this.moduleName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getDisplayCategory() {
        return this.displayCategory;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        int slash = this.codeName.indexOf("/");
        if (slash == -1) {
            return this.codeName;
        }
        return this.codeName.substring(0, slash);
    }

    public int getCodeNameRelease() {
        int slash = this.codeName.indexOf("/");
        if (slash == -1) {
            return -1;
        }
        return Integer.parseInt(this.codeName.substring(slash + 1));
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public synchronized void setClassLoader(ClassLoader cl) {
        if (this.cl != null && cl == null) {
            this.main = null;
            this.layer = null;
            this.badClasses.clear();
            int i = 0;
            while (i < this.sections.length) {
                this.sections[i].release();
                ++i;
            }
        }
        this.cl = cl;
        if (VERBOSE) {
            this.showLoader();
        }
    }

    public Set getBadClasses() {
        return Collections.unmodifiableSet(this.badClasses);
    }

    public synchronized ModuleInstall getModule() {
        try {
            if (this.mainClass != null) {
                this.main = this.mainClassSer ? (ModuleInstall)Beans.instantiate(this.cl, this.mainClass) : (ModuleInstall)SharedClassObject.findObject(Class.forName(this.mainClass, true, this.cl), true);
                if (!this.mainClassSer && this.main.getClass().getClassLoader() != this.cl) {
                    this.badClasses.add(this.main.getClass());
                }
            }
            this.mainClass = null;
        }
        catch (Exception ex) {
            if (ex instanceof ClassNotFoundException) {
                this.showLoader();
            }
            TopManager.getDefault().notifyException(ex);
        }
        if (this.main == null) {
            this.main = MODULE_NONE;
        }
        return this.main;
    }

    void showLoader() {
        if (!Boolean.getBoolean("netbeans.debug.exceptions")) {
            return;
        }
        System.err.println("Offending classloader: " + this.cl);
        ModuleDescription.showLoader0(this.cl);
    }

    private static void showLoader0(ClassLoader cl) {
        if (cl != null) {
            ModuleDescription.showLoader0(cl.getParent());
            if (cl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)cl).getURLs();
                int i = 0;
                while (i < urls.length) {
                    System.err.println("\t" + urls[i]);
                    ++i;
                }
            }
        }
    }

    public synchronized URL getLayer() {
        if (this.layerResource != null) {
            try {
                int idx = this.layerResource.lastIndexOf(46);
                if (idx == -1) {
                    throw new MalformedURLException();
                }
                String base = this.layerResource.substring(0, idx).replace('/', '.');
                String ext = this.layerResource.substring(idx + 1);
                this.layer = NbBundle.getLocalizedFile(base, ext, Locale.getDefault(), this.cl);
            }
            catch (Exception e) {
                TopManager.getDefault().notifyException(e);
            }
            this.layerResource = null;
        }
        return this.layer;
    }

    public String getLayerResource() {
        return this.layerResource;
    }

    public URL getDescription() {
        if (this.description == null) {
            return null;
        }
        ErrorManager em = ErrorManager.getDefault();
        if (this.cl == null) {
            throw (IllegalStateException)em.annotate((Throwable)new IllegalStateException(), new NullPointerException());
        }
        try {
            return NbBundle.getLocalizedFile(this.description, "hs", Locale.getDefault(), this.cl);
        }
        catch (MissingResourceException mre) {
            IllegalStateException ise = new IllegalStateException();
            throw (IllegalStateException)em.annotate((Throwable)ise, mre);
        }
    }

    public String getDescriptionResource() {
        if (this.description == null) {
            return null;
        }
        return this.description.replace('.', '/') + ".hs";
    }

    public synchronized void forEachSection(ManifestSection.Iterator it) {
        int s = this.sections.length;
        LinkedList<ManifestSection> al = new LinkedList<ManifestSection>();
        int i = 0;
        while (i < s) {
            try {
                this.sections[i].invokeIterator(it);
                al.add(this.sections[i]);
            }
            catch (Exception ex) {
                TopManager.getDefault().notifyException(ex);
            }
            ++i;
        }
        if (this.sections.length > al.size()) {
            this.sections = al.toArray(new ManifestSection[al.size()]);
        }
    }

    public Enumeration dependencies() {
        return Collections.enumeration(this.dependenciesSet);
    }

    public Dependency[] getDependencies() {
        return this.dependenciesSet.toArray(new Dependency[0]);
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public String reasonWhyUnsatisfied(ModuleDescription[] otherModules) throws IllegalModuleException {
        if (VERBOSE) {
            System.err.println("Checking all dependencies for " + this);
        }
        String reason = null;
        Iterator it = this.dependenciesSet.iterator();
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            String miss = dep.checkForMiss(otherModules);
            if (miss == null) continue;
            reason = reason == null ? ModuleDescription.getStringFormatted("MSG_Why_Dep_Failed", this.getName(), this.getCodeName()) + miss : reason + "\n" + miss;
        }
        return reason;
    }

    public boolean dependsOnModule(ModuleDescription other) {
        if (this == other || this.codeName.equals(other.codeName)) {
            return true;
        }
        Iterator it = this.dependenciesSet.iterator();
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            if (dep.getType() != 1 || !dep.getName().equals(other.getCodeName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ModuleDescription.getStringFormatted("DBG_Module_ToString", this.getCodeName(), this.getName());
    }

    public static List resolveOrdering(Set modules) throws IllegalModuleException {
        if (VERBOSE) {
            System.err.println("Incoming module list: ");
            Iterator it0 = modules.iterator();
            while (it0.hasNext()) {
                System.err.println("\t" + (ModuleDescription)it0.next());
            }
        }
        HashMap crossdeps = new HashMap();
        Iterator it1 = modules.iterator();
        while (it1.hasNext()) {
            ModuleDescription md = (ModuleDescription)it1.next();
            HashSet<ModuleDescription> thisdeps = new HashSet<ModuleDescription>();
            Iterator it2 = modules.iterator();
            while (it2.hasNext()) {
                ModuleDescription other = (ModuleDescription)it2.next();
                if (md == other || !md.dependsOnModule(other)) continue;
                thisdeps.add(other);
            }
            crossdeps.put(md, thisdeps);
        }
        TreeSet sorted = new TreeSet(codeNameComparator);
        sorted.addAll(modules);
        if (sorted.size() != modules.size()) {
            ModuleDescription.throwOverlapException(modules, sorted);
        }
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        block3: while (sorted.size() > 0) {
            Iterator it3 = sorted.iterator();
            while (it3.hasNext()) {
                ModuleDescription test = (ModuleDescription)it3.next();
                Set remainingDeps = (Set)crossdeps.get(test);
                if (remainingDeps.size() != 0) continue;
                result.add(test);
                it3.remove();
                Iterator it4 = sorted.iterator();
                while (it4.hasNext()) {
                    ModuleDescription othermod = (ModuleDescription)it4.next();
                    if (othermod == test) {
                        throw new IllegalModuleException("Should not happen.");
                    }
                    Set otherdeps = (Set)crossdeps.get(othermod);
                    otherdeps.remove(test);
                }
                continue block3;
            }
            Iterator it5 = sorted.iterator();
            boolean first = true;
            StringBuffer buf = new StringBuffer();
            while (it5.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buf.append("; ");
                }
                ModuleDescription bad = (ModuleDescription)it5.next();
                buf.append(bad.getName());
                buf.append(" (=> ");
                boolean firstagain = true;
                Iterator it6 = ((Set)crossdeps.get(bad)).iterator();
                while (it6.hasNext()) {
                    if (firstagain) {
                        firstagain = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(((ModuleDescription)it6.next()).getName());
                }
                buf.append(")");
            }
            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Cyclic", buf.toString()));
        }
        if (VERBOSE) {
            System.err.println("Outgoing module list: ");
            Iterator hookah2 = result.iterator();
            while (hookah2.hasNext()) {
                System.err.println("\t" + (ModuleDescription)hookah2.next());
            }
        }
        return result;
    }

    private static void throwOverlapException(Set incoming, SortedSet checked) throws IllegalModuleException {
        StringBuffer overlaps = new StringBuffer();
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        Iterator it = incoming.iterator();
        while (it.hasNext()) {
            ModuleDescription md = (ModuleDescription)it.next();
            String cn = md.getCodeName();
            Integer count = (Integer)occurrences.get(cn);
            if (count == null) {
                occurrences.put(cn, new Integer(1));
                continue;
            }
            occurrences.put(cn, new Integer(count + 1));
        }
        boolean firstOverlap = true;
        Iterator it2 = occurrences.keySet().iterator();
        while (it2.hasNext()) {
            String codeName = (String)it2.next();
            Integer count2 = (Integer)occurrences.get(codeName);
            if (count2 <= 1) continue;
            if (firstOverlap) {
                firstOverlap = false;
            } else {
                overlaps.append(' ');
            }
            overlaps.append(codeName);
            overlaps.append('(');
            overlaps.append(count2.toString());
            overlaps.append(')');
        }
        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Overlapping_Code_Names", String.valueOf(checked.size()), String.valueOf(incoming.size() - checked.size()), TAG_MAGIC.toString(), overlaps.toString()));
    }

    public static List resolveOrderingForRealInstall(Set restored, Set installed) throws IllegalModuleException {
        int misscount;
        if (VERBOSE) {
            System.err.println("rOFRI called.");
        }
        TreeSet doubleCheck = new TreeSet(codeNameComparator);
        doubleCheck.addAll(restored);
        doubleCheck.addAll(installed);
        int actual = doubleCheck.size();
        int presumed = restored.size() + installed.size();
        if (actual != presumed) {
            HashSet combined = new HashSet();
            combined.addAll(restored);
            combined.addAll(installed);
            ModuleDescription.throwOverlapException(combined, doubleCheck);
        }
        ArrayList<String> missed = new ArrayList<String>();
        HashSet actual2 = new HashSet();
        actual2.addAll(installed);
        do {
            misscount = 0;
            Iterator it = actual2.iterator();
            while (it.hasNext()) {
                ModuleDescription test = (ModuleDescription)it.next();
                HashSet whatCanIStillUse = new HashSet();
                whatCanIStillUse.addAll(restored);
                whatCanIStillUse.addAll(actual2);
                String miss = test.reasonWhyUnsatisfied(whatCanIStillUse.toArray(new ModuleDescription[0]));
                if (miss == null) continue;
                ++misscount;
                it.remove();
                missed.add(miss);
            }
        } while (misscount > 0);
        return ModuleDescription.resolveOrdering(actual2);
    }

    public static boolean compatibleWith(String older, String newer) throws IllegalModuleException {
        if (older == null || newer == null) {
            return false;
        }
        StringTokenizer oldTok = new StringTokenizer(older, ".");
        StringTokenizer newTok = new StringTokenizer(newer, ".");
        while (oldTok.hasMoreTokens() || newTok.hasMoreTokens()) {
            if (!newTok.hasMoreTokens()) {
                return false;
            }
            if (!oldTok.hasMoreTokens()) {
                return true;
            }
            String oldElt = oldTok.nextToken();
            String newElt = newTok.nextToken();
            int oldNum = 0;
            int newNum = 0;
            try {
                oldNum = Integer.parseInt(oldElt);
                newNum = Integer.parseInt(newElt);
            }
            catch (NumberFormatException e) {
                IllegalModuleException ime = new IllegalModuleException(older + "<" + newer + "?");
                ErrorManager.getDefault().annotate((Throwable)ime, e);
                throw ime;
            }
            if (oldNum < 0 || newNum < 0) {
                return false;
            }
            if (oldNum < newNum) {
                return true;
            }
            if (oldNum <= newNum) continue;
            return false;
        }
        return true;
    }

    static void checkCodeName(String codeName, boolean slashOK) throws IllegalModuleException {
        ModuleDescription.checkCodeName("", codeName, slashOK);
    }

    static void checkCodeName(String moduleName, String codeName, boolean slashOK) throws IllegalModuleException {
        int release;
        String base;
        int slash = codeName.indexOf("/");
        if (slash == -1) {
            base = codeName;
            release = -1;
        } else {
            if (!slashOK) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_slash_not_permitted", codeName, moduleName));
            }
            base = codeName.substring(0, slash);
            try {
                release = Integer.parseInt(codeName.substring(slash + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Non_Numeric_Release", codeName, moduleName));
            }
        }
        int ch = 0;
        while (ch < base.length()) {
            char c = base.charAt(ch);
            if (!Character.isJavaIdentifierPart(c) && c != '.') {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Char_In_Code_Name", codeName, moduleName));
            }
            ++ch;
        }
    }

    static void checkSpec(String spec) throws IllegalModuleException {
        StringTokenizer tok = new StringTokenizer(spec, ".", true);
        if (tok.countTokens() % 2 == 0) {
            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", spec));
        }
        int i = 0;
        while (tok.hasMoreTokens()) {
            block7: {
                String piece = tok.nextToken();
                if (i % 2 == 0) {
                    try {
                        int x = Integer.parseInt(piece);
                        if (x < 0) {
                            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", spec));
                        }
                        break block7;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", spec));
                    }
                }
                if (!".".equals(piece)) {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", spec));
                }
            }
            ++i;
        }
    }

    private void createDescription(String name, Manifest man) throws IllegalModuleException {
        Attributes attr = man.getMainAttributes();
        this.codeName = attr.getValue(TAG_MAGIC);
        if (this.codeName == null) {
            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Not_A_Module", TAG_MAGIC.toString(), name));
        }
        ModuleDescription.checkCodeName(name, this.codeName, true);
        this.moduleName = NbBundle.getLocalizedValue(attr, TAG_NAME);
        if (this.moduleName == null) {
            String str = name;
            int from = str.lastIndexOf(47);
            int till = str.lastIndexOf(46);
            this.moduleName = str.substring(from == -1 ? 0 : from + 1, till == -1 ? str.length() : till);
        }
        this.shortDescription = NbBundle.getLocalizedValue(attr, TAG_SHORT_DESCRIPTION);
        this.longDescription = NbBundle.getLocalizedValue(attr, TAG_LONG_DESCRIPTION);
        this.displayCategory = NbBundle.getLocalizedValue(attr, TAG_CATEGORY);
        this.specVersion = attr.getValue(TAG_SPEC_VERSION);
        if (this.specVersion != null) {
            ModuleDescription.checkSpec(this.specVersion);
        }
        this.implVersion = attr.getValue(TAG_IMPL_VERSION);
        this.dependenciesSet = new HashSet();
        this.parseDependencies(1, attr.getValue(TAG_MODULE_DEPENDENCIES), this.dependenciesSet);
        this.parseDependencies(2, attr.getValue(TAG_PACKAGE_DEPENDENCIES), this.dependenciesSet);
        this.parseDependencies(3, attr.getValue(TAG_JAVA_DEPENDENCIES), this.dependenciesSet);
        this.parseDependencies(4, attr.getValue(TAG_IDE_DEPENDENCIES), this.dependenciesSet);
        this.mainClass = attr.getValue(TAG_MAIN);
        if (this.mainClass != null) {
            this.mainClassSer = this.mainClass.endsWith(".ser");
            this.mainClass = ModuleDescription.createPackageName(this.mainClass);
        }
        this.layerResource = attr.getValue(TAG_LAYER);
        this.description = attr.getValue(TAG_DESCRIPTION);
        Iterator<Map.Entry<String, Attributes>> en = man.getEntries().entrySet().iterator();
        ArrayList<ManifestSection> v = new ArrayList<ManifestSection>();
        while (en.hasNext()) {
            Map.Entry<String, Attributes> entry = en.next();
            ManifestSection s = ManifestSection.createSection(entry.getKey(), entry.getValue(), this);
            if (s == null) continue;
            v.add(s);
        }
        this.sections = new ManifestSection[v.size()];
        v.toArray(this.sections);
    }

    /*
     * Unable to fully structure code
     */
    private void parseDependencies(int type, String body, Set deps) throws IllegalModuleException {
        if (body == null) {
            return;
        }
        tok = new StringTokenizer(body, ",");
        if (tok.hasMoreTokens()) ** GOTO lbl30
        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_No_Deps_Given", body));
lbl-1000:
        // 1 sources

        {
            onedep = tok.nextToken();
            tok2 = new StringTokenizer(onedep, " \t\n\r");
            if (!tok2.hasMoreTokens()) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_No_Name_In_Dep", onedep));
            }
            name = tok2.nextToken();
            if (tok2.hasMoreTokens()) {
                compthing = tok2.nextToken();
                if (compthing.equals(">")) {
                    comparison = 1;
                } else if (compthing.equals("=")) {
                    comparison = 2;
                } else {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Unrec_Comp_Str", compthing));
                }
                if (!tok2.hasMoreTokens()) {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Comp_Str_Without_Vers", onedep));
                }
                version = tok2.nextToken();
                if (tok2.hasMoreTokens()) {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Garbage", onedep));
                }
            } else {
                comparison = 3;
                version = null;
            }
            deps.add(new Dependency(type, name, comparison, version, this));
lbl30:
            // 2 sources

            ** while (tok.hasMoreTokens())
        }
lbl31:
        // 1 sources

    }

    static String createPackageName(String name) throws IllegalModuleException {
        String clExt = ".class";
        if (!name.endsWith(clExt)) {
            clExt = ".ser";
        }
        if (name.endsWith(clExt)) {
            String bareName = name.substring(0, name.length() - clExt.length());
            if (bareName.length() == 0) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", name));
            }
            if (bareName.charAt(0) == '/') {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", name));
            }
            if (bareName.charAt(bareName.length() - 1) == '/') {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", name));
            }
            if (bareName.indexOf(46) != -1) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", name));
            }
            return bareName.replace('/', '.');
        }
        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", name));
    }

    static String getStringFormatted(String key, Object[] args) {
        return NbBundle.getMessage(class$org$openide$modules$ModuleDescription == null ? (class$org$openide$modules$ModuleDescription = ModuleDescription.class$("org.openide.modules.ModuleDescription")) : class$org$openide$modules$ModuleDescription, key, args);
    }

    static String getStringFormatted(String key, String arg1) {
        return NbBundle.getMessage(class$org$openide$modules$ModuleDescription == null ? (class$org$openide$modules$ModuleDescription = ModuleDescription.class$("org.openide.modules.ModuleDescription")) : class$org$openide$modules$ModuleDescription, key, arg1);
    }

    static String getStringFormatted(String key, String arg1, String arg2) {
        return NbBundle.getMessage(class$org$openide$modules$ModuleDescription == null ? (class$org$openide$modules$ModuleDescription = ModuleDescription.class$("org.openide.modules.ModuleDescription")) : class$org$openide$modules$ModuleDescription, key, arg1, arg2);
    }

    static String getStringFormatted(String key, String arg1, String arg2, String arg3) {
        return NbBundle.getMessage(class$org$openide$modules$ModuleDescription == null ? (class$org$openide$modules$ModuleDescription = ModuleDescription.class$("org.openide.modules.ModuleDescription")) : class$org$openide$modules$ModuleDescription, key, arg1, arg2, arg3);
    }

    static String getStringFormatted(String key, String arg1, String arg2, String arg3, String arg4) {
        return ModuleDescription.getStringFormatted(key, new Object[]{arg1, arg2, arg3, arg4});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            System.err.println("WARNING: use of deprecated class org.openide.modules.ModuleDescription");
            Thread.dumpStack();
        }
        VERBOSE = Boolean.getBoolean("org.openide.modules.ModuleDescription.VERBOSE");
        TAG_MAGIC = new Attributes.Name("OpenIDE-Module");
        TAG_NAME = new Attributes.Name("OpenIDE-Module-Name");
        TAG_SHORT_DESCRIPTION = new Attributes.Name("OpenIDE-Module-Short-Description");
        TAG_LONG_DESCRIPTION = new Attributes.Name("OpenIDE-Module-Long-Description");
        TAG_CATEGORY = new Attributes.Name("OpenIDE-Module-Display-Category");
        codeNameComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                ModuleDescription md1 = (ModuleDescription)o1;
                ModuleDescription md2 = (ModuleDescription)o2;
                return md1.getCodeName().compareTo(md2.getCodeName());
            }
        };
        TAG_SPEC_VERSION = new Attributes.Name("OpenIDE-Module-Specification-Version");
        TAG_IMPL_VERSION = new Attributes.Name("OpenIDE-Module-Implementation-Version");
        TAG_MODULE_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-Module-Dependencies");
        TAG_PACKAGE_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-Package-Dependencies");
        TAG_JAVA_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-Java-Dependencies");
        TAG_IDE_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-IDE-Dependencies");
        TAG_MAIN = new Attributes.Name("OpenIDE-Module-Install");
        TAG_LAYER = new Attributes.Name("OpenIDE-Module-Layer");
        TAG_DESCRIPTION = new Attributes.Name("OpenIDE-Module-Description");
        TAG_SECTION_CLASS = new Attributes.Name("OpenIDE-Module-Class");
        TAG_INSTALL_BEFORE = new Attributes.Name("Install-Before");
        TAG_INSTALL_AFTER = new Attributes.Name("Install-After");
        TAG_FILESYSTEM_NAME = new Attributes.Name("Display-Name");
        TAG_FILESYSTEM_HELP = new Attributes.Name("Help");
        TAG_SERVICE_DEFAULT = new Attributes.Name("Default");
        TAG_NODE_TYPE = new Attributes.Name("Type");
        MODULE_NONE = new ModuleInstall();
    }

    public static interface PackageAccessibleClassLoader {
        public Package getPackageAccessibly(String var1);

        public Package[] getPackagesAccessibly();
    }

    public static final class Dependency {
        public static final int TYPE_MODULE = 1;
        public static final int TYPE_PACKAGE = 2;
        public static final int TYPE_JAVA = 3;
        public static final int TYPE_IDE = 4;
        private int type;
        private String name;
        public static final int COMPARE_SPEC = 1;
        public static final int COMPARE_IMPL = 2;
        public static final int COMPARE_ANY = 3;
        private int comparison;
        private String version;
        private ModuleDescription desc;

        Dependency(int type, String name, int comparison, String version, ModuleDescription desc) throws IllegalModuleException {
            this.type = type;
            this.name = name;
            this.comparison = comparison;
            this.version = version;
            this.desc = desc;
            if (comparison == 1) {
                ModuleDescription.checkSpec(version);
            }
            switch (type) {
                case 1: {
                    ModuleDescription.checkCodeName(name, true);
                    break;
                }
                case 2: {
                    int idx = name.indexOf(91);
                    if (idx != -1) {
                        if (idx > 0) {
                            ModuleDescription.checkCodeName(name.substring(0, idx), false);
                        }
                        if (name.charAt(name.length() - 1) != ']') {
                            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_pkg_dep_not_close_bracket", this.toString()));
                        }
                        ModuleDescription.checkCodeName(name.substring(idx + 1, name.length() - 1), false);
                        break;
                    }
                    ModuleDescription.checkCodeName(name, false);
                    break;
                }
                case 3: {
                    if (name.equals("Java") || name.equals("VM")) break;
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Java_Dep", this.toString()));
                }
                case 4: {
                    if (!name.equals("IDE")) {
                        boolean ok;
                        int slash = name.indexOf("/");
                        if (slash == -1) {
                            ok = false;
                        } else {
                            try {
                                Integer.parseInt(name.substring(slash + 1));
                                ok = true;
                            }
                            catch (NumberFormatException e) {
                                ok = false;
                            }
                        }
                        if (!ok) {
                            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_IDE_Dep", this.toString()));
                        }
                    }
                    if (comparison != 3) break;
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_IDE_Dep_Uncompared", this.toString()));
                }
                default: {
                    throw new IllegalModuleException("unknown type");
                }
            }
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getComparison() {
            return this.comparison;
        }

        public String getVersion() {
            return this.version;
        }

        /*
         * Unable to fully structure code
         */
        public String checkForMiss(ModuleDescription[] otherModules) throws IllegalModuleException {
            switch (this.type) {
                case 1: {
                    i = 0;
                    while (i < otherModules.length) {
                        other = otherModules[i];
                        if (this.name.equals(other.getCodeName())) {
                            if (this.comparison == 3) {
                                return null;
                            }
                            if (this.comparison == 1) {
                                if (other.getSpecVersion() == null) {
                                    return ModuleDescription.getStringFormatted("MSG_Module_Spec_None", other.getName());
                                }
                                if (!ModuleDescription.compatibleWith(this.version, other.getSpecVersion())) {
                                    return ModuleDescription.getStringFormatted("MSG_Module_Spec_Bad", other.getName(), other.getSpecVersion(), this.version);
                                }
                                return null;
                            }
                            if (other.getImplVersion() == null) {
                                return ModuleDescription.getStringFormatted("MSG_Module_Impl_None", other.getName());
                            }
                            if (!other.getImplVersion().equals(this.version)) {
                                return ModuleDescription.getStringFormatted("MSG_Module_Impl_Bad", other.getName(), other.getImplVersion(), this.version);
                            }
                            return null;
                        }
                        ++i;
                    }
                    return ModuleDescription.getStringFormatted("MSG_Module_None", this.name);
                }
                case 2: {
                    if (!(this.desc.cl instanceof PackageAccessibleClassLoader)) {
                        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_not_package_accessible", this.desc.cl.getClass().getName()));
                    }
                    idx = this.name.indexOf(91);
                    if (idx == -1) {
                        packageName = this.name;
                        sampleName = null;
                    } else if (idx == 0) {
                        packageName = null;
                        sampleName = this.name.substring(1, this.name.length() - 1);
                    } else {
                        packageName = this.name.substring(0, idx);
                        sampleName = this.name.substring(idx + 1, this.name.length() - 1);
                        if (sampleName.indexOf(46) == -1) {
                            sampleName = packageName + '.' + sampleName;
                        }
                    }
                    if (sampleName == null) ** GOTO lbl47
                    try {
                        this.desc.cl.loadClass(sampleName);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (packageName != null) ** GOTO lbl47
                        return ModuleDescription.getStringFormatted("MSG_pkg_sample_not_found", sampleName);
                    }
lbl47:
                    // 3 sources

                    if (packageName != null) {
                        pkg = ((PackageAccessibleClassLoader)this.desc.cl).getPackageAccessibly(packageName);
                        if (pkg == null) {
                            return ModuleDescription.getStringFormatted("MSG_Package_None", packageName);
                        }
                        if (this.comparison == 3) {
                            return null;
                        }
                        if (this.comparison == 1) {
                            if (pkg.getSpecificationVersion() == null) {
                                return ModuleDescription.getStringFormatted("MSG_Package_Spec_None", pkg.getName());
                            }
                            if (!ModuleDescription.compatibleWith(this.version, pkg.getSpecificationVersion().trim())) {
                                return ModuleDescription.getStringFormatted("MSG_Package_Spec_Bad", pkg.getName(), pkg.getSpecificationVersion(), this.version);
                            }
                            return null;
                        }
                        if (pkg.getImplementationVersion() == null) {
                            return ModuleDescription.getStringFormatted("MSG_Package_Impl_None", pkg.getName());
                        }
                        if (!pkg.getImplementationVersion().trim().equals(this.version)) {
                            return ModuleDescription.getStringFormatted("MSG_Package_Impl_Bad", pkg.getName(), pkg.getImplementationVersion(), this.version);
                        }
                        return null;
                    }
                    return null;
                }
                case 3: {
                    if (this.name.equals("Java")) {
                        if (this.comparison == 1) {
                            return ModuleDescription.compatibleWith(this.version, System.getProperty("java.specification.version")) != false ? null : ModuleDescription.getStringFormatted("MSG_Java_Spec", this.version);
                        }
                        return System.getProperty("java.version").equals(this.version) != false ? null : ModuleDescription.getStringFormatted("MSG_Java_Impl", this.version);
                    }
                    if (this.comparison == 1) {
                        return ModuleDescription.compatibleWith(this.version, System.getProperty("java.vm.specification.version")) != false ? null : ModuleDescription.getStringFormatted("MSG_VM_Spec", this.version);
                    }
                    return System.getProperty("java.vm.version").equals(this.version) != false ? null : ModuleDescription.getStringFormatted("MSG_VM_Impl", this.version);
                }
                case 4: {
                    IDEName = System.getProperty("org.openide.major.version", "IDE");
                    IDESpecVersion = System.getProperty("org.openide.specification.version", "0.0");
                    IDEImplVersion = System.getProperty("org.openide.version", "<unknown>");
                    if (!IDEName.equals(this.name)) {
                        return ModuleDescription.getStringFormatted("MSG_IDE_Name", this.name, IDEName);
                    }
                    if (this.comparison == 1) {
                        return ModuleDescription.compatibleWith(this.version, IDESpecVersion) != false ? null : ModuleDescription.getStringFormatted("MSG_IDE_Spec", this.version, IDESpecVersion);
                    }
                    if (this.comparison == 2) {
                        return this.version.equals(IDEImplVersion) != false ? null : ModuleDescription.getStringFormatted("MSG_IDE_Impl", this.version, IDEImplVersion);
                    }
                    return null;
                }
            }
            throw new IllegalModuleException("should never happen");
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Dependency)) {
                return false;
            }
            Dependency oo = (Dependency)o;
            return this.type == oo.type && this.name.equals(oo.name) && this.comparison == oo.comparison && (this.version == null && oo.version == null || this.version != null && oo.version != null && this.version.equals(oo.version));
        }

        public int hashCode() {
            return this.type * 57 ^ this.name.hashCode() ^ this.comparison * 231 ^ (this.version == null ? 111 : this.version.hashCode());
        }

        public String toString() {
            return ModuleDescription.getStringFormatted("DBG_Dependency_ToString", this.type == 1 ? "Module" : (this.type == 2 ? "Package" : (this.type == 3 ? "Java" : (this.type == 4 ? "IDE" : "???"))), this.name, this.comparison == 3 ? "" : ModuleDescription.getStringFormatted("DBG_Dependency_Comparison", this.comparison == 1 ? ">" : (this.comparison == 2 ? "=" : "???"), this.version));
        }
    }
}

