/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.openide.modules.SpecificationVersion;

public abstract class ModuleInfo {
    public static final String PROP_ENABLED = "enabled";
    private final Set listeners = new HashSet(5);

    protected ModuleInfo() {
    }

    public abstract String getCodeNameBase();

    public abstract int getCodeNameRelease();

    public abstract String getCodeName();

    public String getDisplayName() {
        String dn = (String)this.getLocalizedAttribute("OpenIDE-Module-Name");
        if (dn != null) {
            return dn;
        }
        return this.getCodeNameBase();
    }

    public abstract SpecificationVersion getSpecificationVersion();

    public String getImplementationVersion() {
        return (String)this.getAttribute("OpenIDE-Module-Implementation-Version");
    }

    public abstract boolean isEnabled();

    public abstract Object getAttribute(String var1);

    public abstract Object getLocalizedAttribute(String var1);

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new NullPointerException("If you see this stack trace, please attach to: http://www.netbeans.org/issues/show_bug.cgi?id=22379");
        }
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    protected final void firePropertyChange(String prop, Object old, Object nue) {
        PropertyChangeListener[] ls;
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ls = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        }
        PropertyChangeEvent ev = new PropertyChangeEvent(this, prop, old, nue);
        int i = 0;
        while (i < ls.length) {
            ls[i].propertyChange(ev);
            ++i;
        }
    }

    public abstract Set getDependencies();

    public abstract boolean owns(Class var1);

    public String[] getProvides() {
        return new String[0];
    }
}

