/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.openide.util.Utilities;

public final class SpecificationVersion
implements Comparable {
    private final int[] digits;

    public SpecificationVersion(String version) throws NumberFormatException {
        ArrayList<Integer> l = new ArrayList<Integer>(version.length());
        StringTokenizer tok = new StringTokenizer(version, ".", true);
        if (tok.countTokens() % 2 == 0) {
            throw new NumberFormatException("Even number of pieces in a spec version: `" + version + "'");
        }
        boolean expectingNumber = true;
        while (tok.hasMoreTokens()) {
            if (expectingNumber) {
                expectingNumber = false;
                int piece = Integer.parseInt(tok.nextToken());
                if (piece < 0) {
                    throw new NumberFormatException("Spec version component <0: " + piece);
                }
                l.add(new Integer(piece));
                continue;
            }
            if (!".".equals(tok.nextToken())) {
                throw new NumberFormatException("Expected dot in spec version: `" + version + "'");
            }
            expectingNumber = true;
        }
        int size = l.size();
        this.digits = new int[size];
        int i = 0;
        while (i < size) {
            this.digits[i] = (Integer)l.get(i);
            ++i;
        }
    }

    public int compareTo(Object o) {
        int[] od = ((SpecificationVersion)o).digits;
        int i = 0;
        while (i < Math.max(this.digits.length, od.length)) {
            int d2;
            int d1 = i < this.digits.length ? this.digits[i] : 0;
            int n = d2 = i < od.length ? od[i] : 0;
            if (d1 != d2) {
                return d1 - d2;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpecificationVersion)) {
            return false;
        }
        return Utilities.compareObjects(this.digits, ((SpecificationVersion)o).digits);
    }

    public int hashCode() {
        int hash = 925295;
        int i = 0;
        while (i < this.digits.length) {
            hash ^= this.digits[i] << i;
            ++i;
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.digits.length * 3 + 1);
        int i = 0;
        while (i < this.digits.length) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(this.digits[i]);
            ++i;
        }
        return buf.toString();
    }
}

