/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.DefaultHandle;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class AbstractNode
extends Node {
    private static final MessageFormat[] icons = new MessageFormat[]{new MessageFormat("{0}.gif"), new MessageFormat("{0}32.gif"), new MessageFormat("{0}.gif"), new MessageFormat("{0}32.gif"), new MessageFormat("{0}Open.gif"), new MessageFormat("{0}Open32.gif"), new MessageFormat("{0}Open.gif"), new MessageFormat("{0}Open32.gif")};
    private static final int ICON_BASE = -1;
    private static final int OPENED_ICON_BASE = 3;
    private static final PasteType[] NO_PASTE_TYPES = new PasteType[0];
    private static final NewType[] NO_NEW_TYPES = new NewType[0];
    private static final Node.PropertySet[] NO_PROPERTY_SETS = new Node.PropertySet[0];
    protected MessageFormat displayFormat;
    private static final String DEFAULT_ICON_BASE = "org/openide/resources/defaultNode";
    private static final String DEFAULT_ICON = "org/openide/resources/defaultNode.gif";
    private Object[] iconBase = new Object[]{"org/openide/resources/defaultNode"};
    private CookieSet cookieSet;
    private Sheet sheet;
    protected SystemAction[] systemActions;
    private SystemAction defaultAction;
    private SheetAndCookieListener sheetCookieL = null;

    public AbstractNode(Children children) {
        super(children);
        super.setName("");
    }

    public Node cloneNode() {
        try {
            if (this instanceof Cloneable) {
                return (Node)this.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return new FilterNode(this);
    }

    public void setName(String s) {
        super.setName(s);
        MessageFormat mf = this.displayFormat;
        if (mf != null) {
            this.setDisplayName(mf.format(new Object[]{s}));
        } else {
            this.fireDisplayNameChange(null, null);
        }
    }

    public void setIconBase(String base) {
        this.iconBase = new Object[]{base};
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Image getIcon(int type) {
        return this.findIcon(type, -1);
    }

    public Image getOpenedIcon(int type) {
        return this.findIcon(type, 3);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private Image findIcon(int type, int ib) {
        String res = icons[type + ib].format(this.iconBase);
        Image im = Utilities.loadImage(res);
        if (im != null) {
            return im;
        }
        res = icons[1 + ib].format(this.iconBase);
        im = Utilities.loadImage(res);
        if (im != null) {
            return im;
        }
        if (ib == 3) {
            return this.findIcon(type, -1);
        }
        return this.getDefaultIcon();
    }

    Image getDefaultIcon() {
        return Utilities.loadImage(DEFAULT_ICON);
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    protected final synchronized void setSheet(Sheet s) {
        this.setSheetImpl(s);
        this.firePropertySetsChange(null, null);
    }

    private synchronized void setSheetImpl(Sheet s) {
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if (this.sheet != null) {
            this.sheet.removePropertyChangeListener(this.sheetCookieL);
        }
        s.addPropertyChangeListener(this.sheetCookieL);
        this.sheet = s;
    }

    protected Sheet createSheet() {
        return new Sheet();
    }

    protected final synchronized Sheet getSheet() {
        if (this.sheet != null) {
            return this.sheet;
        }
        this.setSheetImpl(this.createSheet());
        return this.sheet;
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet s = this.getSheet();
        if (s == null) {
            return NO_PROPERTY_SETS;
        }
        return s.toArray();
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable(this, 1);
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable(this, 4);
    }

    public Transferable drag() throws IOException {
        return this.clipboardCopy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    protected void createPasteTypes(Transferable t, List s) {
        NodeTransfer.Paste p = NodeTransfer.findPaste(t);
        if (p != null) {
            s.addAll(Arrays.asList(p.types(this)));
        }
    }

    public final PasteType[] getPasteTypes(Transferable t) {
        LinkedList s = new LinkedList();
        this.createPasteTypes(t, s);
        return s.toArray(NO_PASTE_TYPES);
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        LinkedList s = new LinkedList();
        this.createPasteTypes(t, s);
        return s.isEmpty() ? null : (PasteType)s.get(0);
    }

    public NewType[] getNewTypes() {
        return NO_NEW_TYPES;
    }

    public SystemAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(SystemAction action) {
        this.defaultAction = action;
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
            if (this.systemActions == null) {
                this.systemActions = super.getActions();
            }
        }
        return this.systemActions;
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public Component getCustomizer() {
        return null;
    }

    protected final synchronized void setCookieSet(CookieSet s) {
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if (this.cookieSet != null) {
            this.cookieSet.removeChangeListener(this.sheetCookieL);
        }
        s.addChangeListener(this.sheetCookieL);
        this.cookieSet = s;
        this.fireCookieChange();
    }

    protected final CookieSet getCookieSet() {
        CookieSet s = this.cookieSet;
        if (s != null) {
            return s;
        }
        AbstractNode abstractNode = this;
        synchronized (abstractNode) {
            if (this.cookieSet != null) {
                CookieSet cookieSet = this.cookieSet;
                return cookieSet;
            }
            this.setCookieSet(new CookieSet());
            CookieSet cookieSet = this.cookieSet;
            return cookieSet;
        }
    }

    public Node.Cookie getCookie(Class type) {
        CookieSet c = this.cookieSet;
        if (c == null) {
            return null;
        }
        return c.getCookie(type);
    }

    public Node.Handle getHandle() {
        return DefaultHandle.createHandle(this);
    }

    private final class SheetAndCookieListener
    implements PropertyChangeListener,
    ChangeListener {
        SheetAndCookieListener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            AbstractNode.this.firePropertySetsChange(null, null);
        }

        public void stateChanged(ChangeEvent ev) {
            AbstractNode.this.fireCookieChange();
        }
    }
}

