/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextProxy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanChildren;
import org.openide.nodes.Children;
import org.openide.nodes.IndexedPropertySupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.nodes.TMUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class BeanNode
extends AbstractNode {
    private static final String ICON_BASE = "org/openide/resources/beans";
    private Object bean;
    private BeanInfo beanInfo;
    private Method nameGetter = null;
    private Method nameSetter = null;
    private Method removePCLMethod = null;
    private PropL propertyChangeListener = null;
    private boolean synchronizeName;
    static /* synthetic */ Class class$org$openide$nodes$BeanNode;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    private static Children getChildren(Object bean) {
        BeanContextChild bch;
        if (bean instanceof BeanContext) {
            return new BeanChildren((BeanContext)bean);
        }
        if (bean instanceof BeanContextProxy && (bch = ((BeanContextProxy)bean).getBeanContextProxy()) instanceof BeanContext) {
            return new BeanChildren((BeanContext)bch);
        }
        return Children.LEAF;
    }

    public BeanNode(Object bean) throws IntrospectionException {
        this(bean, BeanNode.getChildren(bean));
    }

    protected BeanNode(Object bean, Children children) throws IntrospectionException {
        super(children == null ? BeanNode.getChildren(bean) : children);
        this.bean = bean;
        try {
            this.initialization();
        }
        catch (IntrospectionException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw BeanNode.mkie(re);
        }
        catch (LinkageError le) {
            throw BeanNode.mkie(le);
        }
    }

    private static IntrospectionException mkie(Throwable t) {
        IntrospectionException ie = new IntrospectionException(t.toString());
        ErrorManager.getDefault().annotate((Throwable)ie, t);
        return ie;
    }

    protected void setSynchronizeName(boolean watch) {
        this.synchronizeName = watch;
    }

    protected Object getBean() {
        return this.bean;
    }

    public void destroy() throws IOException {
        if (this.removePCLMethod != null) {
            try {
                Object o = Beans.getInstanceOf(this.bean, this.removePCLMethod.getDeclaringClass());
                this.removePCLMethod.invoke(o, this.propertyChangeListener);
            }
            catch (Exception e) {
                NodeOp.exception(e);
            }
        }
        super.destroy();
    }

    public boolean canDestroy() {
        return true;
    }

    public void setName(String s) {
        Method m;
        if (this.synchronizeName && (m = this.nameSetter) != null) {
            try {
                m.invoke(this.bean, s);
            }
            catch (Exception e) {
                NodeOp.exception(e);
            }
        }
        super.setName(s);
    }

    public boolean canRename() {
        return !this.synchronizeName || this.nameSetter != null;
    }

    public Image getIcon(int type) {
        Image image = this.beanInfo.getIcon(type);
        if (image != null) {
            return image;
        }
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public HelpCtx getHelpCtx() {
        HelpCtx test = TMUtil.findHelp(this);
        if (test != null) {
            return test;
        }
        return new HelpCtx(class$org$openide$nodes$BeanNode == null ? (class$org$openide$nodes$BeanNode = BeanNode.class$("org.openide.nodes.BeanNode")) : class$org$openide$nodes$BeanNode);
    }

    protected void createProperties(Object bean, BeanInfo info) {
        Descriptor d = BeanNode.computeProperties(bean, this.beanInfo);
        Sheet sets = this.getSheet();
        Sheet.Set pset = Sheet.createPropertiesSet();
        pset.put(d.property);
        BeanDescriptor bd = info.getBeanDescriptor();
        if (bd != null && bd.getValue("propertiesHelpID") != null) {
            pset.setValue("helpID", bd.getValue("propertiesHelpID"));
        }
        sets.put(pset);
        if (d.expert.length != 0) {
            Sheet.Set eset = Sheet.createExpertSet();
            eset.put(d.expert);
            if (bd != null && bd.getValue("expertHelpID") != null) {
                eset.setValue("helpID", bd.getValue("expertHelpID"));
            }
            sets.put(eset);
        }
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    protected SystemAction[] createActions() {
        return NodeOp.createFromNames(new String[]{"CustomizeBean", null, "Copy", null, "Tools", "Properties"});
    }

    public boolean hasCustomizer() {
        return this.beanInfo.getBeanDescriptor().getCustomizerClass() != null;
    }

    public Component getCustomizer() {
        Object o;
        Class<?> clazz = this.beanInfo.getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            o = clazz.newInstance();
        }
        catch (InstantiationException e) {
            NodeOp.exception(e);
            return null;
        }
        catch (IllegalAccessException e) {
            NodeOp.exception(e);
            return null;
        }
        if (!(o instanceof Customizer)) {
            return null;
        }
        Customizer cust = (Customizer)o;
        TMUtil.attachCustomizer(this, cust);
        Component comp = null;
        comp = o instanceof Component ? (Component)o : TMUtil.createDialog(o);
        if (comp == null) {
            return null;
        }
        cust.setObject(this.bean);
        if (this.removePCLMethod == null) {
            cust.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    BeanNode.this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
                }
            });
        }
        return comp;
    }

    public static Descriptor computeProperties(Object bean, BeanInfo info) {
        ArrayList<Node.Property> property = new ArrayList<Node.Property>();
        ArrayList<Node.Property> expert = new ArrayList<Node.Property>();
        ArrayList<Node.Property> hidden = new ArrayList<Node.Property>();
        PropertyDescriptor[] propertyDescriptor = info.getPropertyDescriptors();
        int k = propertyDescriptor.length;
        int i = 0;
        while (i < k) {
            block8: {
                Node.Property prop;
                block10: {
                    String aname;
                    Enumeration<String> e;
                    Node.Property support;
                    PropertyDescriptor p;
                    block9: {
                        if (propertyDescriptor[i].getPropertyType() == null) break block8;
                        if (!(propertyDescriptor[i] instanceof IndexedPropertyDescriptor)) break block9;
                        p = (IndexedPropertyDescriptor)propertyDescriptor[i];
                        if (p.getReadMethod() != null && !p.getReadMethod().getReturnType().isArray()) break block8;
                        support = new IndexedPropertySupport(bean, p.getPropertyType(), ((IndexedPropertyDescriptor)p).getIndexedPropertyType(), p.getReadMethod(), p.getWriteMethod(), ((IndexedPropertyDescriptor)p).getIndexedReadMethod(), ((IndexedPropertyDescriptor)p).getIndexedWriteMethod());
                        ((IndexedPropertySupport)support).setName(p.getName());
                        ((IndexedPropertySupport)support).setDisplayName(p.getDisplayName());
                        ((IndexedPropertySupport)support).setShortDescription(p.getShortDescription());
                        e = p.attributeNames();
                        while (e.hasMoreElements()) {
                            aname = e.nextElement();
                            support.setValue(aname, p.getValue(aname));
                        }
                        prop = support;
                        break block10;
                    }
                    p = propertyDescriptor[i];
                    support = new PropertySupport.Reflection(bean, p.getPropertyType(), p.getReadMethod(), p.getWriteMethod());
                    support.setName(p.getName());
                    support.setDisplayName(p.getDisplayName());
                    support.setShortDescription(p.getShortDescription());
                    ((PropertySupport.Reflection)support).setPropertyEditorClass(p.getPropertyEditorClass());
                    e = p.attributeNames();
                    while (e.hasMoreElements()) {
                        aname = e.nextElement();
                        support.setValue(aname, p.getValue(aname));
                    }
                    prop = support;
                }
                Object help = propertyDescriptor[i].getValue("helpID");
                if (help != null && help instanceof String) {
                    prop.setValue("helpID", help);
                }
                if (propertyDescriptor[i].isHidden()) {
                    hidden.add(prop);
                } else if (propertyDescriptor[i].isExpert()) {
                    expert.add(prop);
                } else {
                    property.add(prop);
                }
            }
            ++i;
        }
        return new Descriptor(property, expert, hidden);
    }

    private void initialization() throws IntrospectionException {
        this.setIconBase(ICON_BASE);
        SystemAction[] arr = NodeOp.createFromNames(new String[]{"Properties"});
        if (arr.length != 0) {
            this.setDefaultAction(arr[0]);
        }
        this.setSynchronizeName(true);
        Class clazz = this.bean.getClass();
        while (!Modifier.isPublic(clazz.getModifiers()) && !this.hasExplicitBeanInfo(clazz)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            Class clazz2 = clazz = class$java$lang$Object == null ? BeanNode.class$("java.lang.Object") : class$java$lang$Object;
        }
        this.beanInfo = Utilities.getBeanInfo(clazz);
        this.registerName();
        this.setNameSilently(this.getNameForBean());
        BeanDescriptor descriptor = this.beanInfo.getBeanDescriptor();
        String sd = descriptor.getShortDescription();
        if (!Utilities.compareObjects(sd, descriptor.getDisplayName())) {
            this.setShortDescription(sd);
        }
        EventSetDescriptor[] eventSetDescriptors = this.beanInfo.getEventSetDescriptors();
        int k = eventSetDescriptors.length;
        Method method = null;
        int i = 0;
        while (i < k) {
            method = eventSetDescriptors[i].getAddListenerMethod();
            if (method != null && method.getName().equals("addPropertyChangeListener") && Modifier.isPublic(method.getModifiers())) break;
            ++i;
        }
        if (i != k) {
            try {
                Object o = Beans.getInstanceOf(this.bean, method.getDeclaringClass());
                this.propertyChangeListener = new PropL();
                method.invoke(o, WeakListener.propertyChange(this.propertyChangeListener, o));
                this.removePCLMethod = eventSetDescriptors[i].getRemoveListenerMethod();
            }
            catch (Exception e) {
                ErrorManager.getDefault().annotate(e, 0, "Trying to invoke " + method + " where introspected class is " + clazz.getName(), null, null, null);
                NodeOp.warning(e);
            }
        }
        this.createProperties(this.bean, this.beanInfo);
        Enumeration<String> e = this.beanInfo.getBeanDescriptor().attributeNames();
        while (e.hasMoreElements()) {
            String aname = e.nextElement();
            this.setValue(aname, this.beanInfo.getBeanDescriptor().getValue(aname));
        }
        Node.Cookie instanceCookie = TMUtil.createInstanceCookie(this.bean);
        if (instanceCookie != null) {
            this.getCookieSet().add(instanceCookie);
        }
    }

    private boolean hasExplicitBeanInfo(Class clazz) {
        String className = clazz.getName();
        int indx = className.lastIndexOf(46);
        className = className.substring(indx + 1);
        String[] paths = Introspector.getBeanInfoSearchPath();
        int i = 0;
        while (i < paths.length) {
            String s = paths[i] + '.' + className + "BeanInfo";
            try {
                Class.forName(s);
                return true;
            }
            catch (ClassNotFoundException ex) {
                ++i;
            }
        }
        return false;
    }

    private void registerName() {
        Class clazz = this.bean.getClass();
        while (!Modifier.isPublic(clazz.getModifiers())) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            Class clazz2 = clazz = class$java$lang$Object == null ? BeanNode.class$("java.lang.Object") : class$java$lang$Object;
        }
        Class[] param = new Class[]{};
        try {
            try {
                this.nameGetter = clazz.getMethod("getName", param);
                if (this.nameGetter.getReturnType() != (class$java$lang$String == null ? (class$java$lang$String = BeanNode.class$("java.lang.String")) : class$java$lang$String)) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    this.nameGetter = clazz.getMethod("getDisplayName", param);
                    if (this.nameGetter.getReturnType() != (class$java$lang$String == null ? (class$java$lang$String = BeanNode.class$("java.lang.String")) : class$java$lang$String)) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException ee) {
                    this.nameGetter = null;
                    return;
                }
            }
        }
        catch (SecurityException se) {
            NodeOp.exception(se);
            this.nameGetter = null;
            return;
        }
        try {
            String result = (String)this.nameGetter.invoke(this.bean, null);
        }
        catch (Exception e) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate(e, 16, "Bad method: " + clazz.getName() + "." + this.nameGetter.getName(), null, null, null);
            em.notify(16, e);
            this.nameGetter = null;
            return;
        }
        param = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BeanNode.class$("java.lang.String")) : class$java$lang$String};
        try {
            try {
                this.nameSetter = clazz.getMethod("setName", param);
                if (this.nameSetter.getReturnType() != Void.TYPE) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    this.nameSetter = clazz.getMethod("setDisplayName", param);
                    if (this.nameSetter.getReturnType() != Void.TYPE) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException ee) {
                    this.nameSetter = null;
                }
            }
        }
        catch (SecurityException se) {
            NodeOp.exception(se);
        }
    }

    private String getNameForBean() {
        if (this.nameGetter != null) {
            try {
                String name = (String)this.nameGetter.invoke(this.bean, null);
                return name != null ? name : "";
            }
            catch (Exception ex) {
                NodeOp.warning(ex);
            }
        }
        BeanDescriptor descriptor = this.beanInfo.getBeanDescriptor();
        return descriptor.getDisplayName();
    }

    void setNameSilently(String name) {
        super.setName(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String newName;
            String name;
            BeanNode.this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
            if (BeanNode.this.synchronizeName && ((name = e.getPropertyName()) == null || name.equals("name") || name.equals("displayName")) && !(newName = BeanNode.this.getNameForBean()).equals(BeanNode.this.getName())) {
                BeanNode.this.setNameSilently(newName);
            }
        }
    }

    public static final class Descriptor {
        public final Node.Property[] property;
        public final Node.Property[] expert;
        public final Node.Property[] hidden;

        Descriptor(ArrayList p, ArrayList e, ArrayList h) {
            this.property = new Node.Property[p.size()];
            p.toArray(this.property);
            this.expert = new Node.Property[e.size()];
            e.toArray(this.expert);
            this.hidden = new Node.Property[h.size()];
            h.toArray(this.hidden);
        }
    }
}

