/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.nodes.Node;

public final class CookieSet {
    private HashMap map = new HashMap(31);
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$openide$nodes$Node$Cookie;

    public void add(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    public void remove(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.unregisterCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie ret = null;
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            R r = this.findR(clazz);
            if (r == null) {
                Node.Cookie cookie = null;
                return cookie;
            }
            ret = r.cookie();
        }
        if (ret instanceof CookieEntry) {
            ret = ((CookieEntry)ret).getCookie();
        }
        return ret;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CookieSet.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CookieSet.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    private void fireChangeEvent() {
        Object[] arr = this.listeners.getListenerList();
        if (arr.length > 0) {
            ChangeEvent ev = null;
            int i = arr.length - 2;
            while (i >= 0) {
                if (arr[i] == (class$javax$swing$event$ChangeListener == null ? CookieSet.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                    if (ev == null) {
                        ev = new ChangeEvent(this);
                    }
                    ((ChangeListener)arr[i + 1]).stateChanged(ev);
                }
                i -= 2;
            }
        }
    }

    private void registerCookie(Class c, Node.Cookie cookie) {
        if (c == null || !(class$org$openide$nodes$Node$Cookie == null ? (class$org$openide$nodes$Node$Cookie = CookieSet.class$("org.openide.nodes.Node$Cookie")) : class$org$openide$nodes$Node$Cookie).isAssignableFrom(c)) {
            return;
        }
        R r = this.findR(c);
        if (r == null) {
            r = new R();
            this.map.put(c, r);
        }
        r.add(cookie);
        this.registerCookie(c.getSuperclass(), cookie);
        Class<?>[] inter = c.getInterfaces();
        int i = 0;
        while (i < inter.length) {
            this.registerCookie(inter[i], cookie);
            ++i;
        }
    }

    private void unregisterCookie(Class c, Node.Cookie cookie) {
        if (c == null || !(class$org$openide$nodes$Node$Cookie == null ? (class$org$openide$nodes$Node$Cookie = CookieSet.class$("org.openide.nodes.Node$Cookie")) : class$org$openide$nodes$Node$Cookie).isAssignableFrom(c)) {
            return;
        }
        R r = this.findR(c);
        if (r != null) {
            r.remove(cookie);
        }
        this.unregisterCookie(c.getSuperclass(), cookie);
        Class<?>[] inter = c.getInterfaces();
        int i = 0;
        while (i < inter.length) {
            this.unregisterCookie(inter[i], cookie);
            ++i;
        }
    }

    public void add(Class cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(cookieClass, new CookieEntry(factory, cookieClass));
        }
        this.fireChangeEvent();
    }

    public void add(Class[] cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            int i = 0;
            while (i < cookieClass.length) {
                this.registerCookie(cookieClass[i], new CookieEntry(factory, cookieClass[i]));
                ++i;
            }
        }
        this.fireChangeEvent();
    }

    public void remove(Class cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            Node.Cookie c;
            R r = this.findR(cookieClass);
            if (r != null && (c = r.cookie()) instanceof CookieEntry) {
                CookieEntry ce = (CookieEntry)c;
                if (ce.factory == factory) {
                    this.unregisterCookie(cookieClass, c);
                }
            }
        }
        this.fireChangeEvent();
    }

    public void remove(Class[] cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            int i = 0;
            while (i < cookieClass.length) {
                Node.Cookie c;
                R r = this.findR(cookieClass[i]);
                if (r != null && (c = r.cookie()) instanceof CookieEntry) {
                    CookieEntry ce = (CookieEntry)c;
                    if (ce.factory == factory) {
                        this.unregisterCookie(cookieClass[i], c);
                    }
                }
                ++i;
            }
        }
        this.fireChangeEvent();
    }

    private R findR(Class c) {
        return (R)this.map.get(c);
    }

    private static Class baseForCookie(Node.Cookie c) {
        if (c instanceof CookieEntry) {
            return ((CookieEntry)c).klass;
        }
        return c.getClass();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class R {
        public List cookies;
        public Class base;

        private R() {
        }

        public void add(Node.Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList(1);
                this.cookies.add(cookie);
                this.base = CookieSet.baseForCookie(cookie);
                return;
            }
            Class newBase = CookieSet.baseForCookie(cookie);
            if (this.base == null || newBase.isAssignableFrom(this.base)) {
                this.cookies.set(0, cookie);
                this.base = newBase;
            } else {
                this.cookies.add(cookie);
            }
        }

        public boolean remove(Node.Cookie cookie) {
            if (this.cookies == null) {
                return true;
            }
            if (this.cookies.remove(cookie) && this.cookies.size() == 0) {
                this.base = null;
                this.cookies = null;
                return true;
            }
            this.base = CookieSet.baseForCookie((Node.Cookie)this.cookies.get(0));
            return false;
        }

        public Node.Cookie cookie() {
            return this.cookies == null || this.cookies.isEmpty() ? null : (Node.Cookie)this.cookies.get(0);
        }
    }

    private static class CookieEntry
    implements Node.Cookie {
        final Factory factory;
        private final Class klass;
        private Reference cookie;

        public CookieEntry(Factory factory, Class klass) {
            this.factory = factory;
            this.klass = klass;
        }

        public synchronized Node.Cookie getCookie() {
            Node.Cookie ret;
            if (this.cookie == null || (ret = (Node.Cookie)this.cookie.get()) == null) {
                ret = this.factory.createCookie(this.klass);
                if (ret == null) {
                    return null;
                }
                this.cookie = new WeakReference<Node.Cookie>(ret);
            }
            return ret;
        }
    }

    public static interface Factory {
        public Node.Cookie createCookie(Class var1);
    }
}

