/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.io.IOException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;

public final class DefaultHandle
implements Node.Handle {
    private Node.Handle parent;
    private String path;
    private static final long serialVersionUID = -8739127064355983273L;

    DefaultHandle(Node.Handle parent, String path) {
        this.parent = parent;
        this.path = path;
    }

    public Node getNode() throws IOException {
        Node parentNode = this.parent.getNode();
        Node child = parentNode.getChildren().findChild(this.path);
        if (child != null) {
            return child;
        }
        throw new NodeNotFoundException(parentNode, this.path, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultHandle createHandle(Node node) {
        DefaultHandle defaultHandle;
        block10: {
            DefaultHandle defaultHandle2;
            block9: {
                DefaultHandle defaultHandle3;
                block8: {
                    DefaultHandle defaultHandle4;
                    block7: {
                        try {
                            Children.PR.enterReadAccess();
                            String childPath = node.getName();
                            if (childPath == null) {
                                DefaultHandle defaultHandle5 = null;
                                Object var9_3 = null;
                                Children.PR.exitReadAccess();
                                return defaultHandle5;
                            }
                            Node parentNode = node.getParentNode();
                            if (parentNode == null) {
                                defaultHandle4 = null;
                                break block7;
                            }
                            if (parentNode.getChildren().findChild(childPath) != node) {
                                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                    System.err.println("WARNING: parent could not find own child in DefaultHandle.createHandle");
                                    System.err.println("\tnode=" + node);
                                    System.err.println("\tparentNode=" + parentNode);
                                    System.err.println("\tchildPath=" + childPath);
                                    System.err.println("\tfound child=" + parentNode.getChildren().findChild(childPath));
                                }
                                defaultHandle3 = null;
                                break block8;
                            }
                            Node.Handle parentHandle = parentNode.getHandle();
                            if (parentHandle == null) {
                                defaultHandle2 = null;
                                break block9;
                            }
                            defaultHandle = new DefaultHandle(parentHandle, childPath);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var9_8 = null;
                            Children.PR.exitReadAccess();
                            throw throwable;
                        }
                    }
                    Object var9_4 = null;
                    Children.PR.exitReadAccess();
                    return defaultHandle4;
                }
                Object var9_5 = null;
                Children.PR.exitReadAccess();
                return defaultHandle3;
            }
            Object var9_6 = null;
            Children.PR.exitReadAccess();
            return defaultHandle2;
        }
        Object var9_7 = null;
        Children.PR.exitReadAccess();
        return defaultHandle;
    }

    public String toString() {
        return "DefaultHandle[" + this.parent + "|" + this.path + "]";
    }
}

