/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class FilterNode
extends Node {
    private Node original;
    private PropertyChangeListener propL;
    private NodeListener nodeL;
    private int delegateMask;
    protected static final int DELEGATE_SET_NAME = 1;
    protected static final int DELEGATE_GET_NAME = 2;
    protected static final int DELEGATE_SET_DISPLAY_NAME = 4;
    protected static final int DELEGATE_GET_DISPLAY_NAME = 8;
    protected static final int DELEGATE_SET_SHORT_DESCRIPTION = 16;
    protected static final int DELEGATE_GET_SHORT_DESCRIPTION = 32;
    protected static final int DELEGATE_DESTROY = 64;
    protected static final int DELEGATE_GET_ACTIONS = 128;
    protected static final int DELEGATE_GET_CONTEXT_ACTIONS = 256;
    private static final int DELEGATE_ALL = 511;
    private boolean pchlAttached = false;
    static /* synthetic */ Class class$org$openide$nodes$FilterNode;
    static /* synthetic */ Class class$org$openide$nodes$FilterNode$Children;

    public FilterNode(Node original) {
        this(original, original.isLeaf() ? org.openide.nodes.Children.LEAF : new Children(original));
    }

    public FilterNode(Node original, org.openide.nodes.Children children) {
        super(children);
        this.original = original;
        this.init();
    }

    private void init() {
        this.original.addNodeListener(this.getNodeListener());
        this.delegateMask = 511;
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener l) {
        if (!this.pchlAttached) {
            this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = true;
        }
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener l) {
        if (this.getPropertyChangeListenersCount() == 0) {
            this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = false;
        }
    }

    protected void finalize() {
        this.original.removePropertyChangeListener(this.getPropertyChangeListener());
        this.original.removeNodeListener(this.getNodeListener());
    }

    protected final void enableDelegation(int mask) {
        if ((mask & 0xFFFFFE00) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + mask);
        }
        this.delegateMask |= mask;
    }

    protected final void disableDelegation(int mask) {
        if ((mask & 0xFFFFFE00) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + mask);
        }
        this.delegateMask &= ~mask;
    }

    private final boolean delegating(int what) {
        return (this.delegateMask & what) != 0;
    }

    public Node cloneNode() {
        if (this.isDefault()) {
            return new FilterNode(this.original);
        }
        return new FilterNode(this);
    }

    protected final void changeOriginal(Node original, boolean changeChildren) {
        if (!(!changeChildren || this.getChildren() instanceof Children || this.getChildren() == org.openide.nodes.Children.LEAF && original.isLeaf())) {
            throw new IllegalStateException("Can't change implicitly defined Children on FilterNode");
        }
        String oldName = null;
        String oldDisplayName = null;
        String oldShortDescription = null;
        Node.PropertySet[] oldPropertySets = null;
        try {
            org.openide.nodes.Children.PR.enterWriteAccess();
            oldName = this.original.getName();
            oldDisplayName = this.original.getDisplayName();
            oldShortDescription = this.original.getShortDescription();
            oldPropertySets = this.original.getPropertySets();
            this.original.removeNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            }
            this.original = original;
            this.original.addNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            }
            if (changeChildren && !original.isLeaf()) {
                ((Children)this.getChildren()).changeOriginal(original);
            }
            Object var8_7 = null;
            org.openide.nodes.Children.PR.exitWriteAccess();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            org.openide.nodes.Children.PR.exitWriteAccess();
            throw throwable;
        }
        this.fireCookieChange();
        this.fireNameChange(oldName, original.getName());
        this.fireDisplayNameChange(oldDisplayName, original.getDisplayName());
        this.fireShortDescriptionChange(oldShortDescription, original.getShortDescription());
        this.fireIconChange();
        this.fireOpenedIconChange();
        this.firePropertySetsChange(null, null);
    }

    public void setName(String s) {
        if (this.delegating(1)) {
            this.original.setName(s);
        } else {
            super.setName(s);
        }
    }

    public String getName() {
        if (this.delegating(2)) {
            return this.original.getName();
        }
        return super.getName();
    }

    public void setDisplayName(String s) {
        if (this.delegating(4)) {
            this.original.setDisplayName(s);
        } else {
            super.setDisplayName(s);
        }
    }

    public String getDisplayName() {
        if (this.delegating(8)) {
            return this.original.getDisplayName();
        }
        return super.getDisplayName();
    }

    public void setShortDescription(String s) {
        if (this.delegating(16)) {
            this.original.setShortDescription(s);
        } else {
            super.setShortDescription(s);
        }
    }

    public String getShortDescription() {
        if (this.delegating(32)) {
            return this.original.getShortDescription();
        }
        return super.getShortDescription();
    }

    public Image getIcon(int type) {
        return this.original.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.original.getOpenedIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    public boolean canRename() {
        return this.original.canRename();
    }

    public boolean canDestroy() {
        return this.original.canDestroy();
    }

    public void destroy() throws IOException {
        if (this.delegating(64)) {
            this.original.destroy();
        } else {
            super.destroy();
        }
    }

    private final void originalDestroyed() {
        try {
            super.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Node.PropertySet[] getPropertySets() {
        return this.original.getPropertySets();
    }

    public Transferable clipboardCopy() throws IOException {
        return this.original.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        return this.original.clipboardCut();
    }

    public boolean canCopy() {
        return this.original.canCopy();
    }

    public boolean canCut() {
        return this.original.canCut();
    }

    public Transferable drag() throws IOException {
        return this.original.drag();
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return this.original.getDropType(t, action, index);
    }

    public PasteType[] getPasteTypes(Transferable t) {
        return this.original.getPasteTypes(t);
    }

    public NewType[] getNewTypes() {
        return this.original.getNewTypes();
    }

    public SystemAction[] getActions() {
        if (this.delegating(128)) {
            return this.original.getActions();
        }
        return super.getActions();
    }

    public SystemAction[] getContextActions() {
        if (this.delegating(256)) {
            return this.original.getContextActions();
        }
        return super.getContextActions();
    }

    public SystemAction getDefaultAction() {
        return this.original.getDefaultAction();
    }

    public boolean hasCustomizer() {
        return this.original.hasCustomizer();
    }

    public Component getCustomizer() {
        return this.original.getCustomizer();
    }

    public Node.Cookie getCookie(Class type) {
        return this.original.getCookie(type);
    }

    public Node.Handle getHandle() {
        if (!this.isDefault()) {
            return null;
        }
        Node.Handle original = this.original.getHandle();
        if (original == null) {
            return null;
        }
        return new FilterHandle(original);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.isDefault()) {
            return false;
        }
        return this.original.equals(o) || o.equals(this.original);
    }

    public int hashCode() {
        return this.isDefault() ? this.original.hashCode() : super.hashCode();
    }

    protected Node getOriginal() {
        return this.original;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeAdapter(this);
    }

    protected NodeListener createNodeListener() {
        return new NodeAdapter(this);
    }

    synchronized PropertyChangeListener getPropertyChangeListener() {
        if (this.propL == null) {
            this.propL = this.createPropertyChangeListener();
        }
        return this.propL;
    }

    synchronized NodeListener getNodeListener() {
        if (this.nodeL == null) {
            this.nodeL = this.createNodeListener();
        }
        return this.nodeL;
    }

    private boolean isDefault() {
        if (this.getClass() != (class$org$openide$nodes$FilterNode == null ? (class$org$openide$nodes$FilterNode = FilterNode.class$("org.openide.nodes.FilterNode")) : class$org$openide$nodes$FilterNode)) {
            return false;
        }
        org.openide.nodes.Children ch = this.getChildren();
        return this.original.isLeaf() && ch == org.openide.nodes.Children.LEAF || !this.original.isLeaf() && ch.getClass() == (class$org$openide$nodes$FilterNode$Children == null ? (class$org$openide$nodes$FilterNode$Children = FilterNode.class$("org.openide.nodes.FilterNode$Children")) : class$org$openide$nodes$FilterNode$Children) && ((Children)ch).original == this.original;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class FilterHandle
    implements Node.Handle {
        private Node.Handle original;
        static final long serialVersionUID = 7928908039428333839L;

        public FilterHandle(Node.Handle original) {
            this.original = original;
        }

        public Node getNode() throws IOException {
            return new FilterNode(this.original.getNode());
        }

        public String toString() {
            return "FilterHandle[" + this.original + "]";
        }
    }

    private static class ChildrenAdapter
    implements NodeListener,
    Runnable {
        private WeakReference children;

        public ChildrenAdapter(Children ch) {
            this.children = new WeakReference<Children>(ch);
        }

        public void run() {
            Children ch = (Children)this.children.get();
            if (ch != null) {
                Object[] arr = ch.original.getChildren().getNodes();
                ch.setKeys(arr);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
        }

        public void childrenAdded(NodeMemberEvent ev) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenAdded(ev);
        }

        public void childrenRemoved(NodeMemberEvent ev) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenRemoved(ev);
        }

        public void childrenReordered(NodeReorderEvent ev) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenReordered(ev);
        }

        public void nodeDestroyed(NodeEvent ev) {
        }
    }

    public static class Children
    extends Children.Keys
    implements Cloneable {
        protected Node original;
        private ChildrenAdapter nodeL;

        public Children(Node or) {
            this.original = or;
        }

        protected final void changeOriginal(Node original) {
            try {
                boolean wasAttached;
                org.openide.nodes.Children.PR.enterWriteAccess();
                boolean bl = wasAttached = this.nodeL != null;
                if (wasAttached) {
                    this.original.removeNodeListener(this.nodeL);
                    this.nodeL = null;
                }
                this.original = original;
                if (wasAttached) {
                    this.addNotifyImpl();
                }
                Object var4_3 = null;
                org.openide.nodes.Children.PR.exitWriteAccess();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                org.openide.nodes.Children.PR.exitWriteAccess();
                throw throwable;
            }
        }

        protected void finalize() {
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
            }
            this.nodeL = null;
        }

        public Object clone() {
            return new Children(this.original);
        }

        protected void addNotify() {
            this.addNotifyImpl();
        }

        private void addNotifyImpl() {
            this.nodeL = new ChildrenAdapter(this);
            this.original.addNodeListener(this.nodeL);
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
                this.nodeL = null;
            }
        }

        protected Node copyNode(Node node) {
            return node.cloneNode();
        }

        public Node findChild(String name) {
            this.original.getChildren().findChild(name);
            return super.findChild(name);
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            return new Node[]{this.copyNode(n)};
        }

        public boolean add(Node[] arr) {
            return this.original.getChildren().add(arr);
        }

        public boolean remove(Node[] arr) {
            return this.original.getChildren().remove(arr);
        }

        protected void filterChildrenAdded(NodeMemberEvent ev) {
            this.updateKeys();
        }

        protected void filterChildrenRemoved(NodeMemberEvent ev) {
            this.updateKeys();
        }

        protected void filterChildrenReordered(NodeReorderEvent ev) {
            this.updateKeys();
        }

        private void updateKeys() {
            ChildrenAdapter runnable = this.nodeL;
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    protected static class NodeAdapter
    implements NodeListener {
        private WeakReference fn;
        private WeakReference children;

        public NodeAdapter(FilterNode fn) {
            this.fn = new WeakReference<FilterNode>(fn);
        }

        public final void propertyChange(PropertyChangeEvent ev) {
            FilterNode fn = (FilterNode)this.fn.get();
            if (fn == null) {
                return;
            }
            this.propertyChange(fn, ev);
        }

        protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
            String n = ev.getPropertyName();
            if (n.equals("parentNode")) {
                return;
            }
            if (n.equals("displayName")) {
                fn.fireOwnPropertyChange("displayName", (String)ev.getOldValue(), (String)ev.getNewValue());
                return;
            }
            if (n.equals("name")) {
                fn.fireOwnPropertyChange("name", (String)ev.getOldValue(), (String)ev.getNewValue());
                return;
            }
            if (n.equals("shortDescription")) {
                fn.fireOwnPropertyChange("shortDescription", (String)ev.getOldValue(), (String)ev.getNewValue());
                return;
            }
            if (n.equals("icon")) {
                fn.fireIconChange();
                return;
            }
            if (n.equals("openedIcon")) {
                fn.fireOpenedIconChange();
                return;
            }
            if (n.equals("propertySets")) {
                fn.firePropertySetsChange((Node.PropertySet[])ev.getOldValue(), (Node.PropertySet[])ev.getNewValue());
                return;
            }
            if (n.equals("cookie")) {
                fn.fireCookieChange();
                return;
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public final void nodeDestroyed(NodeEvent ev) {
            FilterNode fn = (FilterNode)this.fn.get();
            if (fn == null) {
                return;
            }
            fn.originalDestroyed();
        }
    }

    protected static class PropertyChangeAdapter
    implements PropertyChangeListener {
        private WeakReference fn;

        public PropertyChangeAdapter(FilterNode fn) {
            this.fn = new WeakReference<FilterNode>(fn);
        }

        public final void propertyChange(PropertyChangeEvent ev) {
            FilterNode fn = (FilterNode)this.fn.get();
            if (fn == null) {
                return;
            }
            this.propertyChange(fn, ev);
        }

        protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
            fn.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }
    }
}

