/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.io.IOException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.ErrorManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.windows.WindowManager;

public final class NodeOp {
    private static SystemAction[] defaultActions;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    private NodeOp() {
    }

    public static SystemAction[] getDefaultActions() {
        if (defaultActions == null) {
            defaultActions = NodeOp.createFromNames(new String[]{"Tools", "Properties"});
        }
        return defaultActions;
    }

    public static void setDefaultActions(SystemAction[] def) {
        throw new SecurityException();
    }

    public static JPopupMenu findContextMenu(Node[] nodes) {
        JFrame main = (JFrame)WindowManager.getDefault().getMainWindow();
        JComponent mainContentPane = (JComponent)main.getContentPane();
        Object pendingNodeActivator = mainContentPane.getClientProperty("hack.pendingNodeActivator");
        mainContentPane.putClientProperty("hack.pendingNodeActivator", null);
        if (pendingNodeActivator instanceof Runnable) {
            ((Runnable)pendingNodeActivator).run();
        }
        if (nodes.length != 1) {
            return NodeOp.findContextMenuImpl(nodes);
        }
        return nodes[0].getContextMenu();
    }

    static JPopupMenu findContextMenuImpl(Node[] nodes) {
        JPopupMenuPlus menu;
        block14: {
            HashSet<SystemAction> counted;
            SystemAction[] arr;
            menu = new JPopupMenuPlus();
            HashMap<SystemAction, Integer> actions = new HashMap<SystemAction, Integer>();
            int n = 0;
            while (n < nodes.length) {
                arr = nodes[n].getActions();
                if (arr == null) {
                    arr = NodeOp.getDefaultActions();
                }
                counted = new HashSet<SystemAction>();
                int i = 0;
                while (i < arr.length) {
                    if (arr[i] != null && !counted.contains(arr[i])) {
                        counted.add(arr[i]);
                        Integer cntInt = (Integer)actions.get(arr[i]);
                        int cnt = cntInt == null ? 0 : cntInt;
                        actions.put(arr[i], new Integer(cnt + 1));
                    }
                    ++i;
                }
                ++n;
            }
            if (actions.isEmpty()) break block14;
            arr = nodes[0].getActions();
            if (arr == null) {
                arr = defaultActions;
            }
            counted = new HashSet();
            boolean canSep = false;
            int i = 0;
            while (i < arr.length) {
                block16: {
                    boolean addSep;
                    block15: {
                        int cnt;
                        addSep = true;
                        if (arr[i] == null) break block15;
                        if (counted.contains(arr[i])) break block16;
                        counted.add(arr[i]);
                        Integer cntInt = (Integer)actions.get(arr[i]);
                        int n2 = cnt = cntInt == null ? 0 : cntInt;
                        if (cnt == nodes.length) {
                            JMenuItem item;
                            addSep = false;
                            canSep = true;
                            if (arr[i] instanceof Presenter.Popup) {
                                item = ((Presenter.Popup)((Object)arr[i])).getPopupPresenter();
                                if (item == null) {
                                    NullPointerException npe = new NullPointerException("findContextMenuImpl, getPopupPresenter returning null for " + arr[i]);
                                    NodeOp.exception(npe);
                                }
                            } else {
                                item = new JMenuItem(arr[i].getName());
                                item.setEnabled(false);
                            }
                            menu.add(item);
                        }
                    }
                    if (addSep && canSep) {
                        menu.addSeparator();
                        canSep = false;
                    }
                }
                ++i;
            }
        }
        return menu;
    }

    public static boolean isSon(Node parent, Node son) {
        return son.getParentNode() == parent;
    }

    public static String[] createPath(Node node, Node parent) {
        LinkedList<String> ar = new LinkedList<String>();
        while (node != null && node != parent) {
            if (node.getName() == null) {
                boolean isFilter = false;
                if (node instanceof FilterNode) {
                    isFilter = true;
                }
                throw new IllegalArgumentException("Node:" + node.getClass() + "[" + node.getDisplayName() + "]" + (isFilter ? " of original:" + ((FilterNode)node).getOriginal().getClass() : "") + " gets null name!");
            }
            ar.addFirst(node.getName());
            node = node.getParentNode();
        }
        String[] res = new String[ar.size()];
        ar.toArray(res);
        return res;
    }

    public static Node findChild(Node node, String name) {
        return node.getChildren().findChild(name);
    }

    public static Node findPath(Node start, Enumeration names) throws NodeNotFoundException {
        int depth = 0;
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Node next = NodeOp.findChild(start, name);
            if (next == null) {
                throw new NodeNotFoundException(start, name, depth);
            }
            start = next;
            ++depth;
        }
        return start;
    }

    public static Node findPath(Node start, String[] names) throws NodeNotFoundException {
        return NodeOp.findPath(start, new ArrayEnumeration(names));
    }

    public static Node findRoot(Node node) {
        Node parent;
        while ((parent = node.getParentNode()) != null) {
            node = parent;
        }
        return node;
    }

    static final int[] computeSortingPermutation(Node[] nodes) {
        return NodeOp.computeSortingPermutation(nodes, null);
    }

    static final int[] computeSortingPermutation(Node[] nodes, Comparator comp) {
        TreeMap<Node, Integer> tm = comp == null ? new TreeMap<Node, Integer>() : new TreeMap(comp);
        int i = 0;
        while (i < nodes.length) {
            tm.put(nodes[i], new Integer(i));
            ++i;
        }
        int[] perm = new int[nodes.length];
        Iterator it = tm.entrySet().iterator();
        int i2 = 0;
        while (i2 < perm.length) {
            Map.Entry entry = it.next();
            int oldPos = (Integer)entry.getValue();
            perm[oldPos] = i2++;
        }
        return perm;
    }

    public static int[] computePermutation(Node[] arr1, Node[] arr2) throws IllegalArgumentException {
        if (arr1.length != arr2.length) {
            int max = Math.max(arr1.length, arr2.length);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < max) {
                sb.append(i + " ");
                if (i < arr1.length) {
                    sb.append(arr1[i].getName());
                } else {
                    sb.append("---");
                }
                sb.append(" = ");
                if (i < arr2.length) {
                    sb.append(arr2[i].getName());
                } else {
                    sb.append("---");
                }
                sb.append('\n');
                ++i;
            }
            throw new IllegalArgumentException(sb.toString());
        }
        HashMap<Node, Integer> map = new HashMap<Node, Integer>();
        int i = 0;
        while (i < arr2.length) {
            map.put(arr2[i], new Integer(i));
            ++i;
        }
        int[] perm = new int[arr1.length];
        int diff = 0;
        int i2 = 0;
        while (i2 < arr1.length) {
            Integer newPos = (Integer)map.get(arr1[i2]);
            if (newPos == null) {
                throw new IllegalArgumentException("Missing permutation index " + i2);
            }
            perm[i2] = newPos;
            if (perm[i2] != i2) {
                ++diff;
            }
            ++i2;
        }
        return diff == 0 ? null : perm;
    }

    public static Node.Handle[] toHandles(Node[] nodes) {
        LinkedList<Node.Handle> ll = new LinkedList<Node.Handle>();
        int i = 0;
        while (i < nodes.length) {
            Node.Handle h = nodes[i].getHandle();
            if (h != null) {
                ll.add(h);
            }
            ++i;
        }
        return ll.toArray(new Node.Handle[ll.size()]);
    }

    public static Node[] fromHandles(Node.Handle[] handles) throws IOException {
        Node[] arr = new Node[handles.length];
        int i = 0;
        while (i < handles.length) {
            arr[i] = handles[i].getNode();
            ++i;
        }
        return arr;
    }

    static SystemAction[] createFromNames(String[] arr) {
        ErrorManager err = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = NodeOp.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        LinkedList<SystemAction> ll = new LinkedList<SystemAction>();
        int i = 0;
        while (i < arr.length) {
            block5: {
                if (arr[i] == null) {
                    ll.add(null);
                } else {
                    String name = "org.openide.actions." + arr[i] + "Action";
                    try {
                        Class<?> c = Class.forName(name);
                        ll.add(SystemAction.get(c));
                    }
                    catch (ClassNotFoundException ex) {
                        if (err == null) break block5;
                        err.log(1, "NodeOp.java: Missing class " + name);
                    }
                }
            }
            ++i;
        }
        return ll.toArray(new SystemAction[ll.size()]);
    }

    static void exception(Throwable ex) {
        ErrorManager.getDefault().notify(1, ex);
    }

    static void warning(Throwable ex) {
        ErrorManager.getDefault().notify(16, ex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

