/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.SourceException;

public final class InitializerElement
extends Element
implements Cloneable {
    private ClassElement declaringClass;
    static final long serialVersionUID = 5768667690932077280L;

    public InitializerElement() {
        this(new Memory(), null);
    }

    public InitializerElement(Impl impl, ClassElement declaringClass) {
        super(impl);
        this.declaringClass = declaringClass;
    }

    Impl getInitializerImpl() {
        return (Impl)this.impl;
    }

    public Object clone() {
        return new InitializerElement(new Memory(this), null);
    }

    public void setStatic(boolean stat) throws SourceException {
        this.getInitializerImpl().setStatic(stat);
    }

    public boolean isStatic() {
        return this.getInitializerImpl().isStatic();
    }

    public void setBody(String s) throws SourceException {
        this.getInitializerImpl().setBody(s);
    }

    public String getBody() {
        return this.getInitializerImpl().getBody();
    }

    public JavaDoc getJavaDoc() {
        return this.getInitializerImpl().getJavaDoc();
    }

    public final ClassElement getDeclaringClass() {
        return this.declaringClass;
    }

    public void print(ElementPrinter printer) throws ElementPrinterInterruptException {
        printer.markInitializer(this, 0);
        JavaDoc doc = this.getJavaDoc();
        if (doc != null && !doc.isEmpty()) {
            printer.markInitializer(this, 2);
            Element.printJavaDoc(doc, printer);
            printer.markInitializer(this, 3);
            printer.println("");
        }
        if (this.isStatic()) {
            printer.markInitializer(this, 4);
            printer.print("static ");
            printer.markInitializer(this, 5);
        }
        printer.print("{");
        printer.markInitializer(this, 6);
        printer.print(this.getBody());
        printer.markInitializer(this, 7);
        printer.print("}");
        printer.markInitializer(this, 1);
    }

    static class Memory
    extends Element.Memory
    implements Impl {
        private boolean stat;
        private String body;
        private JavaDoc javadoc;
        static final long serialVersionUID = 1956692952966906280L;
        static /* synthetic */ Class class$org$openide$src$ClassElement$Memory;

        Memory() {
            this.stat = false;
            this.body = "";
            this.javadoc = JavaDocSupport.createInitializerJavaDoc(null);
        }

        Memory(InitializerElement el) {
            this.stat = el.isStatic();
            this.body = el.getBody();
            this.javadoc = el.getJavaDoc().isEmpty() ? JavaDocSupport.createJavaDoc(null) : JavaDocSupport.createJavaDoc(el.getJavaDoc().getRawText());
        }

        public void setStatic(boolean stat) {
            boolean old = stat;
            this.stat = stat;
            this.firePropertyChange("static", new Boolean(old), new Boolean(stat));
        }

        public boolean isStatic() {
            return this.stat;
        }

        public void setBody(String s) throws SourceException {
            String old = this.body;
            this.body = s;
            this.firePropertyChange("body", old, this.body);
        }

        public String getBody() {
            return this.body;
        }

        public JavaDoc getJavaDoc() {
            return this.javadoc;
        }

        public void markCurrent(boolean after) {
            ClassElement decl = ((InitializerElement)this.element).getDeclaringClass();
            if (decl == null) {
                throw new IllegalStateException();
            }
            ((ClassElement.Memory)decl.getCookie(class$org$openide$src$ClassElement$Memory == null ? (class$org$openide$src$ClassElement$Memory = Memory.class$("org.openide.src.ClassElement$Memory")) : class$org$openide$src$ClassElement$Memory)).markCurrent(this.element, after);
        }

        public Object readResolve() {
            return new InitializerElement(this, null);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Impl
    extends Element.Impl {
        public static final long serialVersionUID = -3742940543185945549L;

        public void setStatic(boolean var1) throws SourceException;

        public boolean isStatic();

        public void setBody(String var1) throws SourceException;

        public String getBody();

        public JavaDoc getJavaDoc();
    }
}

