/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ClassCustomizer;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class ClassElementNode
extends MemberElementNode {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"classOrInterface"};
    private static final String MENU_CREATE_BLOCK;
    private static final String MENU_CREATE_VARIABLE;
    private static final String MENU_CREATE_CONSTRUCTOR;
    private static final String MENU_CREATE_METHOD;
    private static final String MENU_CREATE_CLASS;
    private static final String MENU_CREATE_INTERFACE;
    static /* synthetic */ Class class$org$openide$src$nodes$ClassElementNode;
    static /* synthetic */ Class class$org$openide$src$Element;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Lorg$openide$src$Identifier;

    public ClassElementNode(ClassElement element, Children children, boolean writeable) {
        super(element, children, writeable);
        this.setElementFormat0(element.isInterface() ? ElementNode.sourceOptions.getInterfaceElementFormat() : ElementNode.sourceOptions.getClassElementFormat());
    }

    public HelpCtx getHelpCtx() {
        if (((ClassElement)this.element).isClassOrInterface()) {
            return new HelpCtx("org.openide.src.nodes.ClassNode");
        }
        return new HelpCtx("org.openide.src.nodes.InterfaceNode");
    }

    protected String resolveIconBase() {
        return ((ClassElement)this.element).isInterface() ? "org/openide/resources/src/interface" : "org/openide/resources/src/class";
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getHintElementFormat() {
        return ((ClassElement)this.element).isInterface() ? ElementNode.sourceOptions.getInterfaceElementLongFormat() : ElementNode.sourceOptions.getClassElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        boolean canWrite = this.isWriteable();
        ps.put(this.createModifiersProperty(canWrite));
        ps.put(this.createNameProperty(canWrite));
        if (((ClassElement)this.element).isClass()) {
            ps.put(this.createSuperclassProperty(canWrite));
        }
        ps.put(this.createInterfacesProperty(canWrite));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                ClassElement el = (ClassElement)ClassElementNode.this.element;
                if (el.getDeclaringClass() != null) {
                    el.getDeclaringClass().removeClass(el);
                } else {
                    el.getSource().removeClass(el);
                }
            }
        });
        super.destroy();
    }

    public Component getCustomizer() {
        return new ClassCustomizer((ClassElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected void createPasteTypes(Transferable t, List s) {
        if (this.isWriteable()) {
            if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                this.createMultiPasteTypes(t, s, 1);
                this.createMultiPasteTypes(t, s, 6);
                return;
            }
            int i = 0;
            while (i <= 1) {
                final boolean delete = i == 1;
                final Element addingElement = (Element)NodeTransfer.cookie(t, delete ? 6 : 1, class$org$openide$src$Element == null ? ClassElementNode.class$("org.openide.src.Element") : class$org$openide$src$Element);
                if (addingElement != null) {
                    s.add(new PasteType(){

                        public Transferable paste() throws IOException {
                            ClassElementNode.this.pasteElement(addingElement, delete);
                            return delete ? ExTransferable.EMPTY : null;
                        }
                    });
                }
                ++i;
            }
        }
        super.createPasteTypes(t, s);
    }

    private void createMultiPasteTypes(Transferable t, List s, int action) {
        MultiTransferObject mto;
        try {
            mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
        }
        catch (UnsupportedFlavorException ex) {
            return;
        }
        catch (IOException ex) {
            return;
        }
        int count = mto.getCount();
        LinkedList candidates = new LinkedList();
        int i = 0;
        while (i < count) {
            Element el;
            Node n = NodeTransfer.node(mto.getTransferableAt(i), action);
            if (n == null || (el = (Element)n.getCookie(class$org$openide$src$Element == null ? ClassElementNode.class$("org.openide.src.Element") : class$org$openide$src$Element)) == null || !(el instanceof MemberElement) && !(el instanceof InitializerElement)) break;
            this.addNodeCandidate(candidates, el);
            ++i;
        }
        if (candidates.isEmpty()) {
            return;
        }
        s.add(new SourceEditSupport.ClassMultiPasteType(this, candidates, (action & 6) > 0));
    }

    private void addNodeCandidate(Collection candidates, Element el) {
        ClassElement enc2 = this.findEnclosingClass(el);
        SourceElement enc2Src = enc2.getSource();
        String fn2 = enc2.getName().getFullName();
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            Element can = (Element)it.next();
            ClassElement enc1 = this.findEnclosingClass(can);
            if (enc1.getSource() != enc2Src) continue;
            if (enc1 == enc2) {
                if (can == enc1) {
                    return;
                }
                if (el != enc2) break;
                it.remove();
                continue;
            }
            String fn1 = enc1.getName().getFullName();
            if (fn2.startsWith(fn1)) {
                if (enc1 != can) continue;
                return;
            }
            if (!fn1.startsWith(fn2)) continue;
            if (enc2 != el) break;
            it.remove();
        }
        candidates.add(el);
    }

    private ClassElement findEnclosingClass(Element el) {
        if (el instanceof ClassElement) {
            return (ClassElement)el;
        }
        if (el instanceof MemberElement) {
            return ((MemberElement)el).getDeclaringClass();
        }
        if (el instanceof InitializerElement) {
            return ((InitializerElement)el).getDeclaringClass();
        }
        return null;
    }

    PropertyChangeListener createElementListener() {
        return new ClassElementListener();
    }

    void pasteElement(final Element addingElement, final boolean delete) throws IOException {
        final boolean[] cancelled = new boolean[]{false};
        if (addingElement instanceof ClassElement) {
            ClassElement declClazz = (ClassElement)addingElement;
            ClassElement myDecl = (ClassElement)this.element;
            while (myDecl != null) {
                if (declClazz == myDecl) {
                    throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Recursion detected"), ElementNode.bundle.getString("ERR_RecursePaste"));
                }
                myDecl = myDecl.getDeclaringClass();
            }
        }
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                ClassElement clazz = (ClassElement)ClassElementNode.this.element;
                if (addingElement instanceof InitializerElement) {
                    InitializerElement e = (InitializerElement)addingElement;
                    clazz.addInitializer(e);
                }
                if (addingElement instanceof FieldElement) {
                    clazz.addField((FieldElement)addingElement);
                } else if (addingElement instanceof MethodElement) {
                    MethodElement me = (MethodElement)addingElement;
                    if (((ClassElement)ClassElementNode.this.element).isInterface()) {
                        if (delete && me.getBody() != null && !me.getBody().trim().equals("") && !ClassElementNode.this.isPastingConfirmed(me)) {
                            cancelled[0] = true;
                            return;
                        }
                        me = (MethodElement)me.clone();
                        me.setBody(null);
                    } else if (me.getBody() == null) {
                        me = (MethodElement)me.clone();
                        me.setBody("");
                    }
                    clazz.addMethod(me);
                } else if (addingElement instanceof ConstructorElement) {
                    clazz.addConstructor((ConstructorElement)addingElement);
                } else if (addingElement instanceof ClassElement) {
                    ClassElement pclass = (ClassElement)addingElement;
                    clazz.addClass(pclass);
                    ClassElement myClass = clazz.getClass(Identifier.create(pclass.getName().getName()));
                    if (pclass.getDeclaringClass() == null && myClass != null) {
                        myClass.setModifiers(myClass.getModifiers() | 8);
                    }
                }
            }
        });
        if (delete && !cancelled[0]) {
            ClassElement origClazz;
            SourceElement src = null;
            if (addingElement instanceof InitializerElement) {
                origClazz = ((InitializerElement)addingElement).getDeclaringClass();
            } else if (addingElement instanceof MemberElement) {
                origClazz = ((MemberElement)addingElement).getDeclaringClass();
                if (addingElement instanceof ClassElement) {
                    ClassElement me = (ClassElement)addingElement;
                    src = me.getSource();
                }
            } else {
                origClazz = null;
            }
            if (src == null && origClazz != null) {
                src = origClazz.getSource();
            }
            final SourceElement classSource = src;
            SourceEditSupport.ExceptionalRunnable r = new SourceEditSupport.ExceptionalRunnable(){

                public void run() throws SourceException {
                    if (addingElement instanceof InitializerElement) {
                        InitializerElement e = (InitializerElement)addingElement;
                        if (origClazz != null) {
                            origClazz.removeInitializer(e);
                        }
                    } else if (addingElement instanceof MemberElement) {
                        if (origClazz != null) {
                            if (addingElement instanceof FieldElement) {
                                origClazz.removeField((FieldElement)addingElement);
                            } else if (addingElement instanceof MethodElement) {
                                origClazz.removeMethod((MethodElement)addingElement);
                            } else if (addingElement instanceof ConstructorElement) {
                                origClazz.removeConstructor((ConstructorElement)addingElement);
                            } else if (addingElement instanceof ClassElement) {
                                origClazz.removeClass((ClassElement)addingElement);
                            }
                        } else if (addingElement instanceof ClassElement && classSource != null) {
                            classSource.removeClass((ClassElement)addingElement);
                        }
                    }
                }
            };
            if (src == null) {
                try {
                    r.run();
                }
                catch (SourceException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                SourceEditSupport.invokeAtomicAsUser(addingElement, r);
            }
        }
    }

    private boolean isPastingConfirmed(MethodElement me) {
        String title = NbBundle.getMessage(class$org$openide$src$nodes$ClassElementNode == null ? (class$org$openide$src$nodes$ClassElementNode = ClassElementNode.class$("org.openide.src.nodes.ClassElementNode")) : class$org$openide$src$nodes$ClassElementNode, "TIT_PastingMethod");
        String text = NbBundle.getMessage(class$org$openide$src$nodes$ClassElementNode == null ? (class$org$openide$src$nodes$ClassElementNode = ClassElementNode.class$("org.openide.src.nodes.ClassElementNode")) : class$org$openide$src$nodes$ClassElementNode, "CONFIRM_DeleteMethodBody", me.getName());
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)text, title, 0);
        return NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify(desc));
    }

    protected Node.Property createSuperclassProperty(boolean canW) {
        return new ElementNode.ElementProp("superclass", class$java$lang$String == null ? (class$java$lang$String = ClassElementNode.class$("java.lang.String")) : class$java$lang$String, canW){

            public Object getValue() {
                Identifier id = ((ClassElement)ClassElementNode.this.element).getSuperclass();
                return id == null ? "" : id.getFullName();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Type t;
                super.setValue(val);
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                String str = ((String)val).trim();
                if (str != null && !"".equals(str) && !(t = Type.parse(str)).isClass()) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ClassElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, str){
                    private final /* synthetic */ String val$str;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$str = val$str;
                    }

                    public void run() throws SourceException {
                        Identifier superclass = this.val$str.equals("") ? null : Identifier.create(this.val$str);
                        ((ClassElement)5.access$200(this.this$1).element).setSuperclass(superclass);
                    }
                });
            }

            static /* synthetic */ ClassElementNode access$200(5 x0) {
                return x0.ClassElementNode.this;
            }
        };
    }

    protected Node.Property createInterfacesProperty(boolean canW) {
        ElementNode.ElementProp prop = new ElementNode.ElementProp("interfaces", array$Lorg$openide$src$Identifier == null ? (array$Lorg$openide$src$Identifier = ClassElementNode.class$("[Lorg.openide.src.Identifier;")) : array$Lorg$openide$src$Identifier, canW){

            public Object getValue() {
                return ((ClassElement)ClassElementNode.this.element).getInterfaces();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Identifier[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ClassElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((ClassElement)7.access$300(this.this$1).element).setInterfaces((Identifier[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ClassElementNode access$300(7 x0) {
                return x0.ClassElementNode.this;
            }
        };
        if (((ClassElement)this.element).isInterface()) {
            prop.setDisplayName(ElementNode.bundle.getString("PROP_superInterfaces"));
            prop.setShortDescription(ElementNode.bundle.getString("HINT_superInterfaces"));
        }
        prop.setValue("changeImmediate", Boolean.FALSE);
        return prop;
    }

    public NewType[] getNewTypes() {
        if (this.isWriteable()) {
            return SourceEditSupport.createNewTypes((ClassElement)this.element);
        }
        return super.getNewTypes();
    }

    public Transferable clipboardCopy() {
        ExTransferable.Single t = NodeTransfer.transferable(this, 1);
        ExTransferable xt = ExTransferable.create(t);
        xt.put(NodeTransfer.createPaste(new SourceEditSupport.PackagePaste((ClassElement)this.element, false)));
        return xt;
    }

    public Transferable clipboardCut() {
        ExTransferable.Single t = NodeTransfer.transferable(this, 4);
        ExTransferable xt = ExTransferable.create(t);
        xt.put(NodeTransfer.createPaste(new SourceEditSupport.PackagePaste((ClassElement)this.element, true)));
        return xt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$src$nodes$ClassElementNode == null ? (class$org$openide$src$nodes$ClassElementNode = ClassElementNode.class$("org.openide.src.nodes.ClassElementNode")) : class$org$openide$src$nodes$ClassElementNode);
        MENU_CREATE_BLOCK = bundle.getString("MENU_CREATE_BLOCK");
        MENU_CREATE_VARIABLE = bundle.getString("MENU_CREATE_VARIABLE");
        MENU_CREATE_CONSTRUCTOR = bundle.getString("MENU_CREATE_CONSTRUCTOR");
        MENU_CREATE_METHOD = bundle.getString("MENU_CREATE_METHOD");
        MENU_CREATE_CLASS = bundle.getString("MENU_CREATE_CLASS");
        MENU_CREATE_INTERFACE = bundle.getString("MENU_CREATE_INTERFACE");
    }

    private class ClassElementListener
    extends ElementNode.ElementListener {
        private ClassElementListener() {
            super(ClassElementNode.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("classOrInterface")) {
                ClassElementNode.this.setElementFormat(((ClassElement)ClassElementNode.this.element).isClass() ? ElementNode.sourceOptions.getClassElementFormat() : ElementNode.sourceOptions.getInterfaceElementFormat());
            }
            super.propertyChange(evt);
        }
    }
}

