/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.src.Element;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.SourceEditSupport;

class ElementBeanModel
implements PropertyModel {
    private PropertyModel original;
    private Element bean;

    public ElementBeanModel(Element bean, String propertyName) {
        this(bean, new DefaultPropertyModel((Object)bean, propertyName));
    }

    public ElementBeanModel(Element bean, PropertyModel original) {
        this.bean = bean;
        this.original = original;
    }

    public Class getPropertyEditorClass() {
        return this.original.getPropertyEditorClass();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.original.removePropertyChangeListener(l);
    }

    public Class getPropertyType() {
        return this.original.getPropertyType();
    }

    public Object getValue() throws InvocationTargetException {
        return this.original.getValue();
    }

    public void setValue(final Object v) throws InvocationTargetException {
        final InvocationTargetException[] ex = new InvocationTargetException[1];
        Throwable[] ex2 = new Throwable[]{null};
        SourceElement srcel = SourceEditSupport.findSource(this.bean);
        if (srcel == null) {
            this.original.setValue(v);
            return;
        }
        try {
            srcel.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        ElementBeanModel.this.original.setValue(v);
                    }
                    catch (InvocationTargetException e) {
                        ex[0] = e;
                        ErrorManager.getDefault().annotate((Throwable)e, e.getTargetException());
                    }
                }
            });
        }
        catch (SourceException e) {
            ex[0] = new InvocationTargetException(e);
            ErrorManager.getDefault().annotate((Throwable)ex[0], e);
        }
        if (ex[0] == null) {
            return;
        }
        throw ex[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.original.addPropertyChangeListener(l);
    }
}

