/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementProperties;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.IconStrings;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.src.nodes.SourceOptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public abstract class ElementNode
extends AbstractNode
implements IconStrings,
ElementProperties {
    static ResourceBundle bundle = NbBundle.getBundle(class$org$openide$src$nodes$ElementNode == null ? (class$org$openide$src$nodes$ElementNode = ElementNode.class$("org.openide.src.nodes.ElementNode")) : class$org$openide$src$nodes$ElementNode);
    private static ElementFormat invalidFormat;
    protected static final SourceOptions sourceOptions;
    private static final String[] ICON_AFFECTING_PROPERTIES;
    protected Element element;
    protected ElementFormat elementFormat = new ElementFormat("");
    protected boolean writeable;
    private transient PropertyChangeListener listener;
    static /* synthetic */ Class class$org$openide$src$nodes$ElementNode;
    static /* synthetic */ Class class$org$openide$src$nodes$SourceOptions;

    public ElementNode(Element element, Children children, boolean writeable) {
        super(children);
        this.element = element;
        this.writeable = writeable;
        this.setIconBase(this.resolveIconBase());
        this.setDisplayName(this.getElementFormat().format(element));
        this.listener = this.createElementListener();
        element.addPropertyChangeListener(WeakListener.propertyChange(this.listener, element));
        this.displayFormat = null;
    }

    public String getShortDescription() {
        try {
            return this.getHintElementFormat().format(this.element);
        }
        catch (IllegalArgumentException e) {
            return super.getShortDescription();
        }
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public final ElementFormat getElementFormat() {
        return this.elementFormat;
    }

    public final void setElementFormat(ElementFormat elementFormat) {
        this.setDisplayName(elementFormat.format(this.element));
        this.elementFormat = elementFormat;
    }

    final void setElementFormat0(ElementFormat elementFormat) {
        try {
            this.setElementFormat(elementFormat);
        }
        catch (IllegalArgumentException iae) {
            this.setElementFormat(ElementNode.getInvalidFormat());
        }
    }

    static ElementFormat getInvalidFormat() {
        if (invalidFormat != null) {
            return invalidFormat;
        }
        invalidFormat = new ElementFormat(bundle.getString("FMT_InvalidFormat"));
        return invalidFormat;
    }

    protected abstract ElementFormat getHintElementFormat();

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$src$nodes$ElementNode == null ? (class$org$openide$src$nodes$ElementNode = ElementNode.class$("org.openide.src.nodes.ElementNode")) : class$org$openide$src$nodes$ElementNode);
    }

    public boolean canRename() {
        return this.isWriteable();
    }

    public boolean canDestroy() {
        return this.isWriteable();
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable ex = ExTransferable.create(super.clipboardCopy());
        ex.put(new ElementStringTransferable());
        return ex;
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.isWriteable()) {
            throw new IOException();
        }
        ExTransferable ex = ExTransferable.create(super.clipboardCut());
        ex.put(new ElementStringTransferable());
        return ex;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.isWriteable();
    }

    public void setActions(SystemAction[] actions) {
        this.systemActions = actions;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie c = super.getCookie(type);
        if (c == null) {
            c = this.element.getCookie(type);
        }
        return c;
    }

    public boolean equals(Object o) {
        return o instanceof ElementNode && this.element.equals(((ElementNode)o).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public Node.Handle getHandle() {
        Node.Handle supe = super.getHandle();
        if (supe != null) {
            return supe;
        }
        if (this.element instanceof SourceElement) {
            return null;
        }
        return new ElementNodeHandle(this.element, this.writeable, this.elementFormat);
    }

    boolean isWriteable() {
        return this.writeable && SourceEditSupport.isWriteable(this.element);
    }

    void superSetName(String name) {
        super.setName(name);
    }

    void superPropertyChange(String name, Object o, Object n) {
        super.firePropertyChange(name, o, n);
    }

    void superShortDescriptionChange(String o, String n) {
        super.fireShortDescriptionChange(o, n);
    }

    PropertyChangeListener createElementListener() {
        return new ElementListener();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        sourceOptions = (SourceOptions)SharedClassObject.findObject(class$org$openide$src$nodes$SourceOptions == null ? (class$org$openide$src$nodes$SourceOptions = ElementNode.class$("org.openide.src.nodes.SourceOptions")) : class$org$openide$src$nodes$SourceOptions, true);
        ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    }

    static abstract class ElementProp
    extends PropertySupport {
        public ElementProp(String name, Class type, boolean canW) {
            super(name, type, bundle.getString("PROP_" + name), bundle.getString("HINT_" + name), true, canW);
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(bundle.getString("MSG_Cannot_Write"));
            }
        }

        void runAtomic(Element element, SourceEditSupport.ExceptionalRunnable exRun) throws InvocationTargetException {
            SourceException[] ex = new SourceException[]{null};
            try {
                SourceElement source = SourceEditSupport.findSource(element);
                if (source == null) {
                    exRun.run();
                } else {
                    Runnable run = new Runnable(this, exRun, ex){
                        private final /* synthetic */ SourceEditSupport.ExceptionalRunnable val$exRun;
                        private final /* synthetic */ SourceException[] val$ex;
                        private final /* synthetic */ ElementProp this$0;
                        {
                            this.this$0 = this$0;
                            this.val$exRun = val$exRun;
                            this.val$ex = val$ex;
                        }

                        public void run() {
                            try {
                                this.val$exRun.run();
                            }
                            catch (SourceException e) {
                                this.val$ex[0] = e;
                            }
                        }
                    };
                    source.runAtomicAsUser(run);
                }
            }
            catch (SourceException e) {
                ex[0] = e;
            }
            if (ex[0] != null) {
                throw new InvocationTargetException(ex[0]);
            }
        }
    }

    class ElementListener
    implements PropertyChangeListener {
        ElementListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null) {
                ElementNode.this.setDisplayName(ElementNode.this.getElementFormat().format(ElementNode.this.element));
                ElementNode.this.setIconBase(ElementNode.this.resolveIconBase());
            } else {
                if ("valid".equals(propName)) {
                    ElementNode.super.fireNodeDestroyed();
                    return;
                }
                if (ElementNode.this.getElementFormat().dependsOnProperty(propName)) {
                    ElementNode.this.setDisplayName(ElementNode.this.getElementFormat().format(ElementNode.this.element));
                }
                String[] iconProps = ElementNode.this.getIconAffectingProperties();
                int i = 0;
                while (i < iconProps.length) {
                    if (iconProps[i].equals(propName)) {
                        ElementNode.this.setIconBase(ElementNode.this.resolveIconBase());
                        break;
                    }
                    ++i;
                }
                if (propName.equals("name")) {
                    try {
                        ElementNode.this.superSetName(((MemberElement)ElementNode.this.element).getName().toString());
                    }
                    catch (ClassCastException e) {}
                } else if (propName.equals("cookie")) {
                    ElementNode.this.superFireCookieChange();
                    return;
                }
            }
            if (ElementNode.this.getHintElementFormat().dependsOnProperty(evt.getPropertyName())) {
                ElementNode.this.superShortDescriptionChange("", ElementNode.this.getShortDescription());
            }
            ElementNode.this.superPropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    private static final class ElementNodeHandle
    implements Node.Handle {
        private static final long serialVersionUID = 910667289626540L;
        private Element element;
        private boolean writable;
        private ElementFormat elementFormat;

        public ElementNodeHandle(Element element, boolean writable, ElementFormat elementFormat) {
            this.element = element;
            this.writable = writable;
            this.elementFormat = elementFormat;
        }

        public Node getNode() throws IOException {
            Node n;
            DefaultFactory factory = new DefaultFactory(this.writable);
            if (this.element instanceof ClassElement) {
                n = factory.createClassNode((ClassElement)this.element);
            } else if (this.element instanceof ConstructorElement) {
                n = factory.createConstructorNode((ConstructorElement)this.element);
            } else if (this.element instanceof FieldElement) {
                n = factory.createFieldNode((FieldElement)this.element);
            } else if (this.element instanceof InitializerElement) {
                n = factory.createInitializerNode((InitializerElement)this.element);
            } else if (this.element instanceof MethodElement) {
                n = factory.createMethodNode((MethodElement)this.element);
            } else {
                throw new IOException("what is element " + this.element + "? cannot restore node");
            }
            if (n instanceof ElementNode) {
                ((ElementNode)n).setElementFormat(this.elementFormat);
            }
            return n;
        }

        public String toString() {
            return "ElementNodeHandle[" + this.element + "]";
        }
    }

    class ElementStringTransferable
    extends ExTransferable.Single {
        ElementStringTransferable() {
            super(DataFlavor.stringFlavor);
        }

        protected Object getData() {
            return ElementNode.this.element.toString();
        }
    }
}

