/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.FieldCustomizer;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class FieldElementNode
extends MemberElementNode {
    static /* synthetic */ Class class$org$openide$src$Type;
    static /* synthetic */ Class class$java$lang$String;

    public FieldElementNode(FieldElement element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        this.setElementFormat0(ElementNode.sourceOptions.getFieldElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.FieldNode");
    }

    protected String resolveIconBase() {
        int modif = ((FieldElement)this.element).getModifiers();
        if (!Modifier.isStatic(modif)) {
            if (Modifier.isPrivate(modif)) {
                return "org/openide/resources/src/variablePrivate";
            }
            if (Modifier.isProtected(modif)) {
                return "org/openide/resources/src/variableProtected";
            }
            if (Modifier.isPublic(modif)) {
                return "org/openide/resources/src/variablePublic";
            }
            return "org/openide/resources/src/variablePackage";
        }
        if (Modifier.isPrivate(modif)) {
            return "org/openide/resources/src/variableStPrivate";
        }
        if (Modifier.isProtected(modif)) {
            return "org/openide/resources/src/variableStProtected";
        }
        if (Modifier.isPublic(modif)) {
            return "org/openide/resources/src/variableStPublic";
        }
        return "org/openide/resources/src/variableStPackage";
    }

    protected ElementFormat getHintElementFormat() {
        return ElementNode.sourceOptions.getFieldElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.isWriteable()));
        ps.put(this.createNameProperty(this.isWriteable()));
        ps.put(this.createTypeProperty(this.isWriteable()));
        ps.put(this.createInitValueProperty(this.isWriteable()));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                FieldElement el = (FieldElement)FieldElementNode.this.element;
                el.getDeclaringClass().removeField(el);
            }
        });
        super.destroy();
    }

    public Component getCustomizer() {
        return new FieldCustomizer((FieldElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected Node.Property createTypeProperty(boolean canW) {
        ElementNode.ElementProp prop = new ElementNode.ElementProp("type", class$org$openide$src$Type == null ? (class$org$openide$src$Type = FieldElementNode.class$("org.openide.src.Type")) : class$org$openide$src$Type, canW){

            public Object getValue() {
                return ((FieldElement)FieldElementNode.this.element).getType();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(FieldElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((FieldElement)2.access$000(this.this$1).element).setType((Type)this.val$val);
                    }
                });
            }

            static /* synthetic */ FieldElementNode access$000(2 x0) {
                return x0.FieldElementNode.this;
            }
        };
        prop.setValue("acceptVoidType", Boolean.FALSE);
        return prop;
    }

    protected Node.Property createInitValueProperty(boolean canW) {
        return new ElementNode.ElementProp("initValue", class$java$lang$String == null ? (class$java$lang$String = FieldElementNode.class$("java.lang.String")) : class$java$lang$String, canW){

            public Object getValue() {
                return ((FieldElement)FieldElementNode.this.element).getInitValue();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(FieldElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((FieldElement)4.access$100(this.this$1).element).setInitValue((String)this.val$val);
                    }
                });
            }

            static /* synthetic */ FieldElementNode access$100(4 x0) {
                return x0.FieldElementNode.this;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

