/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ConstructorElementNode;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class MethodElementNode
extends ConstructorElementNode {
    static /* synthetic */ Class class$org$openide$src$Type;

    public MethodElementNode(MethodElement element, boolean writeable) {
        super(element, writeable);
        this.setElementFormat0(ElementNode.sourceOptions.getMethodElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.MethodNode");
    }

    protected String resolveIconBase() {
        int modif = ((MethodElement)this.element).getModifiers();
        if (Modifier.isStatic(modif)) {
            if (Modifier.isPrivate(modif)) {
                return "org/openide/resources/src/methodStPrivate";
            }
            if (Modifier.isProtected(modif)) {
                return "org/openide/resources/src/methodStProtected";
            }
            if (Modifier.isPublic(modif)) {
                return "org/openide/resources/src/methodStPublic";
            }
            return "org/openide/resources/src/methodStPackage";
        }
        if (Modifier.isPrivate(modif)) {
            return "org/openide/resources/src/methodPrivate";
        }
        if (Modifier.isProtected(modif)) {
            return "org/openide/resources/src/methodProtected";
        }
        if (Modifier.isPublic(modif)) {
            return "org/openide/resources/src/methodPublic";
        }
        return "org/openide/resources/src/methodPackage";
    }

    public boolean canRename() {
        return true;
    }

    protected ElementFormat getHintElementFormat() {
        return ElementNode.sourceOptions.getMethodElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.isWriteable()));
        ps.put(this.createNameProperty(this.isWriteable()));
        ps.put(this.createParametersProperty(this.isWriteable()));
        ps.put(this.createReturnProperty(this.isWriteable()));
        ps.put(this.createExceptionsProperty(this.isWriteable()));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                MethodElement el = (MethodElement)MethodElementNode.this.element;
                el.getDeclaringClass().removeMethod(el);
            }
        });
        super.destroy();
    }

    protected Node.Property createReturnProperty(boolean canW) {
        return new ElementNode.ElementProp("return", class$org$openide$src$Type == null ? (class$org$openide$src$Type = MethodElementNode.class$("org.openide.src.Type")) : class$org$openide$src$Type, canW){

            public Object getValue() {
                return ((MethodElement)MethodElementNode.this.element).getReturn();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(MethodElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, val){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$val = val$val;
                    }

                    public void run() throws SourceException {
                        ((MethodElement)2.access$000(this.this$1).element).setReturn((Type)this.val$val);
                    }
                });
            }

            static /* synthetic */ MethodElementNode access$000(2 x0) {
                return x0.MethodElementNode.this;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

