/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.cookies.FilterCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.SourceElementFilter;
import org.openide.util.Task;
import org.openide.util.WeakListener;

public class SourceChildren
extends Children.Keys
implements FilterCookie {
    static final Object NOT_KEY = new Object();
    static final Object ERROR_KEY = new Object();
    private static int PPP_MASK = 7;
    protected SourceElement element;
    protected SourceElementFilter filter;
    protected ElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private ElementListener propL;
    private boolean nodesInited = false;
    static /* synthetic */ Class class$org$openide$src$nodes$SourceElementFilter;

    public SourceChildren() {
        this(DefaultFactory.READ_WRITE, null);
    }

    public SourceChildren(SourceElement element) {
        this(DefaultFactory.READ_WRITE, element);
    }

    public SourceChildren(ElementNodeFactory factory) {
        this(factory, null);
    }

    public SourceChildren(ElementNodeFactory factory, SourceElement element) {
        this.element = element;
        this.factory = factory;
        this.filter = new SourceElementFilter();
    }

    public Class getFilterClass() {
        return class$org$openide$src$nodes$SourceElementFilter == null ? (class$org$openide$src$nodes$SourceElementFilter = SourceChildren.class$("org.openide.src.nodes.SourceElementFilter")) : class$org$openide$src$nodes$SourceElementFilter;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        if (!(filter instanceof SourceElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (SourceElementFilter)filter;
        if (this.nodesInited) {
            this.refreshKeys();
        }
    }

    protected void addNotify() {
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new ElementListener();
                this.wPropL = WeakListener.propertyChange(this.propL, this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
            this.element.prepare();
        }
        this.refreshKeys();
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof ClassElement) {
            return new Node[]{this.factory.createClassNode((ClassElement)key)};
        }
        if (NOT_KEY.equals(key)) {
            return new Node[]{this.factory.createWaitNode()};
        }
        return new Node[]{this.factory.createErrorNode()};
    }

    public Node[] getNodes(boolean initialize) {
        if (!initialize) {
            return super.getNodes();
        }
        Task t = this.element.prepare();
        t.waitFinished();
        this.refreshKeys();
        Node[] result = this.getNodes();
        t.isFinished();
        return result;
    }

    public Node findChild(String name) {
        Node supe = super.findChild(name);
        if (supe != null) {
            return supe;
        }
        if (this.element != null) {
            Task t = this.element.prepare();
            t.waitFinished();
            this.refreshKeys();
            Node n = super.findChild(name);
            t.isFinished();
            return n;
        }
        return null;
    }

    public SourceElement getElement() {
        return this.element;
    }

    public void setElement(SourceElement element) {
        if (this.element != null) {
            this.element.removePropertyChangeListener(this.wPropL);
        }
        this.element = element;
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new ElementListener();
                this.wPropL = WeakListener.propertyChange(this.propL, this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
        }
        if (this.nodesInited) {
            if (this.element != null) {
                this.element.prepare();
            }
            this.refreshKeys();
        }
    }

    private void refreshKeys() {
        int status = this.element == null ? 1 : this.element.getStatus();
        switch (status) {
            case 0: {
                this.setKeys(new Object[]{NOT_KEY});
                this.element.prepare();
                break;
            }
            case 1: {
                this.setKeys(new Object[]{ERROR_KEY});
                break;
            }
            case 2: 
            case 3: {
                this.refreshAllKeys();
            }
        }
    }

    private void refreshAllKeys() {
        int[] order = this.filter == null || this.filter.getOrder() == null ? SourceElementFilter.DEFAULT_ORDER : this.filter.getOrder();
        LinkedList keys = new LinkedList();
        int i = 0;
        while (i < order.length) {
            this.addKeysOfType(keys, order[i]);
            ++i;
        }
        this.setKeys(keys);
    }

    private void addKeysOfType(Collection keys, int elementType) {
        if (elementType == 1) {
            return;
        }
        List<ClassElement> cls = this.filter != null && this.filter.isAllClasses() ? Arrays.asList(this.element.getAllClasses()) : Arrays.asList(this.element.getClasses());
        int i = 0;
        while (i < cls.size()) {
            ClassElement classElement = cls.get(i);
            int modifiers = classElement.getModifiers();
            if ((modifiers & PPP_MASK) == 0) {
                modifiers += 65536;
            }
            if ((this.filter.getModifiers() & modifiers) != 0) {
                if (classElement.isClass()) {
                    if ((elementType & 2) != 0) {
                        keys.add(classElement);
                    }
                } else if ((elementType & 4) != 0) {
                    keys.add(classElement);
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ElementListener
    implements PropertyChangeListener {
        private ElementListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean refresh = "classes".equals(evt.getPropertyName());
            if (!refresh && "status".equals(evt.getPropertyName())) {
                Integer val = (Integer)evt.getNewValue();
                boolean bl = refresh = val == null || val != 0;
            }
            if (refresh) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SourceChildren.this.refreshKeys();
                    }
                });
            }
        }
    }
}

