/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ClassCustomizer;
import org.openide.src.nodes.ClassElementNode;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.FieldCustomizer;
import org.openide.src.nodes.MethodCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

class SourceEditSupport {
    static final ResourceBundle bundle = NbBundle.getBundle(class$org$openide$src$nodes$SourceEditSupport == null ? (class$org$openide$src$nodes$SourceEditSupport = SourceEditSupport.class$("org.openide.src.nodes.SourceEditSupport")) : class$org$openide$src$nodes$SourceEditSupport);
    static final String[] MENU_NAMES = new String[]{bundle.getString("MENU_CREATE_BLOCK"), bundle.getString("MENU_CREATE_VARIABLE"), bundle.getString("MENU_CREATE_CONSTRUCTOR"), bundle.getString("MENU_CREATE_METHOD"), bundle.getString("MENU_CREATE_CLASS"), bundle.getString("MENU_CREATE_INTERFACE")};
    static /* synthetic */ Class class$org$openide$src$nodes$SourceEditSupport;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    SourceEditSupport() {
    }

    public static NewType[] createNewTypes(ClassElement element) {
        if (element.isClass()) {
            return new NewType[]{new ElementNewType(element, 0), new ElementNewType(element, 1), new ElementNewType(element, 2), new ElementNewType(element, 3), new ElementNewType(element, 4), new ElementNewType(element, 5)};
        }
        return new NewType[]{new ElementNewType(element, 1), new ElementNewType(element, 3), new ElementNewType(element, 4), new ElementNewType(element, 5)};
    }

    static boolean openCustomizer(Component customizer, String titleKey) {
        NotifyDescriptor desriptor = new NotifyDescriptor(customizer, ElementNode.bundle.getString(titleKey), 2, -1, null, null);
        Object ret = TopManager.getDefault().notify(desriptor);
        return ret == NotifyDescriptor.OK_OPTION;
    }

    static void invokeAtomicAsUser(Element element, final ExceptionalRunnable exRun) throws IOException {
        final SourceException[] ex = new SourceException[]{null};
        try {
            SourceElement source = SourceEditSupport.findSource(element);
            if (source == null) {
                exRun.run();
            } else {
                Runnable run = new Runnable(){

                    public void run() {
                        try {
                            exRun.run();
                        }
                        catch (SourceException e) {
                            ex[0] = e;
                        }
                    }
                };
                source.runAtomicAsUser(run);
            }
        }
        catch (SourceException e) {
            ex[0] = e;
        }
        if (ex[0] != null) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                ex[0].printStackTrace();
            }
            IOException x = new IOException(ex[0].getMessage());
            ErrorManager.getDefault().annotate(x, 256, null, null, ex[0], null);
            throw x;
        }
    }

    static void runAsUser(Element ref, final ExceptionalRunnable exRun) throws SourceException {
        final SourceException[] ex = new SourceException[]{null};
        SourceElement src = SourceEditSupport.findSource(ref);
        if (src == null) {
            exRun.run();
        } else {
            src.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        exRun.run();
                    }
                    catch (SourceException e) {
                        ex[0] = e;
                    }
                }
            });
        }
        if (ex[0] != null) {
            throw ex[0];
        }
    }

    static boolean isWriteable(Element element) {
        DataObject d;
        SourceElement el = SourceEditSupport.findSource(element);
        DataObject dataObject = el == null ? null : (d = (DataObject)el.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SourceEditSupport.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject));
        if (d == null) {
            return true;
        }
        return !d.getPrimaryFile().isReadOnly();
    }

    static SourceElement findSource(Element element) {
        SourceElement source = null;
        ClassElement clazz = null;
        if (element instanceof ClassElement) {
            clazz = (ClassElement)element;
        } else if (element instanceof MemberElement) {
            clazz = ((MemberElement)element).getDeclaringClass();
        } else if (element instanceof InitializerElement) {
            clazz = ((InitializerElement)element).getDeclaringClass();
        } else if (element instanceof SourceElement) {
            return (SourceElement)element;
        }
        if (clazz != null) {
            source = clazz.getSource();
        }
        return source;
    }

    static void createJavaFile(ClassElement clazz, FileObject target) throws SourceException, IOException {
        DataObject targetObject;
        String name = clazz.getName().getSourceName();
        String packageName = target.getPackageName('.');
        if ("".equals(packageName)) {
            packageName = null;
        }
        String newName = FileUtil.findFreeFileName(target, name, "java");
        FileObject newFile = target.createData(name, "java");
        try {
            targetObject = DataObject.find(newFile);
        }
        catch (DataObjectNotFoundException e) {
            throw (IOException)ErrorManager.getDefault().annotate(new IOException(e.getMessage()), 4096, "Data object can't be created", bundle.getString("EXC_CREATE_SOURCE_FILE"), e, null);
        }
        SourceCookie cookie = (SourceCookie)targetObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = SourceEditSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        if (cookie == null) {
            throw (SourceException)ErrorManager.getDefault().annotate((Throwable)new SourceException("Source element cannot be found"), bundle.getString("EXC_CREATE_SOURCE_FILE"));
        }
        if (packageName != null && !"".equals(packageName)) {
            cookie.getSource().setPackage(Identifier.create(packageName));
        }
        cookie.getSource().addClass(clazz);
        ClassElement targetC = cookie.getSource().getClass(Identifier.create(clazz.getName().getSourceName()));
        int mods = targetC.getModifiers() & 0xFFFFFFF7;
        if ((mods & 6) > 0) {
            mods = mods & 0xFFFFFFF9 | 1;
        }
        targetC.setModifiers(mods);
    }

    static void removeClass(ClassElement clazz) throws SourceException {
        if (clazz.getDeclaringClass() != null) {
            clazz.getDeclaringClass().removeClass(clazz);
        } else {
            SourceElement src = SourceEditSupport.findSource(clazz);
            if (src == null) {
                throw (SourceException)ErrorManager.getDefault().annotate((Throwable)new SourceException("Element has no source"), bundle.getString("EXC_NO_SOURCE"));
            }
            src.removeClass(clazz);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ClassMultiPasteType
    extends PasteType {
        ClassElementNode target;
        Collection members;
        boolean delete;

        ClassMultiPasteType(ClassElementNode target, Collection members, boolean delete) {
            this.target = target;
            this.members = members;
            this.delete = delete;
        }

        public Transferable paste() throws IOException {
            Iterator it = this.members.iterator();
            while (it.hasNext()) {
                this.target.pasteElement((Element)it.next(), this.delete);
            }
            if (this.delete) {
                return ExTransferable.EMPTY;
            }
            return null;
        }
    }

    static class PackagePaste
    implements NodeTransfer.Paste {
        private static PasteType[] EMPTY_TYPES = new PasteType[0];
        private boolean deleteSelf;
        private ClassElement element;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        PackagePaste(ClassElement cls, boolean deleteSelf) {
            this.deleteSelf = deleteSelf;
            this.element = cls;
        }

        public PasteType[] types(Node target) {
            DataObject obj = (DataObject)target.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PackagePaste.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.element == null || obj == null) {
                return EMPTY_TYPES;
            }
            FileObject fob = obj.getPrimaryFile();
            if (!fob.isFolder()) {
                return EMPTY_TYPES;
            }
            return new PasteType[]{new Type(fob)};
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class Type
        extends PasteType {
            private FileObject target;

            Type(FileObject target) {
                this.target = target;
            }

            public String getName() {
                return bundle.getString("MENU_PASTE_AS_FILE");
            }

            public HelpCtx getHelpCtx() {
                return super.getHelpCtx();
            }

            public Transferable paste() throws IOException {
                ClassElement clazz = PackagePaste.this.element;
                boolean del = PackagePaste.this.deleteSelf;
                try {
                    SourceEditSupport.createJavaFile(clazz, this.target);
                }
                catch (SourceException ex) {
                    IOException x = new IOException(ex.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)x, ex);
                    throw x;
                }
                if (del) {
                    SourceException[] ex = new SourceException[]{null};
                    SourceEditSupport.invokeAtomicAsUser(clazz, new ExceptionalRunnable(this, clazz, ex){
                        private final /* synthetic */ ClassElement val$clazz;
                        private final /* synthetic */ SourceException[] val$ex;
                        private final /* synthetic */ Type this$1;
                        {
                            this.this$1 = this$1;
                            this.val$clazz = val$clazz;
                            this.val$ex = val$ex;
                        }

                        public void run() throws SourceException {
                            try {
                                SourceEditSupport.removeClass(this.val$clazz);
                            }
                            catch (SourceException e) {
                                this.val$ex[0] = e;
                            }
                        }
                    });
                    if (ex[0] != null) {
                        IOException x = new IOException(ex[0].getMessage());
                        ErrorManager.getDefault().annotate((Throwable)x, ex[0]);
                        throw x;
                    }
                    PackagePaste.this.element = null;
                    return ExTransferable.EMPTY;
                }
                return null;
            }
        }
    }

    static interface ExceptionalRunnable {
        public void run() throws SourceException;
    }

    static class ElementNewType
    extends NewType {
        ClassElement element;
        ClassElement proxy;
        byte kind;
        static /* synthetic */ Class class$org$openide$src$nodes$SourceEditSupport;

        public ElementNewType(ClassElement element, byte kind) {
            this.element = element;
            this.proxy = new ClassElement();
            try {
                this.proxy.setName(Identifier.create("Default"));
                this.proxy.setClassOrInterface(element.isClassOrInterface());
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
            this.kind = kind;
        }

        public String getName() {
            return MENU_NAMES[this.kind];
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx((class$org$openide$src$nodes$SourceEditSupport == null ? (class$org$openide$src$nodes$SourceEditSupport = ElementNewType.class$("org.openide.src.nodes.SourceEditSupport")) : class$org$openide$src$nodes$SourceEditSupport).getName() + ".newElement" + this.kind);
        }

        public void create() throws IOException {
            Identifier outerName = this.element.getName();
            boolean outerIsClass = this.element.isClass();
            Element newElement = null;
            try {
                switch (this.kind) {
                    case 0: {
                        Element e = new InitializerElement();
                        ((InitializerElement)e).setStatic(true);
                        ((InitializerElement)e).setBody("\n");
                        newElement = e;
                        break;
                    }
                    case 1: {
                        Element e = new FieldElement();
                        ((FieldElement)e).setType(Type.INT);
                        ((FieldElement)e).setName(Identifier.create("newField"));
                        ((MemberElement)e).setModifiers(2 + (outerIsClass ? 0 : 8));
                        this.proxy.addField((FieldElement)e);
                        e = this.proxy.getFields()[0];
                        FieldCustomizer cust = new FieldCustomizer((FieldElement)e);
                        if (!SourceEditSupport.openCustomizer(cust, "TIT_NewField") || !cust.isOK()) break;
                        newElement = e;
                        break;
                    }
                    case 2: {
                        Element e = new ConstructorElement();
                        ((MemberElement)e).setName(Identifier.create(this.element.getName().getName()));
                        ((MemberElement)e).setModifiers(1);
                        ((ConstructorElement)e).setBody("\n");
                        MethodCustomizer cust = new MethodCustomizer((ConstructorElement)e);
                        if (!SourceEditSupport.openCustomizer(cust, "TIT_NewConstructor") || !cust.isOK()) break;
                        newElement = e;
                        break;
                    }
                    case 3: {
                        Element e = new MethodElement();
                        ((MethodElement)e).setReturn(Type.VOID);
                        ((MethodElement)e).setName(Identifier.create("newMethod"));
                        ((MemberElement)e).setModifiers(1);
                        ((ConstructorElement)e).setBody(outerIsClass ? "\n" : null);
                        this.proxy.addMethod((MethodElement)e);
                        e = this.proxy.getMethods()[0];
                        MethodCustomizer cust = new MethodCustomizer((ConstructorElement)e);
                        if (!SourceEditSupport.openCustomizer(cust, "TIT_NewMethod") || !cust.isOK()) break;
                        if ((((MemberElement)e).getModifiers() & 0x500) > 0) {
                            ((ConstructorElement)e).setBody(null);
                        }
                        newElement = e;
                        break;
                    }
                    case 4: {
                        Element e = new ClassElement();
                        ((ClassElement)e).setName(Identifier.create(outerName.getFullName() + ".InnerClass", "InnerClass"));
                        ((MemberElement)e).setModifiers(1);
                        ((ClassElement)e).setClassOrInterface(true);
                        this.proxy.addClass((ClassElement)e);
                        e = this.proxy.getClasses()[0];
                        ClassCustomizer cust = new ClassCustomizer((ClassElement)e);
                        if (!SourceEditSupport.openCustomizer(cust, "TIT_NewClass") || !cust.isOK()) break;
                        newElement = e;
                        break;
                    }
                    case 5: {
                        Element e = new ClassElement();
                        ((ClassElement)e).setName(Identifier.create(outerName.getFullName() + ".InnerInterface", "InnerInterface"));
                        ((MemberElement)e).setModifiers(1);
                        ((ClassElement)e).setClassOrInterface(false);
                        this.proxy.addClass((ClassElement)e);
                        e = this.proxy.getClasses()[0];
                        ClassCustomizer cust = new ClassCustomizer((ClassElement)e);
                        if (!SourceEditSupport.openCustomizer(cust, "TIT_NewInterface") || !cust.isOK()) break;
                        newElement = e;
                        break;
                    }
                }
            }
            catch (SourceException exc) {
                // empty catch block
            }
            if (newElement == null) {
                return;
            }
            Element addingElement = newElement;
            SourceEditSupport.invokeAtomicAsUser(this.element, new ExceptionalRunnable(this, addingElement){
                private final /* synthetic */ Element val$addingElement;
                private final /* synthetic */ ElementNewType this$0;
                {
                    this.this$0 = this$0;
                    this.val$addingElement = val$addingElement;
                }

                public void run() throws SourceException {
                    switch (this.this$0.kind) {
                        case 0: {
                            this.this$0.element.addInitializer((InitializerElement)this.val$addingElement);
                            return;
                        }
                        case 1: {
                            this.this$0.element.addField((FieldElement)this.val$addingElement);
                            return;
                        }
                        case 2: {
                            this.this$0.element.addConstructor((ConstructorElement)this.val$addingElement);
                            return;
                        }
                        case 3: {
                            this.this$0.element.addMethod((MethodElement)this.val$addingElement);
                            return;
                        }
                        case 4: 
                        case 5: {
                            this.this$0.element.addClass((ClassElement)this.val$addingElement);
                            return;
                        }
                    }
                }
            });
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

