/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceSupport;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class CloneableEditor
extends CloneableTopComponent {
    protected JEditorPane pane;
    private PropertyChangeListener copyL;
    private PropertyChangeListener cutL;
    private PropertyChangeListener deleteL;
    private PropertyChangeListener pasteL;
    private CloneableEditorSupport support;
    private boolean initialized;
    private int cursorPosition;
    private Component customComponent;
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    private Map kitActions;
    static /* synthetic */ Class class$org$openide$text$CloneableEditor;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;
    static /* synthetic */ Class class$org$openide$text$EditorSupport;

    public CloneableEditor() {
        this((CloneableEditorSupport)null);
    }

    public CloneableEditor(CloneableEditorSupport support) {
        this.support = support;
        this.putClientProperty("PersistenceType", "OnlyOpened");
        this.updateName();
        this.setCloseOperation(0);
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx fromKit = InstanceSupport.findHelp(new InstanceSupport.Instance(this.support.kit()));
        if (fromKit != null) {
            return fromKit;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose(Workspace workspace, boolean last) {
        boolean result = super.canClose(workspace, last);
        int closeOp = this.getCloseOperation();
        if (result && (closeOp == 0 || closeOp == 1 && last)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (CloneableEditor.this.pane != null) {
                        StyledDocument doc = CloneableEditor.this.support.createStyledDocument(CloneableEditor.this.pane.getEditorKit());
                        CloneableEditor.this.pane.setDocument(doc);
                        CloneableEditor.this.pane.setEditorKit(null);
                    }
                    CloneableEditor.this.removeAll();
                }
            });
        }
        return result;
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.initialized || this.discard()) {
            return;
        }
        this.initialized = true;
        this.initialize();
    }

    private void initialize() {
        final Task prepareTask = this.support.prepareDocument();
        this.setLayout(new BorderLayout());
        final QuietEditorPane pane = new QuietEditorPane();
        pane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(class$org$openide$text$CloneableEditor == null ? (class$org$openide$text$CloneableEditor = CloneableEditor.class$("org.openide.text.CloneableEditor")) : class$org$openide$text$CloneableEditor, "ACS_CloneableEditor_QuietEditorPane", this.getName()));
        pane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(class$org$openide$text$CloneableEditor == null ? (class$org$openide$text$CloneableEditor = CloneableEditor.class$("org.openide.text.CloneableEditor")) : class$org$openide$text$CloneableEditor, "ACSD_CloneableEditor_QuietEditorPane", this.getAccessibleContext().getAccessibleDescription()));
        this.pane = pane;
        pane.setEditorKit(this.support.kit());
        StyledDocument doc = this.support.getDocumentHack();
        pane.setDocument(doc);
        if (doc instanceof NbDocument.CustomEditor) {
            NbDocument.CustomEditor ce = (NbDocument.CustomEditor)((Object)doc);
            this.customComponent = ce.createEditor(pane);
            if (this.customComponent == null) {
                throw new IllegalStateException("Document:" + doc + " implementing NbDocument.CustomEditor may not" + " return null component");
            }
            this.add(this.customComponent, "Center");
        } else {
            this.add((Component)new JScrollPane(pane), "Center");
        }
        pane.setWorking(3);
        prepareTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task t) {
                Caret caret = pane.getCaret();
                if (caret != null) {
                    caret.setDot(CloneableEditor.this.cursorPosition);
                }
                prepareTask.removeTaskListener(this);
            }
        });
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    public void open(Workspace workspace) {
        if (!this.discard()) {
            Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            this.dockIfNeeded(realWorkspace);
            boolean modeVisible = false;
            TopComponent[] tcArray = this.editorMode(realWorkspace).getTopComponents();
            int i = 0;
            while (i < tcArray.length) {
                if (tcArray[i].isOpened(realWorkspace)) {
                    modeVisible = true;
                    break;
                }
                ++i;
            }
            if (!modeVisible) {
                this.openOtherEditors(realWorkspace);
            }
            super.open(workspace);
            this.openOnOtherWorkspaces(realWorkspace);
        }
    }

    protected boolean closeLast() {
        if (!this.support.canClose()) {
            return false;
        }
        this.support.notifyClosed();
        if (this.support.lastSelected == this) {
            this.support.lastSelected = null;
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] sa = super.getSystemActions();
        return SystemAction.linkActions(sa, new SystemAction[]{null, SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = CloneableEditor.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)});
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            this.customComponent.requestFocus();
        } else if (this.pane != null) {
            this.pane.requestFocus();
        }
    }

    public Dimension getPreferredSize() {
        Rectangle bounds = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(bounds.width / 2, bounds.height / 2);
    }

    private Action getAction(String key) {
        Action ac;
        Reference ref;
        if (key == null) {
            return null;
        }
        if (this.kitActions == null) {
            this.kitActions = new HashMap(5);
        }
        if ((ref = (Reference)this.kitActions.get(key)) != null && (ac = (Action)ref.get()) != null) {
            return ac;
        }
        EditorKit kit = this.support.kit();
        if (kit == null) {
            return null;
        }
        Action[] actions = kit.getActions();
        int i = 0;
        while (i < actions.length) {
            if (key.equals(actions[i].getValue("Name"))) {
                this.kitActions.put(actions[i].getValue("Name"), new WeakReference<Action>(actions[i]));
                return actions[i];
            }
            ++i;
        }
        return null;
    }

    protected void componentActivated() {
        this.copyL = this.setEditorActionListening(this.copyL, this.getAction("copy-to-clipboard"), (CallbackSystemAction)SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = CloneableEditor.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), true);
        this.cutL = this.setEditorActionListening(this.cutL, this.getAction("cut-to-clipboard"), (CallbackSystemAction)SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = CloneableEditor.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), true);
        this.deleteL = this.setEditorActionListening(this.deleteL, this.getAction("delete-next"), (CallbackSystemAction)SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = CloneableEditor.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), false);
        Action paste = this.getAction("paste-from-clipboard");
        final PasteAction sysPaste = (PasteAction)SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = CloneableEditor.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
        if (paste != null && sysPaste != null && paste != sysPaste) {
            if (this.pasteL != null) {
                paste.removePropertyChangeListener(this.pasteL);
            }
            this.pasteL = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        if (((Boolean)evt.getNewValue()).booleanValue()) {
                            CloneableEditor.this.updatePasteAction();
                        } else {
                            sysPaste.setPasteTypes(null);
                        }
                    }
                }
            };
            paste.addPropertyChangeListener(this.pasteL);
        }
        this.updatePasteAction();
        this.support.lastSelected = this;
    }

    protected void componentDeactivated() {
        this.removeEditorActionListening(this.copyL, this.getAction("copy-to-clipboard"), true);
        this.removeEditorActionListening(this.cutL, this.getAction("cut-to-clipboard"), true);
        this.removeEditorActionListening(this.deleteL, this.getAction("delete-next"), false);
        this.removeEditorActionListening(this.pasteL, this.getAction("paste-from-clipboard"), false);
    }

    private PropertyChangeListener setEditorActionListening(PropertyChangeListener listener, Action action, CallbackSystemAction sysAction, boolean substitute) {
        if (action != null && sysAction != null && action != sysAction) {
            if (listener != null) {
                action.removePropertyChangeListener(listener);
            }
            if (substitute && action == this.pane.getActionMap().get(action)) {
                SubstituteAction subsAction = new SubstituteAction(action);
                this.pane.getActionMap().put(action, subsAction);
                action = subsAction;
            }
            listener = new Bridge(action, sysAction);
            action.addPropertyChangeListener(listener);
        }
        return listener;
    }

    private void removeEditorActionListening(PropertyChangeListener listener, Action action, boolean reset) {
        if (listener != null && action != null) {
            action.removePropertyChangeListener(listener);
            if (reset && action != this.pane.getActionMap().get(action)) {
                this.pane.getActionMap().put(action, action);
            }
        }
    }

    private void updatePasteAction() {
        final Action paste = this.getAction("paste-from-clipboard");
        if (paste == null) {
            return;
        }
        final PasteAction sysPaste = (PasteAction)SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = CloneableEditor.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
        RequestProcessor.postRequest(new Runnable(){
            static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

            public void run() {
                Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = 4.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
                Transferable tr = c != null ? c.getContents(null) : null;
                SwingUtilities.invokeLater(new Runnable(this, tr){
                    private final /* synthetic */ Transferable val$tr;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$tr = val$tr;
                    }

                    public void run() {
                        if (this.val$tr != null && this.val$tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            4.access$600(this.this$1).setPasteTypes(new PasteType[]{new PasteType(this){
                                private final /* synthetic */ 5 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public Transferable paste() {
                                    4.access$500(5.access$300(this.this$2)).actionPerformed(new ActionEvent(4.access$400(5.access$300(this.this$2)), 0, ""));
                                    return null;
                                }
                            }});
                        } else {
                            4.access$600(this.this$1).setPasteTypes(null);
                        }
                    }

                    static /* synthetic */ 4 access$300(5 x0) {
                        return x0.this$1;
                    }
                });
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }

            static /* synthetic */ CloneableEditor access$400(4 x0) {
                return x0.CloneableEditor.this;
            }

            static /* synthetic */ Action access$500(4 x0) {
                return x0.paste;
            }

            static /* synthetic */ PasteAction access$600(4 x0) {
                return x0.sysPaste;
            }
        });
    }

    protected void updateName() {
        CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            this.setName(ces.messageName());
            this.setToolTipText(ces.messageToolTip());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.support != null ? this.support.env() : null);
        int pos = 0;
        JEditorPane p = this.pane;
        if (p != null) {
            Caret caret = p.getCaret();
            if (caret != null) {
                pos = caret.getDot();
            } else if (p instanceof QuietEditorPane) {
                int lastPos = ((QuietEditorPane)p).getLastPosition();
                if (lastPos == -1) {
                    ErrorManager.getDefault().notify(1, new IllegalStateException("Pane=" + p + "was not initialized yet!"));
                } else {
                    pos = lastPos;
                }
            } else {
                StyledDocument doc;
                StyledDocument styledDocument = doc = this.support != null ? this.support.getDocument() : null;
                if (doc != null) {
                    ErrorManager.getDefault().notify(1, new IllegalStateException("Caret is null in editor pane=" + p + "\nsupport=" + this.support + "\ndoc=" + doc));
                }
            }
        }
        out.writeObject(new Integer(pos));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int offset;
        super.readExternal(in);
        Object firstObject = in.readObject();
        if (firstObject instanceof DataObject) {
            DataObject obj = (DataObject)firstObject;
            offset = (Integer)in.readObject();
            Object maybe = in.readObject();
            if (maybe instanceof CloneableEditorSupport) {
                this.support = (CloneableEditorSupport)maybe;
            } else {
                EditorSupport supp;
                this.support = (CloneableEditorSupport)((Object)obj.getCookie(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditor.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport));
                if (this.support == null && (supp = (EditorSupport)obj.getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = CloneableEditor.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport)) != null) {
                    this.support = supp.del;
                }
            }
        } else {
            if (firstObject instanceof CloneableOpenSupport.Env) {
                CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)firstObject;
                CloneableOpenSupport os = env.findCloneableOpenSupport();
                this.support = os instanceof EditorSupport ? ((EditorSupport)os).del : (CloneableEditorSupport)os;
            }
            offset = (Integer)in.readObject();
        }
        if (!this.discard()) {
            this.cursorPosition = offset;
        }
        this.updateName();
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.support.initializeCloneableEditor(this);
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.env().isValid();
    }

    private void dockIfNeeded(Workspace workspace) {
        Mode ourMode = workspace.findMode(this);
        if (ourMode == null) {
            this.editorMode(workspace).dockInto(this);
        }
    }

    private Mode editorMode(Workspace workspace) {
        Mode ourMode = workspace.findMode(this);
        if (ourMode == null) {
            ourMode = workspace.createMode("editor", this.getName(), (class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditor.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getResource("/org/openide/resources/editorMode.gif"));
        }
        return ourMode;
    }

    private void openOnOtherWorkspaces(Workspace workspace) {
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        Mode curEditorMode = null;
        Mode tcMode = null;
        int i = 0;
        while (i < workspaces.length) {
            if (!workspaces[i].equals(workspace)) {
                curEditorMode = workspaces[i].findMode("editor");
                tcMode = workspaces[i].findMode(this);
                if (!this.isOpened(workspaces[i]) && curEditorMode != null && (tcMode == null || tcMode.equals(curEditorMode))) {
                    TopComponent[] tcArray = curEditorMode.getTopComponents();
                    int j = 0;
                    while (j < tcArray.length) {
                        if (tcArray[j].isOpened(workspaces[i])) {
                            this.pureOpen(this, workspaces[i]);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void openOtherEditors(Workspace workspace) {
        HashSet<TopComponent> topComps = new HashSet<TopComponent>(15);
        Workspace[] wsArray = WindowManager.getDefault().getWorkspaces();
        Mode curEditorMode = null;
        TopComponent[] tcArray = null;
        int i = 0;
        while (i < wsArray.length) {
            curEditorMode = wsArray[i].findMode("editor");
            if (curEditorMode != null) {
                tcArray = curEditorMode.getTopComponents();
                int j = 0;
                while (j < tcArray.length) {
                    if (tcArray[j].isOpened(wsArray[i])) {
                        topComps.add(tcArray[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Iterator iter = topComps.iterator();
        while (iter.hasNext()) {
            this.pureOpen((TopComponent)iter.next(), workspace);
        }
    }

    private void pureOpen(TopComponent tc, Workspace workspace) {
        if (tc instanceof CloneableEditor) {
            ((CloneableEditor)tc).dockIfNeeded(workspace);
            ((CloneableEditor)tc).superOpen(workspace);
        } else {
            tc.open(workspace);
        }
    }

    private void superOpen(Workspace workspace) {
        super.open(workspace);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SubstituteAction
    implements Action {
        private Action substitutee;

        public SubstituteAction(Action substitutee) {
            this.substitutee = substitutee;
        }

        public void actionPerformed(ActionEvent evt) {
            this.substitutee.actionPerformed(evt);
            CloneableEditor.this.updatePasteAction();
        }

        public Object getValue(String key) {
            return this.substitutee.getValue(key);
        }

        public void putValue(String key, Object value) {
            this.substitutee.putValue(key, value);
        }

        public void setEnabled(boolean enable) {
            this.substitutee.setEnabled(enable);
        }

        public boolean isEnabled() {
            return this.substitutee.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.substitutee.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.substitutee.removePropertyChangeListener(l);
        }
    }

    private class Bridge
    implements PropertyChangeListener,
    ActionPerformer {
        private Action action;
        private CallbackSystemAction sys;

        Bridge(Action act, CallbackSystemAction sys) {
            this.action = act;
            this.sys = sys;
            if (this.action.isEnabled()) {
                sys.setActionPerformer(this);
            } else {
                sys.setActionPerformer(null);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    this.sys.setActionPerformer(this);
                } else if (this.sys.getActionPerformer() == this) {
                    this.sys.setActionPerformer(null);
                }
            }
        }

        public void performAction(SystemAction ac) {
            this.action.actionPerformed(new ActionEvent(CloneableEditor.this, 0, ""));
        }
    }
}

