/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintSettings;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    public static final String EDITOR_MODE = "editor";
    private boolean inUserQuestionExceptionHandler;
    private static final ThreadLocal LOCAL_LOAD_TASK = new ThreadLocal();
    private Task loadTask;
    private Task prepareTask;
    private EditorKit kit;
    private StyledDocument doc;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set lineSet;
    private final Object LOCK_LINE_SET = new Object();
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private HashSet listeners;
    transient CloneableEditor lastSelected;
    private long lastSaveTime;
    private boolean reloadDialogOpened;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;

    public CloneableEditorSupport(Env env) {
        super(env);
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected abstract String messageToolTip();

    final Env env() {
        return (Env)this.env;
    }

    final EditorKit kit() {
        return this.kit;
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        if (this.undoRedo == null) {
            this.undoRedo = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    public Task prepareDocument() {
        return this.prepareDocument(false);
    }

    private Task prepareDocument(final boolean clearDocument) {
        Task t = this.prepareTask;
        if (t != null) {
            return t;
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.prepareTask != null) {
                Task task = this.prepareTask;
                return task;
            }
            this.env.removePropertyChangeListener(this.getListener());
            this.env.addPropertyChangeListener(this.getListener());
            this.kit = this.createEditorKit();
            if (this.doc == null) {
                this.doc = this.createStyledDocument(this.kit);
            }
            Task task = this.prepareTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        Object object = CloneableEditorSupport.this.getLock();
                        synchronized (object) {
                            if (clearDocument) {
                                CloneableEditorSupport.this.clearDocument();
                            }
                            CloneableEditorSupport.this.loadTask = new Task(CloneableEditorSupport.this.getListener());
                            CloneableEditorSupport.this.loadTask.run();
                        }
                        CloneableEditorSupport.this.fireStateChangeEvent(CloneableEditorSupport.this.doc, false);
                    }
                    catch (RuntimeException t) {
                        t.printStackTrace();
                        throw t;
                    }
                }
            });
            return task;
        }
    }

    private void clearDocument() {
        NbDocument.runAtomic(this.doc, new Runnable(){

            public void run() {
                try {
                    CloneableEditorSupport.this.doc.removeDocumentListener(CloneableEditorSupport.this.getListener());
                    CloneableEditorSupport.this.doc.remove(0, CloneableEditorSupport.this.doc.getLength());
                    CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify(1, ble);
                }
            }
        });
    }

    public StyledDocument openDocument() throws IOException {
        StyledDocument d;
        do {
            this.prepareDocument().waitFinished();
            IOException loadExc = this.getListener().checkLoadException();
            if (loadExc == null) continue;
            throw loadExc;
        } while ((d = this.doc) == null);
        return d;
    }

    public StyledDocument getDocument() {
        if (LOCAL_LOAD_TASK.get() != null) {
            return this.doc;
        }
        Task t = this.loadTask;
        if (t != null) {
            t.waitFinished();
            return this.doc;
        }
        return null;
    }

    public boolean isModified() {
        return this.env().isModified();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveDocument() throws IOException {
        block11: {
            if (!this.env().isModified()) {
                return;
            }
            StyledDocument myDoc = this.getDocument();
            BufferedOutputStream os = null;
            long oldSaveTime = this.lastSaveTime;
            try {
                try {
                    this.lastSaveTime = -1L;
                    os = new BufferedOutputStream(this.env().outputStream());
                    this.saveFromKitToStream(myDoc, this.kit, os);
                    if (os != null) {
                        ((OutputStream)os).close();
                        os = null;
                    }
                    this.lastSaveTime = System.currentTimeMillis();
                    this.notifyUnmodified();
                }
                catch (BadLocationException ex) {
                    ErrorManager.getDefault().notify(ex);
                    Object var7_5 = null;
                    if (this.lastSaveTime == -1L) {
                        this.lastSaveTime = oldSaveTime;
                    }
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                    break block11;
                }
                Object var7_4 = null;
                if (this.lastSaveTime == -1L) {
                    this.lastSaveTime = oldSaveTime;
                }
                if (os == null) break block11;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.lastSaveTime == -1L) {
                    this.lastSaveTime = oldSaveTime;
                }
                if (os != null) {
                    ((OutputStream)os).close();
                }
                throw throwable;
            }
            ((OutputStream)os).close();
        }
        this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(this.lastSaveTime)));
        this.updateLineSet(true);
        this.updateTitles();
    }

    public JEditorPane[] getOpenedPanes() {
        LinkedList<JEditorPane> ll = new LinkedList<JEditorPane>();
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (!(o instanceof CloneableEditor)) continue;
            CloneableEditor ed = (CloneableEditor)o;
            if (ed.pane == null) continue;
            if (this.lastSelected == ed) {
                ll.addFirst(ed.pane);
                continue;
            }
            ll.add(ed.pane);
        }
        return ll.isEmpty() ? null : ll.toArray(new JEditorPane[ll.size()]);
    }

    public Line.Set getLineSet() {
        return this.updateLineSet(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print() {
        Object object2 = this.LOCK_PRINTING;
        synchronized (object2) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            block19: {
                try {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    Object o = NbDocument.findPageable(this.openDocument());
                    if (o instanceof Pageable) {
                        job.setPageable((Pageable)o);
                    } else {
                        PageFormat pf = PrintSettings.getPageFormat(job);
                        job.setPrintable((Printable)o, pf);
                    }
                    if (!job.printDialog()) break block19;
                    job.print();
                }
                catch (FileNotFoundException e) {
                    ErrorManager.getDefault().notify(e);
                    String msg = NbBundle.getBundle(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getString("CTL_Bad_File");
                    CloneableEditorSupport.notifyInAWT(msg);
                    Object var7_10 = null;
                    Object object = this.LOCK_PRINTING;
                    synchronized (object) {
                        this.printing = false;
                        return;
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(e);
                    Object var7_11 = null;
                    Object object4 = this.LOCK_PRINTING;
                    synchronized (object4) {
                        this.printing = false;
                        return;
                    }
                }
                catch (PrinterAbortException e) {
                    String msg = NbBundle.getBundle(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getString("CTL_Printer_Abort");
                    CloneableEditorSupport.notifyInAWT(msg);
                    Object var7_12 = null;
                    Object object5 = this.LOCK_PRINTING;
                    synchronized (object5) {
                        this.printing = false;
                        return;
                    }
                }
                catch (PrinterException e) {
                    ErrorManager.getDefault().notify(e);
                    Object var7_13 = null;
                    Object object6 = this.LOCK_PRINTING;
                    synchronized (object6) {
                        this.printing = false;
                        return;
                    }
                }
            }
            Object var7_9 = null;
            Object object = this.LOCK_PRINTING;
            synchronized (object) {
                this.printing = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            Object object7 = this.LOCK_PRINTING;
            synchronized (object7) {
                this.printing = false;
                throw throwable;
            }
        }
    }

    static void notifyInAWT(final String msg) {
        if (EventQueue.isDispatchThread()) {
            TopManager.getDefault().notify(new NotifyDescriptor.Message(msg));
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TopManager.getDefault().notify(new NotifyDescriptor.Message(msg));
                }
            });
        }
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        CloneableEditor ed = this.createCloneableEditor();
        this.initializeCloneableEditor(ed);
        return ed;
    }

    protected boolean canClose() {
        if (this.env().isModified()) {
            String msg = this.messageSave();
            ResourceBundle bundle = NbBundle.getBundle(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport);
            String saveOption = bundle.getString("CTL_Save");
            String discardOption = bundle.getString("CTL_Discard");
            NotifyDescriptor nd = new NotifyDescriptor(msg, bundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{saveOption, discardOption, NotifyDescriptor.CANCEL_OPTION}, saveOption);
            Object ret = TopManager.getDefault().notify(nd);
            if (NotifyDescriptor.CANCEL_OPTION.equals(ret) || NotifyDescriptor.CLOSED_OPTION.equals(ret)) {
                return false;
            }
            if (saveOption.equals(ret)) {
                try {
                    this.saveDocument();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(e);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isDocumentLoaded() {
        return this.loadTask != null;
    }

    public void setMIMEType(String s) {
        this.mimeType = s;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet(8);
        }
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public final PositionRef createPositionRef(int offset, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), offset, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedo.Manager();
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        kit.write(stream, (Document)doc, 0, doc.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        kit.read(stream, (Document)doc, 0);
    }

    protected Task reloadDocument() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.doc != null) {
                int[] carets;
                this.doc.removeUndoableEditListener(this.getUndoRedo());
                final JEditorPane[] panes = this.getOpenedPanes();
                if (panes != null) {
                    carets = new int[panes.length];
                    int i = 0;
                    while (i < panes.length) {
                        carets[i] = panes[i].getCaretPosition();
                        ++i;
                    }
                } else {
                    carets = new int[]{};
                }
                this.prepareTask = null;
                final Task docLoadTask = this.prepareDocument(true);
                docLoadTask.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                if (4.access$500(this.this$1) != null) {
                                    int i = 0;
                                    while (i < 4.access$500(this.this$1).length) {
                                        try {
                                            4.access$500(this.this$1)[i].setCaretPosition(4.access$600(this.this$1)[i]);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        ++i;
                                    }
                                }
                                4.access$700(this.this$1).getUndoRedo().discardAllEdits();
                                4.access$700(this.this$1).getUndoRedo().undoableEditHappened(new UndoableEditEvent(4.access$700(this.this$1), 4.access$700(this.this$1).new BeforeSaveEdit(CloneableEditorSupport.access$800(4.access$700(this.this$1)))));
                                4.access$700(this.this$1).notifyUnmodified();
                                4.access$700(this.this$1).updateLineSet(true);
                            }
                        });
                        docLoadTask.removeTaskListener(this);
                    }

                    static /* synthetic */ JEditorPane[] access$500(4 x0) {
                        return x0.panes;
                    }

                    static /* synthetic */ int[] access$600(4 x0) {
                        return x0.carets;
                    }

                    static /* synthetic */ CloneableEditorSupport access$700(4 x0) {
                        return x0.CloneableEditorSupport.this;
                    }
                });
                Task task = docLoadTask;
                return task;
            }
        }
        return this.prepareDocument();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = JEditorPane.createEditorKitForContentType(this.mimeType);
        } else {
            String defaultMIMEType = this.env().getMimeType();
            this.kit = JEditorPane.createEditorKitForContentType(defaultMIMEType);
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = JEditorPane.createEditorKitForContentType("text/plain");
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = new PlainEditorKit();
        }
        return this.kit;
    }

    private boolean isDumbKit(EditorKit kit) {
        if (kit == null) {
            return true;
        }
        String clazz = kit.getClass().getName();
        return clazz.equals("javax.swing.text.DefaultEditorKit") || clazz.equals("javax.swing.JEditorPane$PlainEditorKit") || clazz.equals("javax.swing.text.html.HTMLEditorKit");
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument sd = CloneableEditorSupport.createNetBeansDocument(kit.createDefaultDocument());
        sd.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.env().getMimeType());
        return sd;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        this.updateTitles();
    }

    protected boolean notifyModified() {
        boolean locked = true;
        try {
            this.env.markModified();
        }
        catch (UserQuestionException ex) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation(ex.getLocalizedMessage());
                            Object res = TopManager.getDefault().notify(nd);
                            if (NotifyDescriptor.OK_OPTION.equals(res)) {
                                try {
                                    ex.confirmed();
                                }
                                catch (IOException ex1) {
                                    ErrorManager.getDefault().notify(ex1);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            locked = false;
        }
        catch (IOException e) {
            if (e.getMessage() != e.getLocalizedMessage()) {
                TopManager.getDefault().setStatusText(e.getLocalizedMessage());
            }
            locked = false;
        }
        if (!locked) {
            Toolkit.getDefaultToolkit().beep();
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    UndoRedo.Manager ur = CloneableEditorSupport.this.getUndoRedo();
                    if (CloneableEditorSupport.this.doc != null) {
                        CloneableEditorSupport.this.doc.removeDocumentListener(CloneableEditorSupport.this.getListener());
                    }
                    try {
                        block5: {
                            try {
                                if (!ur.canUndo()) break block5;
                                ur.undo();
                            }
                            catch (CannotUndoException exc) {
                                Object var4_3 = null;
                                if (CloneableEditorSupport.this.doc == null) return;
                                CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                                return;
                            }
                        }
                        Object var4_2 = null;
                        if (CloneableEditorSupport.this.doc == null) return;
                        CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (CloneableEditorSupport.this.doc == null) throw throwable;
                        CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
                        throw throwable;
                    }
                }
            });
            return false;
        }
        this.updateTitles();
        return true;
    }

    protected void notifyClosed() {
        this.closeDocument();
    }

    final StyledDocument getDocumentHack() {
        return this.doc;
    }

    DataObject getDataObjectHack() {
        return null;
    }

    Line.Set updateLineSet(boolean clear) {
        Object object = this.LOCK_LINE_SET;
        synchronized (object) {
            Object object2;
            if (this.lineSet != null && !clear) {
                Line.Set set = this.lineSet;
                return set;
            }
            Line.Set oldSet = this.lineSet;
            this.lineSet = this.doc == null ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.doc);
            if (oldSet != null) {
                object2 = oldSet.lines;
                synchronized (object2) {
                    this.lineSet.lines.putAll(oldSet.lines);
                }
            }
            object2 = this.lineSet;
            return object2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadDocument(EditorKit kit, StyledDocument doc) throws IOException {
        Throwable throwable = null;
        try {
            try {
                BufferedInputStream is = new BufferedInputStream(this.env().inputStream());
                try {
                    this.loadFromStreamToKit(doc, is, kit);
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    ((InputStream)is).close();
                    throw throwable2;
                }
                ((InputStream)is).close();
                doc.addUndoableEditListener(this.getUndoRedo());
            }
            catch (IOException ex) {
                IOException iOException = ex;
                throw ex;
            }
            catch (Exception e) {
                Exception exception = e;
                Object var8_13 = null;
                if (exception == null) return;
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)exception, NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "EXC_LoadDocument", this.messageName()));
                err.notify(exception);
                return;
            }
            Object var8_12 = null;
            if (throwable == null) return;
        }
        catch (Throwable throwable3) {
            Object var8_14 = null;
            if (throwable == null) throw throwable3;
            ErrorManager err = ErrorManager.getDefault();
            err.annotate(throwable, NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "EXC_LoadDocument", this.messageName()));
            err.notify(throwable);
            throw throwable3;
        }
        ErrorManager err = ErrorManager.getDefault();
        err.annotate(throwable, NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "EXC_LoadDocument", this.messageName()));
        err.notify(throwable);
    }

    protected boolean close(boolean ask) {
        if (!super.close(ask)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    private void closeDocument() {
        while (true) {
            Task prep;
            Object object = this.getLock();
            synchronized (object) {
                if (this.doc == null) {
                    return;
                }
                if (this.loadTask == null) {
                    return;
                }
                prep = this.prepareTask;
                if (prep == null) {
                    return;
                }
                if (prep.isFinished()) {
                    this.doCloseDocument();
                    return;
                }
            }
            prep.waitFinished();
        }
    }

    private void doCloseDocument() {
        this.loadTask = null;
        this.prepareTask = null;
        this.env().removePropertyChangeListener(this.getListener());
        this.notifyUnmodified();
        if (this.doc != null) {
            this.getUndoRedo().discardAllEdits();
            this.doc.removeUndoableEditListener(this.getUndoRedo());
            this.doc.removeDocumentListener(this.getListener());
        }
        if (this.positionManager != null) {
            this.positionManager.documentClosed();
            this.fireStateChangeEvent(this.doc, true);
        }
        this.doc = null;
        this.kit = null;
        this.updateLineSet(true);
    }

    private void checkReload(boolean doReload) {
        StyledDocument doc = this.doc;
        if (doc == null) {
            return;
        }
        if (!doReload && !this.reloadDialogOpened) {
            String msg = NbBundle.getMessage(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport, "FMT_External_change", doc.getProperty("title"));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
            this.reloadDialogOpened = true;
            try {
                Object ret = TopManager.getDefault().notify(nd);
                if (NotifyDescriptor.YES_OPTION.equals(ret)) {
                    doReload = true;
                }
                Object var7_6 = null;
                this.reloadDialogOpened = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.reloadDialogOpened = false;
                throw throwable;
            }
        }
        if (doReload) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CloneableEditorSupport.this.reloadDocument();
                }
            });
        }
    }

    private static StyledDocument createNetBeansDocument(Document d) {
        if (d instanceof StyledDocument) {
            return (StyledDocument)d;
        }
        return new FilterDocument(d);
    }

    private final void fireStateChangeEvent(StyledDocument document, boolean closing) {
        if (this.listeners != null) {
            HashSet s;
            EnhancedChangeEvent event = new EnhancedChangeEvent(this, document, closing);
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                s = (HashSet)this.listeners.clone();
            }
            Iterator it = s.iterator();
            while (it.hasNext()) {
                ChangeListener l = (ChangeListener)it.next();
                l.stateChanged(event);
            }
        }
    }

    protected void updateTitles() {
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (!(o instanceof CloneableEditor)) continue;
            CloneableEditor e = (CloneableEditor)o;
            e.updateName();
        }
    }

    private CloneableEditor openEditorComponent() {
        Object object = this.getLock();
        synchronized (object) {
            CloneableEditor ce = this.getAnyEditor();
            if (ce != null) {
                ce.open();
                CloneableEditor cloneableEditor = ce;
                return cloneableEditor;
            }
            String msg = this.messageOpening();
            if (msg != null) {
                TopManager.getDefault().setStatusText(msg);
            }
            this.prepareDocument();
            ce = this.createCloneableEditor();
            this.initializeCloneableEditor(ce);
            ce.setReference(this.allEditors);
            ce.open();
            msg = this.messageOpened();
            if (msg == null) {
                msg = "";
            }
            TopManager.getDefault().setStatusText(msg);
            CloneableEditor cloneableEditor = ce;
            return cloneableEditor;
        }
    }

    CloneableEditor getAnyEditor() {
        CloneableTopComponent ctc;
        try {
            ctc = this.allEditors.getAnyComponent();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        if (ctc instanceof CloneableEditor) {
            return (CloneableEditor)ctc;
        }
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (!(o instanceof CloneableEditor)) continue;
            return (CloneableEditor)o;
        }
        return null;
    }

    final CloneableEditor openAt(PositionRef pos, int column) {
        CloneableEditor e = this.openEditorComponent();
        Task t = this.prepareDocument();
        e.open();
        e.requestVisible();
        class Selector
        implements TaskListener,
        Runnable {
            private final /* synthetic */ CloneableEditor val$e;
            private final /* synthetic */ int val$column;
            private final /* synthetic */ PositionRef val$pos;
            private final /* synthetic */ CloneableEditorSupport this$0;

            Selector(CloneableEditorSupport this$0, CloneableEditor val$e, int val$column, PositionRef val$pos) {
                this.this$0 = this$0;
                this.val$e = val$e;
                this.val$column = val$column;
                this.val$pos = val$pos;
            }

            public void taskFinished(Task t2) {
                SwingUtilities.invokeLater(this);
                t2.removeTaskListener(this);
            }

            public void run() {
                int offset;
                JEditorPane ePane = this.val$e.pane;
                if (ePane == null) {
                    return;
                }
                Caret caret = ePane.getCaret();
                if (caret == null) {
                    return;
                }
                if (this.val$column >= 0) {
                    Element el = NbDocument.findLineRootElement(this.this$0.getDocument());
                    offset = (el = el.getElement(el.getElementIndex(this.val$pos.getOffset()))).getStartOffset() + this.val$column;
                    if (offset > el.getEndOffset()) {
                        offset = el.getEndOffset();
                    }
                } else {
                    offset = this.val$pos.getOffset();
                }
                caret.setDot(offset);
            }
        }
        t.addTaskListener(new Selector(this, e, column, pos));
        return e;
    }

    Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$1100(CloneableEditorSupport x0, boolean x1) {
        x0.checkReload(x1);
    }

    private class BeforeModificationEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeModificationEdit(long saveTime, UndoableEdit delegate) {
            this.saveTime = saveTime;
            this.delegate = delegate;
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (this.delegate == null) {
                this.delegate = anEdit;
                return true;
            }
            return false;
        }

        public void undo() {
            super.undo();
            if (this.saveTime == CloneableEditorSupport.this.lastSaveTime) {
                CloneableEditorSupport.this.notifyUnmodified();
            }
        }
    }

    private class BeforeSaveEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeSaveEdit(long saveTime) {
            this.saveTime = saveTime;
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            if (this.delegate == null) {
                this.delegate = anEdit;
                return true;
            }
            return false;
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (!(anEdit instanceof BeforeModificationEdit)) {
                CloneableEditorSupport.this.getUndoRedo().addEdit(new BeforeModificationEdit(this.saveTime, anEdit));
                return true;
            }
            return false;
        }

        public void redo() {
            super.redo();
            if (this.saveTime == CloneableEditorSupport.this.lastSaveTime) {
                CloneableEditorSupport.this.notifyUnmodified();
            }
        }

        public boolean isSignificant() {
            return this.delegate != null;
        }
    }

    private class FilterUndoableEdit
    implements UndoableEdit {
        protected UndoableEdit delegate;

        FilterUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            if (this.delegate != null) {
                this.delegate.undo();
            }
        }

        public boolean canUndo() {
            if (this.delegate != null) {
                return this.delegate.canUndo();
            }
            return false;
        }

        public void redo() throws CannotRedoException {
            if (this.delegate != null) {
                this.delegate.redo();
            }
        }

        public boolean canRedo() {
            if (this.delegate != null) {
                return this.delegate.canRedo();
            }
            return false;
        }

        public void die() {
            if (this.delegate != null) {
                this.delegate.die();
            }
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (this.delegate != null) {
                return this.delegate.addEdit(anEdit);
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            if (this.delegate != null) {
                return this.delegate.replaceEdit(anEdit);
            }
            return false;
        }

        public boolean isSignificant() {
            if (this.delegate != null) {
                return this.delegate.isSignificant();
            }
            return true;
        }

        public String getPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getPresentationName();
            }
            return "";
        }

        public String getUndoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getUndoPresentationName();
            }
            return "";
        }

        public String getRedoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getRedoPresentationName();
            }
            return "";
        }
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }

    private final class Listener
    implements DocumentListener,
    PropertyChangeListener,
    Runnable {
        private IOException loadExc;

        Listener() {
        }

        public IOException checkLoadException() {
            IOException ret = this.loadExc;
            this.loadExc = null;
            return ret;
        }

        public void changedUpdate(DocumentEvent ev) {
        }

        public void insertUpdate(DocumentEvent ev) {
            CloneableEditorSupport.this.notifyModified();
        }

        public void removeUpdate(DocumentEvent ev) {
            CloneableEditorSupport.this.notifyModified();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("time".equals(ev.getPropertyName())) {
                Date time = (Date)ev.getNewValue();
                if (CloneableEditorSupport.this.lastSaveTime != -1L && (time == null || time.getTime() > CloneableEditorSupport.this.lastSaveTime)) {
                    SwingUtilities.invokeLater(new Runnable(this, time){
                        private final /* synthetic */ Date val$time;
                        private final /* synthetic */ Listener this$1;
                        {
                            this.this$1 = this$1;
                            this.val$time = val$time;
                        }

                        public void run() {
                            CloneableEditorSupport.access$1100(Listener.access$1000(this.this$1), this.val$time == null || !Listener.access$1000(this.this$1).isModified());
                        }
                    });
                }
            }
        }

        public void run() {
            Object object = CloneableEditorSupport.this.getLock();
            synchronized (object) {
                CloneableEditorSupport.this.doc.removeDocumentListener(CloneableEditorSupport.this.getListener());
                try {
                    try {
                        this.loadExc = null;
                        LOCAL_LOAD_TASK.set(Boolean.TRUE);
                        CloneableEditorSupport.this.loadDocument(CloneableEditorSupport.this.kit, CloneableEditorSupport.this.doc);
                    }
                    catch (IOException e) {
                        this.loadExc = e;
                        Object var4_3 = null;
                        LOCAL_LOAD_TASK.set(null);
                    }
                    Object var4_2 = null;
                    LOCAL_LOAD_TASK.set(null);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    LOCAL_LOAD_TASK.set(null);
                    throw throwable;
                }
                CloneableEditorSupport.this.getPositionManager().documentOpened(CloneableEditorSupport.this.doc);
                CloneableEditorSupport.this.updateLineSet(true);
                CloneableEditorSupport.this.lastSaveTime = System.currentTimeMillis();
                CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
                CloneableEditorSupport.this.doc.addDocumentListener(CloneableEditorSupport.this.getListener());
            }
        }

        static /* synthetic */ CloneableEditorSupport access$1000(Listener x0) {
            return x0.CloneableEditorSupport.this;
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        public Object clone() {
            return new PlainEditorKit();
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element elem) {
            return new WrappedPlainView(elem);
        }

        public void install(JEditorPane pane) {
            super.install(pane);
            pane.setFont(new Font("Monospaced", 0, 12));
        }
    }
}

