/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class PositionRef
implements Serializable {
    static final long serialVersionUID = -4931337398907426948L;
    private transient Manager.Kind kind;
    private Manager manager;
    private boolean insertAfter;

    PositionRef(Manager manager, int offset, Position.Bias bias) {
        this(manager, manager.new Manager.OffsetKind(offset), bias);
    }

    PositionRef(Manager manager, int line, int column, Position.Bias bias) {
        this(manager, manager.new Manager.LineKind(line, column), bias);
    }

    private PositionRef(Manager manager, Manager.Kind kind, Position.Bias bias) {
        this.manager = manager;
        this.kind = kind;
        this.insertAfter = bias == Position.Bias.Backward;
        this.init();
    }

    private void init() {
        this.kind = this.manager.addPosition(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.insertAfter);
        out.writeObject(this.manager);
        this.kind.write(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.insertAfter = in.readBoolean();
        this.manager = (Manager)in.readObject();
        this.kind = this.manager.readKind(in);
        this.init();
    }

    public CloneableEditorSupport getCloneableEditorSupport() {
        return this.manager.getCloneableEditorSupport();
    }

    public EditorSupport getEditorSupport() {
        return EditorSupport.extract(this.getCloneableEditorSupport());
    }

    public Position.Bias getPositionBias() {
        return this.insertAfter ? Position.Bias.Backward : Position.Bias.Forward;
    }

    public Position getPosition() throws IOException {
        if (this.manager.getCloneableEditorSupport().getDocument() == null) {
            this.manager.getCloneableEditorSupport().openDocument();
        }
        Manager manager = this.manager;
        synchronized (manager) {
            Manager.PositionKind p = (Manager.PositionKind)this.kind;
            Position position = p.pos;
            return position;
        }
    }

    public int getOffset() {
        return this.kind.getOffset();
    }

    public int getLine() throws IOException {
        return this.kind.getLine();
    }

    public int getColumn() throws IOException {
        return this.kind.getColumn();
    }

    public String toString() {
        return "Pos[" + this.getOffset() + "]";
    }

    static final class Manager
    implements Runnable,
    Serializable {
        private transient ChainItem head;
        private transient ReferenceQueue queue;
        private transient int counter;
        private transient RequestProcessor.Task sweepTask;
        private transient CloneableEditorSupport support;
        private transient StyledDocument doc;
        static final long serialVersionUID = -4374030124265110801L;
        static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;
        static /* synthetic */ Class class$org$openide$text$PositionRef;

        public Manager(CloneableEditorSupport supp) {
            this.support = supp;
            this.init();
        }

        protected void init() {
            this.queue = new ReferenceQueue();
            this.head = new ChainItem(null, null, null);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object firstObject = in.readObject();
            if (firstObject instanceof DataObject) {
                DataObject obj = (DataObject)firstObject;
                this.support = (CloneableEditorSupport)((Object)obj.getCookie(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = Manager.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport));
            } else {
                CloneableEditorSupport.Env env = (CloneableEditorSupport.Env)firstObject;
                this.support = (CloneableEditorSupport)env.findCloneableOpenSupport();
            }
            if (this.support == null) {
                throw new IOException();
            }
        }

        final Object readResolve() {
            return this.support.getPositionManager();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.support.env());
        }

        public CloneableEditorSupport getCloneableEditorSupport() {
            return this.support;
        }

        void documentOpened(StyledDocument doc) {
            this.doc = doc;
            this.processPositions(true);
        }

        void documentClosed() {
            this.processPositions(false);
            this.doc = null;
        }

        private void processPositions(boolean toMemory) {
            while (this.queue.poll() != null) {
            }
            this.counter = 0;
            Manager manager = this;
            synchronized (manager) {
                ChainItem previous = this.head;
                ChainItem ref = previous.next;
                while (ref != null) {
                    PositionRef pos = (PositionRef)ref.get();
                    if (pos == null) {
                        previous.next = ref.next;
                    } else {
                        if (toMemory) {
                            pos.kind = pos.kind.toMemory(pos.insertAfter);
                        } else {
                            pos.kind = pos.kind.fromMemory();
                        }
                        previous = ref;
                    }
                    ref = ref.next;
                }
            }
        }

        private void checkQueue() {
            while (this.queue.poll() != null) {
                ++this.counter;
            }
            if (this.counter > 100) {
                this.counter = 0;
                if (this.sweepTask == null) {
                    this.sweepTask = RequestProcessor.getDefault().post(this);
                } else if (this.sweepTask.isFinished()) {
                    this.sweepTask.schedule(0);
                }
            }
        }

        public synchronized void run() {
            ChainItem previous = this.head;
            ChainItem ref = previous.next;
            while (ref != null) {
                if (ref.get() == null) {
                    previous.next = ref.next;
                } else {
                    previous = ref;
                }
                ref = ref.next;
            }
        }

        Kind addPosition(PositionRef pos) {
            Kind kind;
            Manager manager = this;
            synchronized (manager) {
                this.head.next = new ChainItem(pos, this.queue, this.head.next);
                kind = this.doc == null ? pos.kind : pos.kind.toMemory(pos.insertAfter);
            }
            this.checkQueue();
            return kind;
        }

        Kind readKind(DataInput is) throws IOException {
            int offset = is.readInt();
            int line = is.readInt();
            int column = is.readInt();
            if (offset == -1) {
                return new LineKind(line, column);
            }
            if (line == -1 || column == -1) {
                return new OffsetKind(offset);
            }
            return new OutKind(offset, line, column);
        }

        private static void annotateException(Exception e, String text) {
            ErrorManager.getDefault().annotate(e, 4096, text, NbBundle.getMessage(class$org$openide$text$PositionRef == null ? (class$org$openide$text$PositionRef = Manager.class$("org.openide.text.PositionRef")) : class$org$openide$text$PositionRef, "EXC_PositionOffset"), null, null);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private final class LineKind
        extends Kind {
            private int line;
            private int column;

            public LineKind(int line, int column) {
                if (line < 0 || column < 0) {
                    IndexOutOfBoundsException iooe = new IndexOutOfBoundsException();
                    Manager.annotateException(iooe, "Illegal LineKind[line=" + line + ",column=" + column + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw iooe;
                }
                this.line = line;
                this.column = column;
            }

            public int getOffset() {
                try {
                    StyledDocument doc = Manager.this.getCloneableEditorSupport().getDocument();
                    if (doc == null) {
                        doc = Manager.this.getCloneableEditorSupport().openDocument();
                    }
                    return NbDocument.findLineOffset(doc, this.line) + this.column;
                }
                catch (IOException e) {
                    return 0;
                }
            }

            public int getLine() throws IOException {
                return this.line;
            }

            public int getColumn() throws IOException {
                return this.column;
            }

            public void write(DataOutput os) throws IOException {
                if (this.line < 0 || this.column < 0) {
                    IOException ioe = new IOException();
                    Manager.annotateException(ioe, "Illegal LineKind[line=" + this.line + ",column=" + this.column + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw ioe;
                }
                os.writeInt(-1);
                os.writeInt(this.line);
                os.writeInt(this.column);
            }

            public PositionKind toMemory(boolean insertAfter) {
                Position p;
                try {
                    p = NbDocument.createPosition(Manager.this.doc, NbDocument.findLineOffset(Manager.this.doc, this.line) + this.column, insertAfter ? Position.Bias.Forward : Position.Bias.Backward);
                }
                catch (BadLocationException e) {
                    p = Manager.this.doc.getEndPosition();
                }
                return new PositionKind(p);
            }
        }

        private final class OffsetKind
        extends Kind {
            private int offset;

            public OffsetKind(int offset) {
                if (offset < 0) {
                    IndexOutOfBoundsException iooe = new IndexOutOfBoundsException();
                    Manager.annotateException(iooe, "Illegal OffsetKind[offset=" + offset + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw iooe;
                }
                this.offset = offset;
            }

            public int getOffset() {
                return this.offset;
            }

            public int getLine() throws IOException {
                return NbDocument.findLineNumber(Manager.this.getCloneableEditorSupport().openDocument(), this.offset);
            }

            public int getColumn() throws IOException {
                return NbDocument.findLineColumn(Manager.this.getCloneableEditorSupport().openDocument(), this.offset);
            }

            public void write(DataOutput os) throws IOException {
                if (this.offset < 0) {
                    IOException ioe = new IOException();
                    Manager.annotateException(ioe, "Illegal OffsetKind[offset=" + this.offset + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw ioe;
                }
                os.writeInt(this.offset);
                os.writeInt(-1);
                os.writeInt(-1);
            }
        }

        private final class OutKind
        extends Kind {
            private int offset;
            private int line;
            private int column;

            public OutKind(PositionKind kind) {
                int offset = kind.getOffset();
                int line = kind.getLine();
                int column = kind.getColumn();
                if (offset < 0 || line < 0 || column < 0) {
                    IndexOutOfBoundsException iooe = new IndexOutOfBoundsException();
                    Manager.annotateException(iooe, "Illegal OutKind[offset=" + offset + ",line=" + line + ",column=" + column + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw iooe;
                }
                this.offset = offset;
                this.line = line;
                this.column = column;
            }

            OutKind(int offset, int line, int column) {
                this.offset = offset;
                this.line = line;
                this.column = column;
            }

            public int getOffset() {
                return this.offset;
            }

            public int getLine() {
                return this.line;
            }

            public int getColumn() {
                return this.column;
            }

            public void write(DataOutput os) throws IOException {
                if (this.offset < 0 || this.line < 0 || this.column < 0) {
                    IOException ioe = new IOException();
                    Manager.annotateException(ioe, "Illegal OutKind[offset=" + this.offset + ",line=" + this.line + ",column=" + this.column + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw ioe;
                }
                os.writeInt(this.offset);
                os.writeInt(this.line);
                os.writeInt(this.column);
            }
        }

        private final class PositionKind
        extends Kind {
            private Position pos;

            public PositionKind(Position pos) {
                this.pos = pos;
            }

            public int getOffset() {
                return this.pos.getOffset();
            }

            public int getLine() {
                return NbDocument.findLineNumber(Manager.this.doc, this.getOffset());
            }

            public int getColumn() {
                return NbDocument.findLineColumn(Manager.this.doc, this.getOffset());
            }

            public void write(DataOutput os) throws IOException {
                int offset = this.getOffset();
                int line = this.getLine();
                int column = this.getColumn();
                if (offset < 0 || line < 0 || column < 0) {
                    IOException ioe = new IOException();
                    Manager.annotateException(ioe, "Illegal PositionKind: " + this.pos + "[offset=" + offset + ",line=" + line + ",column=" + column + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw ioe;
                }
                os.writeInt(offset);
                os.writeInt(line);
                os.writeInt(column);
            }

            public PositionKind toMemory(boolean insertAfter) {
                return this;
            }

            public Kind fromMemory() {
                return new OutKind(this);
            }
        }

        private abstract class Kind {
            Kind() {
            }

            public abstract int getOffset();

            public abstract int getLine() throws IOException;

            public abstract int getColumn() throws IOException;

            public abstract void write(DataOutput var1) throws IOException;

            public PositionKind toMemory(boolean insertAfter) {
                Position p;
                try {
                    p = NbDocument.createPosition(Manager.this.doc, this.getOffset(), insertAfter ? Position.Bias.Forward : Position.Bias.Backward);
                }
                catch (BadLocationException e) {
                    p = Manager.this.doc.getEndPosition();
                }
                return new PositionKind(p);
            }

            public Kind fromMemory() {
                return this;
            }
        }

        private static class ChainItem
        extends WeakReference {
            ChainItem next;

            public ChainItem(PositionRef position, ReferenceQueue queue, ChainItem next) {
                super(position, queue);
                this.next = next;
            }
        }
    }
}

