/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ResourceBundle;
import org.openide.options.ContextSystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public final class PrintSettings
extends ContextSystemOption {
    static final long serialVersionUID = -9102470021814206818L;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    private static ResourceBundle bundle;
    public static final String PROP_PAGE_FORMAT = "pageFormat";
    public static final String PROP_WRAP = "wrap";
    public static final String PROP_HEADER_FORMAT = "headerFormat";
    public static final String PROP_FOOTER_FORMAT = "footerFormat";
    public static final String PROP_HEADER_FONT = "headerFont";
    public static final String PROP_FOOTER_FONT = "footerFont";
    public static final String PROP_HEADER_ALIGNMENT = "headerAlignment";
    public static final String PROP_FOOTER_ALIGNMENT = "footerAlignment";
    public static final String PROP_LINE_ASCENT_CORRECTION = "lineAscentCorrection";
    private static final String HELP_ID = "editing.printing";
    private static PageFormat pageFormat;
    private static boolean wrap;
    private static String headerFormat;
    private static String footerFormat;
    private static Font headerFont;
    private static Font footerFont;
    private static int headerAlignment;
    private static int footerAlignment;
    private static float lineAscentCorrection;
    static /* synthetic */ Class class$org$openide$text$PrintSettings;

    public void writeExternal(ObjectOutput obtos) throws IOException {
        super.writeExternal(obtos);
        obtos.writeBoolean(wrap);
        obtos.writeObject(headerFormat);
        obtos.writeObject(footerFormat);
        obtos.writeObject(headerFont);
        obtos.writeObject(footerFont);
        obtos.writeInt(headerAlignment);
        obtos.writeInt(footerAlignment);
        PrintSettings.externalizePageFormat(pageFormat, obtos);
    }

    public void readExternal(ObjectInput obtis) throws IOException, ClassNotFoundException {
        super.readExternal(obtis);
        wrap = obtis.readBoolean();
        headerFormat = (String)obtis.readObject();
        footerFormat = (String)obtis.readObject();
        headerFont = (Font)obtis.readObject();
        footerFont = (Font)obtis.readObject();
        headerAlignment = obtis.readInt();
        footerAlignment = obtis.readInt();
        pageFormat = PrintSettings.internalizePageFormat(obtis);
    }

    private static void externalizePageFormat(PageFormat pf, ObjectOutput obtos) throws IOException {
        if (pf == null) {
            obtos.writeInt(3);
            return;
        }
        obtos.writeInt(pf.getOrientation());
        Paper paper = pf.getPaper();
        obtos.writeDouble(paper.getWidth());
        obtos.writeDouble(paper.getHeight());
        obtos.writeDouble(paper.getImageableX());
        obtos.writeDouble(paper.getImageableY());
        obtos.writeDouble(paper.getImageableWidth());
        obtos.writeDouble(paper.getImageableHeight());
    }

    private static PageFormat internalizePageFormat(ObjectInput obtis) throws IOException, ClassNotFoundException {
        PageFormat pf = new PageFormat();
        Paper paper = pf.getPaper();
        int etc = obtis.readInt();
        if (etc == 3) {
            return null;
        }
        pf.setOrientation(etc);
        paper.setSize(obtis.readDouble(), obtis.readDouble());
        paper.setImageableArea(obtis.readDouble(), obtis.readDouble(), obtis.readDouble(), obtis.readDouble());
        pf.setPaper(paper);
        return pf;
    }

    public String displayName() {
        return PrintSettings.getString("CTL_Print_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public static PageFormat getPageFormat(PrinterJob pj) {
        if (pageFormat == null) {
            pageFormat = pj.defaultPage();
        }
        return pageFormat;
    }

    public PageFormat getPageFormat() {
        if (pageFormat == null) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pageFormat = pj.defaultPage(new PageFormat());
            pj.cancel();
        }
        return pageFormat;
    }

    public void setPageFormat(PageFormat pf) {
        if (pf == null) {
            return;
        }
        if (pf.equals(pageFormat)) {
            return;
        }
        PageFormat old = pageFormat;
        pageFormat = pf;
        this.firePropertyChange(PROP_PAGE_FORMAT, old, pageFormat);
    }

    public boolean getWrap() {
        return wrap;
    }

    public void setWrap(boolean b) {
        if (wrap == b) {
            return;
        }
        wrap = b;
        this.firePropertyChange(PROP_WRAP, b ? Boolean.FALSE : Boolean.TRUE, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getHeaderFormat() {
        if (headerFormat == null) {
            headerFormat = PrintSettings.getString("CTL_Header_format");
        }
        return headerFormat;
    }

    public void setHeaderFormat(String s) {
        if (s == null) {
            return;
        }
        if (s.equals(headerFormat)) {
            return;
        }
        String of = headerFormat;
        headerFormat = s;
        this.firePropertyChange(PROP_HEADER_FORMAT, of, headerFormat);
    }

    public String getFooterFormat() {
        if (footerFormat == null) {
            footerFormat = PrintSettings.getString("CTL_Footer_format");
        }
        return footerFormat;
    }

    public void setFooterFormat(String s) {
        if (s == null) {
            return;
        }
        if (s.equals(footerFormat)) {
            return;
        }
        String of = footerFormat;
        footerFormat = s;
        this.firePropertyChange(PROP_FOOTER_FORMAT, of, footerFormat);
    }

    public Font getHeaderFont() {
        if (headerFont == null) {
            headerFont = new Font("Monospaced", 0, 6);
        }
        return headerFont;
    }

    public void setHeaderFont(Font f) {
        if (f == null) {
            return;
        }
        if (f.equals(headerFont)) {
            return;
        }
        Font old = headerFont;
        headerFont = f;
        this.firePropertyChange(PROP_HEADER_FONT, old, headerFont);
    }

    public Font getFooterFont() {
        if (footerFont == null) {
            footerFont = this.getHeaderFont();
        }
        return footerFont;
    }

    public void setFooterFont(Font f) {
        if (f == null) {
            return;
        }
        if (f.equals(footerFont)) {
            return;
        }
        Font old = headerFont;
        footerFont = f;
        this.firePropertyChange(PROP_FOOTER_FONT, old, footerFont);
    }

    public int getHeaderAlignment() {
        return headerAlignment;
    }

    public void setHeaderAlignment(int alignment) {
        if (alignment == headerAlignment) {
            return;
        }
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            throw new IllegalArgumentException();
        }
        int old = headerAlignment;
        headerAlignment = alignment;
        this.firePropertyChange(PROP_HEADER_ALIGNMENT, new Integer(old), new Integer(headerAlignment));
    }

    public int getFooterAlignment() {
        return footerAlignment;
    }

    public void setFooterAlignment(int alignment) {
        if (alignment == footerAlignment) {
            return;
        }
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            throw new IllegalArgumentException();
        }
        int old = footerAlignment;
        footerAlignment = alignment;
        this.firePropertyChange(PROP_FOOTER_ALIGNMENT, new Integer(old), new Integer(footerAlignment));
    }

    public float getLineAscentCorrection() {
        return lineAscentCorrection;
    }

    public void setLineAscentCorrection(float correction) {
        if (correction == lineAscentCorrection) {
            return;
        }
        if (correction < 0.0f) {
            throw new IllegalArgumentException();
        }
        float old = lineAscentCorrection;
        lineAscentCorrection = correction;
        this.firePropertyChange(PROP_LINE_ASCENT_CORRECTION, new Float(old), new Float(lineAscentCorrection));
    }

    static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PrintSettings.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings);
        }
        return bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        wrap = true;
        headerAlignment = 1;
        footerAlignment = 1;
        lineAscentCorrection = 0.7f;
    }

    public static class PageFormatEditor
    extends PropertyEditorSupport {
        static /* synthetic */ Class class$org$openide$text$PrintSettings;

        public String getAsText() {
            return null;
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            PageFormat pf = (PageFormat)this.getValue();
            PrinterJob pj = PrinterJob.getPrinterJob();
            PageFormat npf = pj.pageDialog(pf);
            ((PrintSettings)SharedClassObject.findObject(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PageFormatEditor.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings)).setPageFormat((PageFormat)npf.clone());
            pj.cancel();
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class AlignmentEditor
    extends PropertyEditorSupport {
        private String sCENTER;
        private String sRIGHT;
        private String sLEFT = PrintSettings.getString("CTL_LEFT");
        private String[] tags = new String[]{this.sLEFT, this.sCENTER = PrintSettings.getString("CTL_CENTER"), this.sRIGHT = PrintSettings.getString("CTL_RIGHT")};

        public String[] getTags() {
            return this.tags;
        }

        public String getAsText() {
            return this.tags[(Integer)this.getValue()];
        }

        public void setAsText(String s) {
            if (s.equals(this.sLEFT)) {
                this.setValue(new Integer(0));
            } else if (s.equals(this.sCENTER)) {
                this.setValue(new Integer(1));
            } else {
                this.setValue(new Integer(2));
            }
        }
    }
}

