/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;

final class MetaInfServicesLookup
extends AbstractLookup {
    private static final Map knownInstances = new WeakHashMap();
    private final Set classes = new WeakSet();
    private final ClassLoader loader;
    static /* synthetic */ Class class$org$openide$util$MetaInfServicesLookup;

    public MetaInfServicesLookup() {
        this((class$org$openide$util$MetaInfServicesLookup == null ? (class$org$openide$util$MetaInfServicesLookup = MetaInfServicesLookup.class$("org.openide.util.MetaInfServicesLookup")) : class$org$openide$util$MetaInfServicesLookup).getClassLoader());
    }

    public MetaInfServicesLookup(ClassLoader loader) {
        this.loader = loader;
    }

    protected final synchronized void beforeLookup(Lookup.Template t) {
        Class c = t.getType();
        if (this.classes.add(c)) {
            ArrayList arr = new ArrayList();
            this.search(c, arr);
            Iterator it = arr.iterator();
            while (it.hasNext()) {
                AbstractLookup.Pair p = (AbstractLookup.Pair)it.next();
                this.addPair(p);
            }
        }
    }

    private void search(Class clazz, Collection result) {
        Enumeration<URL> en;
        String res = "META-INF/services/" + clazz.getName();
        try {
            en = this.loader.getResources(res);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(ioe);
            return;
        }
        HashSet foundClasses = new HashSet();
        boolean foundOne = false;
        while (en.hasMoreElements()) {
            if (!foundOne) {
                foundOne = true;
                Class<?> realMcCoy = null;
                try {
                    realMcCoy = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (realMcCoy != clazz) {
                    return;
                }
            }
            URL url = en.nextElement();
            try {
                Object var13_16;
                InputStream is = url.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                        Class<?> inst = Class.forName(line, false, this.loader);
                        if (!clazz.isAssignableFrom(inst)) {
                            throw new ClassNotFoundException(inst.getName() + " not a subclass of " + clazz.getName());
                        }
                        if (!foundClasses.add(inst)) continue;
                        result.add(new P(inst));
                    }
                    var13_16 = null;
                }
                catch (Throwable throwable) {
                    var13_16 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                {
                }
            }
            catch (ClassNotFoundException ex) {
                ErrorManager.getDefault().notify(ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class P
    extends AbstractLookup.Pair {
        private Object object;
        static /* synthetic */ Class class$java$lang$Object;

        public P(Class clazz) {
            this.object = clazz;
        }

        private Class clazz() {
            Object o = this.object;
            if (o instanceof Class) {
                return (Class)o;
            }
            if (o != null) {
                return o.getClass();
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = P.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public boolean equals(Object o) {
            if (o instanceof P) {
                return ((P)o).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        protected boolean instanceOf(Class c) {
            return c.isAssignableFrom(this.clazz());
        }

        public Class getType() {
            return this.clazz();
        }

        public Object getInstance() {
            Map map = knownInstances;
            synchronized (map) {
                if (this.object instanceof Class) {
                    try {
                        Class c = (Class)this.object;
                        this.object = knownInstances.get(c);
                        if (this.object == null) {
                            this.object = c.newInstance();
                            knownInstances.put(c, this.object);
                        }
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify(ex);
                        this.object = null;
                    }
                }
                Object object = this.object;
                return object;
            }
        }

        public String getDisplayName() {
            return this.clazz().getName();
        }

        public String getId() {
            return this.clazz().getName();
        }

        protected boolean creatorOf(Object obj) {
            return obj == this.object;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

